/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class ClosableByteArrayOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;
    protected boolean closed;
    protected boolean freed;

    public ClosableByteArrayOutputStream() {
        this(32);
    }

    public ClosableByteArrayOutputStream(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n);
        }
        this.buf = new byte[n];
    }

    @Override
    public synchronized void write(int n) throws IOException {
        this.checkClosed();
        int n2 = this.count + 1;
        if (n2 > this.buf.length) {
            this.buf = this.copyOf(this.buf, Math.max(this.buf.length << 1, n2));
        }
        this.buf[this.count] = (byte)n;
        this.count = n2;
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        this.checkClosed();
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        int n3 = this.count + n2;
        if (n3 > this.buf.length) {
            this.buf = this.copyOf(this.buf, Math.max(this.buf.length << 1, n3));
        }
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count = n3;
    }

    @Override
    public void flush() throws IOException {
        this.checkClosed();
    }

    public synchronized void writeTo(OutputStream outputStream) throws IOException {
        this.checkFreed();
        outputStream.write(this.buf, 0, this.count);
    }

    public synchronized int capacity() throws IOException {
        this.checkFreed();
        return this.buf.length;
    }

    public synchronized void reset() throws IOException {
        this.checkClosed();
        this.count = 0;
    }

    public synchronized void trimToSize() throws IOException {
        this.checkFreed();
        if (this.buf.length > this.count) {
            this.buf = this.copyOf(this.buf, this.count);
        }
    }

    public synchronized byte[] toByteArray() throws IOException {
        this.checkFreed();
        return this.copyOf(this.buf, this.count);
    }

    public synchronized int size() throws IOException {
        return this.count;
    }

    public synchronized void setSize(int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n > this.buf.length) {
            this.buf = this.copyOf(this.buf, Math.max(this.buf.length << 1, n));
        }
        this.count = n;
    }

    public synchronized ByteArrayInputStream toByteArrayInputStream() throws IOException {
        this.checkFreed();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.buf, 0, this.count);
        this.free();
        return byteArrayInputStream;
    }

    public synchronized String toString() {
        try {
            this.checkFreed();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
        return new String(this.buf, 0, this.count);
    }

    public synchronized String toString(String string2) throws IOException, UnsupportedEncodingException {
        this.checkFreed();
        return new String(this.buf, 0, this.count, string2);
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized void free() throws IOException {
        this.closed = true;
        this.freed = true;
        this.buf = null;
        this.count = 0;
    }

    public synchronized boolean isFreed() {
        return this.freed;
    }

    protected synchronized void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("stream is closed.");
        }
    }

    protected synchronized void checkFreed() throws IOException {
        if (this.freed) {
            throw new IOException("stream buffer is freed.");
        }
    }

    protected byte[] copyOf(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, n));
        return byArray2;
    }
}

