/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Writer;

public class ClosableCharArrayWriter
extends Writer {
    protected char[] buf;
    protected int count;
    protected boolean closed;
    protected boolean freed;

    public ClosableCharArrayWriter() {
        this(32);
    }

    public ClosableCharArrayWriter(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n);
        }
        this.buf = new char[n];
    }

    @Override
    public synchronized void write(int n) throws IOException {
        this.checkClosed();
        int n2 = this.count + 1;
        if (n2 > this.buf.length) {
            this.buf = this.copyOf(this.buf, Math.max(this.buf.length << 1, n2));
        }
        this.buf[this.count] = (char)n;
        this.count = n2;
    }

    @Override
    public synchronized void write(char[] cArray, int n, int n2) throws IOException {
        this.checkClosed();
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        int n3 = this.count + n2;
        if (n3 > this.buf.length) {
            this.buf = this.copyOf(this.buf, Math.max(this.buf.length << 1, n3));
        }
        System.arraycopy(cArray, n, this.buf, this.count, n2);
        this.count = n3;
    }

    @Override
    public synchronized void write(String string2, int n, int n2) throws IOException {
        this.checkClosed();
        int n3 = string2.length();
        if (n < 0 || n > n3 || n2 < 0 || n + n2 > n3 || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        int n4 = this.count + n2;
        if (n4 > this.buf.length) {
            this.buf = this.copyOf(this.buf, Math.max(this.buf.length << 1, n4));
        }
        string2.getChars(n, n + n2, this.buf, this.count);
        this.count = n4;
    }

    @Override
    public void flush() throws IOException {
        this.checkClosed();
    }

    public synchronized void writeTo(Writer writer) throws IOException {
        this.checkFreed();
        if (this.count > 0) {
            writer.write(this.buf, 0, this.count);
        }
    }

    public synchronized int capacity() throws IOException {
        this.checkFreed();
        return this.buf.length;
    }

    public synchronized void reset() throws IOException {
        this.checkClosed();
        this.count = 0;
    }

    public synchronized void trimToSize() throws IOException {
        this.checkFreed();
        if (this.buf.length > this.count) {
            this.buf = this.copyOf(this.buf, this.count);
        }
    }

    public synchronized char[] toCharArray() throws IOException {
        this.checkFreed();
        return this.copyOf(this.buf, this.count);
    }

    public synchronized int size() throws IOException {
        return this.count;
    }

    public synchronized void setSize(int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n > this.buf.length) {
            this.buf = this.copyOf(this.buf, Math.max(this.buf.length << 1, n));
        }
        this.count = n;
    }

    public synchronized CharArrayReader toCharArrayReader() throws IOException {
        this.checkFreed();
        CharArrayReader charArrayReader = new CharArrayReader(this.buf, 0, this.count);
        this.free();
        return charArrayReader;
    }

    public synchronized String toString() {
        try {
            this.checkFreed();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
        return new String(this.buf, 0, this.count);
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized void free() throws IOException {
        this.closed = true;
        this.freed = true;
        this.buf = null;
        this.count = 0;
    }

    public synchronized boolean isFreed() {
        return this.freed;
    }

    protected synchronized void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("writer is closed.");
        }
    }

    protected synchronized void checkFreed() throws IOException {
        if (this.freed) {
            throw new IOException("write buffer is freed.");
        }
    }

    protected char[] copyOf(char[] cArray, int n) {
        char[] cArray2 = new char[n];
        System.arraycopy(cArray, 0, cArray2, 0, Math.min(cArray.length, n));
        return cArray2;
    }
}

