/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Random;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.lib.java.JavaSystem;

public class FileUtil
implements FileAccess {
    private static FileUtil fileUtil = new FileUtil();
    private static FileAccessRes fileAccessRes = new FileAccessRes();
    public final boolean fsIsIgnoreCase = new File("A").equals(new File("a"));
    public final boolean fsNormalizesPosixSeparator = new File("/").getPath().endsWith(File.separator);
    final Random random = new Random(System.currentTimeMillis());
    static int discardSuffixLength = 9;

    FileUtil() {
    }

    public static FileUtil getFileUtil() {
        return fileUtil;
    }

    public static FileAccess getFileAccess(boolean bl) {
        return bl ? fileAccessRes : fileUtil;
    }

    @Override
    public boolean isStreamElement(String string2) {
        return new File(string2).exists();
    }

    @Override
    public InputStream openInputStreamElement(String string2) throws IOException {
        try {
            return new FileInputStream(new File(string2));
        }
        catch (Throwable throwable) {
            throw JavaSystem.toIOException(throwable);
        }
    }

    @Override
    public void createParentDirs(String string2) {
        this.makeParentDirectories(new File(string2));
    }

    @Override
    public void removeElement(String string2) {
        if (this.isStreamElement(string2)) {
            this.delete(string2);
        }
    }

    @Override
    public void renameElement(String string2, String string3) {
        this.renameWithOverwrite(string2, string3);
    }

    @Override
    public OutputStream openOutputStreamElement(String string2) throws IOException {
        return new FileOutputStream(new File(string2), true);
    }

    public boolean delete(String string2) {
        return new File(string2).delete();
    }

    public void deleteOnExit(File file) {
        file.deleteOnExit();
    }

    public boolean exists(String string2) {
        return new File(string2).exists();
    }

    public boolean exists(String string2, boolean bl, Class clazz) {
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        return bl ? null != clazz.getResource(string2) : FileUtil.getFileUtil().exists(string2);
    }

    private boolean renameWithOverwrite(String string2, String string3) {
        File file = new File(string2);
        this.delete(string3);
        boolean bl = file.renameTo(new File(string3));
        if (bl) {
            return true;
        }
        System.gc();
        this.delete(string3);
        if (this.exists(string3)) {
            new File(string3).renameTo(new File(FileUtil.newDiscardFileName(string3)));
        }
        return file.renameTo(new File(string3));
    }

    public String absolutePath(String string2) {
        return new File(string2).getAbsolutePath();
    }

    public File canonicalFile(File file) throws IOException {
        return new File(file.getCanonicalPath());
    }

    public File canonicalFile(String string2) throws IOException {
        return new File(new File(string2).getCanonicalPath());
    }

    public String canonicalPath(File file) throws IOException {
        return file.getCanonicalPath();
    }

    public String canonicalPath(String string2) throws IOException {
        return new File(string2).getCanonicalPath();
    }

    public String canonicalOrAbsolutePath(String string2) {
        try {
            return this.canonicalPath(string2);
        }
        catch (Exception exception) {
            return this.absolutePath(string2);
        }
    }

    public void makeParentDirectories(File file) {
        String string2 = file.getParent();
        if (string2 != null) {
            new File(string2).mkdirs();
        } else {
            string2 = file.getPath();
            int n = string2.lastIndexOf(47);
            if (n > 0) {
                string2 = string2.substring(0, n);
                new File(string2).mkdirs();
            }
        }
    }

    public static String makeDirectories(String string2) {
        try {
            File file = new File(string2);
            file.mkdirs();
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public FileAccess.FileSync getFileSync(OutputStream outputStream) throws IOException {
        return new FileSync((FileOutputStream)outputStream);
    }

    public static boolean deleteOrRenameDatabaseFiles(String string2) {
        int n;
        DatabaseFilenameFilter databaseFilenameFilter = new DatabaseFilenameFilter(string2);
        File[] fileArray = databaseFilenameFilter.getExistingFileListInDirectory();
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i].delete();
        }
        File file = new File(databaseFilenameFilter.canonicalFile.getPath() + ".tmp");
        if (file.isDirectory()) {
            File[] fileArray2 = file.listFiles();
            if (fileArray2 != null) {
                for (int i = 0; i < fileArray2.length; ++i) {
                    fileArray2[i].delete();
                }
            }
            file.delete();
        }
        if ((fileArray = databaseFilenameFilter.getExistingMainFileSetList()).length == 0) {
            return true;
        }
        System.gc();
        for (n = 0; n < fileArray.length; ++n) {
            fileArray[n].delete();
        }
        fileArray = databaseFilenameFilter.getExistingMainFileSetList();
        for (n = 0; n < fileArray.length; ++n) {
            fileArray[n].renameTo(new File(FileUtil.newDiscardFileName(fileArray[n].getPath())));
        }
        return true;
    }

    public static File[] getDatabaseFileList(String string2) {
        DatabaseFilenameFilter databaseFilenameFilter = new DatabaseFilenameFilter(string2);
        return databaseFilenameFilter.getExistingFileListInDirectory();
    }

    public static File[] getDatabaseMainFileList(String string2) {
        DatabaseFilenameFilter databaseFilenameFilter = new DatabaseFilenameFilter(string2, false);
        return databaseFilenameFilter.getExistingFileListInDirectory();
    }

    public static String newDiscardFileName(String string2) {
        String string3 = StringUtil.toPaddedString(Integer.toHexString((int)System.currentTimeMillis()), discardSuffixLength - 1, '0', true);
        String string4 = string2 + "." + string3 + ".old";
        return string4;
    }

    static class DatabaseFilenameFilter
    implements FilenameFilter {
        String[] suffixes = new String[]{".backup", ".properties", ".script", ".data", ".log", ".lobs"};
        String[] extraSuffixes = new String[]{".lck", ".sql.log", ".app.log"};
        private String dbName;
        private File parent;
        private File canonicalFile;
        private boolean extraFiles;

        DatabaseFilenameFilter(String string2) {
            this(string2, true);
        }

        DatabaseFilenameFilter(String string2, boolean bl) {
            this.canonicalFile = new File(string2);
            try {
                this.canonicalFile = this.canonicalFile.getCanonicalFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.dbName = this.canonicalFile.getName();
            this.parent = this.canonicalFile.getParentFile();
            this.extraFiles = bl;
        }

        public File[] getCompleteMainFileSetList() {
            File[] fileArray = new File[this.suffixes.length];
            for (int i = 0; i < this.suffixes.length; ++i) {
                fileArray[i] = new File(this.canonicalFile.getPath() + this.suffixes[i]);
            }
            return fileArray;
        }

        public File[] getExistingMainFileSetList() {
            File[] fileArray = this.getCompleteMainFileSetList();
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].exists()) continue;
                hsqlArrayList.add(fileArray[i]);
            }
            fileArray = new File[hsqlArrayList.size()];
            hsqlArrayList.toArray(fileArray);
            return fileArray;
        }

        public File[] getExistingFileListInDirectory() {
            File[] fileArray = this.parent.listFiles(this);
            return fileArray == null ? new File[]{} : fileArray;
        }

        @Override
        public boolean accept(File file, String string2) {
            if (this.parent.equals(file) && string2.indexOf(this.dbName) == 0) {
                int n;
                String string3 = string2.substring(this.dbName.length());
                if (this.extraFiles) {
                    for (n = 0; n < this.extraSuffixes.length; ++n) {
                        if (!string3.equals(this.extraSuffixes[n])) continue;
                        return true;
                    }
                }
                for (n = 0; n < this.suffixes.length; ++n) {
                    if (string3.equals(this.suffixes[n])) {
                        return true;
                    }
                    if (!this.extraFiles || !string3.startsWith(this.suffixes[n]) || !(string2.endsWith(".new") ? string3.length() == this.suffixes[n].length() + 4 : string2.endsWith(".old") && string3.length() == this.suffixes[n].length() + discardSuffixLength + 4)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class FileAccessRes
    implements FileAccess {
        @Override
        public boolean isStreamElement(String string2) {
            URL uRL = null;
            try {
                ClassLoader classLoader;
                uRL = this.getClass().getResource(string2);
                if (uRL == null && (classLoader = Thread.currentThread().getContextClassLoader()) != null) {
                    uRL = classLoader.getResource(string2);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return uRL != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InputStream openInputStreamElement(String string2) throws IOException {
            InputStream inputStream = null;
            try {
                ClassLoader classLoader;
                inputStream = this.getClass().getResourceAsStream(string2);
                if (inputStream == null && (classLoader = Thread.currentThread().getContextClassLoader()) != null) {
                    inputStream = classLoader.getResourceAsStream(string2);
                }
            }
            catch (Throwable throwable) {
                if (inputStream == null) {
                    throw new FileNotFoundException(string2);
                }
            }
            finally {
                if (inputStream == null) {
                    throw new FileNotFoundException(string2);
                }
            }
            return inputStream;
        }

        @Override
        public void createParentDirs(String string2) {
        }

        @Override
        public void removeElement(String string2) {
        }

        @Override
        public void renameElement(String string2, String string3) {
        }

        @Override
        public OutputStream openOutputStreamElement(String string2) throws IOException {
            throw new IOException();
        }

        @Override
        public FileAccess.FileSync getFileSync(OutputStream outputStream) throws IOException {
            throw new IOException();
        }
    }

    public static class FileSync
    implements FileAccess.FileSync {
        FileDescriptor outDescriptor;

        FileSync(FileOutputStream fileOutputStream) throws IOException {
            this.outDescriptor = fileOutputStream.getFD();
        }

        @Override
        public void sync() throws IOException {
            this.outDescriptor.sync();
        }
    }
}

