/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.hsqldb.lib.BasicTextJdkLogFormatter;

public class FrameworkLogger {
    private static Map loggerInstances = new HashMap();
    private static Map jdkToLog4jLevels = new HashMap();
    private static Method log4jGetLogger;
    private static Method log4jLogMethod;
    private static boolean callerFqcnAvailable;
    private Object log4jLogger;
    private Logger jdkLogger;
    private static boolean noopMode;

    public static synchronized String report() {
        return loggerInstances.size() + " logger instances:  " + loggerInstances.keySet();
    }

    public static synchronized void clearLoggers(String string2) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator2 = loggerInstances.keySet().iterator();
        String string3 = string2 + '.';
        while (iterator2.hasNext()) {
            String string4 = (String)iterator2.next();
            if (!string4.equals(string2) && !string4.startsWith(string3)) continue;
            hashSet.add(string4);
        }
        loggerInstances.keySet().removeAll(hashSet);
    }

    private static synchronized void populateJdkToLog4jLevels(String string2) throws ClassNotFoundException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Method method = Class.forName(string2).getMethod("toLevel", String.class);
        jdkToLog4jLevels.put(Level.ALL, method.invoke(null, "ALL"));
        jdkToLog4jLevels.put(Level.FINER, method.invoke(null, "DEBUG"));
        jdkToLog4jLevels.put(Level.WARNING, method.invoke(null, "ERROR"));
        jdkToLog4jLevels.put(Level.SEVERE, method.invoke(null, "FATAL"));
        jdkToLog4jLevels.put(Level.INFO, method.invoke(null, "INFO"));
        jdkToLog4jLevels.put(Level.OFF, method.invoke(null, "OFF"));
        jdkToLog4jLevels.put(Level.FINEST, method.invoke(null, "TRACE"));
        jdkToLog4jLevels.put(Level.WARNING, method.invoke(null, "WARN"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reconfigure() {
        noopMode = false;
        Class<?> clazz = null;
        Class<?> clazz2 = null;
        loggerInstances.clear();
        jdkToLog4jLevels.clear();
        log4jGetLogger = null;
        log4jLogMethod = null;
        callerFqcnAvailable = false;
        try {
            clazz = Class.forName("org.apache.logging.log4j.Logger");
            clazz2 = Class.forName("org.apache.logging.log4j.LogManager");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz != null) {
            try {
                FrameworkLogger.populateJdkToLog4jLevels("org.apache.logging.log4j.Level");
                log4jLogMethod = clazz.getMethod("log", Class.forName("org.apache.logging.log4j.Level"), Object.class, Throwable.class);
                log4jGetLogger = clazz2.getMethod("getLogger", String.class);
                return;
            }
            catch (Exception exception) {
                try {
                    System.err.println("<clinit> failure instantiating configured Log4j v2 system: " + exception);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        clazz = null;
        clazz2 = null;
        log4jLogMethod = null;
        log4jGetLogger = null;
        jdkToLog4jLevels.clear();
        try {
            clazz = Class.forName("org.apache.log4j.Logger");
            clazz2 = clazz;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz != null) {
            try {
                FrameworkLogger.populateJdkToLog4jLevels("org.apache.log4j.Level");
                log4jLogMethod = clazz.getMethod("log", String.class, Class.forName("org.apache.log4j.Priority"), Object.class, Throwable.class);
                log4jGetLogger = clazz2.getMethod("getLogger", String.class);
                callerFqcnAvailable = true;
                return;
            }
            catch (Exception exception) {
                try {
                    System.err.println("<clinit> failure instantiating configured Log4j v1 system: " + exception);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        clazz = null;
        clazz2 = null;
        log4jLogMethod = null;
        log4jGetLogger = null;
        callerFqcnAvailable = false;
        jdkToLog4jLevels.clear();
        String string2 = System.getProperty("hsqldb.reconfig_logging");
        if (string2 != null && string2.equalsIgnoreCase("false")) {
            return;
        }
        InputStream inputStream = null;
        try {
            LogManager logManager = LogManager.getLogManager();
            String string3 = "/org/hsqldb/resources/jdklogging-default.properties";
            if (FrameworkLogger.isDefaultJdkConfig()) {
                logManager.reset();
                ConsoleHandler consoleHandler = new ConsoleHandler();
                consoleHandler.setFormatter(new BasicTextJdkLogFormatter(false));
                consoleHandler.setLevel(Level.INFO);
                inputStream = FrameworkLogger.class.getResourceAsStream(string3);
                logManager.readConfiguration(inputStream);
                Logger logger = Logger.getLogger("org.hsqldb.cmdline");
                logger.addHandler(consoleHandler);
                logger.setUseParentHandlers(false);
            } else {
                logManager.readConfiguration();
            }
        }
        catch (Exception exception) {
            noopMode = true;
            System.err.println("<clinit> failure initializing JDK logging system.  Continuing without Application logging.");
            exception.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    System.err.println("Failed to close logging input stream: " + iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FrameworkLogger(String string2) {
        if (!noopMode) {
            if (log4jGetLogger == null) {
                this.jdkLogger = Logger.getLogger(string2);
            } else {
                try {
                    this.log4jLogger = log4jGetLogger.invoke(null, string2);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Failed to instantiate Log4j Logger", exception);
                }
            }
        }
        Class<FrameworkLogger> clazz = FrameworkLogger.class;
        synchronized (FrameworkLogger.class) {
            loggerInstances.put(string2, this);
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }

    public static FrameworkLogger getLog(Class clazz) {
        return FrameworkLogger.getLog(clazz.getName());
    }

    public static FrameworkLogger getLog(Class clazz, String string2) {
        return string2 == null ? FrameworkLogger.getLog(clazz) : FrameworkLogger.getLog(string2 + '.' + clazz.getName());
    }

    public static FrameworkLogger getLog(String string2, String string3) {
        return string3 == null ? FrameworkLogger.getLog(string2) : FrameworkLogger.getLog(string3 + '.' + string2);
    }

    public static synchronized FrameworkLogger getLog(String string2) {
        if (loggerInstances.containsKey(string2)) {
            return (FrameworkLogger)loggerInstances.get(string2);
        }
        return new FrameworkLogger(string2);
    }

    public void log(Level level, String string2, Throwable throwable) {
        this.privlog(level, string2, throwable, 2, FrameworkLogger.class);
    }

    public void privlog(Level level, String string2, Throwable throwable, int n, Class clazz) {
        if (noopMode) {
            return;
        }
        if (this.log4jLogger == null) {
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            String string3 = "";
            String string4 = "";
            if (stackTraceElementArray.length > n) {
                string3 = stackTraceElementArray[n].getClassName();
                string4 = stackTraceElementArray[n].getMethodName();
            }
            if (throwable == null) {
                this.jdkLogger.logp(level, string3, string4, string2);
            } else {
                this.jdkLogger.logp(level, string3, string4, string2, throwable);
            }
        } else {
            try {
                Object[] objectArray;
                if (callerFqcnAvailable) {
                    Object[] objectArray2 = new Object[4];
                    objectArray2[0] = clazz.getName();
                    objectArray2[1] = jdkToLog4jLevels.get(level);
                    objectArray2[2] = string2;
                    objectArray = objectArray2;
                    objectArray2[3] = throwable;
                } else {
                    Object[] objectArray3 = new Object[3];
                    objectArray3[0] = jdkToLog4jLevels.get(level);
                    objectArray3[1] = string2;
                    objectArray = objectArray3;
                    objectArray3[2] = throwable;
                }
                log4jLogMethod.invoke(this.log4jLogger, objectArray);
            }
            catch (Exception exception) {
                throw new RuntimeException("Logging failed when attempting to log: " + string2, exception);
            }
        }
    }

    public void enduserlog(Level level, String string2) {
        if (noopMode) {
            return;
        }
        if (this.log4jLogger == null) {
            String string3 = FrameworkLogger.class.getName();
            String string4 = "\\l";
            this.jdkLogger.logp(level, string3, string4, string2);
        } else {
            try {
                Object[] objectArray;
                if (callerFqcnAvailable) {
                    Object[] objectArray2 = new Object[4];
                    objectArray2[0] = FrameworkLogger.class.getName();
                    objectArray2[1] = jdkToLog4jLevels.get(level);
                    objectArray2[2] = string2;
                    objectArray = objectArray2;
                    objectArray2[3] = null;
                } else {
                    Object[] objectArray3 = new Object[3];
                    objectArray3[0] = jdkToLog4jLevels.get(level);
                    objectArray3[1] = string2;
                    objectArray = objectArray3;
                    objectArray3[2] = null;
                }
                log4jLogMethod.invoke(this.log4jLogger, objectArray);
            }
            catch (Exception exception) {
                throw new RuntimeException("Logging failed when attempting to log: " + string2, exception);
            }
        }
    }

    public void log(Level level, String string2) {
        this.privlog(level, string2, null, 2, FrameworkLogger.class);
    }

    public void finer(String string2) {
        this.privlog(Level.FINER, string2, null, 2, FrameworkLogger.class);
    }

    public void warning(String string2) {
        this.privlog(Level.WARNING, string2, null, 2, FrameworkLogger.class);
    }

    public void severe(String string2) {
        this.privlog(Level.SEVERE, string2, null, 2, FrameworkLogger.class);
    }

    public void info(String string2) {
        this.privlog(Level.INFO, string2, null, 2, FrameworkLogger.class);
    }

    public void finest(String string2) {
        this.privlog(Level.FINEST, string2, null, 2, FrameworkLogger.class);
    }

    public void error(String string2) {
        this.privlog(Level.WARNING, string2, null, 2, FrameworkLogger.class);
    }

    public void finer(String string2, Throwable throwable) {
        this.privlog(Level.FINER, string2, throwable, 2, FrameworkLogger.class);
    }

    public void warning(String string2, Throwable throwable) {
        this.privlog(Level.WARNING, string2, throwable, 2, FrameworkLogger.class);
    }

    public void severe(String string2, Throwable throwable) {
        this.privlog(Level.SEVERE, string2, throwable, 2, FrameworkLogger.class);
    }

    public void info(String string2, Throwable throwable) {
        this.privlog(Level.INFO, string2, throwable, 2, FrameworkLogger.class);
    }

    public void finest(String string2, Throwable throwable) {
        this.privlog(Level.FINEST, string2, throwable, 2, FrameworkLogger.class);
    }

    public void error(String string2, Throwable throwable) {
        this.privlog(Level.WARNING, string2, throwable, 2, FrameworkLogger.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDefaultJdkConfig() {
        File file = new File(System.getProperty("java.home"), "lib/logging.properties");
        if (!file.isFile()) {
            return false;
        }
        FileInputStream fileInputStream = null;
        LogManager logManager = LogManager.getLogManager();
        try {
            fileInputStream = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            Enumeration<?> enumeration = properties.propertyNames();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                ++n;
                String string2 = (String)enumeration.nextElement();
                String string3 = logManager.getProperty(string2);
                if (string3 == null) {
                    boolean bl = false;
                    return bl;
                }
                if (logManager.getProperty(string2).equals(string3)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static {
        callerFqcnAvailable = false;
        try {
            FrameworkLogger.reconfigure();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

