/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.hsqldb.lib.StringConverter;

public class HsqlByteArrayInputStream
extends InputStream
implements DataInput {
    protected byte[] buffer;
    protected int pos;
    protected int mark = 0;
    protected int count;

    public HsqlByteArrayInputStream(byte[] byArray) {
        this.buffer = byArray;
        this.pos = 0;
        this.count = byArray.length;
    }

    public HsqlByteArrayInputStream(byte[] byArray, int n, int n2) {
        this.buffer = byArray;
        this.pos = n;
        this.count = Math.min(n + n2, byArray.length);
        this.mark = n;
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < n2; i += n3) {
            n3 = this.read(byArray, n + i, n2 - i);
            if (n3 >= 0) continue;
            throw new EOFException();
        }
    }

    @Override
    public boolean readBoolean() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    @Override
    public short readShort() throws IOException {
        if (this.count - this.pos < 2) {
            this.pos = this.count;
            throw new EOFException();
        }
        int n = this.buffer[this.pos++] & 0xFF;
        int n2 = this.buffer[this.pos++] & 0xFF;
        return (short)((n << 8) + n2);
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + n;
    }

    @Override
    public char readChar() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + n);
    }

    @Override
    public int readInt() throws IOException {
        if (this.count - this.pos < 4) {
            this.pos = this.count;
            throw new EOFException();
        }
        int n = this.buffer[this.pos++] & 0xFF;
        int n2 = this.buffer[this.pos++] & 0xFF;
        int n3 = this.buffer[this.pos++] & 0xFF;
        int n4 = this.buffer[this.pos++] & 0xFF;
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    @Override
    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return (int)this.skip(n);
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public String readUTF() throws IOException {
        int n = this.readUnsignedShort();
        if (this.pos + n >= this.count) {
            throw new EOFException();
        }
        String string2 = StringConverter.readUTF(this.buffer, this.pos, n);
        this.pos += n;
        return string2;
    }

    @Override
    public int read() {
        return this.pos < this.count ? this.buffer[this.pos++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + n2 > this.count) {
            n2 = this.count - this.pos;
        }
        if (n2 <= 0) {
            return 0;
        }
        System.arraycopy(this.buffer, this.pos, byArray, n, n2);
        this.pos += n2;
        return n2;
    }

    @Override
    public long skip(long l) {
        if ((long)this.pos + l > (long)this.count) {
            l = this.count - this.pos;
        }
        if (l < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + l);
        return l;
    }

    @Override
    public int available() {
        return this.count - this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int n) {
        this.mark = this.pos;
    }

    @Override
    public void reset() {
        this.pos = this.mark;
    }

    @Override
    public void close() throws IOException {
    }
}

