/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.tar;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hsqldb.lib.tar.RB;
import org.hsqldb.lib.tar.TarMalformatException;

public class PIFData
extends HashMap<String, String> {
    static final long serialVersionUID = 3086795680582315773L;
    private static Pattern pifRecordPattern = Pattern.compile("\\d+ +([^=]+)=(.*)");
    private Long sizeObject = null;

    public Long getSize() {
        return this.sizeObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PIFData(InputStream inputStream) throws TarMalformatException, IOException {
        String string2;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            int n = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                ++n;
                Matcher matcher = pifRecordPattern.matcher(string2);
                if (!matcher.matches()) {
                    throw new TarMalformatException(RB.pif_malformat.getString(n, string2));
                }
                String string3 = matcher.group(1);
                String string4 = matcher.group(2);
                if (string4 == null || string4.length() < 1) {
                    this.remove(string3);
                    continue;
                }
                this.put(string3, string4);
            }
        }
        finally {
            try {
                inputStream.close();
            }
            finally {
                bufferedReader = null;
            }
        }
        string2 = (String)this.get("size");
        if (string2 != null) {
            try {
                this.sizeObject = Long.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new TarMalformatException(RB.pif_malformat_size.getString(string2));
            }
        }
    }
}

