/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.map;

import org.hsqldb.lib.ArrayUtil;

public class BitMap {
    private boolean canChangeSize;
    private int initialSize;
    private int[] map;
    private int limitPos;

    public BitMap(int n, boolean bl) {
        int n2 = n / 32;
        if (n == 0 || n % 32 != 0) {
            ++n2;
        }
        this.map = new int[n2];
        this.canChangeSize = bl;
        this.limitPos = n;
        this.initialSize = n;
    }

    public BitMap(int[] nArray) {
        this.map = nArray;
        this.limitPos = this.initialSize = nArray.length * 32;
        this.canChangeSize = false;
    }

    public BitMap duplicate() {
        BitMap bitMap = new BitMap((int[])ArrayUtil.duplicateArray(this.map));
        bitMap.canChangeSize = this.canChangeSize;
        bitMap.initialSize = this.initialSize;
        bitMap.limitPos = this.limitPos;
        return bitMap;
    }

    public int size() {
        return this.limitPos;
    }

    public void setSize(int n) {
        if (!this.canChangeSize) {
            throw new UnsupportedOperationException("BitMap");
        }
        this.ensureCapacity(n);
        if (this.limitPos > n) {
            this.unsetRange(n, this.limitPos - n);
            this.limitPos = n;
        }
    }

    public void reset() {
        for (int i = 0; i < this.map.length; ++i) {
            this.map[i] = 0;
        }
        this.limitPos = this.initialSize;
    }

    public int countSetMatches(BitMap bitMap) {
        int n = 0;
        for (int i = 0; i < this.map.length; ++i) {
            int n2 = this.map[i] & bitMap.map[i];
            if (n2 == 0) continue;
            n += Integer.bitCount(n2);
        }
        return n;
    }

    public int setRange(int n, int n2) {
        return this.setOrUnsetRange(n, n2, true);
    }

    public int unsetRange(int n, int n2) {
        return this.setOrUnsetRange(n, n2, false);
    }

    private int setOrUnsetRange(int n, int n2, boolean bl) {
        if (n2 == 0) {
            return 0;
        }
        this.ensureCapacity(n + n2);
        int n3 = n >> 5;
        int n4 = n + n2 - 1 >> 5;
        int n5 = -1 >>> (n & 0x1F);
        int n6 = Integer.MIN_VALUE >> (n + n2 - 1 & 0x1F);
        if (n3 == n4) {
            n5 &= n6;
        }
        int n7 = this.map[n3];
        int n8 = Integer.bitCount(n7 & n5);
        this.map[n3] = bl ? n7 | n5 : n7 & (n5 ^= 0xFFFFFFFF);
        if (n3 != n4) {
            n7 = this.map[n4];
            n8 += Integer.bitCount(n7 & n6);
            this.map[n4] = bl ? n7 | n6 : n7 & (n6 ^= 0xFFFFFFFF);
            for (int i = n3 + 1; i < n4; ++i) {
                n8 += Integer.bitCount(this.map[i]);
                this.map[i] = bl ? -1 : 0;
            }
        }
        return bl ? n2 - n8 : n8;
    }

    public int setValue(int n, boolean bl) {
        return bl ? this.set(n) : this.unset(n);
    }

    public int set(int n) {
        this.ensureCapacity(n + 1);
        int n2 = n >> 5;
        int n3 = Integer.MIN_VALUE >>> (n & 0x1F);
        int n4 = this.map[n2];
        int n5 = (n4 & n3) == 0 ? 0 : 1;
        this.map[n2] = n4 | n3;
        return n5;
    }

    public int unset(int n) {
        this.ensureCapacity(n + 1);
        int n2 = n >> 5;
        int n3 = Integer.MIN_VALUE >>> (n & 0x1F);
        int n4 = this.map[n2];
        int n5 = (n4 & n3) == 0 ? 0 : 1;
        this.map[n2] = n4 & (n3 ^= 0xFFFFFFFF);
        return n5;
    }

    public int get(int n) {
        if (n >= this.limitPos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = n >> 5;
        int n3 = this.map[n2];
        int n4 = Integer.MIN_VALUE >>> (n & 0x1F);
        return (n3 & n4) == 0 ? 0 : 1;
    }

    public boolean isSet(int n) {
        return this.get(n) == 1;
    }

    public void set(BitMap bitMap) {
        int n = 0;
        while (n < this.map.length) {
            int n2 = bitMap.map[n];
            int n3 = n++;
            this.map[n3] = this.map[n3] | n2;
        }
    }

    public int countSet(int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            if (!this.isSet(i)) continue;
            ++n3;
        }
        return n3;
    }

    public int countSetBits() {
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.limitPos / 32; ++n2) {
            n = this.map[n2];
            if (n == 0) continue;
            if (n == -1) {
                n3 += 32;
                continue;
            }
            n3 += Integer.bitCount(n);
        }
        if (this.limitPos % 32 != 0) {
            n2 = Integer.MIN_VALUE >> (this.limitPos - 1 & 0x1F);
            n = this.map[this.limitPos / 32] & n2;
            n3 += Integer.bitCount(n);
        }
        return n3;
    }

    public int countSetBitsEnd() {
        int n = 0;
        for (int i = this.limitPos / 32 - 1; i >= 0; --i) {
            if (this.map[i] == -1) {
                n += 32;
                continue;
            }
            int n2 = BitMap.countSetBitsEnd(this.map[i]);
            n += n2;
            break;
        }
        return n;
    }

    public int[] getIntArray() {
        return this.map;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[(this.limitPos + 7) / 8];
        if (byArray.length == 0) {
            return byArray;
        }
        int n = 0;
        do {
            int n2 = this.map[n / 4];
            byArray[n++] = (byte)(n2 >>> 24);
            if (n == byArray.length) break;
            byArray[n++] = (byte)(n2 >>> 16);
            if (n == byArray.length) break;
            byArray[n++] = (byte)(n2 >>> 8);
            if (n == byArray.length) break;
            byArray[n++] = (byte)n2;
        } while (n != byArray.length);
        return byArray;
    }

    private void ensureCapacity(int n) {
        if (n > this.limitPos && !this.canChangeSize) {
            throw new ArrayStoreException("BitMap extend");
        }
        if (n <= this.map.length * 32) {
            if (n > this.limitPos) {
                this.limitPos = n;
            }
            return;
        }
        int n2 = this.map.length;
        while (n > n2 * 32) {
            n2 *= 2;
        }
        int[] nArray = new int[n2];
        System.arraycopy(this.map, 0, nArray, 0, this.map.length);
        this.map = nArray;
        this.limitPos = n;
    }

    public static int countSetBitsEnd(int n) {
        int n2;
        int n3 = 1;
        for (n2 = 0; n2 < 32 && (n & n3) != 0; ++n2) {
            n >>= 1;
        }
        return n2;
    }

    public static int countUnsetBitsStart(int n) {
        int n2;
        int n3 = Integer.MIN_VALUE;
        if (n == 0) {
            return 32;
        }
        for (n2 = 0; n2 < 32 && (n & n3) == 0; ++n2) {
            n3 >>>= 1;
        }
        return n2;
    }

    public static int setByte(int n, byte by2, int n2) {
        int n3 = (by2 & 0xFF) << 24 - n2;
        int n4 = -16777216 >>> n2;
        return (n &= (n4 ^= 0xFFFFFFFF)) | n3;
    }

    public static int set(int n, int n2) {
        int n3 = Integer.MIN_VALUE >>> n2;
        return n | n3;
    }

    public static byte set(byte by2, int n) {
        int n2 = 128 >>> n;
        return (byte)(by2 | n2);
    }

    public static int unset(int n, int n2) {
        int n3 = Integer.MIN_VALUE >>> n2;
        return n & (n3 ^= 0xFFFFFFFF);
    }

    public static boolean isSet(int n, int n2) {
        int n3 = Integer.MIN_VALUE >>> n2;
        return (n & n3) != 0;
    }

    public static boolean isSet(byte by2, int n) {
        int n2 = 128 >>> n;
        return (by2 & n2) != 0;
    }

    public static boolean isSet(byte[] byArray, int n) {
        int n2 = 128 >>> (n & 7);
        int n3 = n / 8;
        if (n3 >= byArray.length) {
            return false;
        }
        byte by2 = byArray[n3];
        return (by2 & n2) != 0;
    }

    public static void unset(byte[] byArray, int n) {
        int n2 = 128 >>> (n & 7);
        n2 ^= 0xFFFFFFFF;
        int n3 = n / 8;
        if (n3 >= byArray.length) {
            return;
        }
        byte by2 = byArray[n3];
        byArray[n3] = (byte)(by2 & n2);
    }

    public static void set(byte[] byArray, int n) {
        int n2 = 128 >>> (n & 7);
        int n3 = n / 8;
        if (n3 >= byArray.length) {
            return;
        }
        byte by2 = byArray[n3];
        byArray[n3] = (byte)(by2 | n2);
    }

    public static void and(byte[] byArray, int n, byte by2, int n2) {
        int n3 = n & 7;
        int n4 = (by2 & 0xFF) >>> n3;
        int n5 = 255 >> n3;
        int n6 = n / 8;
        if (n2 < 8) {
            n5 >>>= 8 - n2;
            n5 <<= 8 - n2;
        }
        n4 &= n5;
        n5 ^= 0xFFFFFFFF;
        if (n6 >= byArray.length) {
            return;
        }
        byte by3 = byArray[n6];
        byArray[n6] = (byte)(by3 & n5);
        by3 = (byte)(by3 & n4);
        byArray[n6] = (byte)(byArray[n6] | by3);
        if (n3 == 0) {
            return;
        }
        if (n2 > (n3 = 8 - n3)) {
            n4 = (by2 & 0xFF) << 8 >>> n3;
            n5 = 65280 >>> n3;
            by3 = byArray[n6 + 1];
            byArray[n6 + 1] = (byte)(by3 & (n5 ^= 0xFFFFFFFF));
            by3 = (byte)(by3 & n4);
            byArray[n6 + 1] = (byte)(byArray[n6 + 1] | by3);
        }
    }

    public static void or(byte[] byArray, int n, byte by2, int n2) {
        byte by3;
        int n3 = n & 7;
        int n4 = (by2 & 0xFF) >>> n3;
        int n5 = n / 8;
        if (n5 >= byArray.length) {
            return;
        }
        byArray[n5] = by3 = (byte)(byArray[n5] | n4);
        if (n3 == 0) {
            return;
        }
        if (n2 > (n3 = 8 - n3)) {
            n4 = (by2 & 0xFF) << 8 >>> n3;
            byArray[n5 + 1] = by3 = (byte)(byArray[n5 + 1] | n4);
        }
    }

    public static void overlay(byte[] byArray, int n, byte by2, int n2) {
        int n3 = n & 7;
        int n4 = (by2 & 0xFF) >>> n3;
        int n5 = 255 >> n3;
        int n6 = n / 8;
        if (n2 < 8) {
            n5 >>>= 8 - n2;
            n5 <<= 8 - n2;
        }
        n4 &= n5;
        n5 ^= 0xFFFFFFFF;
        if (n6 >= byArray.length) {
            return;
        }
        byte by3 = byArray[n6];
        by3 = (byte)(by3 & n5);
        byArray[n6] = (byte)(by3 | n4);
        if (n3 == 0) {
            return;
        }
        if (n2 > (n3 = 8 - n3)) {
            n4 = (by2 & 0xFF) << 8 >>> n3;
            n5 = 65280 >>> n3;
            by3 = byArray[n6 + 1];
            by3 = (byte)(by3 & (n5 ^= 0xFFFFFFFF));
            byArray[n6 + 1] = (byte)(by3 | n4);
        }
    }

    public static byte[] and(byte[] byArray, byte[] byArray2) {
        int n = byArray.length > byArray2.length ? byArray.length : byArray2.length;
        int n2 = byArray.length > byArray2.length ? byArray2.length : byArray.length;
        byte[] byArray3 = new byte[n];
        for (int i = 0; i < n2; ++i) {
            byArray3[i] = (byte)(byArray[i] & byArray2[i]);
        }
        return byArray3;
    }

    public static byte[] or(byte[] byArray, byte[] byArray2) {
        int n = byArray.length > byArray2.length ? byArray.length : byArray2.length;
        int n2 = byArray.length > byArray2.length ? byArray2.length : byArray.length;
        byte[] byArray3 = new byte[n];
        if (n != n2) {
            byte[] byArray4 = byArray.length > byArray2.length ? byArray : byArray2;
            System.arraycopy(byArray4, n2, byArray3, n2, n - n2);
        }
        for (int i = 0; i < n2; ++i) {
            byArray3[i] = (byte)(byArray[i] | byArray2[i]);
        }
        return byArray3;
    }

    public static byte[] xor(byte[] byArray, byte[] byArray2) {
        int n = byArray.length > byArray2.length ? byArray.length : byArray2.length;
        int n2 = byArray.length > byArray2.length ? byArray2.length : byArray.length;
        byte[] byArray3 = new byte[n];
        if (n != n2) {
            byte[] byArray4 = byArray.length > byArray2.length ? byArray : byArray2;
            System.arraycopy(byArray4, n2, byArray3, n2, n - n2);
        }
        for (int i = 0; i < n2; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
        return byArray3;
    }

    public static byte[] not(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i] = ~byArray[i];
        }
        return byArray2;
    }

    public static boolean hasAnyBitSet(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 0) continue;
            return true;
        }
        return false;
    }

    public static byte[] leftShift(byte[] byArray, int n) {
        byte[] byArray2 = new byte[byArray.length];
        int n2 = n / 8;
        if (n2 >= byArray.length) {
            return byArray2;
        }
        if ((n %= 8) == 0) {
            int n3 = 0;
            for (int i = n2; i < byArray.length; ++i) {
                byArray2[n3] = byArray[i];
                ++n3;
            }
        } else {
            int n4 = 0;
            for (int i = n2; i < byArray.length; ++i) {
                int n5 = (byArray[i] & 0xFF) << n;
                byArray2[n4] = (byte)n5;
                if (n4 > 0) {
                    int n6 = n4 - 1;
                    byArray2[n6] = (byte)(byArray2[n6] | (byte)(n5 >>> 8));
                }
                ++n4;
            }
        }
        return byArray2;
    }
}

