/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.result;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import org.hsqldb.ColumnBase;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.DataOutputStream;
import org.hsqldb.map.ValuePool;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.result.ResultLob;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Collation;
import org.hsqldb.types.Type;

public class Result {
    public static final Result[] emptyArray = new Result[0];
    public static final ResultMetaData sessionAttributesMetaData;
    private static final ResultMetaData emptyMeta;
    public static final Result emptyGeneratedResult;
    public static final Result updateZeroResult;
    public static final Result updateOneResult;
    public byte mode;
    int databaseID;
    long sessionID;
    private long id;
    private String databaseName;
    private String mainString;
    private String subString;
    private String zoneString;
    int errorCode;
    private HsqlException exception;
    long statementID;
    int statementReturnType;
    public int updateCount;
    private int fetchSize;
    private Result chainedResult;
    private int lobCount;
    ResultLob lobResults;
    public ResultMetaData metaData;
    public ResultMetaData parameterMetaData;
    public ResultMetaData generatedMetaData;
    public int rsProperties;
    public int queryTimeout;
    int generateKeys;
    public Object valueData;
    public Statement statement;
    public RowSetNavigator navigator;

    Result(int n) {
        this.mode = (byte)n;
    }

    public Result(int n, int n2) {
        this.mode = (byte)n;
        this.updateCount = n2;
    }

    public static Result newResult(RowSetNavigator rowSetNavigator) {
        Result result2 = new Result(3);
        result2.navigator = rowSetNavigator;
        return result2;
    }

    public static Result newResult(int n) {
        RowSetNavigatorClient rowSetNavigatorClient = null;
        Result result2 = null;
        switch (n) {
            case 35: 
            case 41: 
            case 43: {
                break;
            }
            case 8: 
            case 9: {
                rowSetNavigatorClient = new RowSetNavigatorClient(4);
                break;
            }
            case 6: 
            case 17: {
                rowSetNavigatorClient = new RowSetNavigatorClient(1);
                break;
            }
            case 16: {
                rowSetNavigatorClient = new RowSetNavigatorClient(4);
                break;
            }
            case 3: 
            case 14: 
            case 15: 
            case 20: {
                break;
            }
            case 18: {
                throw Error.runtimeError(201, "Result");
            }
        }
        result2 = new Result(n);
        result2.navigator = rowSetNavigatorClient;
        return result2;
    }

    public static Result newResult(DataInput dataInput, RowInputBinary rowInputBinary) throws IOException {
        return Result.newResult(null, dataInput.readByte(), dataInput, rowInputBinary);
    }

    public static Result newResult(Session session, int n, DataInput dataInput, RowInputBinary rowInputBinary) throws IOException {
        try {
            if (n == 18) {
                return ResultLob.newLob(dataInput, false);
            }
            Result result2 = Result.newResult(session, dataInput, rowInputBinary, n);
            return result2;
        }
        catch (IOException iOException) {
            throw Error.error(1300);
        }
    }

    public void readAdditionalResults(SessionInterface sessionInterface, DataInputStream dataInputStream, RowInputBinary rowInputBinary) throws IOException {
        Result result2 = this;
        this.setSession(sessionInterface);
        byte by2;
        while ((by2 = dataInputStream.readByte()) != 0) {
            result2 = Result.newResult(null, dataInputStream, rowInputBinary, by2);
            this.addChainedResult(result2);
        }
        return;
    }

    public void readLobResults(SessionInterface sessionInterface, DataInputStream dataInputStream, RowInputBinary rowInputBinary) throws IOException {
        byte by2;
        Result result2 = this;
        boolean bl = false;
        this.setSession(sessionInterface);
        while ((by2 = dataInputStream.readByte()) == 18) {
            ResultLob resultLob = ResultLob.newLob(dataInputStream, false);
            if (sessionInterface instanceof Session) {
                ((Session)sessionInterface).allocateResultLob(resultLob, dataInputStream);
            } else {
                result2.addLobResult(resultLob);
            }
            bl = true;
        }
        if (by2 != 0) {
            throw Error.runtimeError(201, "Result");
        }
        if (bl) {
            ((Session)sessionInterface).registerResultLobs(result2);
        }
    }

    private static Result newResult(Session session, DataInput dataInput, RowInputBinary rowInputBinary, int n) throws IOException {
        Result result2 = Result.newResult(n);
        int n2 = dataInput.readInt();
        rowInputBinary.resetRow(0L, n2);
        byte[] byArray = rowInputBinary.getBuffer();
        dataInput.readFully(byArray, 4, n2 - 4);
        block0 : switch (n) {
            case 7: {
                result2.statementReturnType = rowInputBinary.readByte();
                break;
            }
            case 10: 
            case 32: 
            case 39: {
                break;
            }
            case 37: {
                result2.setStatementType(rowInputBinary.readByte());
                result2.mainString = rowInputBinary.readString();
                result2.rsProperties = rowInputBinary.readByte();
                result2.generateKeys = rowInputBinary.readByte();
                if (result2.generateKeys != 11 && result2.generateKeys != 21) break;
                result2.generatedMetaData = new ResultMetaData(rowInputBinary);
                break;
            }
            case 40: {
                result2.id = rowInputBinary.readLong();
                break;
            }
            case 36: {
                result2.statementID = rowInputBinary.readLong();
                break;
            }
            case 34: {
                result2.updateCount = rowInputBinary.readInt();
                result2.fetchSize = rowInputBinary.readInt();
                result2.statementReturnType = rowInputBinary.readByte();
                result2.mainString = rowInputBinary.readString();
                result2.rsProperties = rowInputBinary.readByte();
                result2.queryTimeout = rowInputBinary.readShort();
                result2.generateKeys = rowInputBinary.readByte();
                if (result2.generateKeys != 11 && result2.generateKeys != 21) break;
                result2.generatedMetaData = new ResultMetaData(rowInputBinary);
                break;
            }
            case 31: {
                result2.databaseName = rowInputBinary.readString();
                result2.mainString = rowInputBinary.readString();
                result2.subString = rowInputBinary.readString();
                result2.zoneString = rowInputBinary.readString();
                result2.updateCount = rowInputBinary.readInt();
                break;
            }
            case 2: 
            case 19: {
                result2.mainString = rowInputBinary.readString();
                result2.subString = rowInputBinary.readString();
                result2.errorCode = rowInputBinary.readInt();
                break;
            }
            case 11: {
                result2.databaseID = rowInputBinary.readInt();
                result2.sessionID = rowInputBinary.readLong();
                result2.databaseName = rowInputBinary.readString();
                result2.mainString = rowInputBinary.readString();
                result2.generateKeys = rowInputBinary.readInt();
                break;
            }
            case 1: {
                result2.updateCount = rowInputBinary.readInt();
                break;
            }
            case 33: {
                int n3 = rowInputBinary.readInt();
                result2.setActionType(n3);
                switch (n3) {
                    case 2: 
                    case 4: {
                        result2.mainString = rowInputBinary.readString();
                        break block0;
                    }
                    case 0: 
                    case 1: 
                    case 6: 
                    case 7: 
                    case 12: {
                        break block0;
                    }
                }
                throw Error.runtimeError(201, "Result");
            }
            case 38: {
                int n4 = rowInputBinary.readInt();
                result2.setConnectionAttrType(n4);
                switch (n4) {
                    case 10027: {
                        result2.mainString = rowInputBinary.readString();
                        break block0;
                    }
                }
                throw Error.runtimeError(201, "Result");
            }
            case 5: {
                result2.databaseID = rowInputBinary.readInt();
                result2.sessionID = rowInputBinary.readLong();
                result2.statementID = rowInputBinary.readLong();
                result2.generateKeys = rowInputBinary.readInt();
                result2.mainString = rowInputBinary.readString();
                break;
            }
            case 4: {
                result2.statementReturnType = rowInputBinary.readByte();
                result2.statementID = rowInputBinary.readLong();
                result2.rsProperties = rowInputBinary.readByte();
                result2.metaData = new ResultMetaData(rowInputBinary);
                result2.parameterMetaData = new ResultMetaData(rowInputBinary);
                break;
            }
            case 43: {
                result2.updateCount = rowInputBinary.readInt();
                result2.fetchSize = rowInputBinary.readInt();
                result2.statementID = rowInputBinary.readLong();
                result2.statementReturnType = rowInputBinary.readByte();
                result2.rsProperties = rowInputBinary.readByte();
                result2.metaData = new ResultMetaData(rowInputBinary);
                result2.valueData = Result.readSimple(rowInputBinary, result2.metaData);
                break;
            }
            case 35: {
                result2.updateCount = rowInputBinary.readInt();
                result2.fetchSize = rowInputBinary.readInt();
                result2.statementID = rowInputBinary.readLong();
                result2.rsProperties = rowInputBinary.readByte();
                result2.queryTimeout = rowInputBinary.readShort();
                Statement statement = session.statementManager.getStatement(session, result2.statementID);
                if (statement == null) {
                    result2.mode = (byte)21;
                    result2.valueData = ValuePool.emptyObjectArray;
                    break;
                }
                result2.statement = statement;
                result2.metaData = result2.statement.getParametersMetaData();
                result2.valueData = Result.readSimple(rowInputBinary, result2.metaData);
                break;
            }
            case 41: {
                result2.id = rowInputBinary.readLong();
                int n5 = rowInputBinary.readInt();
                result2.setActionType(n5);
                result2.metaData = new ResultMetaData(rowInputBinary);
                result2.valueData = Result.readSimple(rowInputBinary, result2.metaData);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 16: {
                result2.updateCount = rowInputBinary.readInt();
                result2.fetchSize = rowInputBinary.readInt();
                result2.statementID = rowInputBinary.readLong();
                result2.queryTimeout = rowInputBinary.readShort();
                result2.metaData = new ResultMetaData(rowInputBinary);
                result2.navigator.readSimple(rowInputBinary, result2.metaData);
                break;
            }
            case 17: {
                result2.metaData = new ResultMetaData(rowInputBinary);
                result2.navigator.read(rowInputBinary, result2.metaData);
                break;
            }
            case 13: {
                result2.id = rowInputBinary.readLong();
                result2.updateCount = rowInputBinary.readInt();
                result2.fetchSize = rowInputBinary.readInt();
                break;
            }
            case 3: 
            case 15: 
            case 20: {
                result2.id = rowInputBinary.readLong();
                result2.updateCount = rowInputBinary.readInt();
                result2.fetchSize = rowInputBinary.readInt();
                result2.rsProperties = rowInputBinary.readByte();
                result2.metaData = new ResultMetaData(rowInputBinary);
                result2.navigator = new RowSetNavigatorClient();
                result2.navigator.read(rowInputBinary, result2.metaData);
                break;
            }
            case 14: {
                result2.metaData = new ResultMetaData(rowInputBinary);
                result2.navigator = new RowSetNavigatorClient();
                result2.navigator.read(rowInputBinary, result2.metaData);
                break;
            }
            default: {
                throw Error.runtimeError(201, "Result");
            }
        }
        return result2;
    }

    public static Result newPSMResult(int n, String string2, Object object) {
        Result result2 = Result.newResult(42);
        result2.errorCode = n;
        result2.mainString = string2;
        result2.valueData = object;
        return result2;
    }

    public static Result newPSMResult(Object object) {
        Result result2 = Result.newResult(42);
        result2.valueData = object;
        return result2;
    }

    public static Result newPrepareStatementRequest() {
        return Result.newResult(37);
    }

    public static Result newPreparedExecuteRequest(Type[] typeArray, long l) {
        Result result2 = Result.newResult(35);
        result2.metaData = ResultMetaData.newSimpleResultMetaData(typeArray);
        result2.statementID = l;
        result2.valueData = ValuePool.emptyObjectArray;
        return result2;
    }

    public static Result newCallResponse(Type[] typeArray, long l, Object[] objectArray) {
        Result result2 = Result.newResult(43);
        result2.metaData = ResultMetaData.newSimpleResultMetaData(typeArray);
        result2.statementID = l;
        result2.valueData = objectArray;
        return result2;
    }

    public static Result newUpdateResultRequest(Type[] typeArray, long l) {
        Result result2 = Result.newResult(41);
        result2.metaData = ResultMetaData.newUpdateResultMetaData(typeArray);
        result2.id = l;
        result2.valueData = new Object[0];
        return result2;
    }

    public void setPreparedResultUpdateProperties(Object[] objectArray) {
        this.valueData = objectArray;
    }

    public void setPreparedExecuteProperties(Object[] objectArray, int n, int n2, int n3, int n4) {
        this.mode = (byte)35;
        this.valueData = objectArray;
        this.updateCount = n;
        this.fetchSize = n2;
        this.rsProperties = n3;
        this.queryTimeout = n4;
    }

    public void setBatchedPreparedExecuteRequest() {
        this.mode = (byte)9;
        if (this.navigator == null) {
            this.navigator = new RowSetNavigatorClient(4);
        } else {
            this.navigator.clear();
        }
        this.updateCount = 0;
        this.fetchSize = 0;
    }

    public void addBatchedPreparedExecuteRequest(Object[] objectArray) {
        this.navigator.add(objectArray);
    }

    public static Result newBatchedExecuteRequest() {
        Type[] typeArray = new Type[]{Type.SQL_VARCHAR};
        Result result2 = Result.newResult(8);
        result2.metaData = ResultMetaData.newSimpleResultMetaData(typeArray);
        return result2;
    }

    public static Result newBatchedExecuteResponse(int[] nArray, Result result2, Result result3) {
        Result result4 = Result.newResult(16);
        result4.addChainedResult(result2);
        result4.addChainedResult(result3);
        Type[] typeArray = new Type[]{Type.SQL_INTEGER};
        result4.metaData = ResultMetaData.newSimpleResultMetaData(typeArray);
        Object[][] objectArray = new Object[nArray.length][];
        for (int i = 0; i < nArray.length; ++i) {
            objectArray[i] = new Object[]{ValuePool.getInt(nArray[i])};
        }
        ((RowSetNavigatorClient)result4.navigator).setData(objectArray);
        return result4;
    }

    public static Result newResetSessionRequest() {
        Result result2 = Result.newResult(10);
        return result2;
    }

    public static Result newConnectionAttemptRequest(String string2, String string3, String string4, String string5, int n) {
        Result result2 = Result.newResult(31);
        result2.mainString = string2;
        result2.subString = string3;
        result2.zoneString = string5;
        result2.databaseName = string4;
        result2.updateCount = n;
        return result2;
    }

    public static Result newConnectionAcknowledgeResponse(Session session) {
        Result result2 = Result.newResult(11);
        result2.sessionID = session.getId();
        result2.databaseID = session.getDatabase().getDatabaseID();
        result2.databaseName = session.getDatabase().getNameString();
        result2.mainString = session.getDatabase().getProperties().getClientPropertiesAsString();
        result2.generateKeys = session.getRandomId();
        return result2;
    }

    public static Result newUpdateZeroResult() {
        return new Result(1, 0);
    }

    public static Result newUpdateCountResult(int n) {
        return new Result(1, n);
    }

    public static Result newUpdateCountResult(ResultMetaData resultMetaData, int n) {
        Result result2 = Result.newResult(1);
        Result result3 = Result.newGeneratedDataResult(resultMetaData);
        result2.updateCount = n;
        result2.addChainedResult(result3);
        return result2;
    }

    public static Result newSingleColumnResult(ResultMetaData resultMetaData) {
        Result result2 = Result.newResult(3);
        result2.metaData = resultMetaData;
        result2.navigator = new RowSetNavigatorClient();
        return result2;
    }

    public static Result newSingleColumnResult(String string2) {
        Result result2 = Result.newResult(3);
        result2.metaData = ResultMetaData.newSingleColumnMetaData(string2);
        result2.navigator = new RowSetNavigatorClient(8);
        return result2;
    }

    public static Result newSingleColumnStringResult(String string2, String string3) {
        Result result2 = Result.newSingleColumnResult(string2);
        LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(string3));
        while (true) {
            String string4 = null;
            try {
                string4 = lineNumberReader.readLine();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string4 == null) break;
            result2.getNavigator().add(new Object[]{string4});
        }
        return result2;
    }

    public static Result newPrepareResponse(Statement statement) {
        Result result2 = Result.newResult(4);
        result2.statement = statement;
        result2.statementID = statement.getID();
        int n = statement.getType();
        result2.statementReturnType = statement.getStatementReturnType();
        result2.metaData = statement.getResultMetaData();
        result2.parameterMetaData = statement.getParametersMetaData();
        return result2;
    }

    public static Result newCancelRequest(long l, String string2) {
        Result result2 = Result.newResult(5);
        result2.statementID = l;
        result2.mainString = string2;
        return result2;
    }

    public static Result newFreeStmtRequest(long l) {
        Result result2 = Result.newResult(36);
        result2.statementID = l;
        return result2;
    }

    public static Result newExecuteDirectRequest() {
        return Result.newResult(34);
    }

    public void setPrepareOrExecuteProperties(String string2, int n, int n2, int n3, int n4, int n5, int n6, int[] nArray, String[] stringArray) {
        this.mainString = string2;
        this.updateCount = n;
        this.fetchSize = n2;
        this.statementReturnType = n3;
        this.queryTimeout = n4;
        this.rsProperties = n5;
        this.generateKeys = n6;
        this.generatedMetaData = ResultMetaData.newGeneratedColumnsMetaData(nArray, stringArray);
    }

    public static Result newSetSavepointRequest(String string2) {
        Result result2 = Result.newResult(38);
        result2.setConnectionAttrType(10027);
        result2.setMainString(string2);
        return result2;
    }

    public static Result newRequestDataResult(long l, int n, int n2) {
        Result result2 = Result.newResult(13);
        result2.id = l;
        result2.updateCount = n;
        result2.fetchSize = n2;
        return result2;
    }

    public static Result newDataResult(ResultMetaData resultMetaData) {
        Result result2 = Result.newResult(3);
        result2.navigator = new RowSetNavigatorClient();
        result2.metaData = resultMetaData;
        return result2;
    }

    public static Result newGeneratedDataResult(ResultMetaData resultMetaData) {
        Result result2 = Result.newResult(20);
        result2.navigator = new RowSetNavigatorClient();
        result2.metaData = resultMetaData;
        return result2;
    }

    public int getExecuteProperties() {
        return this.rsProperties;
    }

    public static Result newDataHeadResult(SessionInterface sessionInterface, Result result2, int n, int n2) {
        if (n + n2 > result2.navigator.getSize()) {
            n2 = result2.navigator.getSize() - n;
        }
        Result result3 = Result.newResult(15);
        result3.metaData = result2.metaData;
        result3.navigator = new RowSetNavigatorClient(result2.navigator, n, n2);
        result3.navigator.setId(result2.navigator.getId());
        result3.setSession(sessionInterface);
        result3.rsProperties = result2.rsProperties;
        result3.fetchSize = result2.fetchSize;
        return result3;
    }

    public static Result newDataRowsResult(Result result2, int n, int n2) {
        if (n + n2 > result2.navigator.getSize()) {
            n2 = result2.navigator.getSize() - n;
        }
        Result result3 = Result.newResult(14);
        result3.id = result2.id;
        result3.metaData = result2.metaData;
        result3.navigator = new RowSetNavigatorClient(result2.navigator, n, n2);
        return result3;
    }

    public static Result newDataRowsResult(RowSetNavigator rowSetNavigator) {
        Result result2 = Result.newResult(14);
        result2.navigator = rowSetNavigator;
        return result2;
    }

    public static Result newSessionAttributesResult() {
        Result result2 = Result.newResult(3);
        result2.navigator = new RowSetNavigatorClient(1);
        result2.metaData = sessionAttributesMetaData;
        result2.navigator.add(new Object[4]);
        return result2;
    }

    public static Result newWarningResult(HsqlException hsqlException) {
        Result result2 = Result.newResult(19);
        result2.mainString = hsqlException.getMessage();
        result2.subString = hsqlException.getSQLState();
        result2.errorCode = hsqlException.getErrorCode();
        return result2;
    }

    public static Result newErrorResult(Throwable throwable) {
        return Result.newErrorResult(throwable, null);
    }

    public static Result newErrorResult(Throwable throwable, String string2) {
        Result result2 = Result.newResult(2);
        if (throwable instanceof HsqlException) {
            result2.exception = (HsqlException)throwable;
            result2.mainString = result2.exception.getMessage();
            result2.subString = result2.exception.getSQLState();
            if (string2 != null) {
                result2.mainString = result2.mainString + " in statement [" + string2 + "]";
            }
            result2.errorCode = result2.exception.getErrorCode();
        } else if (throwable instanceof OutOfMemoryError) {
            System.gc();
            result2.exception = Error.error(460, throwable);
            result2.mainString = result2.exception.getMessage();
            result2.subString = result2.exception.getSQLState();
            result2.errorCode = result2.exception.getErrorCode();
        } else if (throwable instanceof Throwable) {
            result2.exception = Error.error(458, throwable);
            result2.mainString = result2.exception.getMessage();
            result2.subString = result2.exception.getSQLState();
            result2.errorCode = result2.exception.getErrorCode();
        } else {
            result2.exception = Error.error(458);
            result2.mainString = result2.exception.getMessage();
            result2.subString = result2.exception.getSQLState();
            result2.errorCode = result2.exception.getErrorCode();
        }
        return result2;
    }

    public void write(SessionInterface sessionInterface, DataOutputStream dataOutputStream, RowOutputInterface rowOutputInterface) throws IOException {
        int n;
        rowOutputInterface.reset();
        rowOutputInterface.writeByte(this.mode);
        int n2 = rowOutputInterface.size();
        rowOutputInterface.writeSize(0);
        block0 : switch (this.mode) {
            case 7: {
                rowOutputInterface.writeByte(this.statementReturnType);
                break;
            }
            case 10: 
            case 32: 
            case 39: {
                break;
            }
            case 37: {
                rowOutputInterface.writeByte(this.statementReturnType);
                rowOutputInterface.writeString(this.mainString);
                rowOutputInterface.writeByte(this.rsProperties);
                rowOutputInterface.writeByte(this.generateKeys);
                if (this.generateKeys != 11 && this.generateKeys != 21) break;
                this.generatedMetaData.write(rowOutputInterface);
                break;
            }
            case 36: {
                rowOutputInterface.writeLong(this.statementID);
                break;
            }
            case 40: {
                rowOutputInterface.writeLong(this.id);
                break;
            }
            case 34: {
                rowOutputInterface.writeInt(this.updateCount);
                rowOutputInterface.writeInt(this.fetchSize);
                rowOutputInterface.writeByte(this.statementReturnType);
                rowOutputInterface.writeString(this.mainString);
                rowOutputInterface.writeByte(this.rsProperties);
                rowOutputInterface.writeShort(this.queryTimeout);
                rowOutputInterface.writeByte(this.generateKeys);
                if (this.generateKeys != 11 && this.generateKeys != 21) break;
                this.generatedMetaData.write(rowOutputInterface);
                break;
            }
            case 31: {
                rowOutputInterface.writeString(this.databaseName);
                rowOutputInterface.writeString(this.mainString);
                rowOutputInterface.writeString(this.subString);
                rowOutputInterface.writeString(this.zoneString);
                rowOutputInterface.writeInt(this.updateCount);
                break;
            }
            case 2: 
            case 19: {
                rowOutputInterface.writeString(this.mainString);
                rowOutputInterface.writeString(this.subString);
                rowOutputInterface.writeInt(this.errorCode);
                break;
            }
            case 11: {
                rowOutputInterface.writeInt(this.databaseID);
                rowOutputInterface.writeLong(this.sessionID);
                rowOutputInterface.writeString(this.databaseName);
                rowOutputInterface.writeString(this.mainString);
                rowOutputInterface.writeInt(this.generateKeys);
                break;
            }
            case 1: {
                rowOutputInterface.writeInt(this.updateCount);
                break;
            }
            case 33: {
                n = this.getActionType();
                rowOutputInterface.writeInt(n);
                switch (n) {
                    case 2: 
                    case 4: {
                        rowOutputInterface.writeString(this.mainString);
                        break block0;
                    }
                    case 0: 
                    case 1: 
                    case 6: 
                    case 7: 
                    case 12: {
                        break block0;
                    }
                }
                throw Error.runtimeError(201, "Result");
            }
            case 5: {
                rowOutputInterface.writeInt(this.databaseID);
                rowOutputInterface.writeLong(this.sessionID);
                rowOutputInterface.writeLong(this.statementID);
                rowOutputInterface.writeInt(this.generateKeys);
                rowOutputInterface.writeString(this.mainString);
                break;
            }
            case 4: {
                rowOutputInterface.writeByte(this.statementReturnType);
                rowOutputInterface.writeLong(this.statementID);
                rowOutputInterface.writeByte(this.rsProperties);
                this.metaData.write(rowOutputInterface);
                this.parameterMetaData.write(rowOutputInterface);
                break;
            }
            case 43: {
                rowOutputInterface.writeInt(this.updateCount);
                rowOutputInterface.writeInt(this.fetchSize);
                rowOutputInterface.writeLong(this.statementID);
                rowOutputInterface.writeByte(this.statementReturnType);
                rowOutputInterface.writeByte(this.rsProperties);
                this.metaData.write(rowOutputInterface);
                Result.writeSimple(rowOutputInterface, this.metaData, (Object[])this.valueData);
                break;
            }
            case 35: {
                rowOutputInterface.writeInt(this.updateCount);
                rowOutputInterface.writeInt(this.fetchSize);
                rowOutputInterface.writeLong(this.statementID);
                rowOutputInterface.writeByte(this.rsProperties);
                rowOutputInterface.writeShort(this.queryTimeout);
                Result.writeSimple(rowOutputInterface, this.metaData, (Object[])this.valueData);
                break;
            }
            case 41: {
                rowOutputInterface.writeLong(this.id);
                rowOutputInterface.writeInt(this.getActionType());
                this.metaData.write(rowOutputInterface);
                Result.writeSimple(rowOutputInterface, this.metaData, (Object[])this.valueData);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 16: {
                rowOutputInterface.writeInt(this.updateCount);
                rowOutputInterface.writeInt(this.fetchSize);
                rowOutputInterface.writeLong(this.statementID);
                rowOutputInterface.writeShort(this.queryTimeout);
                this.metaData.write(rowOutputInterface);
                this.navigator.writeSimple(rowOutputInterface, this.metaData);
                break;
            }
            case 17: {
                this.metaData.write(rowOutputInterface);
                this.navigator.write(rowOutputInterface, this.metaData);
                break;
            }
            case 38: {
                n = this.getConnectionAttrType();
                rowOutputInterface.writeInt(n);
                switch (n) {
                    case 10027: {
                        rowOutputInterface.writeString(this.mainString);
                        break block0;
                    }
                }
                throw Error.runtimeError(201, "Result");
            }
            case 13: {
                rowOutputInterface.writeLong(this.id);
                rowOutputInterface.writeInt(this.updateCount);
                rowOutputInterface.writeInt(this.fetchSize);
                break;
            }
            case 14: {
                this.metaData.write(rowOutputInterface);
                this.navigator.write(rowOutputInterface, this.metaData);
                break;
            }
            case 3: 
            case 15: 
            case 20: {
                rowOutputInterface.writeLong(this.id);
                rowOutputInterface.writeInt(this.updateCount);
                rowOutputInterface.writeInt(this.fetchSize);
                rowOutputInterface.writeByte(this.rsProperties);
                this.metaData.write(rowOutputInterface);
                this.navigator.write(rowOutputInterface, this.metaData);
                break;
            }
            default: {
                throw Error.runtimeError(201, "Result");
            }
        }
        rowOutputInterface.writeSize(rowOutputInterface.size() - n2);
        dataOutputStream.write(rowOutputInterface.getOutputStream().getBuffer(), 0, rowOutputInterface.size());
        n = this.getLobCount();
        Result result2 = this;
        for (int i = 0; i < n; ++i) {
            ResultLob resultLob = result2.lobResults;
            resultLob.writeBody(sessionInterface, dataOutputStream);
            result2 = result2.lobResults;
        }
        if (this.chainedResult == null) {
            dataOutputStream.writeByte(0);
        } else {
            this.chainedResult.write(sessionInterface, dataOutputStream, rowOutputInterface);
        }
        dataOutputStream.flush();
    }

    public int getType() {
        return this.mode;
    }

    public boolean isData() {
        return this.mode == 3 || this.mode == 15;
    }

    public boolean isError() {
        return this.mode == 2;
    }

    public boolean isWarning() {
        return this.mode == 19;
    }

    public boolean isUpdateCount() {
        return this.mode == 1;
    }

    public boolean isSimpleValue() {
        return this.mode == 42;
    }

    public boolean hasGeneratedKeys() {
        return this.mode == 1 && this.chainedResult != null;
    }

    public HsqlException getException() {
        return this.exception;
    }

    public long getStatementID() {
        return this.statementID;
    }

    public void setStatementID(long l) {
        this.statementID = l;
    }

    public String getMainString() {
        return this.mainString;
    }

    public void setMainString(String string2) {
        this.mainString = string2;
    }

    public String getSubString() {
        return this.subString;
    }

    public String getZoneString() {
        return this.zoneString;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public Object getValueObject() {
        return this.valueData;
    }

    public void setValueObject(Object object) {
        this.valueData = object;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setMaxRows(int n) {
        this.updateCount = n;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int n) {
        this.fetchSize = n;
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public int getConnectionAttrType() {
        return this.updateCount;
    }

    public void setConnectionAttrType(int n) {
        this.updateCount = n;
    }

    public int getActionType() {
        return this.updateCount;
    }

    public void setActionType(int n) {
        this.updateCount = n;
    }

    public long getSessionId() {
        return this.sessionID;
    }

    public void setSessionId(long l) {
        this.sessionID = l;
    }

    public void setSession(SessionInterface sessionInterface) {
        if (this.navigator != null) {
            this.navigator.setSession(sessionInterface);
        }
    }

    public int getDatabaseId() {
        return this.databaseID;
    }

    public void setDatabaseId(int n) {
        this.databaseID = n;
    }

    public long getResultId() {
        return this.id;
    }

    public void setResultId(long l) {
        this.id = l;
        if (this.navigator != null) {
            this.navigator.setId(l);
        }
    }

    public void setUpdateCount(int n) {
        this.updateCount = n;
    }

    public void setAsTransactionEndRequest(int n, String string2) {
        this.mode = (byte)33;
        this.updateCount = n;
        this.mainString = string2 == null ? "" : string2;
    }

    public Object[] getSingleRowData() {
        Object[] objectArray = this.initialiseNavigator().getNext();
        objectArray = (Object[])ArrayUtil.resizeArrayIfDifferent(objectArray, this.metaData.getColumnCount());
        return objectArray;
    }

    public Object[] getParameterData() {
        return (Object[])this.valueData;
    }

    public Object[] getSessionAttributes() {
        return this.initialiseNavigator().getNext();
    }

    public void setResultType(int n) {
        this.mode = (byte)n;
    }

    public void setStatementType(int n) {
        this.statementReturnType = n;
    }

    public int getStatementType() {
        return this.statementReturnType;
    }

    public void setSessionRandomID(int n) {
        this.generateKeys = n;
    }

    public int getSessionRandomID() {
        return this.generateKeys;
    }

    public int getGeneratedResultType() {
        return this.generateKeys;
    }

    public ResultMetaData getGeneratedResultMetaData() {
        return this.generatedMetaData;
    }

    public Result getChainedResult() {
        return this.chainedResult;
    }

    public Result getUnlinkChainedResult() {
        Result result2 = this.chainedResult;
        this.chainedResult = null;
        return result2;
    }

    public void addChainedResult(Result result2) {
        Result result3 = this;
        while (result3.chainedResult != null) {
            result3 = result3.chainedResult;
        }
        result3.chainedResult = result2;
    }

    public void addWarnings(HsqlException[] hsqlExceptionArray) {
        for (int i = 0; i < hsqlExceptionArray.length; ++i) {
            Result result2 = Result.newWarningResult(hsqlExceptionArray[i]);
            this.addChainedResult(result2);
        }
    }

    public int getLobCount() {
        return this.lobCount;
    }

    public ResultLob getLOBResult() {
        return this.lobResults;
    }

    public void addLobResult(ResultLob resultLob) {
        Result result2 = this;
        while (result2.lobResults != null) {
            result2 = result2.lobResults;
        }
        result2.lobResults = resultLob;
        ++this.lobCount;
    }

    public void clearLobResults() {
        this.lobResults = null;
        this.lobCount = 0;
    }

    public void addRows(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Object[] objectArray = new String[]{stringArray[i]};
            this.initialiseNavigator().add(objectArray);
        }
    }

    public void addRow(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        this.initialiseNavigator().add(stringArray);
    }

    private static Object[] readSimple(RowInputBinary rowInputBinary, ResultMetaData resultMetaData) throws IOException {
        int n = rowInputBinary.readInt();
        return rowInputBinary.readData(resultMetaData.columnTypes);
    }

    private static void writeSimple(RowOutputInterface rowOutputInterface, ResultMetaData resultMetaData, Object[] objectArray) throws IOException {
        rowOutputInterface.writeInt(1);
        rowOutputInterface.writeData(resultMetaData.getColumnCount(), resultMetaData.columnTypes, objectArray, null, null);
    }

    public RowSetNavigator getNavigator() {
        return this.navigator;
    }

    public void setNavigator(RowSetNavigator rowSetNavigator) {
        this.navigator = rowSetNavigator;
    }

    public RowSetNavigator initialiseNavigator() {
        switch (this.mode) {
            case 6: 
            case 8: 
            case 9: 
            case 16: 
            case 17: {
                this.navigator.beforeFirst();
                return this.navigator;
            }
            case 3: 
            case 15: 
            case 20: {
                this.navigator.reset();
                return this.navigator;
            }
        }
        throw Error.runtimeError(201, "Result");
    }

    static {
        SqlInvariants.isSystemSchemaName("SYSTEM_SCHEMA");
        Charset.getDefaultInstance();
        Collation.getDefaultInstance();
        sessionAttributesMetaData = ResultMetaData.newResultMetaData(4);
        for (int i = 0; i < 4; ++i) {
            Result.sessionAttributesMetaData.columns[i] = new ColumnBase(null, null, null, null);
        }
        Result.sessionAttributesMetaData.columns[0].setType(Type.SQL_INTEGER);
        Result.sessionAttributesMetaData.columns[1].setType(Type.SQL_INTEGER);
        Result.sessionAttributesMetaData.columns[2].setType(Type.SQL_BOOLEAN);
        Result.sessionAttributesMetaData.columns[3].setType(Type.SQL_VARCHAR);
        sessionAttributesMetaData.prepareData();
        emptyMeta = ResultMetaData.newResultMetaData(0);
        emptyGeneratedResult = Result.newDataResult(emptyMeta);
        updateZeroResult = Result.newUpdateCountResult(0);
        updateOneResult = Result.newUpdateCountResult(1);
    }
}

