/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rights;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Routine;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.MultiValueHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.Right;
import org.hsqldb.types.Type;

public class Grantee
implements SchemaObject {
    boolean isRole;
    private boolean isAdminDirect = false;
    private boolean isAdmin = false;
    boolean isPublic = false;
    boolean isSystem = false;
    protected HsqlNameManager.HsqlName granteeName;
    private MultiValueHashMap directRightsMap;
    HashMap fullRightsMap = new HashMap();
    OrderedHashSet roles;
    private MultiValueHashMap grantedRightsMap;
    protected GranteeManager granteeManager;
    protected Right ownerRights;

    Grantee(HsqlNameManager.HsqlName hsqlName, GranteeManager granteeManager) {
        this.directRightsMap = new MultiValueHashMap();
        this.grantedRightsMap = new MultiValueHashMap();
        this.granteeName = hsqlName;
        this.granteeManager = granteeManager;
        this.roles = new OrderedHashSet();
        this.ownerRights = new Right();
        this.ownerRights.isFull = true;
        this.ownerRights.grantor = GranteeManager.systemAuthorisation;
        this.ownerRights.grantee = this;
    }

    @Override
    public int getType() {
        return 11;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.granteeName;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return null;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return null;
    }

    @Override
    public Grantee getOwner() {
        return null;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject schemaObject) {
    }

    @Override
    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE").append(' ').append("ROLE");
        stringBuffer.append(' ').append(this.granteeName.statementName);
        return stringBuffer.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public boolean isRole() {
        return this.isRole;
    }

    public boolean isSystem() {
        return this.isSystem;
    }

    public OrderedHashSet getDirectRoles() {
        return this.roles;
    }

    public OrderedHashSet getAllRoles() {
        OrderedHashSet orderedHashSet = this.getGranteeAndAllRoles();
        orderedHashSet.remove(this);
        return orderedHashSet;
    }

    public OrderedHashSet getGranteeAndAllRoles() {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        this.addGranteeAndRoles(orderedHashSet);
        return orderedHashSet;
    }

    public OrderedHashSet getGranteeAndAllRolesWithPublic() {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        this.addGranteeAndRoles(orderedHashSet);
        orderedHashSet.add(this.granteeManager.publicRole);
        return orderedHashSet;
    }

    public boolean isAccessible(HsqlNameManager.HsqlName hsqlName, int n) {
        if (this.isFullyAccessibleByRole(hsqlName)) {
            return true;
        }
        Right right2 = (Right)this.fullRightsMap.get(hsqlName);
        if (right2 == null) {
            return false;
        }
        return right2.canAccess(n);
    }

    public boolean isAccessible(SchemaObject schemaObject) {
        return this.isAccessible(schemaObject.getName());
    }

    public boolean isAccessible(HsqlNameManager.HsqlName hsqlName) {
        if (this.isFullyAccessibleByRole(hsqlName)) {
            return true;
        }
        Right right2 = (Right)this.fullRightsMap.get(hsqlName);
        if (right2 != null && !right2.isEmpty()) {
            return true;
        }
        if (!this.isPublic) {
            return this.granteeManager.publicRole.isAccessible(hsqlName);
        }
        return false;
    }

    private OrderedHashSet addGranteeAndRoles(OrderedHashSet orderedHashSet) {
        orderedHashSet.add(this);
        for (int i = 0; i < this.roles.size(); ++i) {
            Grantee grantee = (Grantee)this.roles.get(i);
            if (orderedHashSet.contains(grantee)) continue;
            grantee.addGranteeAndRoles(orderedHashSet);
        }
        return orderedHashSet;
    }

    private boolean hasRoleDirect(Grantee grantee) {
        return this.roles.contains(grantee);
    }

    public boolean hasRole(Grantee grantee) {
        return this.getAllRoles().contains(grantee);
    }

    void grant(HsqlNameManager.HsqlName hsqlName, Right right2, Grantee grantee, boolean bl) {
        Right right3 = grantee.getAllGrantableRights(hsqlName);
        Right right4 = null;
        if (right2 == Right.fullRights) {
            if (right3.isEmpty()) {
                return;
            }
            right2 = right3;
        } else if (!right3.contains(right2)) {
            throw Error.error(2000);
        }
        Iterator iterator2 = this.directRightsMap.get(hsqlName);
        while (iterator2.hasNext()) {
            Right right5 = (Right)iterator2.next();
            if (right5.grantor != grantee) continue;
            right4 = right5;
            right4.add(right2);
            break;
        }
        if (right4 == null) {
            right4 = right2.duplicate();
            right4.grantor = grantee;
            right4.grantee = this;
            this.directRightsMap.put(hsqlName, right4);
        }
        if (bl) {
            if (right4.grantableRights == null) {
                right4.grantableRights = right2.duplicate();
            } else {
                right4.grantableRights.add(right2);
            }
        }
        if (!grantee.isSystem()) {
            grantee.grantedRightsMap.put(hsqlName, right4);
        }
        this.updateAllRights();
    }

    void revoke(SchemaObject schemaObject, Right right2, Grantee grantee, boolean bl) {
        HsqlNameManager.HsqlName hsqlName = schemaObject.getName();
        if (schemaObject instanceof Routine) {
            hsqlName = ((Routine)schemaObject).getSpecificName();
        }
        Iterator iterator2 = this.directRightsMap.get(hsqlName);
        Right right3 = null;
        while (iterator2.hasNext()) {
            right3 = (Right)iterator2.next();
            if (right3.grantor != grantee) continue;
        }
        if (right3 == null) {
            return;
        }
        if (right3.grantableRights != null) {
            right3.grantableRights.remove(schemaObject, right2);
        }
        if (bl) {
            return;
        }
        if (right2.isFull) {
            this.directRightsMap.remove(hsqlName, right3);
            grantee.grantedRightsMap.remove(hsqlName, right3);
            this.updateAllRights();
            return;
        }
        right3.remove(schemaObject, right2);
        if (right3.isEmpty()) {
            this.directRightsMap.remove(hsqlName, right3);
            grantee.grantedRightsMap.remove(hsqlName, right3);
        }
        this.updateAllRights();
    }

    void revokeDbObject(HsqlNameManager.HsqlName hsqlName) {
        this.directRightsMap.remove(hsqlName);
        this.grantedRightsMap.remove(hsqlName);
        this.fullRightsMap.remove(hsqlName);
    }

    void updateRightsForNewColumn(HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName hsqlName2) {
        Iterator iterator2 = this.directRightsMap.get(hsqlName);
        Right right2 = null;
        while (iterator2.hasNext()) {
            right2 = (Right)iterator2.next();
        }
        if (right2 == null) {
            return;
        }
        right2.addNewColumn(hsqlName2);
        this.updateAllRights();
    }

    void updateRightsForNewColumn(HsqlNameManager.HsqlName hsqlName) {
        Iterator iterator2 = this.grantedRightsMap.get(hsqlName);
        Right right2 = null;
        while (iterator2.hasNext()) {
            right2 = (Right)iterator2.next();
        }
        if (right2 == null) {
            return;
        }
        this.updateAllRights();
    }

    void clearPrivileges() {
        this.roles.clear();
        this.directRightsMap.clear();
        this.grantedRightsMap.clear();
        this.fullRightsMap.clear();
        this.isAdmin = false;
    }

    public OrderedHashSet getColumnsForAllPrivileges(SchemaObject schemaObject) {
        if (schemaObject instanceof Table) {
            Table table = (Table)schemaObject;
            if (this.isFullyAccessibleByRole(table.getName())) {
                return table.getColumnNameSet();
            }
            Right right2 = (Right)this.fullRightsMap.get(table.getName());
            return right2 == null ? Right.emptySet : right2.getColumnsForAllRights(table);
        }
        return Right.emptySet;
    }

    public OrderedHashSet getAllDirectPrivileges(SchemaObject schemaObject) {
        Iterator iterator2;
        if (schemaObject.getOwner() == this) {
            OrderedHashSet orderedHashSet = new OrderedHashSet();
            orderedHashSet.add(this.ownerRights);
            return orderedHashSet;
        }
        HsqlNameManager.HsqlName hsqlName = schemaObject.getName();
        if (schemaObject instanceof Routine) {
            hsqlName = ((Routine)schemaObject).getSpecificName();
        }
        if ((iterator2 = this.directRightsMap.get(hsqlName)).hasNext()) {
            OrderedHashSet orderedHashSet = new OrderedHashSet();
            while (iterator2.hasNext()) {
                orderedHashSet.add(iterator2.next());
            }
            return orderedHashSet;
        }
        return Right.emptySet;
    }

    public OrderedHashSet getAllGrantedPrivileges(SchemaObject schemaObject) {
        Iterator iterator2;
        HsqlNameManager.HsqlName hsqlName = schemaObject.getName();
        if (schemaObject instanceof Routine) {
            hsqlName = ((Routine)schemaObject).getSpecificName();
        }
        if ((iterator2 = this.grantedRightsMap.get(hsqlName)).hasNext()) {
            OrderedHashSet orderedHashSet = new OrderedHashSet();
            while (iterator2.hasNext()) {
                orderedHashSet.add(iterator2.next());
            }
            return orderedHashSet;
        }
        return Right.emptySet;
    }

    public void checkSelect(SchemaObject schemaObject, boolean[] blArray) {
        if (schemaObject instanceof Table) {
            Table table = (Table)schemaObject;
            if (this.isFullyAccessibleByRole(table.getName())) {
                return;
            }
            Right right2 = (Right)this.fullRightsMap.get(table.getName());
            if (right2 != null && right2.canSelect(table, blArray)) {
                return;
            }
        }
        throw Error.error(5501, schemaObject.getName().name);
    }

    public void checkInsert(SchemaObject schemaObject, boolean[] blArray) {
        if (schemaObject instanceof Table) {
            Table table = (Table)schemaObject;
            if (this.isFullyAccessibleByRole(table.getName())) {
                return;
            }
            Right right2 = (Right)this.fullRightsMap.get(table.getName());
            if (right2 != null && right2.canInsert(table, blArray)) {
                return;
            }
        }
        throw Error.error(5501, schemaObject.getName().name);
    }

    public void checkUpdate(SchemaObject schemaObject, boolean[] blArray) {
        if (schemaObject instanceof Table) {
            Table table = (Table)schemaObject;
            if (this.isFullyAccessibleByRole(table.getName())) {
                return;
            }
            Right right2 = (Right)this.fullRightsMap.get(table.getName());
            if (right2 != null && right2.canUpdate(table, blArray)) {
                return;
            }
        }
        throw Error.error(5501, schemaObject.getName().name);
    }

    public void checkReferences(SchemaObject schemaObject, boolean[] blArray) {
        if (schemaObject instanceof Table) {
            Table table = (Table)schemaObject;
            if (this.isFullyAccessibleByRole(table.getName())) {
                return;
            }
            Right right2 = (Right)this.fullRightsMap.get(table.getName());
            if (right2 != null && right2.canReference(table, blArray)) {
                return;
            }
        }
        throw Error.error(5501, schemaObject.getName().name);
    }

    public void checkTrigger(SchemaObject schemaObject, boolean[] blArray) {
        if (schemaObject instanceof Table) {
            Table table = (Table)schemaObject;
            if (this.isFullyAccessibleByRole(table.getName())) {
                return;
            }
            Right right2 = (Right)this.fullRightsMap.get(table.getName());
            if (right2 != null && right2.canReference(table, blArray)) {
                return;
            }
        }
        throw Error.error(5501, schemaObject.getName().name);
    }

    public void checkDelete(SchemaObject schemaObject) {
        if (schemaObject instanceof Table) {
            Table table = (Table)schemaObject;
            if (this.isFullyAccessibleByRole(table.getName())) {
                return;
            }
            Right right2 = (Right)this.fullRightsMap.get(table.getName());
            if (right2 != null && right2.canDelete()) {
                return;
            }
        }
        throw Error.error(5501, schemaObject.getName().name);
    }

    public void checkAccess(SchemaObject schemaObject) {
        Right right2;
        if (this.isFullyAccessibleByRole(schemaObject.getName())) {
            return;
        }
        HsqlNameManager.HsqlName hsqlName = schemaObject.getName();
        if (schemaObject instanceof Routine) {
            hsqlName = ((Routine)schemaObject).getSpecificName();
        }
        if ((right2 = (Right)this.fullRightsMap.get(hsqlName)) != null && !right2.isEmpty()) {
            return;
        }
        throw Error.error(5501, schemaObject.getName().name);
    }

    public void checkSchemaUpdateOrGrantRights(String string2) {
        if (!this.hasSchemaUpdateOrGrantRights(string2)) {
            throw Error.error(5501, string2);
        }
    }

    public boolean hasSchemaUpdateOrGrantRights(String string2) {
        if (this.isAdmin()) {
            return true;
        }
        Grantee grantee = this.granteeManager.database.schemaManager.toSchemaOwner(string2);
        if (grantee == this) {
            return true;
        }
        return this.hasRole(grantee);
    }

    public boolean isGrantable(SchemaObject schemaObject, Right right2) {
        if (this.isFullyAccessibleByRole(schemaObject.getName())) {
            return true;
        }
        Right right3 = this.getAllGrantableRights(schemaObject.getName());
        return right3.contains(right2);
    }

    public boolean isGrantable(Grantee grantee) {
        return this.isAdmin;
    }

    public boolean isFullyAccessibleByRole(HsqlNameManager.HsqlName hsqlName) {
        Grantee grantee;
        if (this.isAdmin) {
            return true;
        }
        if (hsqlName.type == 2) {
            grantee = hsqlName.owner;
        } else {
            if (hsqlName.schema == null) {
                return false;
            }
            grantee = hsqlName.schema.owner;
        }
        if (grantee == this) {
            return true;
        }
        return this.hasRole(grantee);
    }

    public void checkAdmin() {
        if (!this.isAdmin()) {
            throw Error.error(5507);
        }
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public boolean isSchemaCreator() {
        return this.isAdmin || this.hasRole(this.granteeManager.schemaRole);
    }

    public boolean canChangeAuthorisation() {
        return this.isAdmin || this.hasRole(this.granteeManager.changeAuthRole);
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public OrderedHashSet visibleGrantees() {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        GranteeManager granteeManager = this.granteeManager;
        if (this.isAdmin()) {
            orderedHashSet.addAll(granteeManager.getGrantees());
        } else {
            orderedHashSet.add(this);
            Iterator iterator2 = this.getAllRoles().iterator();
            while (iterator2.hasNext()) {
                orderedHashSet.add(iterator2.next());
            }
        }
        return orderedHashSet;
    }

    public boolean hasNonSelectTableRight(SchemaObject schemaObject) {
        if (this.isFullyAccessibleByRole(schemaObject.getName())) {
            return true;
        }
        Right right2 = (Right)this.fullRightsMap.get(schemaObject.getName());
        if (right2 == null) {
            return false;
        }
        return right2.canAccesssNonSelect();
    }

    public boolean hasColumnRights(SchemaObject schemaObject, int[] nArray) {
        if (this.isFullyAccessibleByRole(schemaObject.getName())) {
            return true;
        }
        Right right2 = (Right)this.fullRightsMap.get(schemaObject.getName());
        if (right2 == null) {
            return false;
        }
        return right2.canAccess((Table)schemaObject, nArray);
    }

    void setAdminDirect() {
        this.isAdminDirect = true;
        this.isAdmin = true;
    }

    boolean updateNestedRoles(Grantee grantee) {
        boolean bl = false;
        if (grantee != this) {
            for (int i = 0; i < this.roles.size(); ++i) {
                Grantee grantee2 = (Grantee)this.roles.get(i);
                bl |= grantee2.updateNestedRoles(grantee);
            }
        }
        if (bl) {
            this.updateAllRights();
        }
        return bl || grantee == this;
    }

    void updateAllRights() {
        this.fullRightsMap.clear();
        this.isAdmin = this.isAdminDirect;
        for (int i = 0; i < this.roles.size(); ++i) {
            Grantee grantee = (Grantee)this.roles.get(i);
            this.addToFullRights(grantee.fullRightsMap);
            this.isAdmin |= grantee.isAdmin();
        }
        this.addToFullRights(this.directRightsMap);
        if (!(this.isRole || this.isPublic || this.isSystem)) {
            this.addToFullRights(this.granteeManager.publicRole.fullRightsMap);
        }
    }

    void addToFullRights(HashMap hashMap) {
        Iterator iterator2 = hashMap.keySet().iterator();
        while (iterator2.hasNext()) {
            Object object = iterator2.next();
            Right right2 = (Right)hashMap.get(object);
            Right right3 = (Right)this.fullRightsMap.get(object);
            if (right3 == null) {
                right3 = right2.duplicate();
                this.fullRightsMap.put(object, right3);
            } else {
                right3.add(right2);
            }
            if (right2.grantableRights == null) continue;
            if (right3.grantableRights == null) {
                right3.grantableRights = right2.grantableRights.duplicate();
                continue;
            }
            right3.grantableRights.add(right2.grantableRights);
        }
    }

    private void addToFullRights(MultiValueHashMap multiValueHashMap) {
        Iterator iterator2 = multiValueHashMap.keySet().iterator();
        while (iterator2.hasNext()) {
            Object object = iterator2.next();
            Iterator iterator3 = multiValueHashMap.get(object);
            Right right2 = (Right)this.fullRightsMap.get(object);
            while (iterator3.hasNext()) {
                Right right3 = (Right)iterator3.next();
                if (right2 == null) {
                    right2 = right3.duplicate();
                    this.fullRightsMap.put(object, right2);
                } else {
                    right2.add(right3);
                }
                if (right3.grantableRights == null) continue;
                if (right2.grantableRights == null) {
                    right2.grantableRights = right3.grantableRights.duplicate();
                    continue;
                }
                right2.grantableRights.add(right3.grantableRights);
            }
        }
    }

    Right getAllGrantableRights(HsqlNameManager.HsqlName hsqlName) {
        if (this.isAdmin) {
            return hsqlName.schema.owner.ownerRights;
        }
        if (hsqlName.schema.owner == this) {
            return this.ownerRights;
        }
        if (this.roles.contains(hsqlName.schema.owner)) {
            return hsqlName.schema.owner.ownerRights;
        }
        OrderedHashSet orderedHashSet = this.getAllRoles();
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            Grantee grantee = (Grantee)orderedHashSet.get(i);
            if (hsqlName.schema.owner != grantee) continue;
            return grantee.ownerRights;
        }
        Right right2 = (Right)this.fullRightsMap.get(hsqlName);
        return right2 == null || right2.grantableRights == null ? Right.noRights : right2.grantableRights;
    }

    private MultiValueHashMap getRights() {
        return this.directRightsMap;
    }

    void grant(Grantee grantee) {
        this.roles.add(grantee);
    }

    void revoke(Grantee grantee) {
        if (!this.hasRoleDirect(grantee)) {
            throw Error.error(2253, grantee.getName().getNameString());
        }
        this.roles.remove(grantee);
    }

    private String roleMapToString(OrderedHashSet orderedHashSet) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            Grantee grantee = (Grantee)orderedHashSet.get(i);
            stringBuffer.append(grantee.getName().getStatementName());
        }
        return stringBuffer.toString();
    }

    HsqlArrayList getRightsSQL() {
        Object object;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        String string2 = this.roleMapToString(this.roles);
        if (string2.length() != 0) {
            object = new StringBuffer(128);
            ((StringBuffer)object).append("GRANT").append(' ').append(string2);
            ((StringBuffer)object).append(' ').append("TO").append(' ');
            ((StringBuffer)object).append(this.getName().getStatementName());
            hsqlArrayList.add(((StringBuffer)object).toString());
        }
        object = this.getRights();
        Iterator iterator2 = ((MultiValueHashMap)object).keySet().iterator();
        while (iterator2.hasNext()) {
            Object object2 = iterator2.next();
            Iterator iterator3 = ((MultiValueHashMap)object).get(object2);
            while (iterator3.hasNext()) {
                Right right2 = (Right)iterator3.next();
                StringBuffer stringBuffer = new StringBuffer(128);
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)object2;
                switch (hsqlName.type) {
                    case 3: 
                    case 4: {
                        Table table = this.granteeManager.database.schemaManager.findUserTable(hsqlName.name, hsqlName.schema.name);
                        if (table == null) break;
                        stringBuffer.append("GRANT").append(' ');
                        stringBuffer.append(right2.getTableRightsSQL(table));
                        stringBuffer.append(' ').append("ON").append(' ');
                        stringBuffer.append("TABLE").append(' ');
                        stringBuffer.append(hsqlName.getSchemaQualifiedStatementName());
                        break;
                    }
                    case 7: {
                        NumberSequence numberSequence = (NumberSequence)this.granteeManager.database.schemaManager.findSchemaObject(hsqlName.name, hsqlName.schema.name, 7);
                        if (numberSequence == null) break;
                        stringBuffer.append("GRANT").append(' ');
                        stringBuffer.append("USAGE");
                        stringBuffer.append(' ').append("ON").append(' ');
                        stringBuffer.append("SEQUENCE").append(' ');
                        stringBuffer.append(hsqlName.getSchemaQualifiedStatementName());
                        break;
                    }
                    case 13: {
                        Type type = (Type)this.granteeManager.database.schemaManager.findSchemaObject(hsqlName.name, hsqlName.schema.name, 13);
                        if (type == null) break;
                        stringBuffer.append("GRANT").append(' ');
                        stringBuffer.append("USAGE");
                        stringBuffer.append(' ').append("ON").append(' ');
                        stringBuffer.append("DOMAIN").append(' ');
                        stringBuffer.append(hsqlName.getSchemaQualifiedStatementName());
                        break;
                    }
                    case 12: {
                        Type type = (Type)this.granteeManager.database.schemaManager.findSchemaObject(hsqlName.name, hsqlName.schema.name, 13);
                        if (type == null) break;
                        stringBuffer.append("GRANT").append(' ');
                        stringBuffer.append("USAGE");
                        stringBuffer.append(' ').append("ON").append(' ');
                        stringBuffer.append("TYPE").append(' ');
                        stringBuffer.append(hsqlName.getSchemaQualifiedStatementName());
                        break;
                    }
                    case 16: 
                    case 17: 
                    case 24: {
                        SchemaObject schemaObject = this.granteeManager.database.schemaManager.findSchemaObject(hsqlName.name, hsqlName.schema.name, hsqlName.type);
                        if (schemaObject == null) break;
                        stringBuffer.append("GRANT").append(' ');
                        stringBuffer.append("EXECUTE").append(' ');
                        stringBuffer.append("ON").append(' ');
                        stringBuffer.append("SPECIFIC").append(' ');
                        if (schemaObject.getType() == 17) {
                            stringBuffer.append("PROCEDURE");
                        } else {
                            stringBuffer.append("FUNCTION");
                        }
                        stringBuffer.append(' ');
                        stringBuffer.append(hsqlName.getSchemaQualifiedStatementName());
                        break;
                    }
                }
                if (stringBuffer.length() == 0) continue;
                stringBuffer.append(' ').append("TO").append(' ');
                stringBuffer.append(this.getName().getStatementName());
                hsqlArrayList.add(stringBuffer.toString());
            }
        }
        return hsqlArrayList;
    }
}

