/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rights;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.error.Error;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.Right;
import org.hsqldb.rights.User;

public class GranteeManager {
    static User systemAuthorisation;
    private HashMappedList map = new HashMappedList();
    private HashMappedList roleMap = new HashMappedList();
    Database database;
    private MessageDigest digester;
    private String digestAlgo;
    Grantee publicRole;
    Grantee dbaRole;
    Grantee schemaRole;
    Grantee changeAuthRole;
    static final IntValueHashMap rightsStringLookup;

    public GranteeManager(Database database) {
        this.database = database;
        this.addRole(this.database.nameManager.newHsqlName("PUBLIC", false, 11));
        this.publicRole = this.getRole("PUBLIC");
        this.publicRole.isPublic = true;
        this.addRole(this.database.nameManager.newHsqlName("DBA", false, 11));
        this.dbaRole = this.getRole("DBA");
        this.dbaRole.setAdminDirect();
        this.addRole(this.database.nameManager.newHsqlName("CREATE_SCHEMA", false, 11));
        this.schemaRole = this.getRole("CREATE_SCHEMA");
        this.addRole(this.database.nameManager.newHsqlName("CHANGE_AUTHORIZATION", false, 11));
        this.changeAuthRole = this.getRole("CHANGE_AUTHORIZATION");
    }

    public Grantee getDBARole() {
        return this.dbaRole;
    }

    public static Grantee getSystemRole() {
        return systemAuthorisation;
    }

    public void grant(Session session, OrderedHashSet orderedHashSet, SchemaObject schemaObject, Right right2, Grantee grantee, boolean bl) {
        if (schemaObject instanceof RoutineSchema) {
            SchemaObject[] schemaObjectArray = ((RoutineSchema)schemaObject).getSpecificRoutines();
            this.grant(session, orderedHashSet, schemaObjectArray, right2, grantee, bl);
            return;
        }
        HsqlNameManager.HsqlName hsqlName = schemaObject.getName();
        if (schemaObject instanceof Routine) {
            hsqlName = ((Routine)schemaObject).getSpecificName();
        }
        if (!grantee.isAccessible(schemaObject)) {
            throw Error.error(2000, grantee.getName().getNameString());
        }
        if (!grantee.isGrantable(schemaObject, right2)) {
            session.addWarning(Error.error(1007, grantee.getName().getNameString()));
            return;
        }
        if (grantee.isAdmin()) {
            grantee = schemaObject.getOwner();
        }
        this.checkGranteeList(orderedHashSet);
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            Grantee grantee2 = this.get((String)orderedHashSet.get(i));
            grantee2.grant(hsqlName, right2, grantee, bl);
            if (!grantee2.isRole) continue;
            this.updateAllRights(grantee2);
        }
    }

    public void grant(Session session, OrderedHashSet orderedHashSet, SchemaObject[] schemaObjectArray, Right right2, Grantee grantee, boolean bl) {
        boolean bl2 = false;
        for (int i = 0; i < schemaObjectArray.length; ++i) {
            if (!grantee.isGrantable(schemaObjectArray[i], right2)) continue;
            this.grant(session, orderedHashSet, schemaObjectArray[i], right2, grantee, bl);
            bl2 = true;
        }
        if (!bl2) {
            throw Error.error(2000, grantee.getName().getNameString());
        }
    }

    public void checkGranteeList(OrderedHashSet orderedHashSet) {
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            String string2 = (String)orderedHashSet.get(i);
            Grantee grantee = this.get(string2);
            if (grantee == null) {
                throw Error.error(4001, string2);
            }
            if (GranteeManager.isImmutable(string2)) {
                throw Error.error(4002, string2);
            }
            if (!(grantee instanceof User) || !((User)grantee).isExternalOnly) continue;
            throw Error.error(4000, string2);
        }
    }

    public void grant(String string2, String string3, Grantee grantee) {
        Grantee grantee2 = this.get(string2);
        if (grantee2 == null) {
            throw Error.error(4001, string2);
        }
        if (GranteeManager.isImmutable(string2)) {
            throw Error.error(4002, string2);
        }
        Grantee grantee3 = this.getRole(string3);
        if (grantee3 == null) {
            throw Error.error(2200, string3);
        }
        if (grantee3 == grantee2) {
            throw Error.error(2251, string2);
        }
        if (grantee3.hasRole(grantee2)) {
            throw Error.error(2251, string3);
        }
        if (!grantee.isGrantable(grantee3)) {
            throw Error.error(2000, grantee.getName().getNameString());
        }
        grantee2.grant(grantee3);
        grantee2.updateAllRights();
        if (grantee2.isRole) {
            this.updateAllRights(grantee2);
        }
    }

    public void checkRoleList(String string2, OrderedHashSet orderedHashSet, Grantee grantee, boolean bl) {
        Grantee grantee2 = this.get(string2);
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            String string3 = (String)orderedHashSet.get(i);
            Grantee grantee3 = this.getRole(string3);
            if (grantee3 == null) {
                throw Error.error(2200, string3);
            }
            if (string3.equals("_SYSTEM") || string3.equals("PUBLIC")) {
                throw Error.error(4002, string3);
            }
            if (bl) {
                if (grantee2.getDirectRoles().contains(grantee3)) {
                    throw Error.error(2200, string2);
                }
            } else if (!grantee2.getDirectRoles().contains(grantee3)) {
                throw Error.error(2200, string3);
            }
            if (grantee.isAdmin()) continue;
            throw Error.error(2000, grantee.getName().getNameString());
        }
    }

    public void grantSystemToPublic(SchemaObject schemaObject, Right right2) {
        this.publicRole.grant(schemaObject.getName(), right2, systemAuthorisation, true);
    }

    public void revoke(String string2, String string3, Grantee grantee) {
        if (!grantee.isAdmin()) {
            throw Error.error(5507);
        }
        Grantee grantee2 = this.get(string2);
        if (grantee2 == null) {
            throw Error.error(4000, string2);
        }
        Grantee grantee3 = (Grantee)this.roleMap.get(string3);
        grantee2.revoke(grantee3);
        grantee2.updateAllRights();
        if (grantee2.isRole) {
            this.updateAllRights(grantee2);
        }
    }

    public void revoke(OrderedHashSet orderedHashSet, SchemaObject schemaObject, Right right2, Grantee grantee, boolean bl, boolean bl2) {
        Grantee grantee2;
        String string2;
        int n;
        if (schemaObject instanceof RoutineSchema) {
            SchemaObject[] schemaObjectArray = ((RoutineSchema)schemaObject).getSpecificRoutines();
            this.revoke(orderedHashSet, schemaObjectArray, right2, grantee, bl, bl2);
            return;
        }
        HsqlNameManager.HsqlName hsqlName = schemaObject.getName();
        if (schemaObject instanceof Routine) {
            hsqlName = ((Routine)schemaObject).getSpecificName();
        }
        if (!grantee.isFullyAccessibleByRole(hsqlName)) {
            throw Error.error(5501, schemaObject.getName().name);
        }
        if (grantee.isAdmin()) {
            grantee = schemaObject.getOwner();
        }
        for (n = 0; n < orderedHashSet.size(); ++n) {
            string2 = (String)orderedHashSet.get(n);
            grantee2 = this.get(string2);
            if (grantee2 == null) {
                throw Error.error(4001, string2);
            }
            if (!GranteeManager.isImmutable(string2)) continue;
            throw Error.error(4002, string2);
        }
        for (n = 0; n < orderedHashSet.size(); ++n) {
            string2 = (String)orderedHashSet.get(n);
            grantee2 = this.get(string2);
            grantee2.revoke(schemaObject, right2, grantee, bl);
            grantee2.updateAllRights();
            if (!grantee2.isRole) continue;
            this.updateAllRights(grantee2);
        }
    }

    public void revoke(OrderedHashSet orderedHashSet, SchemaObject[] schemaObjectArray, Right right2, Grantee grantee, boolean bl, boolean bl2) {
        for (int i = 0; i < schemaObjectArray.length; ++i) {
            this.revoke(orderedHashSet, schemaObjectArray[i], right2, grantee, bl, bl2);
        }
    }

    public void updateAddColumn(HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName hsqlName2) {
        Grantee grantee;
        Iterator iterator2 = this.getRoles().iterator();
        while (iterator2.hasNext()) {
            grantee = (Grantee)iterator2.next();
            grantee.updateRightsForNewColumn(hsqlName, hsqlName2);
        }
        iterator2 = this.getGrantees().iterator();
        while (iterator2.hasNext()) {
            grantee = (Grantee)iterator2.next();
            grantee.updateRightsForNewColumn(hsqlName, hsqlName2);
        }
        this.updateAddColumn(hsqlName);
    }

    private void updateAddColumn(HsqlNameManager.HsqlName hsqlName) {
        Grantee grantee;
        Iterator iterator2 = this.getRoles().iterator();
        while (iterator2.hasNext()) {
            grantee = (Grantee)iterator2.next();
            grantee.updateRightsForNewColumn(hsqlName);
        }
        iterator2 = this.getGrantees().iterator();
        while (iterator2.hasNext()) {
            grantee = (Grantee)iterator2.next();
            grantee.updateRightsForNewColumn(hsqlName);
        }
    }

    void removeEmptyRole(Grantee grantee) {
        for (int i = 0; i < this.map.size(); ++i) {
            Grantee grantee2 = (Grantee)this.map.get(i);
            grantee2.roles.remove(grantee);
        }
    }

    public void removeDbObject(HsqlNameManager.HsqlName hsqlName) {
        for (int i = 0; i < this.map.size(); ++i) {
            Grantee grantee = (Grantee)this.map.get(i);
            grantee.revokeDbObject(hsqlName);
        }
    }

    public void removeDbObjects(OrderedHashSet orderedHashSet) {
        Iterator iterator2 = orderedHashSet.iterator();
        while (iterator2.hasNext()) {
            HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)iterator2.next();
            for (int i = 0; i < this.map.size(); ++i) {
                Grantee grantee = (Grantee)this.map.get(i);
                grantee.revokeDbObject(hsqlName);
            }
        }
    }

    void updateAllRights(Grantee grantee) {
        Grantee grantee2;
        int n;
        for (n = 0; n < this.map.size(); ++n) {
            grantee2 = (Grantee)this.map.get(n);
            if (!grantee2.isRole) continue;
            grantee2.updateNestedRoles(grantee);
        }
        for (n = 0; n < this.map.size(); ++n) {
            grantee2 = (Grantee)this.map.get(n);
            if (grantee2.isRole) continue;
            grantee2.updateAllRights();
        }
    }

    public boolean removeGrantee(String string2) {
        if (GranteeManager.isReserved(string2)) {
            return false;
        }
        Grantee grantee = (Grantee)this.map.remove(string2);
        if (grantee == null) {
            return false;
        }
        grantee.clearPrivileges();
        this.updateAllRights(grantee);
        if (grantee.isRole) {
            this.roleMap.remove(string2);
            this.removeEmptyRole(grantee);
        }
        return true;
    }

    public Grantee addRole(HsqlNameManager.HsqlName hsqlName) {
        if (this.map.containsKey(hsqlName.name)) {
            throw Error.error(4003, hsqlName.name);
        }
        if (SqlInvariants.isLobsSchemaName(hsqlName.name) || SqlInvariants.isSystemSchemaName(hsqlName.name)) {
            throw Error.error(4002, hsqlName.name);
        }
        Grantee grantee = new Grantee(hsqlName, this);
        grantee.isRole = true;
        this.map.put(hsqlName.name, grantee);
        this.roleMap.add(hsqlName.name, grantee);
        return grantee;
    }

    public User addUser(HsqlNameManager.HsqlName hsqlName) {
        if (this.map.containsKey(hsqlName.name)) {
            throw Error.error(4003, hsqlName.name);
        }
        if (SqlInvariants.isLobsSchemaName(hsqlName.name) || SqlInvariants.isSystemSchemaName(hsqlName.name)) {
            throw Error.error(4002, hsqlName.name);
        }
        User user = new User(hsqlName, this);
        this.map.put(hsqlName.name, user);
        return user;
    }

    public void removeNewUser(HsqlNameManager.HsqlName hsqlName) {
        this.map.remove(hsqlName.name);
    }

    boolean isGrantee(String string2) {
        return this.map.containsKey(string2);
    }

    public static int getCheckSingleRight(String string2) {
        int n = GranteeManager.getRight(string2);
        if (n != 0) {
            return n;
        }
        throw Error.error(5581, string2);
    }

    public static int getRight(String string2) {
        return rightsStringLookup.get((Object)string2, 0);
    }

    public Grantee get(String string2) {
        return (Grantee)this.map.get(string2);
    }

    public Collection getGrantees() {
        return this.map.values();
    }

    public static boolean validRightString(String string2) {
        return GranteeManager.getRight(string2) != 0;
    }

    public static boolean isImmutable(String string2) {
        return string2.equals("_SYSTEM") || string2.equals("DBA") || string2.equals("CREATE_SCHEMA") || string2.equals("CHANGE_AUTHORIZATION");
    }

    public static boolean isReserved(String string2) {
        return string2.equals("_SYSTEM") || string2.equals("DBA") || string2.equals("CREATE_SCHEMA") || string2.equals("CHANGE_AUTHORIZATION") || string2.equals("PUBLIC");
    }

    public void dropRole(String string2) {
        if (!this.isRole(string2)) {
            throw Error.error(2200, string2);
        }
        if (GranteeManager.isReserved(string2)) {
            throw Error.error(5507);
        }
        this.removeGrantee(string2);
    }

    public Set getRoleNames() {
        return this.roleMap.keySet();
    }

    public Collection getRoles() {
        return this.roleMap.values();
    }

    public Grantee getRole(String string2) {
        Grantee grantee = (Grantee)this.roleMap.get(string2);
        if (grantee == null) {
            throw Error.error(2200, string2);
        }
        return grantee;
    }

    public boolean isRole(String string2) {
        return this.roleMap.containsKey(string2);
    }

    public String[] getSQL() {
        Object object;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Iterator iterator2 = this.getRoles().iterator();
        while (iterator2.hasNext()) {
            object = (String[])iterator2.next();
            if (GranteeManager.isReserved(object.getName().getNameString())) continue;
            hsqlArrayList.add(object.getSQL());
        }
        iterator2 = this.getGrantees().iterator();
        while (iterator2.hasNext()) {
            object = (Grantee)iterator2.next();
            if (!(object instanceof User) || ((User)object).isExternalOnly) continue;
            hsqlArrayList.add(object.getSQL());
            if (!((User)object).isLocalOnly) continue;
            hsqlArrayList.add(((User)object).getLocalUserSQL());
        }
        object = new String[hsqlArrayList.size()];
        hsqlArrayList.toArray(object);
        return object;
    }

    public String[] getRightsSQL() {
        String[] stringArray;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Iterator iterator2 = this.getGrantees().iterator();
        while (iterator2.hasNext()) {
            stringArray = (String[])iterator2.next();
            String string2 = stringArray.getName().getNameString();
            if (GranteeManager.isImmutable(string2) || stringArray instanceof User && ((User)stringArray).isExternalOnly) continue;
            HsqlArrayList hsqlArrayList2 = stringArray.getRightsSQL();
            hsqlArrayList.addAll(hsqlArrayList2);
        }
        stringArray = new String[hsqlArrayList.size()];
        hsqlArrayList.toArray(stringArray);
        return stringArray;
    }

    public void setDigestAlgo(String string2) {
        this.digestAlgo = string2;
    }

    public String getDigestAlgo() {
        return this.digestAlgo;
    }

    synchronized MessageDigest getDigester() {
        if (this.digester == null) {
            try {
                this.digester = MessageDigest.getInstance(this.digestAlgo);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw Error.error(458, noSuchAlgorithmException);
            }
        }
        return this.digester;
    }

    String digest(String string2) throws RuntimeException {
        byte[] byArray;
        try {
            byArray = string2.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw Error.error(458, unsupportedEncodingException);
        }
        byArray = this.getDigester().digest(byArray);
        return StringConverter.byteArrayToHexString(byArray);
    }

    static {
        HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newSystemObjectName("_SYSTEM", 11);
        systemAuthorisation = new User(hsqlName, null);
        GranteeManager.systemAuthorisation.isSystem = true;
        systemAuthorisation.setAdminDirect();
        systemAuthorisation.setInitialSchema(SqlInvariants.SYSTEM_SCHEMA_HSQLNAME);
        SqlInvariants.INFORMATION_SCHEMA_HSQLNAME.owner = systemAuthorisation;
        SqlInvariants.SYSTEM_SCHEMA_HSQLNAME.owner = systemAuthorisation;
        SqlInvariants.LOBS_SCHEMA_HSQLNAME.owner = systemAuthorisation;
        SqlInvariants.SQLJ_SCHEMA_HSQLNAME.owner = systemAuthorisation;
        rightsStringLookup = new IntValueHashMap(7);
        rightsStringLookup.put("ALL", 63);
        rightsStringLookup.put("SELECT", 1);
        rightsStringLookup.put("UPDATE", 8);
        rightsStringLookup.put("DELETE", 2);
        rightsStringLookup.put("INSERT", 4);
        rightsStringLookup.put("EXECUTE", 32);
        rightsStringLookup.put("USAGE", 16);
        rightsStringLookup.put("REFERENCES", 64);
        rightsStringLookup.put("TRIGGER", 128);
    }
}

