/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.math.BigDecimal;
import org.hsqldb.Scanner;
import org.hsqldb.error.Error;
import org.hsqldb.map.ValuePool;
import org.hsqldb.persist.TextFileSettings;
import org.hsqldb.rowio.RowInputBase;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class RowInputText
extends RowInputBase
implements RowInputInterface {
    protected TextFileSettings textFileSettings;
    private String fieldSep;
    private String varSep;
    private String longvarSep;
    private int fieldSepLen;
    private int varSepLen;
    private int longvarSepLen;
    private boolean fieldSepEnd;
    private boolean varSepEnd;
    private boolean longvarSepEnd;
    private int textLen;
    protected String text;
    protected long line;
    protected int field;
    protected int next = 0;
    protected Scanner scanner;
    private int maxPooledStringLength = ValuePool.getMaxStringLength();

    public RowInputText(TextFileSettings textFileSettings) {
        super(new byte[0]);
        this.scanner = new Scanner();
        this.textFileSettings = textFileSettings;
        this.fieldSep = textFileSettings.fs;
        this.varSep = textFileSettings.vs;
        this.longvarSep = textFileSettings.lvs;
        if (this.fieldSep.endsWith("\n")) {
            this.fieldSepEnd = true;
            this.fieldSep = this.fieldSep.substring(0, this.fieldSep.length() - 1);
        }
        if (this.varSep.endsWith("\n")) {
            this.varSepEnd = true;
            this.varSep = this.varSep.substring(0, this.varSep.length() - 1);
        }
        if (this.longvarSep.endsWith("\n")) {
            this.longvarSepEnd = true;
            this.longvarSep = this.longvarSep.substring(0, this.longvarSep.length() - 1);
        }
        this.fieldSepLen = this.fieldSep.length();
        this.varSepLen = this.varSep.length();
        this.longvarSepLen = this.longvarSep.length();
    }

    public void setSource(String string2, long l, int n) {
        this.size = n;
        this.text = string2;
        this.textLen = string2.length();
        this.filePos = l;
        this.next = 0;
        ++this.line;
        this.field = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getField(String string2, int n, boolean bl) {
        String string3 = null;
        try {
            int n2 = this.next;
            ++this.field;
            if (bl) {
                if (this.next >= this.textLen && n > 0) {
                    throw Error.error(488);
                }
                if (!this.text.endsWith(string2)) throw Error.error(488);
                this.next = this.textLen - n;
            } else {
                this.next = this.text.indexOf(string2, n2);
                if (this.next == -1) {
                    this.next = this.textLen;
                }
            }
            if (n2 > this.next) {
                n2 = this.next;
            }
            string3 = this.text.substring(n2, this.next);
            this.next += n;
            int n3 = string3.trim().length();
            if (n3 == 0) {
                return null;
            }
            if (n3 >= string3.length()) return string3;
            n3 = string3.length() - 1;
            while (string3.charAt(n3) < ' ') {
                --n3;
            }
            return string3.substring(0, n3 + 1);
        }
        catch (Exception exception) {
            String string4 = exception.toString();
            throw Error.error(exception, 41, string4);
        }
    }

    @Override
    public String readString() {
        return this.getField(this.fieldSep, this.fieldSepLen, this.fieldSepEnd);
    }

    private String readVarString() {
        return this.getField(this.varSep, this.varSepLen, this.varSepEnd);
    }

    private String readLongVarString() {
        return this.getField(this.longvarSep, this.longvarSepLen, this.longvarSepEnd);
    }

    @Override
    public char readChar() {
        throw Error.runtimeError(201, "RowInputText");
    }

    @Override
    public byte readByte() {
        throw Error.runtimeError(201, "RowInputText");
    }

    @Override
    public short readShort() {
        throw Error.runtimeError(201, "RowInputText");
    }

    @Override
    public int readInt() {
        throw Error.runtimeError(201, "RowInputText");
    }

    @Override
    public long readLong() {
        throw Error.runtimeError(201, "RowInputText");
    }

    @Override
    public int readType() {
        return 0;
    }

    @Override
    protected boolean readNull() {
        return false;
    }

    @Override
    protected String readChar(Type type) {
        String string2 = null;
        switch (type.typeCode) {
            case 1: {
                string2 = this.readString();
                break;
            }
            case 12: {
                string2 = this.readVarString();
                break;
            }
            default: {
                string2 = this.readLongVarString();
            }
        }
        if (string2 == null) {
            return null;
        }
        if (string2.length() > this.maxPooledStringLength) {
            return string2;
        }
        return ValuePool.getString(string2);
    }

    @Override
    protected Integer readSmallint() {
        String string2 = this.readString();
        if (string2 == null) {
            return null;
        }
        if ((string2 = string2.trim()).length() == 0) {
            return null;
        }
        return ValuePool.getInt(Integer.parseInt(string2));
    }

    @Override
    protected Integer readInteger() {
        String string2 = this.readString();
        if (string2 == null) {
            return null;
        }
        if ((string2 = string2.trim()).length() == 0) {
            return null;
        }
        return ValuePool.getInt(Integer.parseInt(string2));
    }

    @Override
    protected Long readBigint() {
        String string2 = this.readString();
        if (string2 == null) {
            return null;
        }
        if ((string2 = string2.trim()).length() == 0) {
            return null;
        }
        return ValuePool.getLong(Long.parseLong(string2));
    }

    @Override
    protected Double readReal() {
        String string2 = this.readString();
        if (string2 == null) {
            return null;
        }
        if ((string2 = string2.trim()).length() == 0) {
            return null;
        }
        return Double.valueOf(string2);
    }

    @Override
    protected BigDecimal readDecimal(Type type) {
        String string2 = this.readString();
        if (string2 == null) {
            return null;
        }
        if ((string2 = string2.trim()).length() == 0) {
            return null;
        }
        return new BigDecimal(string2);
    }

    @Override
    protected TimeData readTime(Type type) {
        String string2 = this.readString();
        if (string2 == null) {
            return null;
        }
        if ((string2 = string2.trim()).length() == 0) {
            return null;
        }
        return this.scanner.newTime(string2);
    }

    @Override
    protected TimestampData readDate(Type type) {
        String string2 = this.readString();
        if (string2 == null) {
            return null;
        }
        if ((string2 = string2.trim()).length() == 0) {
            return null;
        }
        return this.scanner.newDate(string2);
    }

    @Override
    protected TimestampData readTimestamp(Type type) {
        String string2 = this.readString();
        if (string2 == null) {
            return null;
        }
        if ((string2 = string2.trim()).length() == 0) {
            return null;
        }
        return this.scanner.newTimestamp(string2);
    }

    @Override
    protected IntervalMonthData readYearMonthInterval(Type type) {
        String string2 = this.readString();
        if (string2 == null) {
            return null;
        }
        if ((string2 = string2.trim()).length() == 0) {
            return null;
        }
        return (IntervalMonthData)this.scanner.newInterval(string2, (IntervalType)type);
    }

    @Override
    protected IntervalSecondData readDaySecondInterval(Type type) {
        String string2 = this.readString();
        if (string2 == null) {
            return null;
        }
        if ((string2 = string2.trim()).length() == 0) {
            return null;
        }
        return (IntervalSecondData)this.scanner.newInterval(string2, (IntervalType)type);
    }

    @Override
    protected Boolean readBoole() {
        String string2 = this.readString();
        if (string2 == null) {
            return null;
        }
        if ((string2 = string2.trim()).length() == 0) {
            return null;
        }
        return string2.equalsIgnoreCase("TRUE") ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    protected Object readOther() {
        String string2 = this.readString();
        if (string2 == null) {
            return null;
        }
        BinaryData binaryData = this.scanner.convertToBinary(string2);
        if (binaryData.length(null) == 0L) {
            return null;
        }
        return new JavaObjectData(binaryData.getBytes());
    }

    @Override
    protected BinaryData readBit() {
        String string2 = this.readString();
        if (string2 == null) {
            return null;
        }
        BinaryData binaryData = this.scanner.convertToBit(string2);
        return binaryData;
    }

    @Override
    protected BinaryData readBinary() {
        String string2 = this.readString();
        if (string2 == null) {
            return null;
        }
        BinaryData binaryData = this.scanner.convertToBinary(string2);
        return binaryData;
    }

    @Override
    protected ClobData readClob() {
        String string2 = this.readString();
        if (string2 == null) {
            return null;
        }
        if ((string2 = string2.trim()).length() == 0) {
            return null;
        }
        long l = Long.parseLong(string2);
        return new ClobDataID(l);
    }

    @Override
    protected BlobData readBlob() {
        String string2 = this.readString();
        if (string2 == null) {
            return null;
        }
        if ((string2 = string2.trim()).length() == 0) {
            return null;
        }
        long l = Long.parseLong(string2);
        return new BlobDataID(l);
    }

    @Override
    protected Object[] readArray(Type type) {
        throw Error.runtimeError(201, "RowInputText");
    }

    public long getLineNumber() {
        return this.line;
    }

    public void skippedLine() {
        ++this.line;
    }

    @Override
    public void reset() {
        this.text = "";
        this.textLen = 0;
        this.filePos = 0L;
        this.next = 0;
        this.field = 0;
        this.line = 0L;
    }
}

