/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.error.Error;
import org.hsqldb.lib.LineReader;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.map.ValuePool;
import org.hsqldb.result.Result;
import org.hsqldb.rowio.RowInputTextLog;
import org.hsqldb.scriptio.ScriptReaderBase;
import org.hsqldb.scriptio.ScriptWriterText;
import org.hsqldb.types.Type;

public class ScriptReaderText
extends ScriptReaderBase {
    LineReader dataStreamIn;
    InputStream inputStream;
    InputStream bufferedStream;
    GZIPInputStream gzipStream;
    RowInputTextLog rowIn;
    boolean isInsert;

    ScriptReaderText(Database database, String string2) {
        super(database, string2);
    }

    public ScriptReaderText(Database database, String string2, boolean bl) throws IOException {
        super(database, string2);
        InputStream inputStream;
        this.inputStream = this.database.logger.getFileAccess().openInputStreamElement(string2);
        this.bufferedStream = new BufferedInputStream(this.inputStream);
        if (bl) {
            this.gzipStream = new GZIPInputStream(this.bufferedStream);
            inputStream = this.gzipStream;
        } else {
            inputStream = this.bufferedStream;
        }
        this.dataStreamIn = new LineReader(inputStream, "ISO-8859-1");
        this.rowIn = new RowInputTextLog(database.databaseProperties.isVersion18());
    }

    @Override
    protected void readDDL(Session session) {
        while (this.readLoggedStatement(session)) {
            Statement statement = null;
            Result result2 = null;
            if (this.rowIn.getStatementType() == 3) {
                this.isInsert = true;
                break;
            }
            try {
                statement = session.compileStatement(this.statement);
                result2 = session.executeCompiledStatement(statement, ValuePool.emptyObjectArray, 0);
            }
            catch (HsqlException hsqlException) {
                result2 = Result.newErrorResult(hsqlException);
            }
            if (result2.isError() && statement != null && (statement.getType() == 53 || statement.getType() == 69 && result2.getMainString().indexOf("org.hsqldb.Library") > -1) || !result2.isError()) continue;
            this.database.logger.logWarningEvent(result2.getMainString(), result2.getException());
            if (statement != null && statement.getType() == 69) continue;
            HsqlException hsqlException = Error.error(result2.getException(), 461, 25, new Object[]{Long.toString(this.lineCount) + " " + this.database.getCanonicalPath(), result2.getMainString()});
            this.handleException(hsqlException);
        }
    }

    @Override
    protected void readExistingData(Session session) {
        try {
            String string2 = null;
            this.database.setReferentialIntegrity(false);
            while (this.isInsert || this.readLoggedStatement(session)) {
                if (this.statementType == 6) {
                    session.setSchema(this.currentSchema);
                    string2 = null;
                } else if (this.statementType == 3) {
                    if (!this.rowIn.getTableName().equals(string2)) {
                        string2 = this.rowIn.getTableName();
                        String string3 = session.getSchemaName(this.currentSchema);
                        this.currentTable = this.database.schemaManager.getUserTable(string2, string3);
                        this.currentStore = this.database.persistentStoreCollection.getStore(this.currentTable);
                    }
                    try {
                        this.currentTable.insertFromScript(session, this.currentStore, this.rowData);
                    }
                    catch (HsqlException hsqlException) {
                        this.handleException(hsqlException);
                    }
                } else {
                    throw Error.error(461, this.statement);
                }
                this.isInsert = false;
            }
        }
        catch (Throwable throwable) {
            this.database.logger.logSevereEvent("readExistingData failed " + this.lineCount, throwable);
            throw Error.error(throwable, 461, 25, new Object[]{this.lineCount, throwable.toString()});
        }
        finally {
            this.database.setReferentialIntegrity(true);
        }
    }

    @Override
    public boolean readLoggedStatement(Session session) {
        if (!this.sessionChanged) {
            try {
                this.rawStatement = this.dataStreamIn.readLine();
            }
            catch (EOFException eOFException) {
                return false;
            }
            catch (IOException iOException) {
                throw Error.error(iOException, 452, null);
            }
            ++this.lineCount;
            this.statement = StringConverter.unicodeStringToString(this.rawStatement);
            if (this.statement == null) {
                return false;
            }
        }
        this.processStatement(session);
        return true;
    }

    void processStatement(Session session) {
        if (this.statement.startsWith("/*C")) {
            int n = this.statement.indexOf(42, 4);
            this.sessionNumber = Integer.parseInt(this.statement.substring(3, n));
            this.statement = this.statement.substring(n + 2);
            this.sessionChanged = true;
            this.statementType = 5;
            return;
        }
        this.sessionChanged = false;
        this.rowIn.setSource(session, this.statement);
        this.statementType = this.rowIn.getStatementType();
        if (this.statementType == 1) {
            this.rowData = null;
            this.currentTable = null;
            return;
        }
        if (this.statementType == 4) {
            this.rowData = null;
            this.currentTable = null;
            return;
        }
        if (this.statementType == 6) {
            this.rowData = null;
            this.currentTable = null;
            this.currentSchema = this.rowIn.getSchemaName();
            return;
        }
        String string2 = this.rowIn.getTableName();
        String string3 = session.getCurrentSchemaHsqlName().name;
        this.currentTable = this.database.schemaManager.getUserTable(string2, string3);
        this.currentStore = this.database.persistentStoreCollection.getStore(this.currentTable);
        Type[] typeArray = this.statementType == 3 ? this.currentTable.getColumnTypes() : (this.currentTable.hasPrimaryKey() ? this.currentTable.getPrimaryKeyTypes() : this.currentTable.getColumnTypes());
        this.rowData = this.rowIn.readData(typeArray);
    }

    @Override
    public void close() {
        try {
            if (this.dataStreamIn != null) {
                this.dataStreamIn.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.gzipStream != null) {
                this.gzipStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.scrwriter != null) {
                this.scrwriter.close();
            }
            this.database.recoveryMode = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handleException(HsqlException hsqlException) {
        if (this.database.recoveryMode == 0) {
            throw hsqlException;
        }
        if (this.scrwriter == null) {
            String string2 = this.database.getPath() + ".reject";
            this.scrwriter = new ScriptWriterText(this.database, string2, true, true, true);
        }
        try {
            this.scrwriter.writeLogStatement(null, this.rawStatement);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

