/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.hsqldb.Database;
import org.hsqldb.DatabaseManager;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HsqlTimer;
import org.hsqldb.lib.Iterator;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.result.Result;

public abstract class ScriptWriterBase
implements Runnable {
    Database database;
    String outFile;
    OutputStream fileStreamOut;
    FileAccess.FileSync outDescriptor;
    int tableRowCount;
    HsqlNameManager.HsqlName schemaToLog;
    boolean isClosed;
    boolean isCompressed;
    boolean isCrypt;
    boolean isUserScript;
    boolean includeCachedData;
    boolean includeIndexRoots;
    boolean includeTableInit;
    long byteCount;
    long lineCount;
    volatile boolean needsSync;
    private int syncCount;
    static final int INSERT = 0;
    static final int INSERT_WITH_SCHEMA = 1;
    Session currentSession;
    public static final String[] LIST_SCRIPT_FORMATS = new String[]{"TEXT", "BINARY", null, "COMPRESSED"};
    private Object timerTask;
    protected volatile int writeDelay = 60000;

    ScriptWriterBase(Database database, OutputStream outputStream, FileAccess.FileSync fileSync, boolean bl) {
        this.initBuffers();
        this.database = database;
        this.includeCachedData = bl;
        this.includeIndexRoots = !bl;
        this.currentSession = this.database.sessionManager.getSysSession();
        this.schemaToLog = this.currentSession.loggedSchema = this.currentSession.currentSchema;
        this.fileStreamOut = new BufferedOutputStream(outputStream, 16384);
        this.outDescriptor = fileSync;
    }

    ScriptWriterBase(Database database, String string2, boolean bl, boolean bl2, boolean bl3) {
        this.initBuffers();
        boolean bl4 = false;
        bl4 = bl3 ? FileUtil.getFileUtil().exists(string2) : database.logger.getFileAccess().isStreamElement(string2);
        if (bl4 && bl2) {
            throw Error.error(452, string2);
        }
        this.database = database;
        this.isUserScript = bl3;
        this.includeCachedData = bl;
        this.includeIndexRoots = !bl;
        this.outFile = string2;
        this.currentSession = this.database.sessionManager.getSysSession();
        this.schemaToLog = this.currentSession.loggedSchema = this.currentSession.currentSchema;
        this.openFile();
    }

    public void setIncludeIndexRoots(boolean bl) {
        this.includeIndexRoots = bl;
    }

    public void setIncludeCachedData(boolean bl) {
        this.includeCachedData = bl;
    }

    public void setIncludeTableInit(boolean bl) {
        this.includeTableInit = bl;
    }

    protected abstract void initBuffers();

    public void sync() {
        if (this.isClosed) {
            return;
        }
        if (this.needsSync) {
            this.forceSync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceSync() {
        if (this.isClosed) {
            return;
        }
        this.needsSync = false;
        OutputStream outputStream = this.fileStreamOut;
        synchronized (outputStream) {
            try {
                this.fileStreamOut.flush();
                this.outDescriptor.sync();
                ++this.syncCount;
            }
            catch (IOException iOException) {
                this.database.logger.logWarningEvent("ScriptWriter synch error: ", iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.stop();
        if (this.isClosed) {
            return;
        }
        try {
            OutputStream outputStream = this.fileStreamOut;
            synchronized (outputStream) {
                this.finishStream();
                this.forceSync();
                this.fileStreamOut.close();
                this.outDescriptor = null;
                this.isClosed = true;
            }
        }
        catch (IOException iOException) {
            throw Error.error(452);
        }
        this.byteCount = 0L;
        this.lineCount = 0L;
    }

    public long size() {
        return this.byteCount;
    }

    public void writeAll() {
        try {
            this.writeDDL();
            this.writeExistingData();
        }
        catch (IOException iOException) {
            throw Error.error(452);
        }
    }

    protected void openFile() {
        try {
            FileUtil fileUtil = this.isUserScript ? FileUtil.getFileUtil() : this.database.logger.getFileAccess();
            OutputStream outputStream = fileUtil.openOutputStreamElement(this.outFile);
            this.outDescriptor = fileUtil.getFileSync(outputStream);
            this.fileStreamOut = outputStream;
            this.fileStreamOut = new BufferedOutputStream(outputStream, 16384);
        }
        catch (IOException iOException) {
            throw Error.error(iOException, 452, 26, new Object[]{iOException.toString(), this.outFile});
        }
    }

    protected void finishStream() throws IOException {
    }

    public void writeDDL() throws IOException {
        Result result2 = this.database.getScript(this.includeIndexRoots);
        this.writeSingleColumnResult(result2);
    }

    public void writeExistingData() throws IOException {
        this.currentSession.loggedSchema = null;
        String[] stringArray = this.database.schemaManager.getSchemaNamesArray();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            Iterator iterator2 = this.database.schemaManager.databaseObjectIterator(string2, 3);
            while (iterator2.hasNext()) {
                Table table = (Table)iterator2.next();
                boolean bl = false;
                switch (table.getTableType()) {
                    case 4: {
                        bl = true;
                        break;
                    }
                    case 5: {
                        bl = this.includeCachedData;
                        break;
                    }
                    case 7: {
                        bl = this.includeCachedData && !table.isDataReadOnly();
                    }
                }
                try {
                    if (!bl) continue;
                    this.schemaToLog = table.getName().schema;
                    this.writeTableInit(table);
                    RowIterator rowIterator = table.rowIteratorClustered(this.currentSession);
                    while (rowIterator.hasNext()) {
                        Row row = rowIterator.getNextRow();
                        this.writeRow(this.currentSession, row, table);
                    }
                    this.writeTableTerm(table);
                }
                catch (Exception exception) {
                    throw Error.error(452, exception.toString());
                }
            }
        }
        this.writeDataTerm();
    }

    public void writeTableInit(Table table) throws IOException {
    }

    public void writeTableTerm(Table table) throws IOException {
    }

    protected void writeSingleColumnResult(Result result2) throws IOException {
        RowSetNavigator rowSetNavigator = result2.initialiseNavigator();
        while (rowSetNavigator.hasNext()) {
            Object[] objectArray = rowSetNavigator.getNext();
            this.writeLogStatement(this.currentSession, (String)objectArray[0]);
        }
    }

    public abstract void writeRow(Session var1, Row var2, Table var3) throws IOException;

    protected abstract void writeDataTerm() throws IOException;

    protected abstract void writeSessionIdAndSchema(Session var1) throws IOException;

    public abstract void writeLogStatement(Session var1, String var2) throws IOException;

    public abstract void writeOtherStatement(Session var1, String var2) throws IOException;

    public abstract void writeInsertStatement(Session var1, Row var2, Table var3) throws IOException;

    public abstract void writeDeleteStatement(Session var1, Table var2, Object[] var3) throws IOException;

    public abstract void writeSequenceStatement(Session var1, NumberSequence var2) throws IOException;

    public abstract void writeCommitStatement(Session var1) throws IOException;

    @Override
    public void run() {
        try {
            if (this.writeDelay != 0) {
                this.sync();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setWriteDelay(int n) {
        this.writeDelay = n;
    }

    public void start() {
        if (this.writeDelay > 0) {
            this.timerTask = DatabaseManager.getTimer().schedulePeriodicallyAfter(0L, this.writeDelay, this, false);
        }
    }

    public void stop() {
        if (this.timerTask != null) {
            HsqlTimer.cancel(this.timerTask);
            this.timerTask = null;
        }
    }

    public int getWriteDelay() {
        return this.writeDelay;
    }
}

