/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.Principal;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.cert.X509Certificate;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.server.HsqlSocketFactory;

public final class HsqlSocketFactorySecure
extends HsqlSocketFactory
implements HandshakeCompletedListener {
    protected Object socketFactory;
    protected Object serverSocketFactory;
    protected final Object socket_factory_mutex = new Object();
    protected final Object server_socket_factory_mutex = new Object();

    protected HsqlSocketFactorySecure() throws Exception {
    }

    @Override
    public void configureSocket(Socket socket) {
        super.configureSocket(socket);
        SSLSocket sSLSocket = (SSLSocket)socket;
        sSLSocket.addHandshakeCompletedListener(this);
    }

    @Override
    public ServerSocket createServerSocket(int n) throws Exception {
        SSLServerSocket sSLServerSocket = (SSLServerSocket)this.getServerSocketFactoryImpl().createServerSocket(n);
        if (Error.TRACESYSTEMOUT) {
            Error.printSystemOut("[" + this + "]: createServerSocket()");
            Error.printSystemOut("capabilities for " + sSLServerSocket + ":");
            Error.printSystemOut("----------------------------");
            HsqlSocketFactorySecure.dump("supported cipher suites", sSLServerSocket.getSupportedCipherSuites());
            HsqlSocketFactorySecure.dump("enabled cipher suites", sSLServerSocket.getEnabledCipherSuites());
        }
        return sSLServerSocket;
    }

    @Override
    public ServerSocket createServerSocket(int n, String string2) throws Exception {
        InetAddress inetAddress = InetAddress.getByName(string2);
        SSLServerSocket sSLServerSocket = (SSLServerSocket)this.getServerSocketFactoryImpl().createServerSocket(n, 128, inetAddress);
        if (Error.TRACESYSTEMOUT) {
            Error.printSystemOut("[" + this + "]: createServerSocket()");
            Error.printSystemOut("capabilities for " + sSLServerSocket + ":");
            Error.printSystemOut("----------------------------");
            HsqlSocketFactorySecure.dump("supported cipher suites", sSLServerSocket.getSupportedCipherSuites());
            HsqlSocketFactorySecure.dump("enabled cipher suites", sSLServerSocket.getEnabledCipherSuites());
        }
        return sSLServerSocket;
    }

    private static void dump(String string2, String[] stringArray) {
        Error.printSystemOut(string2);
        Error.printSystemOut("----------------------------");
        for (int i = 0; i < stringArray.length; ++i) {
            Error.printSystemOut(String.valueOf(stringArray[i]));
        }
        Error.printSystemOut("----------------------------");
    }

    @Override
    public Socket createSocket(Socket socket, String string2, int n) throws Exception {
        if (socket == null) {
            return this.createSocket(string2, n);
        }
        SSLSocket sSLSocket = (SSLSocket)this.getSocketFactoryImpl().createSocket(socket, string2, n, true);
        sSLSocket.addHandshakeCompletedListener(this);
        sSLSocket.startHandshake();
        this.verify(string2, sSLSocket.getSession());
        return sSLSocket;
    }

    @Override
    public Socket createSocket(String string2, int n) throws Exception {
        SSLSocket sSLSocket = (SSLSocket)this.getSocketFactoryImpl().createSocket(string2, n);
        sSLSocket.addHandshakeCompletedListener(this);
        sSLSocket.startHandshake();
        this.verify(string2, sSLSocket.getSession());
        return sSLSocket;
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SSLServerSocketFactory getServerSocketFactoryImpl() throws Exception {
        Object object;
        Object object2 = this.server_socket_factory_mutex;
        synchronized (object2) {
            object = this.serverSocketFactory;
            if (object == null) {
                this.serverSocketFactory = object = SSLServerSocketFactory.getDefault();
            }
        }
        return (SSLServerSocketFactory)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SSLSocketFactory getSocketFactoryImpl() throws Exception {
        Object object;
        Object object2 = this.socket_factory_mutex;
        synchronized (object2) {
            object = this.socketFactory;
            if (object == null) {
                this.socketFactory = object = SSLSocketFactory.getDefault();
            }
        }
        return (SSLSocketFactory)object;
    }

    protected void verify(String string2, SSLSession sSLSession) throws Exception {
        String string3;
        X509Certificate[] x509CertificateArray = sSLSession.getPeerCertificateChain();
        X509Certificate x509Certificate = x509CertificateArray[0];
        Principal principal = x509Certificate.getSubjectDN();
        String string4 = String.valueOf(principal);
        int n = string4.indexOf("CN=");
        if (n < 0) {
            throw new UnknownHostException(Error.getMessage(63));
        }
        int n2 = string4.indexOf(44, n += 3);
        if ((string3 = string4.substring(n, n2 > -1 ? n2 : string4.length())).length() < 1) {
            throw new UnknownHostException(Error.getMessage(64));
        }
        if (!string3.equalsIgnoreCase(string2)) {
            throw new UnknownHostException(Error.getMessage(65, 0, new Object[]{string3, string2}));
        }
    }

    @Override
    public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
        if (Error.TRACESYSTEMOUT) {
            SSLSocket sSLSocket = handshakeCompletedEvent.getSocket();
            SSLSession sSLSession = handshakeCompletedEvent.getSession();
            Error.printSystemOut("SSL handshake completed:");
            Error.printSystemOut("------------------------------------------------");
            Error.printSystemOut("socket:      : " + sSLSocket);
            Error.printSystemOut("cipher suite : " + sSLSession.getCipherSuite());
            String string2 = StringConverter.byteArrayToHexString(sSLSession.getId());
            Error.printSystemOut("session id   : " + string2);
            Error.printSystemOut("------------------------------------------------");
        }
    }
}

