/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.io.IOException;
import java.util.Locale;
import org.hsqldb.ColumnBase;
import org.hsqldb.lib.DataOutputStream;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.server.OdbcPacketInputStream;
import org.hsqldb.server.OdbcPacketOutputStream;
import org.hsqldb.server.RecoverableOdbcFailure;

public class OdbcUtil {
    static final int ODBC_SM_DATABASE = 64;
    static final int ODBC_SM_USER = 32;
    static final int ODBC_SM_OPTIONS = 64;
    static final int ODBC_SM_UNUSED = 64;
    static final int ODBC_SM_TTY = 64;
    static final int ODBC_AUTH_REQ_PASSWORD = 3;
    static final int ODBC_AUTH_REQ_OK = 0;
    static String[][] hardcodedParams = new String[][]{{"client_encoding", "SQL_ASCII"}, {"DateStyle", "ISO, MDY"}, {"integer_datetimes", "on"}, {"is_superuser", "on"}, {"server_encoding", "SQL_ASCII"}, {"server_version", "8.3.1"}, {"session_authorization", "blaine"}, {"standard_conforming_strings", "off"}, {"TimeZone", "US/Eastern"}};
    static final int ODBC_SIMPLE_MODE = 0;
    static final int ODBC_EXTENDED_MODE = 1;
    static final int ODBC_EXT_RECOVER_MODE = 2;
    static final int ODBC_SEVERITY_FATAL = 1;
    static final int ODBC_SEVERITY_ERROR = 2;
    static final int ODBC_SEVERITY_PANIC = 3;
    static final int ODBC_SEVERITY_WARNING = 4;
    static final int ODBC_SEVERITY_NOTICE = 5;
    static final int ODBC_SEVERITY_DEBUG = 6;
    static final int ODBC_SEVERITY_INFO = 7;
    static final int ODBC_SEVERITY_LOG = 8;
    static IntKeyHashMap odbcSeverityMap = new IntKeyHashMap();

    static void validateInputPacketSize(OdbcPacketInputStream odbcPacketInputStream) throws RecoverableOdbcFailure {
        int n = -1;
        try {
            n = odbcPacketInputStream.available();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n < 1) {
            return;
        }
        throw new RecoverableOdbcFailure("Client supplied bad length for " + odbcPacketInputStream.packetType + " packet.  " + n + " bytes available after processing", "Bad length for " + odbcPacketInputStream.packetType + " packet.  " + n + " extra bytes", "08P01");
    }

    static String echoBackReplyString(String string2, int n) {
        int n2;
        String string3 = string2.trim().toUpperCase(Locale.ENGLISH);
        for (n2 = 0; n2 < string3.length() && !Character.isWhitespace(string3.charAt(n2)); ++n2) {
        }
        StringBuffer stringBuffer = new StringBuffer(string3.substring(0, n2));
        String string4 = stringBuffer.toString();
        if (string4.equals("UPDATE") || string4.equals("DELETE")) {
            stringBuffer.append(" " + n);
        } else if (string4.equals("CREATE") || string4.equals("DROP")) {
            int n3;
            int n4;
            for (n4 = n2; n4 < string3.length() && Character.isWhitespace(string3.charAt(n4)); ++n4) {
            }
            for (n3 = n4; n3 < string3.length() && Character.isWhitespace(string3.charAt(n3)); ++n3) {
            }
            stringBuffer.append(" " + string3.substring(n4, n3));
        } else if (string4.equals("INSERT")) {
            stringBuffer.append(" 0 " + n);
        }
        return stringBuffer.toString();
    }

    static void writeParam(String string2, String string3, DataOutputStream dataOutputStream) throws IOException {
        OdbcPacketOutputStream odbcPacketOutputStream = OdbcPacketOutputStream.newOdbcPacketOutputStream();
        odbcPacketOutputStream.write(string2);
        odbcPacketOutputStream.write(string3);
        odbcPacketOutputStream.xmit('S', dataOutputStream);
        odbcPacketOutputStream.close();
    }

    static void alertClient(int n, String string2, DataOutputStream dataOutputStream) throws IOException {
        OdbcUtil.alertClient(n, string2, null, dataOutputStream);
    }

    static void alertClient(int n, String string2, String string3, DataOutputStream dataOutputStream) throws IOException {
        if (string3 == null) {
            string3 = "XX000";
        }
        if (!odbcSeverityMap.containsKey(n)) {
            throw new IllegalArgumentException("Unknown severity value (" + n + ')');
        }
        OdbcPacketOutputStream odbcPacketOutputStream = OdbcPacketOutputStream.newOdbcPacketOutputStream();
        odbcPacketOutputStream.write("S" + odbcSeverityMap.get(n));
        if (n < 5) {
            odbcPacketOutputStream.write("C" + string3);
        }
        odbcPacketOutputStream.write("M" + string2);
        odbcPacketOutputStream.writeByte(0);
        odbcPacketOutputStream.xmit(n < 5 ? (char)'E' : 'N', dataOutputStream);
        odbcPacketOutputStream.close();
    }

    static String revertMungledPreparedQuery(String string2) {
        return string2.replaceAll("\\$\\d+", "?");
    }

    public static int getTableOidForColumn(int n, ResultMetaData resultMetaData) {
        if (!resultMetaData.isTableColumn(n)) {
            return 0;
        }
        ColumnBase columnBase = resultMetaData.columns[n];
        int n2 = (columnBase.getSchemaNameString() + '.' + columnBase.getTableNameString()).hashCode();
        if (n2 < 0) {
            n2 *= -1;
        }
        return n2;
    }

    public static short getIdForColumn(int n, ResultMetaData resultMetaData) {
        if (!resultMetaData.isTableColumn(n)) {
            return 0;
        }
        short s2 = (short)resultMetaData.getGeneratedColumnNames()[n].hashCode();
        if (s2 < 0) {
            s2 = (short)(s2 * -1);
        }
        return s2;
    }

    public static String hexCharsToOctalOctets(String string2) {
        int n = string2.length();
        if (n != n / 2 * 2) {
            throw new IllegalArgumentException("Hex character lists contains an odd number of characters: " + n);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            int n2 = 0;
            char c = string2.charAt(i);
            if (c >= 'a' && c <= 'f') {
                n2 += 10 + c - 97;
            } else if (c >= 'A' && c <= 'F') {
                n2 += 10 + c - 65;
            } else if (c >= '0' && c <= '9') {
                n2 += c - 48;
            } else {
                throw new IllegalArgumentException("Non-hex character in input at offset " + i + ": " + c);
            }
            n2 <<= 4;
            c = string2.charAt(++i);
            if (c >= 'a' && c <= 'f') {
                n2 += 10 + c - 97;
            } else if (c >= 'A' && c <= 'F') {
                n2 += 10 + c - 65;
            } else if (c >= '0' && c <= '9') {
                n2 += c - 48;
            } else {
                throw new IllegalArgumentException("Non-hex character in input at offset " + i + ": " + c);
            }
            stringBuffer.append('\\');
            stringBuffer.append((char)(48 + (n2 >> 6)));
            stringBuffer.append((char)(48 + (n2 >> 3 & 7)));
            stringBuffer.append((char)(48 + (n2 & 7)));
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        System.out.println("(" + OdbcUtil.hexCharsToOctalOctets(stringArray[0]) + ')');
    }

    static {
        odbcSeverityMap.put(1, "FATAL");
        odbcSeverityMap.put(2, "ERROR");
        odbcSeverityMap.put(3, "PANIC");
        odbcSeverityMap.put(4, "WARNING");
        odbcSeverityMap.put(5, "NOTICE");
        odbcSeverityMap.put(6, "DEBUG");
        odbcSeverityMap.put(7, "INFO");
        odbcSeverityMap.put(8, "LOG");
    }
}

