/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.io.DataInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hsqldb.DatabaseManager;
import org.hsqldb.DatabaseURL;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.lib.DataOutputStream;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.result.Result;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowOutputBinary;

public class Servlet
extends HttpServlet {
    private static final int BUFFER_SIZE = 256;
    private String dbType;
    private String dbPath;
    private String initError;
    private static long lModified = 0L;

    public void init(ServletConfig servletConfig) {
        try {
            super.init(servletConfig);
        }
        catch (ServletException servletException) {
            this.log(servletException.toString());
        }
        String string2 = this.getInitParameter("hsqldb.server.database");
        if (string2 == null) {
            string2 = ".";
        }
        String string3 = this.getInitParameter("hsqldb.server.use_web-inf_path");
        if (!string2.equals(".") && "true".equalsIgnoreCase(string3)) {
            string2 = this.getServletContext().getRealPath("/") + "WEB-INF/" + string2;
        }
        HsqlProperties hsqlProperties = DatabaseURL.parseURL(string2, false, false);
        this.log("Database filename = " + string2);
        if (hsqlProperties == null) {
            this.initError = "Bad Database name";
        } else {
            this.dbPath = hsqlProperties.getProperty("database");
            this.dbType = hsqlProperties.getProperty("connection_type");
            try {
                DatabaseManager.getDatabase(this.dbType, this.dbPath, hsqlProperties);
            }
            catch (HsqlException hsqlException) {
                this.initError = hsqlException.getMessage();
            }
        }
        if (this.initError == null) {
            this.log("Initialization completed.");
        } else {
            this.log("Database could not be initialised.");
            this.log(this.initError);
        }
    }

    protected long getLastModified(HttpServletRequest httpServletRequest) {
        return lModified++;
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String string2 = httpServletRequest.getQueryString();
        if (string2 == null || string2.length() == 0) {
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setHeader("Pragma", "no-cache");
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println("<html><head><title>HSQL Database Engine Servlet</title>");
            printWriter.println("</head><body><h1>HSQL Database Engine Servlet</h1>");
            printWriter.println("The servlet is running.<p>");
            if (this.initError == null) {
                printWriter.println("Connected to the database.<p>");
                printWriter.println("Database name: " + this.dbType + this.dbPath + "<p>");
            } else {
                printWriter.println("<h2>The database is not available.</h2>");
                printWriter.println("The error message is:<p>");
                printWriter.println(this.initError);
            }
            printWriter.println("</body></html>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        DataInputStream dataInputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            Result result2;
            dataInputStream = new DataInputStream((InputStream)httpServletRequest.getInputStream());
            int n = dataInputStream.readInt();
            long l = dataInputStream.readLong();
            byte by2 = dataInputStream.readByte();
            RowInputBinary rowInputBinary = new RowInputBinary(256);
            Session session = DatabaseManager.getSession(n, l);
            Result result3 = Result.newResult(session, by2, dataInputStream, rowInputBinary);
            result3.setDatabaseId(n);
            result3.setSessionId(l);
            int n2 = result3.getType();
            if (n2 == 31) {
                try {
                    session = DatabaseManager.newSession(this.dbType, this.dbPath, result3.getMainString(), result3.getSubString(), new HsqlProperties(), result3.getZoneString(), result3.getUpdateCount());
                    result2 = Result.newConnectionAcknowledgeResponse(session);
                }
                catch (HsqlException hsqlException) {
                    result2 = Result.newErrorResult(hsqlException);
                }
            } else {
                long l2;
                if (n2 == 32 || n2 == 10) {
                    httpServletResponse.setHeader("Cache-Control", "no-cache");
                    httpServletResponse.setContentType("application/octet-stream");
                    httpServletResponse.setContentLength(6);
                    filterOutputStream = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
                    ((DataOutputStream)filterOutputStream).writeByte(32);
                    ((DataOutputStream)filterOutputStream).writeInt(4);
                    ((DataOutputStream)filterOutputStream).writeByte(0);
                    filterOutputStream.close();
                    return;
                }
                if (n2 == 5) {
                    int n3 = result3.getDatabaseId();
                    l2 = result3.getSessionId();
                    session = DatabaseManager.getSession(n3, l2);
                    result2 = session.cancel(result3);
                } else {
                    int n4 = result3.getDatabaseId();
                    l2 = result3.getSessionId();
                    session = DatabaseManager.getSession(n4, l2);
                    result3.readLobResults(session, dataInputStream, rowInputBinary);
                    result2 = session.execute(result3);
                }
            }
            HsqlByteArrayOutputStream hsqlByteArrayOutputStream = new HsqlByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(hsqlByteArrayOutputStream);
            RowOutputBinary rowOutputBinary = new RowOutputBinary(256, 1);
            result2.write(session, dataOutputStream, rowOutputBinary);
            httpServletResponse.setHeader("Cache-Control", "no-cache");
            httpServletResponse.setContentType("application/octet-stream");
            httpServletResponse.setContentLength(hsqlByteArrayOutputStream.size());
            filterOutputStream = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
            hsqlByteArrayOutputStream.writeTo(filterOutputStream);
        }
        catch (HsqlException hsqlException) {
        }
        finally {
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
            if (dataInputStream != null) {
                dataInputStream.close();
            }
        }
    }
}

