/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.hsqldb.DatabaseManager;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.DataOutputStream;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.InOutUtil;
import org.hsqldb.resources.ResourceBundleHandler;
import org.hsqldb.result.Result;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowOutputBinary;
import org.hsqldb.server.WebServer;

class WebServerConnection
implements Runnable {
    static final String ENCODING = "ISO-8859-1";
    private Charset iso = Charset.forName("ISO-8859-1");
    private CharsetDecoder iso_8859_1_decoder = this.iso.newDecoder();
    private Socket socket;
    private WebServer server;
    private static final int REQUEST_TYPE_BAD = 0;
    private static final int REQUEST_TYPE_GET = 1;
    private static final int REQUEST_TYPE_HEAD = 2;
    private static final int REQUEST_TYPE_POST = 3;
    private static final String HEADER_OK = "HTTP/1.0 200 OK";
    private static final String HEADER_BAD_REQUEST = "HTTP/1.0 400 Bad Request";
    private static final String HEADER_NOT_FOUND = "HTTP/1.0 404 Not Found";
    private static final String HEADER_FORBIDDEN = "HTTP/1.0 403 Forbidden";
    static final int BUFFER_SIZE = 256;
    final byte[] mainBuffer = new byte[256];
    private RowOutputBinary rowOut = new RowOutputBinary(this.mainBuffer);
    private RowInputBinary rowIn = new RowInputBinary(this.rowOut);
    static byte[] BYTES_GET;
    static byte[] BYTES_HEAD;
    static byte[] BYTES_POST;
    static byte[] BYTES_CONTENT;
    static final byte[] BYTES_WHITESPACE;
    private static final int hnd_content_types;

    WebServerConnection(Socket socket, WebServer webServer) {
        this.server = webServer;
        this.socket = socket;
    }

    private String getMimeTypeString(String string2) {
        if (string2 == null) {
            return "text/html";
        }
        int n = string2.lastIndexOf(46);
        String string3 = null;
        String string4 = null;
        if (n >= 0) {
            string3 = string2.substring(n).toLowerCase();
            string4 = this.server.serverProperties.getProperty(string3);
        }
        if (string4 == null && string3.length() > 1) {
            string4 = ResourceBundleHandler.getString(hnd_content_types, string3.substring(1));
        }
        return string4 == null ? "text/html" : string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        DataInputStream dataInputStream = null;
        try {
            int n;
            int n2;
            dataInputStream = new DataInputStream(this.socket.getInputStream());
            String string2 = null;
            int n3 = 0;
            do {
                if ((n2 = InOutUtil.readLine(dataInputStream, this.rowOut)) != 0) continue;
                throw new Exception();
            } while (n2 < 2);
            byte[] byArray = this.rowOut.toByteArray();
            if (ArrayUtil.containsAt(byArray, n = this.rowOut.size() - n2, BYTES_POST)) {
                n3 = 3;
                n += BYTES_POST.length;
            } else if (ArrayUtil.containsAt(byArray, n, BYTES_GET)) {
                n3 = 1;
                n += BYTES_GET.length;
            } else if (ArrayUtil.containsAt(byArray, n, BYTES_HEAD)) {
                n3 = 2;
                n += BYTES_HEAD.length;
            } else {
                n3 = 0;
            }
            n2 = ArrayUtil.countStartElementsAt(byArray, n, BYTES_WHITESPACE);
            if (n2 == 0) {
                n3 = 0;
            }
            n += n2;
            n2 = ArrayUtil.countNonStartElementsAt(byArray, n, BYTES_WHITESPACE);
            string2 = new String(byArray, n, n2, ENCODING);
            switch (n3) {
                case 3: {
                    this.processPost(dataInputStream, string2);
                    return;
                }
                case 0: {
                    this.processError(0);
                    return;
                }
                case 1: {
                    this.processGet(string2, true);
                    return;
                }
                case 2: {
                    this.processGet(string2, false);
                    return;
                }
            }
            return;
        }
        catch (Exception exception) {
            this.server.printStackTrace(exception);
            return;
        }
        finally {
            try {
                if (dataInputStream != null) {
                    dataInputStream.close();
                }
                this.socket.close();
            }
            catch (IOException iOException) {
                this.server.printStackTrace(iOException);
            }
        }
    }

    private void processPost(InputStream inputStream, String string2) throws IOException {
        try {
            int n;
            while ((n = InOutUtil.readLine(inputStream, this.rowOut)) > 2) {
            }
            String string3 = this.iso_8859_1_decoder.decode(ByteBuffer.wrap(this.rowOut.toByteArray())).toString();
            if (string3.indexOf("Content-Type: application/octet-stream") < 0) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            this.processError(400);
            return;
        }
        this.processQuery(inputStream);
    }

    void processQuery(InputStream inputStream) {
        try {
            Result result2;
            Object object;
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n = dataInputStream.readInt();
            long l = dataInputStream.readLong();
            byte by2 = dataInputStream.readByte();
            Session session = DatabaseManager.getSession(n, l);
            Result result3 = Result.newResult(session, by2, dataInputStream, this.rowIn);
            result3.setDatabaseId(n);
            result3.setSessionId(l);
            int n2 = result3.getType();
            if (n2 == 31) {
                try {
                    object = result3.getDatabaseName();
                    int n3 = this.server.getDBIndex((String)object);
                    int n4 = this.server.dbID[n3];
                    session = DatabaseManager.newSession(n4, result3.getMainString(), result3.getSubString(), result3.getZoneString(), result3.getUpdateCount());
                    result2 = Result.newConnectionAcknowledgeResponse(session);
                }
                catch (HsqlException hsqlException) {
                    result2 = Result.newErrorResult(hsqlException);
                }
                catch (RuntimeException runtimeException) {
                    result2 = Result.newErrorResult(runtimeException);
                }
            } else if (session == null) {
                result2 = Result.newErrorResult(Error.error(402));
            } else {
                result3.setSession(session);
                result3.readLobResults(session, dataInputStream, this.rowIn);
                result2 = n2 == 5 ? session.cancel(result3) : session.execute(result3);
            }
            if (n2 == 32 || n2 == 10) {
                object = new DataOutputStream(this.socket.getOutputStream());
                String string2 = this.getHead(HEADER_OK, false, "application/octet-stream", 6);
                ((FilterOutputStream)object).write(string2.getBytes(ENCODING));
                ((DataOutputStream)object).writeByte(32);
                ((DataOutputStream)object).writeInt(4);
                ((DataOutputStream)object).writeByte(0);
                ((FilterOutputStream)object).close();
                return;
            }
            object = new HsqlByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)object);
            result2.write(session, dataOutputStream, this.rowOut);
            DataOutputStream dataOutputStream2 = new DataOutputStream(this.socket.getOutputStream());
            String string3 = this.getHead(HEADER_OK, false, "application/octet-stream", ((HsqlByteArrayOutputStream)object).size());
            dataOutputStream2.write(string3.getBytes(ENCODING));
            ((HsqlByteArrayOutputStream)object).writeTo(dataOutputStream2);
            dataOutputStream2.close();
        }
        catch (IOException iOException) {
            this.server.printStackTrace(iOException);
        }
    }

    private void processGet(String string2, boolean bl) {
        try {
            String string3;
            if (string2.endsWith("/")) {
                string2 = string2 + this.server.getDefaultWebPage();
            }
            if (string2.indexOf("..") != -1) {
                this.processError(403);
                return;
            }
            string2 = this.server.getWebRoot() + string2;
            if (File.separatorChar != '/') {
                string2 = string2.replace('/', File.separatorChar);
            }
            InputStream inputStream = null;
            this.server.printWithThread("GET " + string2);
            try {
                File file = new File(string2);
                inputStream = new DataInputStream(new FileInputStream(file));
                string3 = this.getHead(HEADER_OK, true, this.getMimeTypeString(string2), (int)file.length());
            }
            catch (IOException iOException) {
                this.processError(404);
                if (inputStream != null) {
                    inputStream.close();
                }
                return;
            }
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.socket.getOutputStream());
            ((OutputStream)bufferedOutputStream).write(string3.getBytes(ENCODING));
            if (bl) {
                int n;
                while ((n = inputStream.read()) != -1) {
                    ((OutputStream)bufferedOutputStream).write(n);
                }
            }
            ((OutputStream)bufferedOutputStream).flush();
            ((OutputStream)bufferedOutputStream).close();
            inputStream.close();
        }
        catch (Exception exception) {
            this.server.printError("processGet: " + exception.toString());
            this.server.printStackTrace(exception);
        }
    }

    String getHead(String string2, boolean bl, String string3, int n) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(string2).append("\r\n");
        if (bl) {
            stringBuffer.append("Allow: GET, HEAD, POST\nMIME-Version: 1.0\r\n");
            stringBuffer.append("Server: ").append("HSQL Database Engine").append("\r\n");
        }
        if (string3 != null) {
            stringBuffer.append("Cache-Control: no-cache\r\n");
            stringBuffer.append("Content-Type: ").append(string3).append("\r\n");
        }
        stringBuffer.append("\r\n");
        return stringBuffer.toString();
    }

    private void processError(int n) {
        String string2;
        this.server.printWithThread("processError " + n);
        switch (n) {
            case 400: {
                string2 = this.getHead(HEADER_BAD_REQUEST, false, null, 0);
                string2 = string2 + ResourceBundleHandler.getString(WebServer.webBundleHandle, "BAD_REQUEST");
                break;
            }
            case 403: {
                string2 = this.getHead(HEADER_FORBIDDEN, false, null, 0);
                string2 = string2 + ResourceBundleHandler.getString(WebServer.webBundleHandle, "FORBIDDEN");
                break;
            }
            default: {
                string2 = this.getHead(HEADER_NOT_FOUND, false, null, 0);
                string2 = string2 + ResourceBundleHandler.getString(WebServer.webBundleHandle, "NOT_FOUND");
            }
        }
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.socket.getOutputStream());
            ((OutputStream)bufferedOutputStream).write(string2.getBytes(ENCODING));
            ((OutputStream)bufferedOutputStream).flush();
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (Exception exception) {
            this.server.printError("processError: " + exception.toString());
            this.server.printStackTrace(exception);
        }
    }

    String getConnectionThreadName() {
        return "HSQLDB HTTP Connection @" + Integer.toString(this.hashCode(), 16);
    }

    static {
        try {
            BYTES_GET = "GET".getBytes(ENCODING);
            BYTES_HEAD = "HEAD".getBytes(ENCODING);
            BYTES_POST = "POST".getBytes(ENCODING);
            BYTES_CONTENT = "Content-Length: ".getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw Error.runtimeError(201, "RowOutputTextLog");
        }
        BYTES_WHITESPACE = new byte[]{32, 9};
        hnd_content_types = ResourceBundleHandler.getBundleHandle("webserver-content-types", null);
    }
}

