/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.io.InputStream;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobInputStream;

public class BlobDataID
implements BlobData {
    long id;
    long length = -1L;

    public BlobDataID(long l) {
        this.id = l;
    }

    @Override
    public BlobData duplicate(SessionInterface sessionInterface) {
        ResultLob resultLob = ResultLob.newLobDuplicateRequest(this.id);
        Result result2 = sessionInterface.execute(resultLob);
        if (result2.isError()) {
            throw result2.getException();
        }
        long l = ((ResultLob)result2).getLobID();
        return new BlobDataID(l);
    }

    @Override
    public void free() {
    }

    @Override
    public InputStream getBinaryStream(SessionInterface sessionInterface) {
        long l = this.length(sessionInterface);
        return new BlobInputStream(sessionInterface, this, 0L, l);
    }

    @Override
    public InputStream getBinaryStream(SessionInterface sessionInterface, long l, long l2) {
        return new BlobInputStream(sessionInterface, this, l, l2);
    }

    @Override
    public byte[] getBytes() {
        return null;
    }

    @Override
    public byte[] getBytes(SessionInterface sessionInterface, long l, int n) {
        ResultLob resultLob = ResultLob.newLobGetBytesRequest(this.id, l, n);
        Result result2 = sessionInterface.execute(resultLob);
        if (result2.isError()) {
            throw Error.error(result2);
        }
        return ((ResultLob)result2).getByteArray();
    }

    @Override
    public BlobData getBlob(SessionInterface sessionInterface, long l, long l2) {
        ResultLob resultLob = ResultLob.newLobGetRequest(this.id, l, l2);
        Result result2 = sessionInterface.execute(resultLob);
        if (result2.isError()) {
            throw Error.error(result2);
        }
        long l3 = ((ResultLob)result2).getLobID();
        return new BlobDataID(l3);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long l) {
        this.id = l;
    }

    @Override
    public int getStreamBlockSize() {
        return 0;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public long length(SessionInterface sessionInterface) {
        if (this.length > -1L) {
            return this.length;
        }
        ResultLob resultLob = ResultLob.newLobGetLengthRequest(this.id);
        Result result2 = sessionInterface.execute(resultLob);
        if (result2.isError()) {
            throw result2.getException();
        }
        this.length = ((ResultLob)result2).getBlockLength();
        return this.length;
    }

    @Override
    public long bitLength(SessionInterface sessionInterface) {
        return this.length(sessionInterface) * 8L;
    }

    @Override
    public boolean isBits() {
        return false;
    }

    @Override
    public long position(SessionInterface sessionInterface, BlobData blobData, long l) {
        ResultLob resultLob = ResultLob.newLobGetCharPatternPositionRequest(this.id, blobData.getId(), l);
        Result result2 = sessionInterface.execute(resultLob);
        if (result2.isError()) {
            throw result2.getException();
        }
        return ((ResultLob)result2).getOffset();
    }

    @Override
    public long position(SessionInterface sessionInterface, byte[] byArray, long l) {
        ResultLob resultLob = ResultLob.newLobGetBytePatternPositionRequest(this.id, byArray, l);
        Result result2 = sessionInterface.execute(resultLob);
        if (result2.isError()) {
            throw result2.getException();
        }
        return ((ResultLob)result2).getOffset();
    }

    @Override
    public long nonZeroLength(SessionInterface sessionInterface) {
        ResultLob resultLob = ResultLob.newLobGetTruncateLength(this.id);
        Result result2 = sessionInterface.execute(resultLob);
        if (result2.isError()) {
            throw result2.getException();
        }
        return ((ResultLob)result2).getBlockLength();
    }

    @Override
    public void setBytes(SessionInterface sessionInterface, long l, byte[] object, int n, int n2) {
        Result result2;
        Object object2;
        if (n != 0 || n2 != ((byte[])object).length) {
            if (!BinaryData.isInLimits(((byte[])object).length, n, n2)) {
                throw new IndexOutOfBoundsException();
            }
            object2 = new byte[n2];
            System.arraycopy(object, n, object2, 0, n2);
            object = object2;
        }
        if ((result2 = sessionInterface.execute((Result)(object2 = ResultLob.newLobSetBytesRequest(this.id, l, object)))).isError()) {
            throw result2.getException();
        }
        this.length = ((ResultLob)result2).getBlockLength();
    }

    @Override
    public void setBytes(SessionInterface sessionInterface, long l, byte[] byArray) {
        this.setBytes(sessionInterface, l, byArray, 0, byArray.length);
    }

    @Override
    public void setBytes(SessionInterface sessionInterface, long l, BlobData blobData, long l2, long l3) {
        if (l3 > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException();
        }
        byte[] byArray = blobData.getBytes(sessionInterface, l2, (int)l3);
        this.setBytes(sessionInterface, l, byArray, 0, byArray.length);
    }

    @Override
    public void setBinaryStream(SessionInterface sessionInterface, long l, InputStream inputStream) {
    }

    @Override
    public void setSession(SessionInterface sessionInterface) {
    }

    @Override
    public void truncate(SessionInterface sessionInterface, long l) {
        ResultLob resultLob = ResultLob.newLobTruncateRequest(this.id, l);
        Result result2 = sessionInterface.execute(resultLob);
        if (result2.isError()) {
            throw result2.getException();
        }
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof BlobDataID) {
            return this.id == ((BlobDataID)object).id;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.id;
    }
}

