/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

public class Status {
    private final Code code;
    private final SubCode subCode;
    private final String state;

    public Status(Code code, SubCode subCode, String string2) {
        this.code = code;
        this.subCode = subCode;
        this.state = string2;
    }

    private Status(byte by2, byte by3, String string2) {
        this.code = Code.getCode(by2);
        this.subCode = SubCode.getSubCode(by3);
        this.state = string2;
    }

    public Code getCode() {
        return this.code;
    }

    public SubCode getSubCode() {
        return this.subCode;
    }

    public String getState() {
        return this.state;
    }

    public String getCodeString() {
        StringBuilder stringBuilder = new StringBuilder().append(this.code.name());
        if (this.subCode != null && this.subCode != SubCode.None) {
            stringBuilder.append("(").append(this.subCode.name()).append(")");
        }
        return stringBuilder.toString();
    }

    public static enum SubCode {
        None(0),
        MutexTimeout(1),
        LockTimeout(2),
        LockLimit(3),
        MaxSubCode(126);

        private final byte value;

        private SubCode(byte by2) {
            this.value = by2;
        }

        public static SubCode getSubCode(byte by2) {
            for (SubCode subCode : SubCode.values()) {
                if (subCode.value != by2) continue;
                return subCode;
            }
            throw new IllegalArgumentException("Illegal value provided for SubCode.");
        }
    }

    public static enum Code {
        Ok(0),
        NotFound(1),
        Corruption(2),
        NotSupported(3),
        InvalidArgument(4),
        IOError(5),
        MergeInProgress(6),
        Incomplete(7),
        ShutdownInProgress(8),
        TimedOut(9),
        Aborted(10),
        Busy(11),
        Expired(12),
        TryAgain(13);

        private final byte value;

        private Code(byte by2) {
            this.value = by2;
        }

        public static Code getCode(byte by2) {
            for (Code code : Code.values()) {
                if (code.value != by2) continue;
                return code;
            }
            throw new IllegalArgumentException("Illegal value provided for Code.");
        }
    }
}

