/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb.util;

public class Environment {
    private static String OS = System.getProperty("os.name").toLowerCase();
    private static String ARCH = System.getProperty("os.arch").toLowerCase();

    public static boolean isPowerPC() {
        return ARCH.contains("ppc");
    }

    public static boolean isWindows() {
        return OS.contains("win");
    }

    public static boolean isMac() {
        return OS.contains("mac");
    }

    public static boolean isAix() {
        return OS.contains("aix");
    }

    public static boolean isUnix() {
        return OS.contains("nix") || OS.contains("nux");
    }

    public static boolean isSolaris() {
        return OS.contains("sunos");
    }

    public static boolean is64Bit() {
        if (ARCH.indexOf("sparcv9") >= 0) {
            return true;
        }
        return ARCH.indexOf("64") > 0;
    }

    public static String getSharedLibraryName(String string2) {
        return string2 + "jni";
    }

    public static String getSharedLibraryFileName(String string2) {
        return Environment.appendLibOsSuffix("lib" + Environment.getSharedLibraryName(string2), true);
    }

    public static String getJniLibraryName(String string2) {
        if (Environment.isUnix()) {
            String string3;
            String string4 = string3 = Environment.is64Bit() ? "64" : "32";
            if (Environment.isPowerPC()) {
                return String.format("%sjni-linux-%s", string2, ARCH);
            }
            return String.format("%sjni-linux%s", string2, string3);
        }
        if (Environment.isMac()) {
            return String.format("%sjni-osx", string2);
        }
        if (Environment.isAix() && Environment.is64Bit()) {
            return String.format("%sjni-aix64", string2);
        }
        if (Environment.isSolaris()) {
            String string5 = Environment.is64Bit() ? "64" : "32";
            return String.format("%sjni-solaris%s", string2, string5);
        }
        if (Environment.isWindows() && Environment.is64Bit()) {
            return String.format("%sjni-win64", string2);
        }
        throw new UnsupportedOperationException(String.format("Cannot determine JNI library name for ARCH='%s' OS='%s' name='%s'", ARCH, OS, string2));
    }

    public static String getJniLibraryFileName(String string2) {
        return Environment.appendLibOsSuffix("lib" + Environment.getJniLibraryName(string2), false);
    }

    private static String appendLibOsSuffix(String string2, boolean bl) {
        if (Environment.isUnix() || Environment.isAix() || Environment.isSolaris()) {
            return string2 + ".so";
        }
        if (Environment.isMac()) {
            return string2 + (bl ? ".dylib" : ".jnilib");
        }
        if (Environment.isWindows()) {
            return string2 + ".dll";
        }
        throw new UnsupportedOperationException();
    }

    public static String getJniLibraryExtension() {
        if (Environment.isWindows()) {
            return ".dll";
        }
        return Environment.isMac() ? ".jnilib" : ".so";
    }
}

