/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.process.util;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;

public class TimeSerializers {
    public static void addDefaultSerializers(StreamExecutionEnvironment streamExecutionEnvironment) {
        TimeSerializers.addSerializer(streamExecutionEnvironment, Duration.class, new DurationSerializer());
        TimeSerializers.addSerializer(streamExecutionEnvironment, Instant.class, new InstantSerializer());
        TimeSerializers.addSerializer(streamExecutionEnvironment, LocalDate.class, new LocalDateSerializer());
        TimeSerializers.addSerializer(streamExecutionEnvironment, LocalTime.class, new LocalTimeSerializer());
        TimeSerializers.addSerializer(streamExecutionEnvironment, LocalDateTime.class, new LocalDateTimeSerializer());
        TimeSerializers.addSerializer(streamExecutionEnvironment, ZoneOffset.class, new ZoneOffsetSerializer());
        TimeSerializers.addSerializer(streamExecutionEnvironment, ZoneId.class, new ZoneIdSerializer());
        TimeSerializers.addSerializer(streamExecutionEnvironment, OffsetTime.class, new OffsetTimeSerializer());
        TimeSerializers.addSerializer(streamExecutionEnvironment, OffsetDateTime.class, new OffsetDateTimeSerializer());
        TimeSerializers.addSerializer(streamExecutionEnvironment, ZonedDateTime.class, new ZonedDateTimeSerializer());
        TimeSerializers.addSerializer(streamExecutionEnvironment, Year.class, new YearSerializer());
        TimeSerializers.addSerializer(streamExecutionEnvironment, YearMonth.class, new YearMonthSerializer());
        TimeSerializers.addSerializer(streamExecutionEnvironment, MonthDay.class, new MonthDaySerializer());
        TimeSerializers.addSerializer(streamExecutionEnvironment, Period.class, new PeriodSerializer());
    }

    private static <T, Y extends Serializer<T>> void addSerializer(StreamExecutionEnvironment streamExecutionEnvironment, Class<T> clazz, Y y) {
        streamExecutionEnvironment.getConfig().getRegisteredTypesWithKryoSerializers().put(clazz, new ExecutionConfig.SerializableSerializer(y));
        streamExecutionEnvironment.getConfig().getDefaultKryoSerializers().put(clazz, new ExecutionConfig.SerializableSerializer(y));
    }

    private static class PeriodSerializer
    extends Serializer<Period>
    implements Serializable {
        private PeriodSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, Period period) {
            output.writeInt(period.getYears(), true);
            output.writeInt(period.getMonths(), true);
            output.writeInt(period.getDays(), true);
        }

        public Period read(Kryo kryo, Input input2, Class<Period> clazz) {
            int n = input2.readInt(true);
            int n2 = input2.readInt(true);
            int n3 = input2.readInt(true);
            return Period.of(n, n2, n3);
        }
    }

    private static class MonthDaySerializer
    extends Serializer<MonthDay>
    implements Serializable {
        private MonthDaySerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, MonthDay monthDay) {
            output.writeByte(monthDay.getMonthValue());
            output.writeByte(monthDay.getDayOfMonth());
        }

        public MonthDay read(Kryo kryo, Input input2, Class<MonthDay> clazz) {
            byte by2 = input2.readByte();
            byte by3 = input2.readByte();
            return MonthDay.of(by2, (int)by3);
        }
    }

    private static class YearMonthSerializer
    extends Serializer<YearMonth>
    implements Serializable {
        private YearMonthSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, YearMonth yearMonth) {
            output.writeInt(yearMonth.getYear(), true);
            output.writeByte(yearMonth.getMonthValue());
        }

        public YearMonth read(Kryo kryo, Input input2, Class<YearMonth> clazz) {
            int n = input2.readInt(true);
            byte by2 = input2.readByte();
            return YearMonth.of(n, by2);
        }
    }

    private static class YearSerializer
    extends Serializer<Year>
    implements Serializable {
        private YearSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, Year year) {
            output.writeInt(year.getValue(), true);
        }

        public Year read(Kryo kryo, Input input2, Class<Year> clazz) {
            return Year.of(input2.readInt(true));
        }
    }

    private static class ZonedDateTimeSerializer
    extends Serializer<ZonedDateTime>
    implements Serializable {
        private ZonedDateTimeSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, ZonedDateTime zonedDateTime) {
            LocalDateSerializer.write(output, zonedDateTime.toLocalDate());
            LocalTimeSerializer.write(output, zonedDateTime.toLocalTime());
            ZoneIdSerializer.write(output, zonedDateTime.getZone());
        }

        public ZonedDateTime read(Kryo kryo, Input input2, Class<ZonedDateTime> clazz) {
            LocalDate localDate = LocalDateSerializer.read(input2);
            LocalTime localTime = LocalTimeSerializer.read(input2);
            ZoneId zoneId = ZoneIdSerializer.read(input2);
            return ZonedDateTime.of(localDate, localTime, zoneId);
        }
    }

    private static class OffsetDateTimeSerializer
    extends Serializer<OffsetDateTime>
    implements Serializable {
        private OffsetDateTimeSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, OffsetDateTime offsetDateTime) {
            LocalDateSerializer.write(output, offsetDateTime.toLocalDate());
            LocalTimeSerializer.write(output, offsetDateTime.toLocalTime());
            ZoneOffsetSerializer.write(output, offsetDateTime.getOffset());
        }

        public OffsetDateTime read(Kryo kryo, Input input2, Class<OffsetDateTime> clazz) {
            LocalDate localDate = LocalDateSerializer.read(input2);
            LocalTime localTime = LocalTimeSerializer.read(input2);
            ZoneOffset zoneOffset = ZoneOffsetSerializer.read(input2);
            return OffsetDateTime.of(localDate, localTime, zoneOffset);
        }
    }

    private static class OffsetTimeSerializer
    extends Serializer<OffsetTime>
    implements Serializable {
        private OffsetTimeSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, OffsetTime offsetTime) {
            LocalTimeSerializer.write(output, offsetTime.toLocalTime());
            ZoneOffsetSerializer.write(output, offsetTime.getOffset());
        }

        public OffsetTime read(Kryo kryo, Input input2, Class<OffsetTime> clazz) {
            LocalTime localTime = LocalTimeSerializer.read(input2);
            ZoneOffset zoneOffset = ZoneOffsetSerializer.read(input2);
            return OffsetTime.of(localTime, zoneOffset);
        }
    }

    private static class ZoneIdSerializer
    extends Serializer<ZoneId>
    implements Serializable {
        private ZoneIdSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, ZoneId zoneId) {
            ZoneIdSerializer.write(output, zoneId);
        }

        static void write(Output output, ZoneId zoneId) {
            output.writeString(zoneId.getId());
        }

        public ZoneId read(Kryo kryo, Input input2, Class<ZoneId> clazz) {
            return ZoneIdSerializer.read(input2);
        }

        static ZoneId read(Input input2) {
            String string2 = input2.readString();
            return ZoneId.of(string2);
        }
    }

    private static class ZoneOffsetSerializer
    extends Serializer<ZoneOffset>
    implements Serializable {
        private ZoneOffsetSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, ZoneOffset zoneOffset) {
            ZoneOffsetSerializer.write(output, zoneOffset);
        }

        static void write(Output output, ZoneOffset zoneOffset) {
            int n = zoneOffset.getTotalSeconds();
            int n2 = n % 900 == 0 ? n / 900 : 127;
            output.writeByte(n2);
            if (n2 == 127) {
                output.writeInt(n);
            }
        }

        public ZoneOffset read(Kryo kryo, Input input2, Class<ZoneOffset> clazz) {
            return ZoneOffsetSerializer.read(input2);
        }

        static ZoneOffset read(Input input2) {
            byte by2 = input2.readByte();
            return by2 == 127 ? ZoneOffset.ofTotalSeconds(input2.readInt()) : ZoneOffset.ofTotalSeconds(by2 * 900);
        }
    }

    private static class LocalTimeSerializer
    extends Serializer<LocalTime>
    implements Serializable {
        private LocalTimeSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, LocalTime localTime) {
            LocalTimeSerializer.write(output, localTime);
        }

        static void write(Output output, LocalTime localTime) {
            if (localTime.getNano() == 0) {
                if (localTime.getSecond() == 0) {
                    if (localTime.getMinute() == 0) {
                        output.writeByte(~localTime.getHour());
                    } else {
                        output.writeByte(localTime.getHour());
                        output.writeByte(~localTime.getMinute());
                    }
                } else {
                    output.writeByte(localTime.getHour());
                    output.writeByte(localTime.getMinute());
                    output.writeByte(~localTime.getSecond());
                }
            } else {
                output.writeByte(localTime.getHour());
                output.writeByte(localTime.getMinute());
                output.writeByte(localTime.getSecond());
                output.writeInt(localTime.getNano(), true);
            }
        }

        public LocalTime read(Kryo kryo, Input input2, Class<LocalTime> clazz) {
            return LocalTimeSerializer.read(input2);
        }

        static LocalTime read(Input input2) {
            int n = input2.readByte();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            if (n < 0) {
                n ^= 0xFFFFFFFF;
            } else {
                n2 = input2.readByte();
                if (n2 < 0) {
                    n2 ^= 0xFFFFFFFF;
                } else {
                    n3 = input2.readByte();
                    if (n3 < 0) {
                        n3 ^= 0xFFFFFFFF;
                    } else {
                        n4 = input2.readInt(true);
                    }
                }
            }
            return LocalTime.of(n, n2, n3, n4);
        }
    }

    private static class LocalDateTimeSerializer
    extends Serializer<LocalDateTime>
    implements Serializable {
        private LocalDateTimeSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, LocalDateTime localDateTime) {
            LocalDateSerializer.write(output, localDateTime.toLocalDate());
            LocalTimeSerializer.write(output, localDateTime.toLocalTime());
        }

        public LocalDateTime read(Kryo kryo, Input input2, Class<LocalDateTime> clazz) {
            LocalDate localDate = LocalDateSerializer.read(input2);
            LocalTime localTime = LocalTimeSerializer.read(input2);
            return LocalDateTime.of(localDate, localTime);
        }
    }

    private static class LocalDateSerializer
    extends Serializer<LocalDate>
    implements Serializable {
        private LocalDateSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, LocalDate localDate) {
            LocalDateSerializer.write(output, localDate);
        }

        static void write(Output output, LocalDate localDate) {
            output.writeInt(localDate.getYear(), true);
            output.writeByte(localDate.getMonthValue());
            output.writeByte(localDate.getDayOfMonth());
        }

        public LocalDate read(Kryo kryo, Input input2, Class<LocalDate> clazz) {
            return LocalDateSerializer.read(input2);
        }

        static LocalDate read(Input input2) {
            int n = input2.readInt(true);
            byte by2 = input2.readByte();
            byte by3 = input2.readByte();
            return LocalDate.of(n, by2, (int)by3);
        }
    }

    private static class InstantSerializer
    extends Serializer<Instant>
    implements Serializable {
        private InstantSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, Instant instant) {
            output.writeLong(instant.getEpochSecond(), true);
            output.writeInt(instant.getNano(), true);
        }

        public Instant read(Kryo kryo, Input input2, Class<Instant> clazz) {
            long l = input2.readLong(true);
            int n = input2.readInt(true);
            return Instant.ofEpochSecond(l, n);
        }
    }

    private static class DurationSerializer
    extends Serializer<Duration>
    implements Serializable {
        private DurationSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, Duration duration) {
            output.writeLong(duration.getSeconds());
            output.writeInt(duration.getNano(), true);
        }

        public Duration read(Kryo kryo, Input input2, Class<Duration> clazz) {
            long l = input2.readLong();
            int n = input2.readInt(true);
            return Duration.ofSeconds(l, n);
        }
    }
}

