/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.management;

import io.circe.Json;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.common.JobStatus;
import pl.touk.nussknacker.engine.ModelData;
import pl.touk.nussknacker.engine.api.ProcessVersion;
import pl.touk.nussknacker.engine.api.deployment.DeploymentId;
import pl.touk.nussknacker.engine.api.deployment.ProcessState;
import pl.touk.nussknacker.engine.api.deployment.ProcessState$;
import pl.touk.nussknacker.engine.api.deployment.ProcessStateDefinitionManager;
import pl.touk.nussknacker.engine.api.deployment.SavepointResult;
import pl.touk.nussknacker.engine.api.deployment.StateStatus;
import pl.touk.nussknacker.engine.api.namespaces.FlinkUsageKey$;
import pl.touk.nussknacker.engine.api.namespaces.NamingContext;
import pl.touk.nussknacker.engine.api.namespaces.UsageKey;
import pl.touk.nussknacker.engine.api.process.ProcessName;
import pl.touk.nussknacker.engine.management.FlinkArgsEncodeHack$;
import pl.touk.nussknacker.engine.management.FlinkConfig;
import pl.touk.nussknacker.engine.management.FlinkProcessManager;
import pl.touk.nussknacker.engine.management.FlinkStateStatus$;
import pl.touk.nussknacker.engine.management.flinkRestModel;
import pl.touk.nussknacker.engine.management.flinkRestModel$DeployProcessRequest$;
import pl.touk.nussknacker.engine.management.flinkRestModel$GetSavepointStatusResponse$;
import pl.touk.nussknacker.engine.management.flinkRestModel$JarsResponse$;
import pl.touk.nussknacker.engine.management.flinkRestModel$JobConfig$;
import pl.touk.nussknacker.engine.management.flinkRestModel$JobsResponse$;
import pl.touk.nussknacker.engine.management.flinkRestModel$SavepointTriggerRequest$;
import pl.touk.nussknacker.engine.management.flinkRestModel$SavepointTriggerResponse$;
import pl.touk.nussknacker.engine.management.flinkRestModel$StopRequest$;
import pl.touk.nussknacker.engine.management.flinkRestModel$UploadJarResponse$;
import pl.touk.nussknacker.engine.sttp.SttpJson$;
import pl.touk.nussknacker.engine.util.exception.DeeplyCheckingExceptionExtractor;
import pl.touk.nussknacker.engine.util.exception.DeeplyCheckingExceptionExtractor$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Unit$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sttp.client.IsOption$;
import sttp.client.RequestT;
import sttp.client.Response;
import sttp.client.SttpBackend;
import sttp.client.circe.package$;
import sttp.model.Part;
import sttp.model.StatusCode;
import sttp.model.Uri;

@ScalaSignature(bytes="\u0006\u0001\tud\u0001\u0002\u0010 \u0001)B\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t{\u0001\u0011\t\u0011)A\u0005}!A!\t\u0001B\u0001B\u0003%1\t\u0003\u0005Q\u0001\t\u0005\t\u0015a\u0003R\u0011\u0015q\u0007\u0001\"\u0001p\u0011\u001d1\bA1A\u0005\n]DaA \u0001!\u0002\u0013A\b\u0002C@\u0001\u0001\u0004%I!!\u0001\t\u0013\u0005-\u0001\u00011A\u0005\n\u00055\u0001\u0002CA\r\u0001\u0001\u0006K!a\u0001\t\u000f\u0005m\u0001\u0001\"\u0003\u0002\u001e!9\u0011q\u0004\u0001\u0005\n\u0005\u0005\u0002bBA\u0014\u0001\u0011%\u0011Q\u0004\u0005\b\u0003S\u0001A\u0011IA\u0016\u0011\u001d\t\t\u0006\u0001C\u0005\u0003'Bq!a#\u0001\t#\ti\tC\u0004\u0002\u001a\u0002!\t\"a'\t\u000f\u0005\u0015\u0006\u0001\"\u0003\u0002(\"9\u00111\u0018\u0001\u0005\n\u0005u\u0006\"CAo\u0001E\u0005I\u0011BAp\u0011\u001d\t)\u0010\u0001C)\u0003oDq!a@\u0001\t#\u0012\t\u0001C\u0004\u0003\f\u0001!\tF!\u0004\t\u000f\tM\u0001\u0001\"\u0003\u0003\u0016!I!q\u0006\u0001C\u0002\u0013%!\u0011\u0007\u0005\t\u0005'\u0002\u0001\u0015!\u0003\u00034!9!Q\u000b\u0001\u0005R\t]\u0003b\u0002B6\u0001\u0011%!Q\u000e\u0005\b\u0005s\u0002A\u0011\tB>\u0005A1E.\u001b8l%\u0016\u001cH/T1oC\u001e,'O\u0003\u0002!C\u0005QQ.\u00198bO\u0016lWM\u001c;\u000b\u0005\t\u001a\u0013AB3oO&tWM\u0003\u0002%K\u0005Ya.^:tW:\f7m[3s\u0015\t1s%\u0001\u0003u_V\\'\"\u0001\u0015\u0002\u0005Ad7\u0001A\n\u0004\u0001-z\u0003C\u0001\u0017.\u001b\u0005y\u0012B\u0001\u0018 \u0005M1E.\u001b8l!J|7-Z:t\u001b\u0006t\u0017mZ3s!\t\u0001t'D\u00012\u0015\t\u00114'\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u00025k\u0005AA/\u001f9fg\u00064WMC\u00017\u0003\r\u0019w.\\\u0005\u0003qE\u00121\u0002T1{s2{wmZ5oO\u000611m\u001c8gS\u001e\u0004\"\u0001L\u001e\n\u0005qz\"a\u0003$mS:\\7i\u001c8gS\u001e\f\u0011\"\\8eK2$\u0015\r^1\u0011\u0005}\u0002U\"A\u0011\n\u0005\u0005\u000b#!C'pI\u0016dG)\u0019;b\u00035i\u0017-\u001b8DY\u0006\u001c8OT1nKB\u0011A)\u0014\b\u0003\u000b.\u0003\"AR%\u000e\u0003\u001dS!\u0001S\u0015\u0002\rq\u0012xn\u001c;?\u0015\u0005Q\u0015!B:dC2\f\u0017B\u0001'J\u0003\u0019\u0001&/\u001a3fM&\u0011aj\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u00051K\u0015a\u00022bG.,g\u000e\u001a\t\u0006%^KvlY\u0007\u0002'*\u0011A+V\u0001\u0007G2LWM\u001c;\u000b\u0003Y\u000bAa\u001d;ua&\u0011\u0001l\u0015\u0002\f'R$\bOQ1dW\u0016tG\r\u0005\u0002[;6\t1L\u0003\u0002]\u0013\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005y[&A\u0002$viV\u0014X\r\u0005\u0002aC6\t\u0011*\u0003\u0002c\u0013\n9aj\u001c;iS:<\u0007C\u00013l\u001d\t)\u0017N\u0004\u0002gQ:\u0011aiZ\u0005\u0002-&\u0011A+V\u0005\u0003UN\u000bq\u0001]1dW\u0006<W-\u0003\u0002m[\nAaj\u001c;iS:<GK\u0003\u0002k'\u00061A(\u001b8jiz\"B\u0001]:ukR\u0011\u0011O\u001d\t\u0003Y\u0001AQ\u0001U\u0003A\u0004ECQ!O\u0003A\u0002iBQ!P\u0003A\u0002yBQAQ\u0003A\u0002\r\u000b\u0001B\u001a7j].,&\u000f\\\u000b\u0002qB\u0011\u0011\u0010`\u0007\u0002u*\u001110V\u0001\u0006[>$W\r\\\u0005\u0003{j\u00141!\u0016:j\u0003%1G.\u001b8l+Jd\u0007%\u0001\u000fkCJ,\u0006\u000f\\8bI\u0016$')\u001a4pe\u0016d\u0015m\u001d;SKN$\u0018M\u001d;\u0016\u0005\u0005\r\u0001#\u00021\u0002\u0006\u0005%\u0011bAA\u0004\u0013\n1q\n\u001d;j_:\u00042AW/D\u0003\u0001R\u0017M]+qY>\fG-\u001a3CK\u001a|'/\u001a'bgR\u0014Vm\u001d;beR|F%Z9\u0015\t\u0005=\u0011Q\u0003\t\u0004A\u0006E\u0011bAA\n\u0013\n!QK\\5u\u0011%\t9\"CA\u0001\u0002\u0004\t\u0019!A\u0002yIE\nQD[1s+Bdw.\u00193fI\n+gm\u001c:f\u0019\u0006\u001cHOU3ti\u0006\u0014H\u000fI\u0001\u000ekBdw.\u00193fI*\u000b'/\u00133\u0015\u0005\u0005%\u0011\u0001E2iK\u000e\\\u0017J\u001a&be\u0016C\u0018n\u001d;t)\u0011\tI!a\t\t\r\u0005\u0015B\u00021\u0001D\u0003\u0015Q\u0017M]%e\u0003A)\b\u000f\\8bI\u000e+(O]3oi*\u000b'/A\u0007gS:$'j\u001c2Ti\u0006$Xo\u001d\u000b\u0005\u0003[\t\t\u0005\u0005\u0003[;\u0006=\u0002#\u00021\u0002\u0006\u0005E\u0002\u0003BA\u001a\u0003{i!!!\u000e\u000b\t\u0005]\u0012\u0011H\u0001\u000bI\u0016\u0004Hn\\=nK:$(bAA\u001eC\u0005\u0019\u0011\r]5\n\t\u0005}\u0012Q\u0007\u0002\r!J|7-Z:t'R\fG/\u001a\u0005\b\u0003\u0007r\u0001\u0019AA#\u0003\u0011q\u0017-\\3\u0011\t\u0005\u001d\u0013QJ\u0007\u0003\u0003\u0013RA!a\u0013\u0002:\u00059\u0001O]8dKN\u001c\u0018\u0002BA(\u0003\u0013\u00121\u0002\u0015:pG\u0016\u001c8OT1nK\u0006\u0011b-\u001b8e%Vtg.\u001b8h\u001fJ4\u0015N]:u)\u0011\t)&a\u001e\u0011\t\u0005]\u0013\u0011\u000f\b\u0005\u00033\niG\u0004\u0003\u0002\\\u0005-d\u0002BA/\u0003SrA!a\u0018\u0002h9!\u0011\u0011MA3\u001d\r1\u00151M\u0005\u0002Q%\u0011aeJ\u0005\u0003I\u0015J!AI\u0012\n\u0005\u0001\n\u0013bAA8?\u0005qa\r\\5oWJ+7\u000f^'pI\u0016d\u0017\u0002BA:\u0003k\u00121BS8c\u001fZ,'O^5fo*\u0019\u0011qN\u0010\t\u000f\u0005et\u00021\u0001\u0002|\u0005a!n\u001c2Pm\u0016\u0014h/[3xgB1\u0011QPAC\u0003+rA!a \u0002\u0004:\u0019a)!!\n\u0003)K!A[%\n\t\u0005\u001d\u0015\u0011\u0012\u0002\u0005\u0019&\u001cHO\u0003\u0002k\u0013\u0006i\u0011n\u001d(pi\u001aKg.[:iK\u0012$B!a$\u0002\u0016B\u0019\u0001-!%\n\u0007\u0005M\u0015JA\u0004C_>dW-\u00198\t\u000f\u0005]\u0005\u00031\u0001\u0002V\u0005AqN^3sm&,w/\u0001\u0007nCBTuNY*uCR,8\u000f\u0006\u0003\u0002\u001e\u0006\r\u0006\u0003BA\u001a\u0003?KA!!)\u00026\tY1\u000b^1uKN#\u0018\r^;t\u0011\u001d\t9*\u0005a\u0001\u0003+\n1b^5uQZ+'o]5p]R1\u0011\u0011VA[\u0003s\u0003BAW/\u0002,B)\u0001-!\u0002\u0002.B!\u0011qVAY\u001b\t\tI$\u0003\u0003\u00024\u0006e\"A\u0004)s_\u000e,7o\u001d,feNLwN\u001c\u0005\u0007\u0003o\u0013\u0002\u0019A\"\u0002\u000b)|'-\u00133\t\u000f\u0005\r#\u00031\u0001\u0002F\u0005\u0001r/Y5u\r>\u00148+\u0019<fa>Lg\u000e\u001e\u000b\t\u0003\u007f\u000b9-a4\u0002TB!!,XAa!\u0011\t\u0019$a1\n\t\u0005\u0015\u0017Q\u0007\u0002\u0010'\u00064X\r]8j]R\u0014Vm];mi\"9\u0011qW\nA\u0002\u0005%\u0007\u0003BA\u001a\u0003\u0017LA!!4\u00026\taA)\u001a9m_flWM\u001c;JI\"1\u0011\u0011[\nA\u0002\r\u000b1b]1wKB|\u0017N\u001c;JI\"I\u0011Q[\n\u0011\u0002\u0003\u0007\u0011q[\u0001\fi&lWm\\;u\u0019\u00164G\u000fE\u0002a\u00033L1!a7J\u0005\u0011auN\\4\u00025]\f\u0017\u000e\u001e$peN\u000bg/\u001a9pS:$H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\u0005(\u0006BAl\u0003G\\#!!:\u0011\t\u0005\u001d\u0018\u0011_\u0007\u0003\u0003STA!a;\u0002n\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003_L\u0015AC1o]>$\u0018\r^5p]&!\u00111_Au\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0007G\u0006t7-\u001a7\u0015\t\u0005e\u00181 \t\u00055v\u000by\u0001C\u0004\u0002~V\u0001\r!!\r\u0002\u0007)|'-A\u0007nC.,7+\u0019<fa>Lg\u000e\u001e\u000b\u0007\u0003\u007f\u0013\u0019A!\u0002\t\u000f\u0005uh\u00031\u0001\u00022!9!q\u0001\fA\u0002\t%\u0011\u0001D:bm\u0016\u0004x.\u001b8u\t&\u0014\b\u0003\u00021\u0002\u0006\r\u000bAa\u001d;paR1\u0011q\u0018B\b\u0005#Aq!!@\u0018\u0001\u0004\t\t\u0004C\u0004\u0003\b]\u0001\rA!\u0003\u0002/A\u0014xnY3tgN\u000bg/\u001a9pS:$(+Z9vKN$HCBA`\u0005/\u0011I\u0002C\u0004\u0002~b\u0001\r!!\r\t\u000f\tm\u0001\u00041\u0001\u0003\u001e\u00059!/Z9vKN$\b\u0003\u0003*\u0003 \t\r\"\u0011F0\n\u0007\t\u00052K\u0001\u0005SKF,Xm\u001d;U!\r!'QE\u0005\u0004\u0005Oi'\u0001C%eK:$\u0018\u000e^=\u0011\r\u0005u$1F\"D\u0013\u0011\u0011i#!#\u0003\r\u0015KG\u000f[3s\u0003A!\u0018.\\3pkR,\u0005\u0010\u001e:bGR|'/\u0006\u0002\u00034A1!Q\u0007B \u0005\u0007j!Aa\u000e\u000b\t\te\"1H\u0001\nKb\u001cW\r\u001d;j_:T1A!\u0010\"\u0003\u0011)H/\u001b7\n\t\t\u0005#q\u0007\u0002!\t\u0016,\u0007\u000f\\=DQ\u0016\u001c7.\u001b8h\u000bb\u001cW\r\u001d;j_:,\u0005\u0010\u001e:bGR|'\u000f\u0005\u0003\u0003F\t=SB\u0001B$\u0015\ra&\u0011\n\u0006\u0005\u0005{\u0011YE\u0003\u0002\u0003N\u0005!!.\u0019<b\u0013\u0011\u0011\tFa\u0012\u0003!QKW.Z8vi\u0016C8-\u001a9uS>t\u0017!\u0005;j[\u0016|W\u000f^#yiJ\f7\r^8sA\u0005Q!/\u001e8Qe><'/Y7\u0015\u0015\u0005e(\u0011\fB/\u0005C\u00129\u0007C\u0004\u0003\\m\u0001\r!!\u0012\u0002\u0017A\u0014xnY3tg:\u000bW.\u001a\u0005\u0007\u0005?Z\u0002\u0019A\"\u0002\u00135\f\u0017N\\\"mCN\u001c\bb\u0002B27\u0001\u0007!QM\u0001\u0005CJ<7\u000fE\u0003\u0002~\u0005\u00155\tC\u0004\u0003jm\u0001\rA!\u0003\u0002\u001bM\fg/\u001a9pS:$\b+\u0019;i\u0003IA\u0017M\u001c3mKVs\u0017\u000e\u001e*fgB|gn]3\u0015\t\u0005e(q\u000e\u0005\b\u0005cb\u0002\u0019\u0001B:\u0003!\u0011Xm\u001d9p]N,\u0007#\u0002*\u0003v\t%\u0012b\u0001B<'\nA!+Z:q_:\u001cX-A\u0003dY>\u001cX\r\u0006\u0002\u0002\u0010\u0001")
public class FlinkRestManager
extends FlinkProcessManager {
    private final FlinkConfig config;
    private final ModelData modelData;
    private final SttpBackend<Future, Nothing$, Nothing$> backend;
    private final Uri flinkUrl;
    private Option<Future<String>> jarUploadedBeforeLastRestart;
    private final DeeplyCheckingExceptionExtractor<TimeoutException> pl$touk$nussknacker$engine$management$FlinkRestManager$$timeoutExtractor;

    private Uri flinkUrl() {
        return this.flinkUrl;
    }

    private Option<Future<String>> jarUploadedBeforeLastRestart() {
        return this.jarUploadedBeforeLastRestart;
    }

    private void jarUploadedBeforeLastRestart_$eq(Option<Future<String>> x$1) {
        this.jarUploadedBeforeLastRestart = x$1;
    }

    private Future<String> uploadedJarId() {
        Future future;
        Option<Future<String>> option = this.jarUploadedBeforeLastRestart();
        if (None$.MODULE$.equals(option)) {
            future = this.pl$touk$nussknacker$engine$management$FlinkRestManager$$uploadCurrentJar();
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Future uploadedJar = (Future)some.value();
            future = uploadedJar.flatMap((Function1 & Serializable & scala.Serializable)jarId -> this.checkIfJarExists((String)jarId), ExecutionContext.Implicits$.MODULE$.global()).recoverWith((PartialFunction)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FlinkRestManager $outer;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    BoxedUnit boxedUnit;
                    A1 A1 = x1;
                    if (this.$outer.logger().underlying().isInfoEnabled()) {
                        this.$outer.logger().underlying().info("Getting already uploaded jar failed with {}, trying to upload again", A1);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    Future<String> future = this.$outer.pl$touk$nussknacker$engine$management$FlinkRestManager$$uploadCurrentJar();
                    return (B1)future;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    boolean bl = true;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, ExecutionContext.Implicits$.MODULE$.global());
        } else {
            throw new MatchError(option);
        }
        return future;
    }

    private Future<String> checkIfJarExists(String jarId) {
        return ((Future)sttp.client.package$.MODULE$.basicRequest().get(this.flinkUrl().path("jars")).response(package$.MODULE$.asJson(flinkRestModel$JarsResponse$.MODULE$.decodeJarsResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), ExecutionContext.Implicits$.MODULE$.global()).flatMap((Function1 & Serializable & scala.Serializable)jars -> {
            boolean isJarUploaded = ((LinearSeqOptimized)jars.files().toList().flatten((Function1)Predef$.MODULE$.$conforms())).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FlinkRestManager.$anonfun$checkIfJarExists$3(jarId, x$1)));
            return isJarUploaded ? Future$.MODULE$.successful((Object)jarId) : Future$.MODULE$.failed((Throwable)new Exception(new StringBuilder(29).append("Jar with id '").append(jarId).append("' does not exist").toString()));
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    /*
     * WARNING - void declaration
     */
    public Future<String> pl$touk$nussknacker$engine$management$FlinkRestManager$$uploadCurrentJar() {
        void var1_1;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Uploading new jar");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Future uploadedJar = ((Future)sttp.client.package$.MODULE$.basicRequest().post(this.flinkUrl().path("jars", "upload", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).multipartBody(sttp.client.package$.MODULE$.multipartFile("jarfile", this.jarFile()).contentType("application/x-java-archive"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Part[0])).response(package$.MODULE$.asJson(flinkRestModel$UploadJarResponse$.MODULE$.decodeUploadJarResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), ExecutionContext.Implicits$.MODULE$.global()).map((Function1 & Serializable & scala.Serializable)file -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Uploaded jar to {}", new Object[]{file});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return new File(file.filename()).getName();
        }, ExecutionContext.Implicits$.MODULE$.global());
        this.jarUploadedBeforeLastRestart_$eq((Option<Future<String>>)new Some((Object)uploadedJar));
        return var1_1;
    }

    public Future<Option<ProcessState>> findJobStatus(String name) {
        String preparedName = this.modelData.objectNaming().prepareName(name, this.modelData.processConfig(), new NamingContext((UsageKey)FlinkUsageKey$.MODULE$));
        return ((Future)sttp.client.package$.MODULE$.basicRequest().get(this.flinkUrl().path("jobs", "overview", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).response(package$.MODULE$.asJson(flinkRestModel$JobsResponse$.MODULE$.decodeJobsResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), ExecutionContext.Implicits$.MODULE$.global()).flatMap((Function1 & Serializable & scala.Serializable)jobs -> {
            Future future;
            List jobsForName = ((List)((SeqLike)jobs.jobs().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)FlinkRestManager.$anonfun$findJobStatus$3(preparedName, x$2)))).sortBy((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.last$minusmodification()), (Ordering)Ordering.Long$.MODULE$)).reverse();
            List list = jobsForName;
            if (Nil$.MODULE$.equals(list)) {
                future = Future$.MODULE$.successful((Object)None$.MODULE$);
            } else if (list.count((Function1 & Serializable & scala.Serializable)overview -> BoxesRunTime.boxToBoolean((boolean)this.isNotFinished(overview))) > 1) {
                String x$1 = ((flinkRestModel.JobOverview)list.head()).jid();
                StateStatus x$22 = FlinkStateStatus$.MODULE$.MultipleJobsRunning();
                ProcessStateDefinitionManager x$32 = this.processStateDefinitionManager();
                Option x$4 = Option$.MODULE$.empty();
                Option x$5 = Option$.MODULE$.empty();
                Some x$6 = new Some((Object)BoxesRunTime.boxToLong((long)((flinkRestModel.JobOverview)list.head()).start$minustime()));
                .colon.colon x$7 = new .colon.colon((Object)new StringBuilder(27).append("Expected one job, instead: ").append(((TraversableOnce)jobsForName.map((Function1 & Serializable & scala.Serializable)job -> new StringBuilder(3).append(job.jid()).append(" - ").append(job.state()).toString(), List$.MODULE$.canBuildFrom())).mkString(", ")).toString(), (List)Nil$.MODULE$);
                future = Future$.MODULE$.successful((Object)new Some((Object)ProcessState$.MODULE$.apply(x$1, x$22, x$4, x$32, (Option)x$6, x$5, (List)x$7)));
            } else {
                flinkRestModel.JobOverview job2 = this.findRunningOrFirst((List<flinkRestModel.JobOverview>)list);
                StateStatus stateStatus = this.mapJobStatus(job2);
                future = this.withVersion(job2.jid(), name).map((Function1 & Serializable & scala.Serializable)version -> {
                    BoxedUnit boxedUnit;
                    if (version.isEmpty()) {
                        if (this.logger().underlying().isDebugEnabled()) {
                            this.logger().underlying().debug("No correct version in deployed process: {}", new Object[]{job2.name()});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return new Some((Object)ProcessState$.MODULE$.apply(job2.jid(), stateStatus, version, this.processStateDefinitionManager(), (Option)new Some((Object)BoxesRunTime.boxToLong((long)job2.start$minustime())), Option$.MODULE$.empty(), List$.MODULE$.empty()));
                }, ExecutionContext.Implicits$.MODULE$.global());
            }
            return future;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private flinkRestModel.JobOverview findRunningOrFirst(List<flinkRestModel.JobOverview> jobOverviews) {
        return (flinkRestModel.JobOverview)jobOverviews.find((Function1 & Serializable & scala.Serializable)overview -> BoxesRunTime.boxToBoolean((boolean)this.isNotFinished(overview))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (flinkRestModel.JobOverview)jobOverviews.head());
    }

    public boolean isNotFinished(flinkRestModel.JobOverview overview) {
        return !JobStatus.valueOf((String)overview.state()).isGloballyTerminalState();
    }

    public StateStatus mapJobStatus(flinkRestModel.JobOverview overview) {
        StateStatus stateStatus;
        JobStatus jobStatus = JobStatus.valueOf((String)overview.state());
        if (JobStatus.RUNNING.equals(jobStatus)) {
            stateStatus = FlinkStateStatus$.MODULE$.Running();
        } else if (JobStatus.FINISHED.equals(jobStatus)) {
            stateStatus = FlinkStateStatus$.MODULE$.Finished();
        } else if (JobStatus.RESTARTING.equals(jobStatus)) {
            stateStatus = FlinkStateStatus$.MODULE$.Restarting();
        } else if (JobStatus.CANCELED.equals(jobStatus)) {
            stateStatus = FlinkStateStatus$.MODULE$.Canceled();
        } else if (JobStatus.CANCELLING.equals(jobStatus)) {
            stateStatus = FlinkStateStatus$.MODULE$.DuringCancel();
        } else {
            boolean bl = JobStatus.RECONCILING.equals(jobStatus) ? true : (JobStatus.CREATED.equals(jobStatus) ? true : JobStatus.SUSPENDED.equals(jobStatus));
            if (bl) {
                stateStatus = FlinkStateStatus$.MODULE$.Running();
            } else if (JobStatus.FAILING.equals(jobStatus)) {
                stateStatus = FlinkStateStatus$.MODULE$.Failing();
            } else if (JobStatus.FAILED.equals(jobStatus)) {
                stateStatus = FlinkStateStatus$.MODULE$.Failed();
            } else {
                throw new MatchError((Object)jobStatus);
            }
        }
        return stateStatus;
    }

    private Future<Option<ProcessVersion>> withVersion(String jobId, String name) {
        return ((Future)sttp.client.package$.MODULE$.basicRequest().get(this.flinkUrl().path("jobs", jobId, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"config"}))).response(package$.MODULE$.asJson(flinkRestModel$JobConfig$.MODULE$.decodeJobConfig(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), ExecutionContext.Implicits$.MODULE$.global()).map((Function1 & Serializable & scala.Serializable)config -> {
            Map<String, Json> userConfig = config.execution$minusconfig().user$minusconfig();
            return userConfig.get((Object)"versionId").flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.asString()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)FlinkRestManager.$anonfun$withVersion$4(x$5))).flatMap((Function1 & Serializable & scala.Serializable)version -> FlinkRestManager.$anonfun$withVersion$5(userConfig, name, BoxesRunTime.unboxToLong((Object)version)));
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<SavepointResult> waitForSavepoint(String jobId, String savepointId, long timeoutLeft) {
        long start = System.currentTimeMillis();
        if (timeoutLeft <= 0L) {
            return Future$.MODULE$.failed((Throwable)new Exception(new StringBuilder(54).append("Failed to complete savepoint in time for ").append(new DeploymentId(jobId)).append(" and trigger ").append(savepointId).toString()));
        }
        return ((Future)sttp.client.package$.MODULE$.basicRequest().get(this.flinkUrl().path("jobs", jobId, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"savepoints", savepointId}))).response(package$.MODULE$.asJson(flinkRestModel$GetSavepointStatusResponse$.MODULE$.decodeGetSavepointStatusResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), ExecutionContext.Implicits$.MODULE$.global()).flatMap((Function1 & Serializable & scala.Serializable)resp -> {
            Future future;
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Waiting for savepoint {} of {}, got response: {}", new Object[]{savepointId, new DeploymentId(jobId), resp});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (resp.isCompletedSuccessfully()) {
                BoxedUnit boxedUnit2;
                String location = (String)resp.operation().flatMap((Function1 & Serializable & scala.Serializable)x$10 -> x$10.location()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Savepoint {} for {} finished in {}", new Object[]{savepointId, new DeploymentId(jobId), location});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                future = Future$.MODULE$.successful((Object)new SavepointResult(location));
            } else if (resp.isFailed()) {
                future = Future$.MODULE$.failed((Throwable)new RuntimeException(new StringBuilder(30).append("Failed to complete savepoint: ").append(resp.operation()).toString()));
            } else {
                Thread.sleep(1000L);
                future = this.waitForSavepoint(jobId, savepointId, timeoutLeft - (System.currentTimeMillis() - start));
            }
            return future;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private long waitForSavepoint$default$3() {
        return this.config.jobManagerTimeout().toMillis();
    }

    @Override
    public Future<BoxedUnit> cancel(ProcessState job) {
        return ((Future)sttp.client.package$.MODULE$.basicRequest().patch(this.flinkUrl().path("jobs", job.deploymentId(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> this.handleUnitResponse((Response<Either<String, String>>)response), ExecutionContext.Implicits$.MODULE$.global());
    }

    @Override
    public Future<SavepointResult> makeSavepoint(ProcessState job, Option<String> savepointDir) {
        RequestT savepointRequest = sttp.client.package$.MODULE$.basicRequest().post(this.flinkUrl().path("jobs", job.deploymentId(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"savepoints"}))).body((Object)new flinkRestModel.SavepointTriggerRequest(savepointDir, false), package$.MODULE$.circeBodySerializer(flinkRestModel$SavepointTriggerRequest$.MODULE$.encodeSavepointTriggerRequest(), package$.MODULE$.circeBodySerializer$default$2()));
        return this.processSavepointRequest(job, (RequestT<Object, Either<String, String>, Nothing$>)savepointRequest);
    }

    @Override
    public Future<SavepointResult> stop(ProcessState job, Option<String> savepointDir) {
        RequestT stopRequest = sttp.client.package$.MODULE$.basicRequest().post(this.flinkUrl().path("jobs", job.deploymentId(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stop"}))).body((Object)new flinkRestModel.StopRequest(savepointDir, false), package$.MODULE$.circeBodySerializer(flinkRestModel$StopRequest$.MODULE$.encodeStopRequest(), package$.MODULE$.circeBodySerializer$default$2()));
        return this.processSavepointRequest(job, (RequestT<Object, Either<String, String>, Nothing$>)stopRequest);
    }

    private Future<SavepointResult> processSavepointRequest(ProcessState job, RequestT<Object, Either<String, String>, Nothing$> request) {
        return ((Future)request.response(package$.MODULE$.asJson(flinkRestModel$SavepointTriggerResponse$.MODULE$.decodeSavepointTriggerResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), ExecutionContext.Implicits$.MODULE$.global()).flatMap((Function1 & Serializable & scala.Serializable)response -> this.waitForSavepoint(job.deploymentId(), response.request$minusid(), this.waitForSavepoint$default$3()), ExecutionContext.Implicits$.MODULE$.global());
    }

    public DeeplyCheckingExceptionExtractor<TimeoutException> pl$touk$nussknacker$engine$management$FlinkRestManager$$timeoutExtractor() {
        return this.pl$touk$nussknacker$engine$management$FlinkRestManager$$timeoutExtractor;
    }

    @Override
    public Future<BoxedUnit> runProgram(String processName, String mainClass, List<String> args, Option<String> savepointPath) {
        BoxedUnit boxedUnit;
        String x$1 = mainClass;
        int x$2 = -1;
        Option<String> x$3 = savepointPath;
        boolean x$4 = true;
        String x$5 = FlinkArgsEncodeHack$.MODULE$.prepareProgramArgs(args).mkString(" ");
        flinkRestModel.DeployProcessRequest program = new flinkRestModel.DeployProcessRequest(x$1, x$2, x$3, x$5, x$4);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Starting to deploy process: {} with savepoint {}", new Object[]{new ProcessName(processName), savepointPath});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.uploadedJarId().flatMap((Function1 & Serializable & scala.Serializable)jarId -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Deploying {} with {} and jarId: {}", new Object[]{new ProcessName(processName), savepointPath, jarId});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return ((Future)sttp.client.package$.MODULE$.basicRequest().post(this.flinkUrl().path("jars", jarId, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"run"}))).body((Object)program, package$.MODULE$.circeBodySerializer(flinkRestModel$DeployProcessRequest$.MODULE$.encodeDeployProcessRequest(), package$.MODULE$.circeBodySerializer$default$2())).send($this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> this.handleUnitResponse((Response<Either<String, String>>)response), ExecutionContext.Implicits$.MODULE$.global()).recover((PartialFunction)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FlinkRestManager $outer;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    Option option = this.$outer.pl$touk$nussknacker$engine$management$FlinkRestManager$$timeoutExtractor().unapply(A1);
                    if (!option.isEmpty()) {
                        BoxedUnit boxedUnit;
                        TimeoutException e = (TimeoutException)option.get();
                        if (this.$outer.logger().underlying().isWarnEnabled()) {
                            this.$outer.logger().underlying().warn("TimeoutException occurred while waiting for deploy result. Recovering with Future.successful...", (Throwable)e);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        Future$.MODULE$.successful((Object)Unit$.MODULE$);
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    Option option = this.$outer.pl$touk$nussknacker$engine$management$FlinkRestManager$$timeoutExtractor().unapply(throwable);
                    boolean bl = !option.isEmpty();
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, ExecutionContext.Implicits$.MODULE$.global());
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<BoxedUnit> handleUnitResponse(Response<Either<String, String>> response) {
        Future future;
        Either either = (Either)response.body();
        if (either instanceof Right) {
            future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        } else if (either instanceof Left) {
            Left left = (Left)either;
            String error = (String)left.value();
            future = Future$.MODULE$.failed((Throwable)new RuntimeException(new StringBuilder(24).append("Request failed: ").append(error).append(", code: ").append(new StatusCode(response.code())).toString()));
        } else {
            throw new MatchError((Object)either);
        }
        return future;
    }

    public void close() {
        Await$.MODULE$.result((Awaitable)this.backend.close(), (Duration)Duration$.MODULE$.apply(10L, TimeUnit.SECONDS));
    }

    public static final /* synthetic */ boolean $anonfun$checkIfJarExists$3(String jarId$1, flinkRestModel.JarFile x$1) {
        String string = x$1.id();
        String string2 = jarId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findJobStatus$3(String preparedName$1, flinkRestModel.JobOverview x$2) {
        String string = x$2.name();
        String string2 = preparedName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ long $anonfun$withVersion$4(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).toLong();
    }

    public static final /* synthetic */ int $anonfun$withVersion$10(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).toInt();
    }

    public static final /* synthetic */ Option $anonfun$withVersion$5(Map userConfig$1, String name$2, long version) {
        return userConfig$1.get((Object)"user").map((Function1 & Serializable & scala.Serializable)x$6 -> (String)x$6.asString().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).map((Function1 & Serializable & scala.Serializable)user -> {
            Option modelVersion = userConfig$1.get((Object)"modelVersion").flatMap((Function1 & Serializable & scala.Serializable)x$7 -> x$7.asString()).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)FlinkRestManager.$anonfun$withVersion$10(x$8)));
            return new Tuple2(user, (Object)modelVersion);
        }).map((Function1 & Serializable & scala.Serializable)x$9 -> {
            Tuple2 tuple2 = x$9;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String user = (String)tuple2._1();
            Option modelVersion = (Option)tuple2._2();
            ProcessVersion processVersion = new ProcessVersion(version, name$2, user, modelVersion);
            return processVersion;
        });
    }

    public FlinkRestManager(FlinkConfig config, ModelData modelData, String mainClassName, SttpBackend<Future, Nothing$, ?> backend) {
        this.config = config;
        this.modelData = modelData;
        this.backend = backend;
        super(modelData, BoxesRunTime.unboxToBoolean((Object)config.shouldVerifyBeforeDeploy().getOrElse((Function0)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        })), mainClassName);
        this.flinkUrl = sttp.client.package$.MODULE$.UriContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).uri((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config.restUrl()}));
        this.jarUploadedBeforeLastRestart = None$.MODULE$;
        this.pl$touk$nussknacker$engine$management$FlinkRestManager$$timeoutExtractor = DeeplyCheckingExceptionExtractor$.MODULE$.forClass(ClassTag$.MODULE$.apply(TimeoutException.class));
    }
}

