/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.management;

import cats.Applicative;
import cats.Functor;
import cats.Monad;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.implicits$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import pl.touk.nussknacker.engine.api.StreamMetaData;
import pl.touk.nussknacker.engine.api.TypeSpecificData;
import pl.touk.nussknacker.engine.api.deployment.CustomProcess;
import pl.touk.nussknacker.engine.api.deployment.ExternalDeploymentId;
import pl.touk.nussknacker.engine.api.deployment.GraphProcess;
import pl.touk.nussknacker.engine.api.deployment.ProcessDeploymentData;
import pl.touk.nussknacker.engine.canonicalgraph.CanonicalProcess;
import pl.touk.nussknacker.engine.management.FlinkSlotsChecker$NotEnoughSlotsException$;
import pl.touk.nussknacker.engine.management.rest.HttpFlinkClient;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel;
import pl.touk.nussknacker.engine.marshall.ProcessMarshaller$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t=g\u0001\u0002 @\u0001)C\u0001b\u0017\u0001\u0003\u0002\u0003\u0006I\u0001\u0018\u0005\tE\u0002\u0011\t\u0011)A\u0006G\")\u0011\u000e\u0001C\u0001U\")\u0001\u000f\u0001C\u0001c\"9\u0011Q\u0003\u0001\u0005\n\u0005]\u0001b\u0002BS\u0001\u0011%!q\u0015\u0005\b\u0005[\u0003A\u0011\u0002BX\u000f\u001d\tIe\u0010E\u0001\u0003\u00172aAP \t\u0002\u00055\u0003BB5\n\t\u0003\tyE\u0002\u0004\u0002R%\u0001\u00151\u000b\u0005\u000b\u0003gZ!Q3A\u0005\u0002\u0005U\u0004BCA?\u0017\tE\t\u0015!\u0003\u0002x!Q\u0011qP\u0006\u0003\u0016\u0004%\t!!\u001e\t\u0015\u0005\u00055B!E!\u0002\u0013\t9\b\u0003\u0006\u0002\u0004.\u0011)\u001a!C\u0001\u0003\u000bC!Ba\u0004\f\u0005#\u0005\u000b\u0011BAD\u0011\u0019I7\u0002\"\u0001\u0003\u0012!I\u0011qT\u0006\u0002\u0002\u0013\u0005!1\u0004\u0005\n\u0003O[\u0011\u0013!C\u0001\u0003SC\u0011\"a0\f#\u0003%\t!!+\t\u0013\t\r2\"%A\u0005\u0002\t\u0015\u0002\"CAa\u0017\u0005\u0005I\u0011IAb\u0011%\t)nCA\u0001\n\u0003\t)\bC\u0005\u0002X.\t\t\u0011\"\u0001\u0003*!I\u0011Q]\u0006\u0002\u0002\u0013\u0005\u0013q\u001d\u0005\n\u0003k\\\u0011\u0011!C\u0001\u0005[A\u0011B!\u0001\f\u0003\u0003%\tEa\u0001\t\u0013\t%1\"!A\u0005B\tEra\u0002B\u001b\u0013!\u0005!q\u0007\u0004\b\u0003#J\u0001\u0012\u0001B\u001d\u0011\u0019Iw\u0004\"\u0001\u0003<!9!QH\u0010\u0005\u0002\t}\u0002\"\u0003B\u001f?\u0005\u0005I\u0011\u0011B-\u0011%\u0011\tgHA\u0001\n\u0003\u0013\u0019\u0007C\u0005\u0003r}\t\t\u0011\"\u0003\u0003t\u00191\u00111R\u0005A\u0003\u001bC!\"a$&\u0005+\u0007I\u0011AA;\u0011)\t\t*\nB\tB\u0003%\u0011q\u000f\u0005\u000b\u0003'+#Q3A\u0005\u0002\u0005U\u0004BCAKK\tE\t\u0015!\u0003\u0002x!1\u0011.\nC\u0001\u0003/Cq!!(&\t\u0003\t)\bC\u0005\u0002 \u0016\n\t\u0011\"\u0001\u0002\"\"I\u0011qU\u0013\u0012\u0002\u0013\u0005\u0011\u0011\u0016\u0005\n\u0003\u007f+\u0013\u0013!C\u0001\u0003SC\u0011\"!1&\u0003\u0003%\t%a1\t\u0013\u0005UW%!A\u0005\u0002\u0005U\u0004\"CAlK\u0005\u0005I\u0011AAm\u0011%\t)/JA\u0001\n\u0003\n9\u000fC\u0005\u0002v\u0016\n\t\u0011\"\u0001\u0002x\"I!\u0011A\u0013\u0002\u0002\u0013\u0005#1\u0001\u0005\n\u0005\u000b)\u0013\u0011!C!\u0005\u000fA\u0011B!\u0003&\u0003\u0003%\tEa\u0003\b\u0013\tm\u0014\"!A\t\u0002\tud!CAF\u0013\u0005\u0005\t\u0012\u0001B@\u0011\u0019I\u0007\b\"\u0001\u0003\u000e\"I!Q\u0001\u001d\u0002\u0002\u0013\u0015#q\u0001\u0005\n\u0005{A\u0014\u0011!CA\u0005\u001fC\u0011B!\u00199\u0003\u0003%\tI!&\t\u0013\tE\u0004(!A\u0005\n\tM$!\u0005$mS:\\7\u000b\\8ug\u000eCWmY6fe*\u0011\u0001)Q\u0001\u000b[\u0006t\u0017mZ3nK:$(B\u0001\"D\u0003\u0019)gnZ5oK*\u0011A)R\u0001\f]V\u001c8o\u001b8bG.,'O\u0003\u0002G\u000f\u0006!Ao\\;l\u0015\u0005A\u0015A\u00019m\u0007\u0001\u00192\u0001A&R!\tau*D\u0001N\u0015\u0005q\u0015!B:dC2\f\u0017B\u0001)N\u0005\u0019\te.\u001f*fMB\u0011!+W\u0007\u0002'*\u0011A+V\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003-^\u000b\u0001\u0002^=qKN\fg-\u001a\u0006\u00021\u0006\u00191m\\7\n\u0005i\u001b&a\u0003'bufdunZ4j]\u001e\faa\u00197jK:$\bCA/a\u001b\u0005q&BA0@\u0003\u0011\u0011Xm\u001d;\n\u0005\u0005t&a\u0004%uiB4E.\u001b8l\u00072LWM\u001c;\u0002\u0005\u0015\u001c\u0007C\u00013h\u001b\u0005)'B\u00014N\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003Q\u0016\u0014\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\tYw\u000e\u0006\u0002m]B\u0011Q\u000eA\u0007\u0002\u007f!)!m\u0001a\u0002G\")1l\u0001a\u00019\u000613\r[3dWJ+\u0017/^5sK\u0012\u001cFn\u001c;t\u000bb\u001cW-\u001a3Bm\u0006LG.\u00192mKNcw\u000e^:\u0015\tID\u0018Q\u0001\t\u0004IN,\u0018B\u0001;f\u0005\u00191U\u000f^;sKB\u0011AJ^\u0005\u0003o6\u0013A!\u00168ji\")\u0011\u0010\u0002a\u0001u\u0006)\u0002O]8dKN\u001cH)\u001a9m_flWM\u001c;ECR\f\u0007cA>\u0002\u00025\tAP\u0003\u0002~}\u0006QA-\u001a9m_flWM\u001c;\u000b\u0005}\f\u0015aA1qS&\u0019\u00111\u0001?\u0003+A\u0013xnY3tg\u0012+\u0007\u000f\\8z[\u0016tG\u000fR1uC\"9\u0011q\u0001\u0003A\u0002\u0005%\u0011AF2veJ,g\u000e\u001e7z\t\u0016\u0004Hn\\=fI*{'-\u00133\u0011\u000b1\u000bY!a\u0004\n\u0007\u00055QJ\u0001\u0004PaRLwN\u001c\t\u0004w\u0006E\u0011bAA\ny\n!R\t\u001f;fe:\fG\u000eR3qY>LX.\u001a8u\u0013\u0012\fQ\u0003Z3uKJl\u0017N\\3TY>$8OQ1mC:\u001cW\r\u0006\u0004\u0002\u001a\t\u0005&1\u0015\t\t\u00037\t)#!\u000b\u0002,5\u0011\u0011Q\u0004\u0006\u0005\u0003?\t\t#\u0001\u0003eCR\f'BAA\u0012\u0003\u0011\u0019\u0017\r^:\n\t\u0005\u001d\u0012Q\u0004\u0002\b\u001fB$\u0018n\u001c8U!\t!7\u000fE\u0002\u0002.\u0015r1!a\f\t\u001d\u0011\t\t$a\u0012\u000f\t\u0005M\u0012Q\t\b\u0005\u0003k\t\u0019E\u0004\u0003\u00028\u0005\u0005c\u0002BA\u001d\u0003\u007fi!!a\u000f\u000b\u0007\u0005u\u0012*\u0001\u0004=e>|GOP\u0005\u0002\u0011&\u0011aiR\u0005\u0003\t\u0016K!AQ\"\n\u0005\u0001\u000b\u0015!\u0005$mS:\\7\u000b\\8ug\u000eCWmY6feB\u0011Q.C\n\u0003\u0013-#\"!a\u0013\u0003/9{G/\u00128pk\u001eD7\u000b\\8ug\u0016C8-\u001a9uS>t7cB\u0006\u0002V\u0005\u001d\u0014Q\u000e\t\u0005\u0003/\n\tG\u0004\u0003\u0002Z\u0005uc\u0002BA\u001d\u00037J\u0011AT\u0005\u0004\u0003?j\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003G\n)G\u0001\rJY2,w-\u00197Be\u001e,X.\u001a8u\u000bb\u001cW\r\u001d;j_:T1!a\u0018N!\ra\u0015\u0011N\u0005\u0004\u0003Wj%a\u0002)s_\u0012,8\r\u001e\t\u0004\u0019\u0006=\u0014bAA9\u001b\na1+\u001a:jC2L'0\u00192mK\u0006q\u0011M^1jY\u0006\u0014G.Z*m_R\u001cXCAA<!\ra\u0015\u0011P\u0005\u0004\u0003wj%aA%oi\u0006y\u0011M^1jY\u0006\u0014G.Z*m_R\u001c\b%\u0001\u0006u_R\fGn\u00157piN\f1\u0002^8uC2\u001cFn\u001c;tA\u0005a1\u000f\\8ug\n\u000bG.\u00198dKV\u0011\u0011q\u0011\t\u0004\u0003\u0013+S\"A\u0005\u0003\u0019Mcw\u000e^:CC2\fgnY3\u0014\r\u0015Z\u0015qMA7\u0003!\u0011X\r\\3bg\u0016$\u0017!\u0003:fY\u0016\f7/\u001a3!\u0003%\tG\u000e\\8dCR,G-\u0001\u0006bY2|7-\u0019;fI\u0002\"b!a\"\u0002\u001a\u0006m\u0005bBAHU\u0001\u0007\u0011q\u000f\u0005\b\u0003'S\u0003\u0019AA<\u0003\u00151\u0018\r\\;f\u0003\u0011\u0019w\u000e]=\u0015\r\u0005\u001d\u00151UAS\u0011%\ty\t\fI\u0001\u0002\u0004\t9\bC\u0005\u0002\u00142\u0002\n\u00111\u0001\u0002x\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAVU\u0011\t9(!,,\u0005\u0005=\u0006\u0003BAY\u0003wk!!a-\u000b\t\u0005U\u0016qW\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!/N\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003{\u000b\u0019LA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u000b\u0004B!a2\u0002R6\u0011\u0011\u0011\u001a\u0006\u0005\u0003\u0017\fi-\u0001\u0003mC:<'BAAh\u0003\u0011Q\u0017M^1\n\t\u0005M\u0017\u0011\u001a\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111\\Aq!\ra\u0015Q\\\u0005\u0004\u0003?l%aA!os\"I\u00111]\u0019\u0002\u0002\u0003\u0007\u0011qO\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005%\bCBAv\u0003c\fY.\u0004\u0002\u0002n*\u0019\u0011q^'\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002t\u00065(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!?\u0002\u0000B\u0019A*a?\n\u0007\u0005uXJA\u0004C_>dW-\u00198\t\u0013\u0005\r8'!AA\u0002\u0005m\u0017\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005]\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u0015\u0017AB3rk\u0006d7\u000f\u0006\u0003\u0002z\n5\u0001\"CArm\u0005\u0005\t\u0019AAn\u00035\u0019Hn\u001c;t\u0005\u0006d\u0017M\\2fAQA!1\u0003B\u000b\u0005/\u0011I\u0002E\u0002\u0002\n.Aq!a\u001d\u0013\u0001\u0004\t9\bC\u0004\u0002\u0000I\u0001\r!a\u001e\t\u000f\u0005\r%\u00031\u0001\u0002\bRA!1\u0003B\u000f\u0005?\u0011\t\u0003C\u0005\u0002tM\u0001\n\u00111\u0001\u0002x!I\u0011qP\n\u0011\u0002\u0003\u0007\u0011q\u000f\u0005\n\u0003\u0007\u001b\u0002\u0013!a\u0001\u0003\u000f\u000babY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0003()\"\u0011qQAW)\u0011\tYNa\u000b\t\u0013\u0005\r\u0018$!AA\u0002\u0005]D\u0003BA}\u0005_A\u0011\"a9\u001c\u0003\u0003\u0005\r!a7\u0015\t\u0005e(1\u0007\u0005\n\u0003Gl\u0012\u0011!a\u0001\u00037\fqCT8u\u000b:|Wo\u001a5TY>$8/\u0012=dKB$\u0018n\u001c8\u0011\u0007\u0005%ud\u0005\u0003 \u0017\u00065DC\u0001B\u001c\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\u0011\u0019B!\u0011\u0003X!9!1I\u0011A\u0002\t\u0015\u0013aD2mkN$XM](wKJ4\u0018.Z<\u0011\t\t\u001d#\u0011\u000b\b\u0005\u0005\u0013\u0012iE\u0004\u0003\u00020\t-\u0013BA0@\u0013\r\u0011yEX\u0001\u000fM2Lgn\u001b*fgRlu\u000eZ3m\u0013\u0011\u0011\u0019F!\u0016\u0003\u001f\rcWo\u001d;fe>3XM\u001d<jK^T1Aa\u0014_\u0011\u001d\t\u0019)\ta\u0001\u0003\u000f#\u0002Ba\u0005\u0003\\\tu#q\f\u0005\b\u0003g\u0012\u0003\u0019AA<\u0011\u001d\tyH\ta\u0001\u0003oBq!a!#\u0001\u0004\t9)A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t\u0015$Q\u000e\t\u0006\u0019\u0006-!q\r\t\n\u0019\n%\u0014qOA<\u0003\u000fK1Aa\u001bN\u0005\u0019!V\u000f\u001d7fg!I!qN\u0012\u0002\u0002\u0003\u0007!1C\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!\u001e\u0011\t\u0005\u001d'qO\u0005\u0005\u0005s\nIM\u0001\u0004PE*,7\r^\u0001\r'2|Go\u001d\"bY\u0006t7-\u001a\t\u0004\u0003\u0013C4#\u0002\u001d\u0003\u0002\u00065\u0004C\u0003BB\u0005\u0013\u000b9(a\u001e\u0002\b6\u0011!Q\u0011\u0006\u0004\u0005\u000fk\u0015a\u0002:v]RLW.Z\u0005\u0005\u0005\u0017\u0013)IA\tBEN$(/Y2u\rVt7\r^5p]J\"\"A! \u0015\r\u0005\u001d%\u0011\u0013BJ\u0011\u001d\tyi\u000fa\u0001\u0003oBq!a%<\u0001\u0004\t9\b\u0006\u0003\u0003\u0018\n}\u0005#\u0002'\u0002\f\te\u0005c\u0002'\u0003\u001c\u0006]\u0014qO\u0005\u0004\u0005;k%A\u0002+va2,'\u0007C\u0005\u0003pq\n\t\u00111\u0001\u0002\b\")\u00110\u0002a\u0001u\"9\u0011qA\u0003A\u0002\u0005%\u0011!J:m_R\u001cH\u000b[1u/&dGNQ3SK2,\u0017m]3e\u0003\u001a$XM\u001d&pE\u000e\u000bgnY3m)\u0011\u0011IKa+\u0011\t\u0011\u001c\u0018q\u000f\u0005\b\u0003\u000f1\u0001\u0019AA\u0005\u0003!\u001aHn\u001c;t\u00032dwnY1uK\u0012\u0014\u0015\u0010\u0015:pG\u0016\u001c8\u000f\u00165bi^KGNQ3EKBdw._3e)\u0019\u0011IK!-\u0003>\"9!1W\u0004A\u0002\tU\u0016AB:ue\u0016\fW\u000e\u0005\u0003\u00038\neV\"\u0001@\n\u0007\tmfP\u0001\bTiJ,\u0017-\\'fi\u0006$\u0015\r^1\t\u000f\t}v\u00011\u0001\u0003B\u0006I\u0001O]8dKN\u001c\u0018\n\u001a\t\u0005\u0005\u0007\u0014YM\u0004\u0003\u0003F\n\u001d\u0007cAA\u001d\u001b&\u0019!\u0011Z'\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019N!4\u000b\u0007\t%W\n")
public class FlinkSlotsChecker
implements LazyLogging {
    private final HttpFlinkClient client;
    private final ExecutionContext ec;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        FlinkSlotsChecker flinkSlotsChecker = this;
        synchronized (flinkSlotsChecker) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public Future<BoxedUnit> checkRequiredSlotsExceedAvailableSlots(ProcessDeploymentData processDeploymentData, Option<ExternalDeploymentId> currentlyDeployedJobId) {
        OptionT collectedSlotsCheckInputs = this.determineSlotsBalance(processDeploymentData, currentlyDeployedJobId).flatMap((Function1 & Serializable & scala.Serializable)slotsBalance -> new OptionT((Object)$this.client.getClusterOverview().map((Function1 & Serializable & scala.Serializable)x$1 -> Option$.MODULE$.apply(x$1), $this.ec)).map((Function1 & Serializable & scala.Serializable)clusterOverview -> new Tuple2(slotsBalance, clusterOverview), (Functor)implicits$.MODULE$.catsStdInstancesForFuture($this.ec)), (Monad)implicits$.MODULE$.catsStdInstancesForFuture(this.ec));
        OptionT checkResult = new OptionT((Object)((Future)collectedSlotsCheckInputs.value()).recover((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkSlotsChecker $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Option option = NonFatal$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    BoxedUnit boxedUnit;
                    Throwable ex = (Throwable)option.get();
                    if (this.$outer.logger().underlying().isWarnEnabled()) {
                        this.$outer.logger().underlying().warn("Error during collecting inputs needed for available slots checking. Slots checking will be omitted", ex);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = None$.MODULE$;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                Option option = NonFatal$.MODULE$.unapply(throwable);
                boolean bl = !option.isEmpty();
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.ec)).map((Function1 & Serializable & scala.Serializable)collectedInputs -> {
            Tuple2 tuple2 = collectedInputs;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SlotsBalance slotsBalance = (SlotsBalance)tuple2._1();
            flinkRestModel.ClusterOverview clusterOverview = (flinkRestModel.ClusterOverview)tuple2._2();
            Tuple3 tuple3 = new Tuple3((Object)tuple2, (Object)slotsBalance, (Object)clusterOverview);
            Tuple3 tuple32 = tuple3;
            Tuple2 x$2 = (Tuple2)tuple32._1();
            SlotsBalance slotsBalance2 = (SlotsBalance)tuple32._2();
            flinkRestModel.ClusterOverview clusterOverview2 = (flinkRestModel.ClusterOverview)tuple32._3();
            return new Tuple2(collectedInputs, (Object)x$2);
        }, (Functor)implicits$.MODULE$.catsStdInstancesForFuture(this.ec)).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$4;
            if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
                throw new MatchError((Object)tuple22);
            }
            SlotsBalance slotsBalance = (SlotsBalance)tuple2._1();
            flinkRestModel.ClusterOverview clusterOverview = (flinkRestModel.ClusterOverview)tuple2._2();
            OptionT optionT = new OptionT((Object)(slotsBalance.value() > clusterOverview.slots$minusavailable() ? Future$.MODULE$.failed((Throwable)FlinkSlotsChecker$NotEnoughSlotsException$.MODULE$.apply(clusterOverview, slotsBalance)) : Future$.MODULE$.successful((Object)Option$.MODULE$.apply((Object)BoxedUnit.UNIT)))).map((Function1 & Serializable & scala.Serializable)_ -> {
                FlinkSlotsChecker.$anonfun$checkRequiredSlotsExceedAvailableSlots$6(_);
                return BoxedUnit.UNIT;
            }, (Functor)implicits$.MODULE$.catsStdInstancesForFuture($this.ec));
            return optionT;
        }, (Monad)implicits$.MODULE$.catsStdInstancesForFuture(this.ec));
        return ((Future)checkResult.value()).map((Function1 & Serializable & scala.Serializable)x$5 -> {
            FlinkSlotsChecker.$anonfun$checkRequiredSlotsExceedAvailableSlots$7(x$5);
            return BoxedUnit.UNIT;
        }, this.ec);
    }

    private OptionT<Future, SlotsBalance> determineSlotsBalance(ProcessDeploymentData processDeploymentData, Option<ExternalDeploymentId> currentlyDeployedJobId) {
        OptionT optionT;
        ProcessDeploymentData processDeploymentData2 = processDeploymentData;
        if (processDeploymentData2 instanceof GraphProcess) {
            OptionT optionT2;
            GraphProcess graphProcess = (GraphProcess)processDeploymentData2;
            String processAsJson = graphProcess.processAsJson();
            CanonicalProcess process = (CanonicalProcess)ProcessMarshaller$.MODULE$.fromJson(processAsJson).valueOr((Function1 & Serializable & scala.Serializable)err -> {
                throw new IllegalArgumentException(err.msg());
            });
            TypeSpecificData typeSpecificData = process.metaData().typeSpecificData();
            if (typeSpecificData instanceof StreamMetaData) {
                StreamMetaData streamMetaData = (StreamMetaData)typeSpecificData;
                Future requiredSlotsFuture = this.slotsThatWillBeReleasedAfterJobCancel(currentlyDeployedJobId).flatMap((Function1 & Serializable & scala.Serializable)releasedSlots -> FlinkSlotsChecker.$anonfun$determineSlotsBalance$2(this, streamMetaData, process, BoxesRunTime.unboxToInt((Object)releasedSlots)), this.ec);
                optionT2 = new OptionT((Object)requiredSlotsFuture);
            } else {
                optionT2 = OptionT$.MODULE$.none((Applicative)implicits$.MODULE$.catsStdInstancesForFuture(this.ec));
            }
            optionT = optionT2;
        } else if (processDeploymentData2 instanceof CustomProcess) {
            optionT = OptionT$.MODULE$.none((Applicative)implicits$.MODULE$.catsStdInstancesForFuture(this.ec));
        } else {
            throw new MatchError((Object)processDeploymentData2);
        }
        return optionT;
    }

    private Future<Object> slotsThatWillBeReleasedAfterJobCancel(Option<ExternalDeploymentId> currentlyDeployedJobId) {
        return (Future)currentlyDeployedJobId.map((Function1 & Serializable & scala.Serializable)deploymentId -> FlinkSlotsChecker.$anonfun$slotsThatWillBeReleasedAfterJobCancel$1(this, ((ExternalDeploymentId)deploymentId).value())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Future$.MODULE$.successful((Object)BoxesRunTime.boxToInteger((int)0)));
    }

    private Future<Object> slotsAllocatedByProcessThatWilBeDeployed(StreamMetaData stream, String processId) {
        return (Future)stream.parallelism().map((Function1 & Serializable & scala.Serializable)definedParallelism -> Future$.MODULE$.successful((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)definedParallelism)))).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.client.getJobManagerConfig().map((Function1 & Serializable & scala.Serializable)config -> BoxesRunTime.boxToInteger((int)FlinkSlotsChecker.$anonfun$slotsAllocatedByProcessThatWilBeDeployed$3(this, processId, config)), $this.ec));
    }

    public static final /* synthetic */ void $anonfun$checkRequiredSlotsExceedAvailableSlots$6(BoxedUnit _) {
    }

    public static final /* synthetic */ void $anonfun$checkRequiredSlotsExceedAvailableSlots$7(Option x$5) {
    }

    public static final /* synthetic */ Future $anonfun$determineSlotsBalance$2(FlinkSlotsChecker $this, StreamMetaData x2$1, CanonicalProcess process$1, int releasedSlots) {
        return $this.slotsAllocatedByProcessThatWilBeDeployed(x2$1, process$1.metaData().id()).map((Function1 & Serializable & scala.Serializable)allocatedSlots -> Option$.MODULE$.apply((Object)new SlotsBalance(releasedSlots, BoxesRunTime.unboxToInt((Object)allocatedSlots))), $this.ec);
    }

    public static final /* synthetic */ Future $anonfun$slotsThatWillBeReleasedAfterJobCancel$1(FlinkSlotsChecker $this, String deploymentId) {
        return $this.client.getJobConfig(deploymentId).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.job$minusparallelism()), $this.ec);
    }

    public static final /* synthetic */ int $anonfun$slotsAllocatedByProcessThatWilBeDeployed$3(FlinkSlotsChecker $this, String processId$1, Configuration config) {
        BoxedUnit boxedUnit;
        Integer defaultParallelism = (Integer)config.get(CoreOptions.DEFAULT_PARALLELISM);
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("Not specified parallelism for process: {}, will be used default configured on jobmanager: {}", new Object[]{processId$1, defaultParallelism});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Predef$.MODULE$.Integer2int(defaultParallelism);
    }

    public FlinkSlotsChecker(HttpFlinkClient client, ExecutionContext ec) {
        this.client = client;
        this.ec = ec;
        LazyLogging.$init$((LazyLogging)this);
    }

    public static class NotEnoughSlotsException
    extends IllegalArgumentException
    implements Product,
    scala.Serializable {
        private final int availableSlots;
        private final int totalSlots;
        private final SlotsBalance slotsBalance;

        public int availableSlots() {
            return this.availableSlots;
        }

        public int totalSlots() {
            return this.totalSlots;
        }

        public SlotsBalance slotsBalance() {
            return this.slotsBalance;
        }

        public NotEnoughSlotsException copy(int availableSlots, int totalSlots, SlotsBalance slotsBalance) {
            return new NotEnoughSlotsException(availableSlots, totalSlots, slotsBalance);
        }

        public int copy$default$1() {
            return this.availableSlots();
        }

        public int copy$default$2() {
            return this.totalSlots();
        }

        public SlotsBalance copy$default$3() {
            return this.slotsBalance();
        }

        public String productPrefix() {
            return "NotEnoughSlotsException";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToInteger((int)this.availableSlots());
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this.totalSlots());
                    break;
                }
                case 2: {
                    object = this.slotsBalance();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof NotEnoughSlotsException;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.availableSlots());
            n = Statics.mix((int)n, (int)this.totalSlots());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.slotsBalance()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof NotEnoughSlotsException)) return false;
            boolean bl = true;
            if (!bl) return false;
            NotEnoughSlotsException notEnoughSlotsException = (NotEnoughSlotsException)x$1;
            if (this.availableSlots() != notEnoughSlotsException.availableSlots()) return false;
            if (this.totalSlots() != notEnoughSlotsException.totalSlots()) return false;
            SlotsBalance slotsBalance = this.slotsBalance();
            SlotsBalance slotsBalance2 = notEnoughSlotsException.slotsBalance();
            if (slotsBalance == null) {
                if (slotsBalance2 != null) {
                    return false;
                }
            } else if (!((Object)slotsBalance).equals(slotsBalance2)) return false;
            if (!notEnoughSlotsException.canEqual(this)) return false;
            return true;
        }

        public NotEnoughSlotsException(int availableSlots, int totalSlots, SlotsBalance slotsBalance) {
            this.availableSlots = availableSlots;
            this.totalSlots = totalSlots;
            this.slotsBalance = slotsBalance;
            super(new StringBuilder(72).append("Not enough free slots on Flink cluster. Available slots: ").append(availableSlots).append(", requested: ").append(Math.max(0, slotsBalance.value())).append(". ").append((Object)(slotsBalance.allocated() > 1 ? "Decrease scenario's parallelism or extend Flink cluster resources" : "Extend resources of Flink cluster resources")).toString());
            Product.$init$((Product)this);
        }
    }

    public static class SlotsBalance
    implements Product,
    scala.Serializable {
        private final int released;
        private final int allocated;

        public int released() {
            return this.released;
        }

        public int allocated() {
            return this.allocated;
        }

        public int value() {
            return this.allocated() - this.released();
        }

        public SlotsBalance copy(int released, int allocated) {
            return new SlotsBalance(released, allocated);
        }

        public int copy$default$1() {
            return this.released();
        }

        public int copy$default$2() {
            return this.allocated();
        }

        public String productPrefix() {
            return "SlotsBalance";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Integer n;
            int n2 = x$1;
            switch (n2) {
                case 0: {
                    n = BoxesRunTime.boxToInteger((int)this.released());
                    break;
                }
                case 1: {
                    n = BoxesRunTime.boxToInteger((int)this.allocated());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return n;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SlotsBalance;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.released());
            n = Statics.mix((int)n, (int)this.allocated());
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SlotsBalance)) return false;
            boolean bl = true;
            if (!bl) return false;
            SlotsBalance slotsBalance = (SlotsBalance)x$1;
            if (this.released() != slotsBalance.released()) return false;
            if (this.allocated() != slotsBalance.allocated()) return false;
            if (!slotsBalance.canEqual(this)) return false;
            return true;
        }

        public SlotsBalance(int released, int allocated) {
            this.released = released;
            this.allocated = allocated;
            Product.$init$((Product)this);
        }
    }
}

