/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.management.rest;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.circe.Decoder$;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import org.apache.flink.configuration.Configuration;
import pl.touk.nussknacker.engine.api.CirceUtil$;
import pl.touk.nussknacker.engine.api.deployment.ExternalDeploymentId;
import pl.touk.nussknacker.engine.api.deployment.SavepointResult;
import pl.touk.nussknacker.engine.management.FlinkArgsEncodeHack$;
import pl.touk.nussknacker.engine.management.FlinkConfig;
import pl.touk.nussknacker.engine.management.rest.FlinkClient;
import pl.touk.nussknacker.engine.management.rest.FlinkClientError;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$ClusterOverview$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$DeployProcessRequest$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$FlinkError$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$GetSavepointStatusResponse$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$JarsResponse$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$JobConfig$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$JobsResponse$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$KeyValueEntry$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$RunResponse$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$SavepointTriggerRequest$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$SavepointTriggerResponse$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$StopRequest$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$UploadJarResponse$;
import pl.touk.nussknacker.engine.sttp.SttpJson$;
import pl.touk.nussknacker.engine.util.exception.DeeplyCheckingExceptionExtractor;
import pl.touk.nussknacker.engine.util.exception.DeeplyCheckingExceptionExtractor$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sttp.client.HttpError;
import sttp.client.IsOption$;
import sttp.client.RequestT;
import sttp.client.Response;
import sttp.client.SttpBackend;
import sttp.client.circe.package$;
import sttp.model.Part;
import sttp.model.StatusCode;
import sttp.model.StatusCode$;
import sttp.model.Uri;

@ScalaSignature(bytes="\u0006\u0001\tUg\u0001\u0002\u000f\u001e\u0001)B\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\t\t\u0002\u0011\t\u0011)A\u0006\u000b\"AA\r\u0001B\u0001B\u0003-Q\rC\u0003i\u0001\u0011\u0005\u0011\u000eC\u0004p\u0001\t\u0007I\u0011\u00029\t\r]\u0004\u0001\u0015!\u0003r\u0011\u0015A\b\u0001\"\u0001z\u0011\u001d\t\t\u0004\u0001C\u0005\u0003gAq!!\u0015\u0001\t\u0003\t\u0019\u0006C\u0004\u0002Z\u0001!\t%a\u0017\t\u000f\u0005%\u0004\u0001\"\u0003\u0002l!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005M\u0004bBAI\u0001\u0011\u0005\u00111\u0013\u0005\b\u0003G\u0003A\u0011AAS\u0011%\ty\rAI\u0001\n\u0003\t\t\u000eC\u0004\u0002h\u0002!\t!!;\t\u000f\u0005=\b\u0001\"\u0001\u0002r\"9\u00111 \u0001\u0005\u0002\u0005u\bb\u0002B\u0002\u0001\u0011%!Q\u0001\u0005\n\u0005G\u0001!\u0019!C\u0005\u0005KA\u0001Ba\u0011\u0001A\u0003%!q\u0005\u0005\b\u0005\u000b\u0002A\u0011\u0001B$\u0011\u001d\u0011i\u0006\u0001C\u0001\u0005?BqA!\u001b\u0001\t\u0003\u0011Y\u0007C\u0004\u0003\b\u0002!IA!#\t\u000f\te\u0005\u0001\"\u0003\u0003\u001c\"9!q\u0016\u0001\u0005\n\tE&a\u0004%uiB4E.\u001b8l\u00072LWM\u001c;\u000b\u0005yy\u0012\u0001\u0002:fgRT!\u0001I\u0011\u0002\u00155\fg.Y4f[\u0016tGO\u0003\u0002#G\u00051QM\\4j]\u0016T!\u0001J\u0013\u0002\u00179,8o]6oC\u000e\\WM\u001d\u0006\u0003M\u001d\nA\u0001^8vW*\t\u0001&\u0001\u0002qY\u000e\u00011\u0003\u0002\u0001,cU\u0002\"\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\u0012a!\u00118z%\u00164\u0007C\u0001\u001a4\u001b\u0005i\u0012B\u0001\u001b\u001e\u0005-1E.\u001b8l\u00072LWM\u001c;\u0011\u0005YjT\"A\u001c\u000b\u0005aJ\u0014\u0001D:dC2\fGn\\4hS:<'B\u0001\u001e<\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001\u001f\u0002\u0007\r|W.\u0003\u0002?o\tYA*\u0019>z\u0019><w-\u001b8h\u0003\u0019\u0019wN\u001c4jOB\u0011\u0011IQ\u0007\u0002?%\u00111i\b\u0002\f\r2Lgn[\"p]\u001aLw-A\u0004cC\u000e\\WM\u001c3\u0011\u000b\u0019[Uj\u0015,\u000e\u0003\u001dS!\u0001S%\u0002\r\rd\u0017.\u001a8u\u0015\u0005Q\u0015\u0001B:uiBL!\u0001T$\u0003\u0017M#H\u000f\u001d\"bG.,g\u000e\u001a\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!6\n!bY8oGV\u0014(/\u001a8u\u0013\t\u0011vJ\u0001\u0004GkR,(/\u001a\t\u0003YQK!!V\u0017\u0003\u000f9{G\u000f[5oOB\u0011q+\u0019\b\u00031~s!!\u00170\u000f\u0005ikV\"A.\u000b\u0005qK\u0013A\u0002\u001fs_>$h(C\u0001K\u0013\tA\u0015*\u0003\u0002a\u000f\u00069\u0001/Y2lC\u001e,\u0017B\u00012d\u0005!qu\u000e\u001e5j]\u001e$&B\u00011H\u0003\t)7\r\u0005\u0002OM&\u0011qm\u0014\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\fa\u0001P5oSRtDC\u00016o)\rYG.\u001c\t\u0003e\u0001AQ\u0001\u0012\u0003A\u0004\u0015CQ\u0001\u001a\u0003A\u0004\u0015DQa\u0010\u0003A\u0002\u0001\u000b\u0001B\u001a7j].,&\u000f\\\u000b\u0002cB\u0011!/^\u0007\u0002g*\u0011A/S\u0001\u0006[>$W\r\\\u0005\u0003mN\u00141!\u0016:j\u0003%1G.\u001b8l+Jd\u0007%\u0001\rva2|\u0017\r\u001a&be\u001aKG.Z%g\u001d>$X\t_5tiN$2A_A\u000f!\rq\u0015k\u001f\t\u0004y\u0006]abA?\u0002\u00149\u0019a0!\u0005\u000f\u0007}\fyA\u0004\u0003\u0002\u0002\u00055a\u0002BA\u0002\u0003\u0017qA!!\u0002\u0002\n9\u0019!,a\u0002\n\u0003!J!AJ\u0014\n\u0005\u0011*\u0013B\u0001\u0012$\u0013\t\u0001\u0013%\u0003\u0002\u001f?%\u0019\u0011QC\u000f\u0002\u001d\u0019d\u0017N\\6SKN$Xj\u001c3fY&!\u0011\u0011DA\u000e\u0005\u001dQ\u0015M\u001d$jY\u0016T1!!\u0006\u001e\u0011\u001d\tyb\u0002a\u0001\u0003C\tqA[1s\r&dW\r\u0005\u0003\u0002$\u00055RBAA\u0013\u0015\u0011\t9#!\u000b\u0002\u0005%|'BAA\u0016\u0003\u0011Q\u0017M^1\n\t\u0005=\u0012Q\u0005\u0002\u0005\r&dW-\u0001\u000edQ\u0016\u001c7\u000e\u00165bi*\u000b'oV5uQ:\u000bW.Z#ySN$8\u000f\u0006\u0003\u00026\u0005u\u0002\u0003\u0002(R\u0003o\u0001B\u0001LA\u001dw&\u0019\u00111H\u0017\u0003\r=\u0003H/[8o\u0011\u001d\ty\u0004\u0003a\u0001\u0003\u0003\nqA[1s\u001d\u0006lW\r\u0005\u0003\u0002D\u0005-c\u0002BA#\u0003\u000f\u0002\"AW\u0017\n\u0007\u0005%S&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001b\nyE\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0013j\u0013!C;qY>\fGMS1s)\u0011\t)&a\u0016\u0011\t9\u000b\u0016\u0011\t\u0005\b\u0003?I\u0001\u0019AA\u0011\u0003E!W\r\\3uK*\u000b'/\u00134Fq&\u001cHo\u001d\u000b\u0005\u0003;\n)\u0007\u0005\u0003O#\u0006}\u0003c\u0001\u0017\u0002b%\u0019\u00111M\u0017\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003OR\u0001\u0019AA!\u0003-Q\u0017M\u001d$jY\u0016t\u0015-\\3\u0002\u0013\u0011,G.\u001a;f\u0015\u0006\u0014H\u0003BA/\u0003[Bq!a\u001c\f\u0001\u0004\t\t%A\u0003kCJLE-\u0001\bgS:$'j\u001c2t\u0005ft\u0015-\\3\u0015\t\u0005U\u0014Q\u0012\t\u0005\u001dF\u000b9\b\u0005\u0004\u0002z\u0005\u0005\u0015q\u0011\b\u0005\u0003w\nyHD\u0002[\u0003{J\u0011AL\u0005\u0003A6JA!a!\u0002\u0006\n!A*[:u\u0015\t\u0001W\u0006E\u0002}\u0003\u0013KA!a#\u0002\u001c\tY!j\u001c2Pm\u0016\u0014h/[3x\u0011\u001d\ty\t\u0004a\u0001\u0003\u0003\nqA[8c\u001d\u0006lW-\u0001\u0007hKRTuNY\"p]\u001aLw\r\u0006\u0003\u0002\u0016\u0006}\u0005\u0003\u0002(R\u0003/\u0003B!!'\u0002\u001c:\u0019!'a\u0005\n\t\u0005u\u00151\u0004\u0002\u0010\u000bb,7-\u001e;j_:\u001cuN\u001c4jO\"9\u0011\u0011U\u0007A\u0002\u0005\u0005\u0013!\u00026pE&#\u0017\u0001E<bSR4uN]*bm\u0016\u0004x.\u001b8u)!\t9+!/\u0002B\u0006\u0015\u0007\u0003\u0002(R\u0003S\u0003B!a+\u000266\u0011\u0011Q\u0016\u0006\u0005\u0003_\u000b\t,\u0001\u0006eKBdw._7f]RT1!a-\"\u0003\r\t\u0007/[\u0005\u0005\u0003o\u000biKA\bTCZ,\u0007o\\5oiJ+7/\u001e7u\u0011\u001d\t\tK\u0004a\u0001\u0003w\u0003B!a+\u0002>&!\u0011qXAW\u0005Q)\u0005\u0010^3s]\u0006dG)\u001a9m_flWM\u001c;JI\"9\u00111\u0019\bA\u0002\u0005\u0005\u0013aC:bm\u0016\u0004x.\u001b8u\u0013\u0012D\u0011\"a2\u000f!\u0003\u0005\r!!3\u0002\u0017QLW.Z8vi2+g\r\u001e\t\u0004Y\u0005-\u0017bAAg[\t!Aj\u001c8h\u0003i9\u0018-\u001b;G_J\u001c\u0016M^3q_&tG\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t\u0019N\u000b\u0003\u0002J\u0006U7FAAl!\u0011\tI.a9\u000e\u0005\u0005m'\u0002BAo\u0003?\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005X&\u0001\u0006b]:|G/\u0019;j_:LA!!:\u0002\\\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\r\r\fgnY3m)\u0011\ti&a;\t\u000f\u00055\b\u00031\u0001\u0002<\u0006aA-\u001a9m_flWM\u001c;JI\u0006iQ.Y6f'\u00064X\r]8j]R$b!a*\u0002t\u0006U\bbBAw#\u0001\u0007\u00111\u0018\u0005\b\u0003o\f\u0002\u0019AA}\u00031\u0019\u0018M^3q_&tG\u000fR5s!\u0015a\u0013\u0011HA!\u0003\u0011\u0019Ho\u001c9\u0015\r\u0005\u001d\u0016q B\u0001\u0011\u001d\tiO\u0005a\u0001\u0003wCq!a>\u0013\u0001\u0004\tI0A\fqe>\u001cWm]:TCZ,\u0007o\\5oiJ+\u0017/^3tiRA\u0011q\u0015B\u0004\u0005\u0013\u0011y\u0002C\u0004\u0002nN\u0001\r!a/\t\u000f\t-1\u00031\u0001\u0003\u000e\u00059!/Z9vKN$\b\u0003\u0003$\u0003\u0010\tM!\u0011D*\n\u0007\tEqI\u0001\u0005SKF,Xm\u001d;U!\r9&QC\u0005\u0004\u0005/\u0019'\u0001C%eK:$\u0018\u000e^=\u0011\u0011\u0005e$1DA!\u0003\u0003JAA!\b\u0002\u0006\n1Q)\u001b;iKJDqA!\t\u0014\u0001\u0004\t\t%\u0001\u0004bGRLwN\\\u0001\u0011i&lWm\\;u\u000bb$(/Y2u_J,\"Aa\n\u0011\r\t%\"1\u0007B\u001c\u001b\t\u0011YC\u0003\u0003\u0003.\t=\u0012!C3yG\u0016\u0004H/[8o\u0015\r\u0011\t$I\u0001\u0005kRLG.\u0003\u0003\u00036\t-\"\u0001\t#fKBd\u0017p\u00115fG.LgnZ#yG\u0016\u0004H/[8o\u000bb$(/Y2u_J\u0004BA!\u000f\u0003@5\u0011!1\b\u0006\u0004!\nu\"\u0002\u0002B\u0019\u0003SIAA!\u0011\u0003<\t\u0001B+[7f_V$X\t_2faRLwN\\\u0001\u0012i&lWm\\;u\u000bb$(/Y2u_J\u0004\u0013A\u0003:v]B\u0013xn\u001a:b[RQ!\u0011\nB'\u0005\u001f\u0012\u0019F!\u0017\u0011\t9\u000b&1\n\t\u0006Y\u0005e\u00121\u0018\u0005\b\u0003?1\u0002\u0019AA\u0011\u0011\u001d\u0011\tF\u0006a\u0001\u0003\u0003\n\u0011\"\\1j]\u000ec\u0017m]:\t\u000f\tUc\u00031\u0001\u0003X\u0005!\u0011M]4t!\u0019\tI(!!\u0002B!9!1\f\fA\u0002\u0005e\u0018!D:bm\u0016\u0004x.\u001b8u!\u0006$\b.\u0001\nhKR\u001cE.^:uKJ|e/\u001a:wS\u0016<XC\u0001B1!\u0011q\u0015Ka\u0019\u0011\u0007q\u0014)'\u0003\u0003\u0003h\u0005m!aD\"mkN$XM](wKJ4\u0018.Z<\u0002'\u001d,GOS8c\u001b\u0006t\u0017mZ3s\u0007>tg-[4\u0016\u0005\t5\u0004\u0003\u0002(R\u0005_\u0002BA!\u001d\u0003\u00046\u0011!1\u000f\u0006\u0005\u0005k\u00129(A\u0007d_:4\u0017nZ;sCRLwN\u001c\u0006\u0005\u0005s\u0012Y(A\u0003gY&t7N\u0003\u0003\u0003~\t}\u0014AB1qC\u000eDWM\u0003\u0002\u0003\u0002\u0006\u0019qN]4\n\t\t\u0015%1\u000f\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002%!\fg\u000e\u001a7f+:LGOU3ta>t7/\u001a\u000b\u0005\u0005\u0017\u00139\n\u0006\u0003\u0002^\t5\u0005b\u0002BH3\u0001\u0007!\u0011S\u0001\te\u0016\u001c\bo\u001c8tKB)aIa%\u0003\u001a%\u0019!QS$\u0003\u0011I+7\u000f]8og\u0016DqA!\t\u001a\u0001\u0004\t\t%A\tiC:$G.Z\"mS\u0016tG/\u0012:s_J$\u0002B!(\u0003 \n\r&Q\u0016\t\u0004\u001dF\u001b\u0006b\u0002BQ5\u0001\u0007\u0011\u0011I\u0001\u0005E>$\u0017\u0010C\u0004\u0003&j\u0001\rAa*\u0002\rM$\u0018\r^;t!\r\u0011(\u0011V\u0005\u0004\u0005W\u001b(AC*uCR,8oQ8eK\"9!\u0011\u0005\u000eA\u0002\u0005\u0005\u0013A\u0005:fG>4XM],ji\"lUm]:bO\u0016,BAa-\u0003HR!!Q\u0017Bj!\u001da#q\u0017B^\u0005\u0003L1A!/.\u0005=\u0001\u0016M\u001d;jC24UO\\2uS>t\u0007\u0003BA=\u0005{KAAa0\u0002\u0006\nIA\u000b\u001b:po\u0006\u0014G.\u001a\t\u0005\u001dF\u0013\u0019\r\u0005\u0003\u0003F\n\u001dG\u0002\u0001\u0003\b\u0005\u0013\\\"\u0019\u0001Bf\u0005\u0005!\u0016cA*\u0003NB\u0019AFa4\n\u0007\tEWFA\u0002B]fDqA!\t\u001c\u0001\u0004\t\t\u0005")
public class HttpFlinkClient
implements FlinkClient,
LazyLogging {
    private final FlinkConfig config;
    private final SttpBackend<Future, Nothing$, Nothing$> backend;
    private final ExecutionContext ec;
    private final Uri flinkUrl;
    private final DeeplyCheckingExceptionExtractor<TimeoutException> pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        HttpFlinkClient httpFlinkClient = this;
        synchronized (httpFlinkClient) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private Uri flinkUrl() {
        return this.flinkUrl;
    }

    public Future<flinkRestModel.JarFile> uploadJarFileIfNotExists(File jarFile) {
        return this.checkThatJarWithNameExists(jarFile.getName()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                flinkRestModel.JarFile file = (flinkRestModel.JarFile)some.value();
                future = Future$.MODULE$.successful((Object)file);
            } else if (None$.MODULE$.equals(option)) {
                future = this.uploadJar(jarFile).map((Function1 & Serializable & scala.Serializable)id -> new flinkRestModel.JarFile((String)id, jarFile.getName()), $this.ec);
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, this.ec);
    }

    private Future<Option<flinkRestModel.JarFile>> checkThatJarWithNameExists(String jarName) {
        return ((Future)sttp.client.package$.MODULE$.basicRequest().get(this.flinkUrl().path("jars")).response(package$.MODULE$.asJson(flinkRestModel$JarsResponse$.MODULE$.decodeJarsResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).map((Function1 & Serializable & scala.Serializable)x$1 -> ((LinearSeqOptimized)x$1.files().toList().flatten((Function1)Predef$.MODULE$.$conforms())).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HttpFlinkClient.$anonfun$checkThatJarWithNameExists$3(jarName, x$2))), this.ec);
    }

    public Future<String> uploadJar(File jarFile) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Uploading new jar: {}", new Object[]{jarFile.getAbsolutePath()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return ((Future)sttp.client.package$.MODULE$.basicRequest().post(this.flinkUrl().path("jars", "upload", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).multipartBody(sttp.client.package$.MODULE$.multipartFile("jarfile", jarFile).contentType("application/x-java-archive"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Part[0])).response(package$.MODULE$.asJson(flinkRestModel$UploadJarResponse$.MODULE$.decodeUploadJarResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).map((Function1 & Serializable & scala.Serializable)file -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Uploaded jar to {}", new Object[]{file});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return new File(file.filename()).getName();
        }, this.ec).recoverWith(this.recoverWithMessage("upload Nussnknacker jar to Flink"), this.ec);
    }

    @Override
    public Future<BoxedUnit> deleteJarIfExists(String jarFileName) {
        return this.checkThatJarWithNameExists(jarFileName).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                flinkRestModel.JarFile file = (flinkRestModel.JarFile)some.value();
                future = this.deleteJar(file.id()).recover((PartialFunction)new scala.Serializable(this, jarFileName){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HttpFlinkClient $outer;
                    private final String jarFileName$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        BoxedUnit boxedUnit;
                        A1 A1 = x1;
                        if (this.$outer.logger().underlying().isWarnEnabled()) {
                            this.$outer.logger().underlying().warn(new StringBuilder(22).append("Failed to delete jar: ").append(this.jarFileName$1).toString(), A1);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        return (B1)boxedUnit2;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        boolean bl = true;
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.jarFileName$1 = jarFileName$1;
                    }
                }, $this.ec);
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("{} does not exist, not removing", new Object[]{jarFileName});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, this.ec);
    }

    private Future<BoxedUnit> deleteJar(String jarId) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Delete jar id: {}", new Object[]{jarId});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return ((Future)sttp.client.package$.MODULE$.basicRequest().delete(this.flinkUrl().path("jars", jarId, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> this.handleUnitResponse("delete jar", (Response<Either<String, String>>)response), this.ec).recoverWith(this.recoverWithMessage("delete jar"), this.ec);
    }

    @Override
    public Future<List<flinkRestModel.JobOverview>> findJobsByName(String jobName) {
        return ((Future)sttp.client.package$.MODULE$.basicRequest().get(this.flinkUrl().path("jobs", "overview", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).response(package$.MODULE$.asJson(flinkRestModel$JobsResponse$.MODULE$.decodeJobsResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).map((Function1 & Serializable & scala.Serializable)jobs -> ((List)((SeqLike)jobs.jobs().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)HttpFlinkClient.$anonfun$findJobsByName$3(jobName, x$3)))).sortBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.last$minusmodification()), (Ordering)Ordering.Long$.MODULE$)).reverse(), this.ec).recoverWith(this.recoverWithMessage("retrieve Flink jobs"), this.ec);
    }

    @Override
    public Future<flinkRestModel.ExecutionConfig> getJobConfig(String jobId) {
        return ((Future)sttp.client.package$.MODULE$.basicRequest().get(this.flinkUrl().path("jobs", jobId, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"config"}))).response(package$.MODULE$.asJson(flinkRestModel$JobConfig$.MODULE$.decodeJobConfig(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.execution$minusconfig(), this.ec);
    }

    public Future<SavepointResult> waitForSavepoint(String jobId, String savepointId, long timeoutLeft) {
        long start = System.currentTimeMillis();
        if (timeoutLeft <= 0L) {
            return Future$.MODULE$.failed((Throwable)new Exception(new StringBuilder(54).append("Failed to complete savepoint in time for ").append(new ExternalDeploymentId(jobId)).append(" and trigger ").append(savepointId).toString()));
        }
        return ((Future)sttp.client.package$.MODULE$.basicRequest().get(this.flinkUrl().path("jobs", jobId, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"savepoints", savepointId}))).response(package$.MODULE$.asJson(flinkRestModel$GetSavepointStatusResponse$.MODULE$.decodeGetSavepointStatusResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).flatMap((Function1 & Serializable & scala.Serializable)resp -> {
            Future future;
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Waiting for savepoint {} of {}, got response: {}", new Object[]{savepointId, new ExternalDeploymentId(jobId), resp});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (resp.isCompletedSuccessfully()) {
                BoxedUnit boxedUnit2;
                String location = (String)resp.operation().flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.location()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Savepoint {} for {} finished in {}", new Object[]{savepointId, new ExternalDeploymentId(jobId), location});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                future = Future$.MODULE$.successful((Object)new SavepointResult(location));
            } else if (resp.isFailed()) {
                future = Future$.MODULE$.failed((Throwable)new RuntimeException(new StringBuilder(30).append("Failed to complete savepoint: ").append(resp.operation()).toString()));
            } else {
                Thread.sleep(1000L);
                future = this.waitForSavepoint(jobId, savepointId, timeoutLeft - (System.currentTimeMillis() - start));
            }
            return future;
        }, this.ec);
    }

    public long waitForSavepoint$default$3() {
        return this.config.jobManagerTimeout().toMillis();
    }

    @Override
    public Future<BoxedUnit> cancel(String deploymentId) {
        return ((Future)sttp.client.package$.MODULE$.basicRequest().patch(this.flinkUrl().path("jobs", deploymentId, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> this.handleUnitResponse("cancel scenario", (Response<Either<String, String>>)response), this.ec).recoverWith(this.recoverWithMessage("cancel scenario"), this.ec);
    }

    @Override
    public Future<SavepointResult> makeSavepoint(String deploymentId, Option<String> savepointDir) {
        RequestT savepointRequest = sttp.client.package$.MODULE$.basicRequest().post(this.flinkUrl().path("jobs", deploymentId, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"savepoints"}))).body((Object)new flinkRestModel.SavepointTriggerRequest(savepointDir, false), package$.MODULE$.circeBodySerializer(flinkRestModel$SavepointTriggerRequest$.MODULE$.encodeSavepointTriggerRequest(), package$.MODULE$.circeBodySerializer$default$2()));
        return this.processSavepointRequest(deploymentId, (RequestT<Object, Either<String, String>, Nothing$>)savepointRequest, "make savepoint");
    }

    @Override
    public Future<SavepointResult> stop(String deploymentId, Option<String> savepointDir) {
        RequestT stopRequest = sttp.client.package$.MODULE$.basicRequest().post(this.flinkUrl().path("jobs", deploymentId, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stop"}))).body((Object)new flinkRestModel.StopRequest(savepointDir, false), package$.MODULE$.circeBodySerializer(flinkRestModel$StopRequest$.MODULE$.encodeStopRequest(), package$.MODULE$.circeBodySerializer$default$2()));
        return this.processSavepointRequest(deploymentId, (RequestT<Object, Either<String, String>, Nothing$>)stopRequest, "stop scenario");
    }

    private Future<SavepointResult> processSavepointRequest(String deploymentId, RequestT<Object, Either<String, String>, Nothing$> request, String action) {
        return ((Future)request.response(package$.MODULE$.asJson(flinkRestModel$SavepointTriggerResponse$.MODULE$.decodeSavepointTriggerResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).flatMap((Function1 & Serializable & scala.Serializable)response -> this.waitForSavepoint(deploymentId, response.request$minusid(), this.waitForSavepoint$default$3()), this.ec).recoverWith(this.recoverWithMessage(action), this.ec);
    }

    public DeeplyCheckingExceptionExtractor<TimeoutException> pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor() {
        return this.pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor;
    }

    @Override
    public Future<Option<ExternalDeploymentId>> runProgram(File jarFile, String mainClass, List<String> args, Option<String> savepointPath) {
        flinkRestModel.DeployProcessRequest program = new flinkRestModel.DeployProcessRequest(mainClass, savepointPath, FlinkArgsEncodeHack$.MODULE$.prepareProgramArgs(args).mkString(" "), flinkRestModel$DeployProcessRequest$.MODULE$.apply$default$4(), flinkRestModel$DeployProcessRequest$.MODULE$.apply$default$5());
        return this.uploadJarFileIfNotExists(jarFile).flatMap((Function1 & Serializable & scala.Serializable)flinkJarFile -> ((Future)sttp.client.package$.MODULE$.basicRequest().post(this.flinkUrl().path("jars", flinkJarFile.id(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"run"}))).body((Object)program, package$.MODULE$.circeBodySerializer(flinkRestModel$DeployProcessRequest$.MODULE$.encodeDeployProcessRequest(), package$.MODULE$.circeBodySerializer$default$2())).response(package$.MODULE$.asJson(flinkRestModel$RunResponse$.MODULE$.decodeRunResponse(), IsOption$.MODULE$.otherIsNotOption())).send($this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), $this.ec).map((Function1 & Serializable & scala.Serializable)ret -> new Some((Object)new ExternalDeploymentId(ret.jobid())), $this.ec).recover((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpFlinkClient $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Option option = this.$outer.pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor().unapply(A1);
                if (!option.isEmpty()) {
                    BoxedUnit boxedUnit;
                    TimeoutException e = (TimeoutException)option.get();
                    if (this.$outer.logger().underlying().isWarnEnabled()) {
                        this.$outer.logger().underlying().warn("TimeoutException occurred while waiting for deploy result. Recovering with Future.successful...", (Throwable)e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = None$.MODULE$;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                Option option = this.$outer.pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor().unapply(throwable);
                boolean bl = !option.isEmpty();
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, $this.ec).recoverWith(this.recoverWithMessage("deploy scenario"), $this.ec), this.ec);
    }

    public Future<flinkRestModel.ClusterOverview> getClusterOverview() {
        return ((Future)sttp.client.package$.MODULE$.basicRequest().get(this.flinkUrl().path("overview")).response(package$.MODULE$.asJson(flinkRestModel$ClusterOverview$.MODULE$.decodeClusterOverview(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec);
    }

    public Future<Configuration> getJobManagerConfig() {
        return ((Future)sttp.client.package$.MODULE$.basicRequest().get(this.flinkUrl().path("jobmanager", "config", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).response(package$.MODULE$.asJson(Decoder$.MODULE$.decodeList(flinkRestModel$KeyValueEntry$.MODULE$.decodeKeyValueEntry()), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).map((Function1 & Serializable & scala.Serializable)list -> Configuration.fromMap((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)list.map((Function1 & Serializable & scala.Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.key()), (Object)e.value()), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava())), this.ec);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Future<BoxedUnit> handleUnitResponse(String action, Response<Either<String, String>> response) {
        Tuple2 tuple2 = new Tuple2((Object)new StatusCode(response.code()), response.body());
        if (tuple2 != null) {
            int code = ((StatusCode)tuple2._1()).code();
            Either either = (Either)tuple2._2();
            if (either instanceof Right && StatusCode$.MODULE$.isSuccess$extension(code)) {
                return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        int code = ((StatusCode)tuple2._1()).code();
        Either either = (Either)tuple2._2();
        if (!(either instanceof Left)) throw new MatchError((Object)tuple2);
        Left left = (Left)either;
        String error = (String)left.value();
        return this.pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$handleClientError(error, code, action);
    }

    public Future<Nothing$> pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$handleClientError(String body, int status, String action) {
        BoxedUnit boxedUnit;
        flinkRestModel.FlinkError decodedErrors = (flinkRestModel.FlinkError)CirceUtil$.MODULE$.decodeJson(body, flinkRestModel$FlinkError$.MODULE$.decodeFlinkError()).fold((Function1 & Serializable & scala.Serializable)error -> new flinkRestModel.FlinkError((List<String>)new .colon.colon((Object)new StringBuilder(18).append("Failed to decode: ").append(error).toString(), (List)Nil$.MODULE$)), (Function1 & Serializable & scala.Serializable)x -> (flinkRestModel.FlinkError)Predef$.MODULE$.identity(x));
        if (this.logger().underlying().isErrorEnabled()) {
            this.logger().underlying().error("Failed to {}, status code: {}, errors from Flink: {}", new Object[]{action, new StatusCode(status), decodedErrors.errors().mkString("\n")});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Future$.MODULE$.failed((Throwable)new FlinkClientError(new StringBuilder(60).append("Flink cluster failed to ").append(action).append(". Detailed error information in logs").toString()));
    }

    private <T> PartialFunction<Throwable, Future<T>> recoverWithMessage(String action) {
        return new scala.Serializable(this, action){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpFlinkClient $outer;
            private final String action$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Future<Nothing$> future;
                A1 A1 = x1;
                if (A1 instanceof HttpError) {
                    HttpError httpError = (HttpError)A1;
                    String body = httpError.body();
                    int status = httpError.statusCode();
                    future = this.$outer.pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$handleClientError(body, status, this.action$1);
                } else {
                    future = function1.apply(x1);
                }
                return (B1)future;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof HttpError;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.action$1 = action$1;
            }
        };
    }

    public static final /* synthetic */ boolean $anonfun$checkThatJarWithNameExists$3(String jarName$1, flinkRestModel.JarFile x$2) {
        String string = x$2.name();
        String string2 = jarName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findJobsByName$3(String jobName$1, flinkRestModel.JobOverview x$3) {
        String string = x$3.name();
        String string2 = jobName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public HttpFlinkClient(FlinkConfig config, SttpBackend<Future, Nothing$, ?> backend, ExecutionContext ec) {
        this.config = config;
        this.backend = backend;
        this.ec = ec;
        LazyLogging.$init$((LazyLogging)this);
        this.flinkUrl = sttp.client.package$.MODULE$.UriContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).uri((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config.restUrl()}));
        this.pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor = DeeplyCheckingExceptionExtractor$.MODULE$.forClass(ClassTag$.MODULE$.apply(TimeoutException.class));
    }
}

