/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.management.rest;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.circe.Decoder$;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import org.apache.flink.configuration.Configuration;
import pl.touk.nussknacker.engine.api.CirceUtil$;
import pl.touk.nussknacker.engine.api.deployment.ExternalDeploymentId;
import pl.touk.nussknacker.engine.api.deployment.SavepointResult;
import pl.touk.nussknacker.engine.management.FlinkArgsEncodeHack$;
import pl.touk.nussknacker.engine.management.FlinkConfig;
import pl.touk.nussknacker.engine.management.rest.FlinkClient;
import pl.touk.nussknacker.engine.management.rest.FlinkClientError;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$ClusterOverview$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$DeployProcessRequest$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$FlinkError$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$GetSavepointStatusResponse$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$JarsResponse$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$JobConfig$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$JobsResponse$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$KeyValueEntry$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$RunResponse$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$SavepointTriggerRequest$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$SavepointTriggerResponse$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$StopRequest$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$UploadJarResponse$;
import pl.touk.nussknacker.engine.sttp.SttpJson$;
import pl.touk.nussknacker.engine.util.exception.DeeplyCheckingExceptionExtractor;
import pl.touk.nussknacker.engine.util.exception.DeeplyCheckingExceptionExtractor$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sttp.client.HttpError;
import sttp.client.IsOption$;
import sttp.client.RequestT;
import sttp.client.Response;
import sttp.client.SttpBackend;
import sttp.client.circe.package$;
import sttp.model.Part;
import sttp.model.StatusCode;
import sttp.model.StatusCode$;
import sttp.model.Uri;

@ScalaSignature(bytes="\u0006\u0001\t\u0015h\u0001B\u000f\u001f\u0001-B\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\t\u000b\u0002\u0011\t\u0011)A\u0006\r\"AQ\r\u0001B\u0001B\u0003-a\rC\u0003j\u0001\u0011\u0005!\u000eC\u0004q\u0001\t\u0007I\u0011B9\t\ra\u0004\u0001\u0015!\u0003s\u0011\u0015I\b\u0001\"\u0001{\u0011\u001d\t\u0019\u0004\u0001C\u0005\u0003kAq!a\u0015\u0001\t\u0003\t)\u0006C\u0004\u0002\\\u0001!\t%!\u0018\t\u000f\u0005-\u0004\u0001\"\u0003\u0002n!9\u00111\u000f\u0001\u0005\u0002\u0005U\u0004bBAJ\u0001\u0011\u0005\u0011Q\u0013\u0005\b\u0003K\u0003A\u0011AAT\u0011%\t\t\u000eAI\u0001\n\u0003\t\u0019\u000eC\u0004\u0002j\u0002!\t!a;\t\u000f\u0005E\b\u0001\"\u0001\u0002t\"9\u0011Q \u0001\u0005\u0002\u0005}\bb\u0002B\u0003\u0001\u0011%!q\u0001\u0005\n\u0005K\u0001!\u0019!C\u0005\u0005OA\u0001B!\u0012\u0001A\u0003%!\u0011\u0006\u0005\b\u0005\u000f\u0002A\u0011\u0001B%\u0011\u001d\u0011y\u0006\u0001C\u0001\u0005CBqAa\u001b\u0001\t\u0003\u0011i\u0007C\u0004\u0003\n\u0002!IAa#\t\u000f\t]\u0005\u0001\"\u0003\u0003\u001a\"9!\u0011\u0016\u0001\u0005\n\t-\u0006b\u0002B`\u0001\u0011%!\u0011\u0019\u0002\u0010\u0011R$\bO\u00127j].\u001cE.[3oi*\u0011q\u0004I\u0001\u0005e\u0016\u001cHO\u0003\u0002\"E\u0005QQ.\u00198bO\u0016lWM\u001c;\u000b\u0005\r\"\u0013AB3oO&tWM\u0003\u0002&M\u0005Ya.^:tW:\f7m[3s\u0015\t9\u0003&\u0001\u0003u_V\\'\"A\u0015\u0002\u0005Ad7\u0001A\n\u0005\u00011\u0012d\u0007\u0005\u0002.a5\taFC\u00010\u0003\u0015\u00198-\u00197b\u0013\t\tdF\u0001\u0004B]f\u0014VM\u001a\t\u0003gQj\u0011AH\u0005\u0003ky\u00111B\u00127j].\u001cE.[3oiB\u0011qGP\u0007\u0002q)\u0011\u0011HO\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003wq\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002{\u0005\u00191m\\7\n\u0005}B$a\u0003'bufdunZ4j]\u001e\faaY8oM&<\u0007C\u0001\"D\u001b\u0005\u0001\u0013B\u0001#!\u0005-1E.\u001b8l\u0007>tg-[4\u0002\u000f\t\f7m[3oIB)q\t\u0014(U/6\t\u0001J\u0003\u0002J\u0015\u000611\r\\5f]RT\u0011aS\u0001\u0005gR$\b/\u0003\u0002N\u0011\nY1\u000b\u001e;q\u0005\u0006\u001c7.\u001a8e!\ty%+D\u0001Q\u0015\t\tf&\u0001\u0006d_:\u001cWO\u001d:f]RL!a\u0015)\u0003\r\u0019+H/\u001e:f!\tiS+\u0003\u0002W]\t9aj\u001c;iS:<\u0007C\u0001-c\u001d\tI\u0006M\u0004\u0002[?:\u00111LX\u0007\u00029*\u0011QLK\u0001\u0007yI|w\u000e\u001e \n\u0003-K!!\u0013&\n\u0005\u0005D\u0015a\u00029bG.\fw-Z\u0005\u0003G\u0012\u0014\u0001BT8uQ&tw\r\u0016\u0006\u0003C\"\u000b!!Z2\u0011\u0005=;\u0017B\u00015Q\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0003W>$2\u0001\\7o!\t\u0019\u0004\u0001C\u0003F\t\u0001\u000fa\tC\u0003f\t\u0001\u000fa\rC\u0003A\t\u0001\u0007\u0011)\u0001\u0005gY&t7.\u0016:m+\u0005\u0011\bCA:w\u001b\u0005!(BA;K\u0003\u0015iw\u000eZ3m\u0013\t9HOA\u0002Ve&\f\u0011B\u001a7j].,&\u000f\u001c\u0011\u00021U\u0004Hn\\1e\u0015\u0006\u0014h)\u001b7f\u0013\u001atu\u000e^#ySN$8\u000fF\u0002|\u0003?\u00012a\u0014*}!\ri\u0018\u0011\u0004\b\u0004}\u0006UabA@\u0002\u00149!\u0011\u0011AA\t\u001d\u0011\t\u0019!a\u0004\u000f\t\u0005\u0015\u0011Q\u0002\b\u0005\u0003\u000f\tYAD\u0002\\\u0003\u0013I\u0011!K\u0005\u0003O!J!!\n\u0014\n\u0005\r\"\u0013BA\u0011#\u0013\ty\u0002%C\u0002\u0002\u0018y\taB\u001a7j].\u0014Vm\u001d;N_\u0012,G.\u0003\u0003\u0002\u001c\u0005u!a\u0002&be\u001aKG.\u001a\u0006\u0004\u0003/q\u0002bBA\u0011\u000f\u0001\u0007\u00111E\u0001\bU\u0006\u0014h)\u001b7f!\u0011\t)#a\f\u000e\u0005\u0005\u001d\"\u0002BA\u0015\u0003W\t!![8\u000b\u0005\u00055\u0012\u0001\u00026bm\u0006LA!!\r\u0002(\t!a)\u001b7f\u0003i\u0019\u0007.Z2l)\"\fGOS1s/&$\bNT1nK\u0016C\u0018n\u001d;t)\u0011\t9$a\u0010\u0011\t=\u0013\u0016\u0011\b\t\u0005[\u0005mB0C\u0002\u0002>9\u0012aa\u00149uS>t\u0007bBA!\u0011\u0001\u0007\u00111I\u0001\bU\u0006\u0014h*Y7f!\u0011\t)%!\u0014\u000f\t\u0005\u001d\u0013\u0011\n\t\u00037:J1!a\u0013/\u0003\u0019\u0001&/\u001a3fM&!\u0011qJA)\u0005\u0019\u0019FO]5oO*\u0019\u00111\n\u0018\u0002\u0013U\u0004Hn\\1e\u0015\u0006\u0014H\u0003BA,\u00033\u0002Ba\u0014*\u0002D!9\u0011\u0011E\u0005A\u0002\u0005\r\u0012!\u00053fY\u0016$XMS1s\u0013\u001a,\u00050[:ugR!\u0011qLA4!\u0011y%+!\u0019\u0011\u00075\n\u0019'C\u0002\u0002f9\u0012A!\u00168ji\"9\u0011\u0011\u000e\u0006A\u0002\u0005\r\u0013a\u00036be\u001aKG.\u001a(b[\u0016\f\u0011\u0002Z3mKR,'*\u0019:\u0015\t\u0005}\u0013q\u000e\u0005\b\u0003cZ\u0001\u0019AA\"\u0003\u0015Q\u0017M]%e\u000391\u0017N\u001c3K_\n\u001c()\u001f(b[\u0016$B!a\u001e\u0002\u0010B!qJUA=!\u0019\tY(a!\u0002\n:!\u0011QPAA\u001d\rY\u0016qP\u0005\u0002_%\u0011\u0011ML\u0005\u0005\u0003\u000b\u000b9I\u0001\u0003MSN$(BA1/!\ri\u00181R\u0005\u0005\u0003\u001b\u000biBA\u0006K_\n|e/\u001a:wS\u0016<\bbBAI\u0019\u0001\u0007\u00111I\u0001\bU>\u0014g*Y7f\u000319W\r\u001e&pE\u000e{gNZ5h)\u0011\t9*!)\u0011\t=\u0013\u0016\u0011\u0014\t\u0005\u00037\u000biJD\u00024\u0003+IA!a(\u0002\u001e\tyQ\t_3dkRLwN\\\"p]\u001aLw\rC\u0004\u0002$6\u0001\r!a\u0011\u0002\u000b)|'-\u00133\u0002!]\f\u0017\u000e\u001e$peN\u000bg/\u001a9pS:$H\u0003CAU\u0003w\u000b\u0019-a2\u0011\t=\u0013\u00161\u0016\t\u0005\u0003[\u000b9,\u0004\u0002\u00020*!\u0011\u0011WAZ\u0003)!W\r\u001d7ps6,g\u000e\u001e\u0006\u0004\u0003k\u0013\u0013aA1qS&!\u0011\u0011XAX\u0005=\u0019\u0016M^3q_&tGOU3tk2$\bbBAR\u001d\u0001\u0007\u0011Q\u0018\t\u0005\u0003[\u000by,\u0003\u0003\u0002B\u0006=&\u0001F#yi\u0016\u0014h.\u00197EKBdw._7f]RLE\rC\u0004\u0002F:\u0001\r!a\u0011\u0002\u0017M\fg/\u001a9pS:$\u0018\n\u001a\u0005\n\u0003\u0013t\u0001\u0013!a\u0001\u0003\u0017\f1\u0002^5nK>,H\u000fT3giB\u0019Q&!4\n\u0007\u0005=gF\u0001\u0003M_:<\u0017AG<bSR4uN]*bm\u0016\u0004x.\u001b8uI\u0011,g-Y;mi\u0012\u001aTCAAkU\u0011\tY-a6,\u0005\u0005e\u0007\u0003BAn\u0003Kl!!!8\u000b\t\u0005}\u0017\u0011]\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a9/\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003O\fiNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\faaY1oG\u0016dG\u0003BA0\u0003[Dq!a<\u0011\u0001\u0004\ti,\u0001\u0007eKBdw._7f]RLE-A\u0007nC.,7+\u0019<fa>Lg\u000e\u001e\u000b\u0007\u0003S\u000b)0a>\t\u000f\u0005=\u0018\u00031\u0001\u0002>\"9\u0011\u0011`\tA\u0002\u0005m\u0018\u0001D:bm\u0016\u0004x.\u001b8u\t&\u0014\b#B\u0017\u0002<\u0005\r\u0013\u0001B:u_B$b!!+\u0003\u0002\t\r\u0001bBAx%\u0001\u0007\u0011Q\u0018\u0005\b\u0003s\u0014\u0002\u0019AA~\u0003]\u0001(o\\2fgN\u001c\u0016M^3q_&tGOU3rk\u0016\u001cH\u000f\u0006\u0005\u0002*\n%!1\u0002B\u0011\u0011\u001d\tyo\u0005a\u0001\u0003{CqA!\u0004\u0014\u0001\u0004\u0011y!A\u0004sKF,Xm\u001d;\u0011\u0011\u001d\u0013\tB!\u0006\u0003\u001cQK1Aa\u0005I\u0005!\u0011V-];fgR$\u0006c\u0001-\u0003\u0018%\u0019!\u0011\u00043\u0003\u0011%#WM\u001c;jif\u0004\u0002\"a\u001f\u0003\u001e\u0005\r\u00131I\u0005\u0005\u0005?\t9I\u0001\u0004FSRDWM\u001d\u0005\b\u0005G\u0019\u0002\u0019AA\"\u0003\u0019\t7\r^5p]\u0006\u0001B/[7f_V$X\t\u001f;sC\u000e$xN]\u000b\u0003\u0005S\u0001bAa\u000b\u00036\teRB\u0001B\u0017\u0015\u0011\u0011yC!\r\u0002\u0013\u0015D8-\u001a9uS>t'b\u0001B\u001aE\u0005!Q\u000f^5m\u0013\u0011\u00119D!\f\u0003A\u0011+W\r\u001d7z\u0007\",7m[5oO\u0016C8-\u001a9uS>tW\t\u001f;sC\u000e$xN\u001d\t\u0005\u0005w\u0011\t%\u0004\u0002\u0003>)\u0019\u0011Ka\u0010\u000b\t\tM\u00121F\u0005\u0005\u0005\u0007\u0012iD\u0001\tUS6,w.\u001e;Fq\u000e,\u0007\u000f^5p]\u0006\tB/[7f_V$X\t\u001f;sC\u000e$xN\u001d\u0011\u0002\u0015I,h\u000e\u0015:pOJ\fW\u000e\u0006\u0006\u0003L\t=#\u0011\u000bB+\u00057\u0002Ba\u0014*\u0003NA)Q&a\u000f\u0002>\"9\u0011\u0011\u0005\fA\u0002\u0005\r\u0002b\u0002B*-\u0001\u0007\u00111I\u0001\n[\u0006Lgn\u00117bgNDqAa\u0016\u0017\u0001\u0004\u0011I&\u0001\u0003be\u001e\u001c\bCBA>\u0003\u0007\u000b\u0019\u0005C\u0004\u0003^Y\u0001\r!a?\u0002\u001bM\fg/\u001a9pS:$\b+\u0019;i\u0003I9W\r^\"mkN$XM](wKJ4\u0018.Z<\u0016\u0005\t\r\u0004\u0003B(S\u0005K\u00022! B4\u0013\u0011\u0011I'!\b\u0003\u001f\rcWo\u001d;fe>3XM\u001d<jK^\f1cZ3u\u0015>\u0014W*\u00198bO\u0016\u00148i\u001c8gS\u001e,\"Aa\u001c\u0011\t=\u0013&\u0011\u000f\t\u0005\u0005g\u0012))\u0004\u0002\u0003v)!!q\u000fB=\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]*!!1\u0010B?\u0003\u00151G.\u001b8l\u0015\u0011\u0011yH!!\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\u0011\u0019)A\u0002pe\u001eLAAa\"\u0003v\ti1i\u001c8gS\u001e,(/\u0019;j_:\fAcY8oM&<WO]1uS>tgI]8n\u001b\u0006\u0004H\u0003\u0002B9\u0005\u001bCqAa$\u001a\u0001\u0004\u0011\t*\u0001\u0004wC2,Xm\u001d\t\t\u0003\u000b\u0012\u0019*a\u0011\u0002D%!!QSA)\u0005\ri\u0015\r]\u0001\u0013Q\u0006tG\r\\3V]&$(+Z:q_:\u001cX\r\u0006\u0003\u0003\u001c\n\u001dF\u0003BA0\u0005;CqAa(\u001b\u0001\u0004\u0011\t+\u0001\u0005sKN\u0004xN\\:f!\u00159%1\u0015B\u000e\u0013\r\u0011)\u000b\u0013\u0002\t%\u0016\u001c\bo\u001c8tK\"9!1\u0005\u000eA\u0002\u0005\r\u0013!\u00055b]\u0012dWm\u00117jK:$XI\u001d:peRA!Q\u0016BX\u0005g\u0013i\fE\u0002P%RCqA!-\u001c\u0001\u0004\t\u0019%\u0001\u0003c_\u0012L\bb\u0002B[7\u0001\u0007!qW\u0001\u0007gR\fG/^:\u0011\u0007M\u0014I,C\u0002\u0003<R\u0014!b\u0015;biV\u001c8i\u001c3f\u0011\u001d\u0011\u0019c\u0007a\u0001\u0003\u0007\n!C]3d_Z,'oV5uQ6+7o]1hKV!!1\u0019Bl)\u0011\u0011)Ma9\u0011\u000f5\u00129Ma3\u0003R&\u0019!\u0011\u001a\u0018\u0003\u001fA\u000b'\u000f^5bY\u001a+hn\u0019;j_:\u0004B!a\u001f\u0003N&!!qZAD\u0005%!\u0006N]8xC\ndW\r\u0005\u0003P%\nM\u0007\u0003\u0002Bk\u0005/d\u0001\u0001B\u0004\u0003Zr\u0011\rAa7\u0003\u0003Q\u000b2\u0001\u0016Bo!\ri#q\\\u0005\u0004\u0005Ct#aA!os\"9!1\u0005\u000fA\u0002\u0005\r\u0003")
public class HttpFlinkClient
implements FlinkClient,
LazyLogging {
    private final FlinkConfig config;
    private final SttpBackend<Future, Nothing$, Nothing$> backend;
    private final ExecutionContext ec;
    private final Uri flinkUrl;
    private final DeeplyCheckingExceptionExtractor<TimeoutException> pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        HttpFlinkClient httpFlinkClient = this;
        synchronized (httpFlinkClient) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private Uri flinkUrl() {
        return this.flinkUrl;
    }

    public Future<flinkRestModel.JarFile> uploadJarFileIfNotExists(File jarFile) {
        return this.checkThatJarWithNameExists(jarFile.getName()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                flinkRestModel.JarFile file = (flinkRestModel.JarFile)some.value();
                future = Future$.MODULE$.successful((Object)file);
            } else if (None$.MODULE$.equals(option)) {
                future = this.uploadJar(jarFile).map((Function1 & Serializable & scala.Serializable)id -> new flinkRestModel.JarFile((String)id, jarFile.getName()), $this.ec);
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, this.ec);
    }

    private Future<Option<flinkRestModel.JarFile>> checkThatJarWithNameExists(String jarName) {
        return ((Future)sttp.client.package$.MODULE$.basicRequest().get(this.flinkUrl().path("jars")).response(package$.MODULE$.asJson(flinkRestModel$JarsResponse$.MODULE$.decodeJarsResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).map((Function1 & Serializable & scala.Serializable)x$1 -> ((LinearSeqOptimized)x$1.files().toList().flatten((Function1)Predef$.MODULE$.$conforms())).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HttpFlinkClient.$anonfun$checkThatJarWithNameExists$3(jarName, x$2))), this.ec);
    }

    public Future<String> uploadJar(File jarFile) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Uploading new jar: {}", new Object[]{jarFile.getAbsolutePath()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return ((Future)sttp.client.package$.MODULE$.basicRequest().post(this.flinkUrl().path("jars", "upload", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).multipartBody(sttp.client.package$.MODULE$.multipartFile("jarfile", jarFile).contentType("application/x-java-archive"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Part[0])).response(package$.MODULE$.asJson(flinkRestModel$UploadJarResponse$.MODULE$.decodeUploadJarResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).map((Function1 & Serializable & scala.Serializable)file -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Uploaded jar to {}", new Object[]{file});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return new File(file.filename()).getName();
        }, this.ec).recoverWith(this.recoverWithMessage("upload Nussnknacker jar to Flink"), this.ec);
    }

    @Override
    public Future<BoxedUnit> deleteJarIfExists(String jarFileName) {
        return this.checkThatJarWithNameExists(jarFileName).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                flinkRestModel.JarFile file = (flinkRestModel.JarFile)some.value();
                future = this.deleteJar(file.id()).recover((PartialFunction)new scala.Serializable(this, jarFileName){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HttpFlinkClient $outer;
                    private final String jarFileName$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        BoxedUnit boxedUnit;
                        A1 A1 = x1;
                        if (this.$outer.logger().underlying().isWarnEnabled()) {
                            this.$outer.logger().underlying().warn(new StringBuilder(22).append("Failed to delete jar: ").append(this.jarFileName$1).toString(), A1);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        return (B1)boxedUnit2;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        boolean bl = true;
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.jarFileName$1 = jarFileName$1;
                    }
                }, $this.ec);
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("{} does not exist, not removing", new Object[]{jarFileName});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, this.ec);
    }

    private Future<BoxedUnit> deleteJar(String jarId) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Delete jar id: {}", new Object[]{jarId});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return ((Future)sttp.client.package$.MODULE$.basicRequest().delete(this.flinkUrl().path("jars", jarId, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> this.handleUnitResponse("delete jar", (Response<Either<String, String>>)response), this.ec).recoverWith(this.recoverWithMessage("delete jar"), this.ec);
    }

    @Override
    public Future<List<flinkRestModel.JobOverview>> findJobsByName(String jobName) {
        return ((Future)sttp.client.package$.MODULE$.basicRequest().get(this.flinkUrl().path("jobs", "overview", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).response(package$.MODULE$.asJson(flinkRestModel$JobsResponse$.MODULE$.decodeJobsResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).map((Function1 & Serializable & scala.Serializable)jobs -> ((List)((SeqLike)jobs.jobs().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)HttpFlinkClient.$anonfun$findJobsByName$3(jobName, x$3)))).sortBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.last$minusmodification()), (Ordering)Ordering.Long$.MODULE$)).reverse(), this.ec).recoverWith(this.recoverWithMessage("retrieve Flink jobs"), this.ec);
    }

    @Override
    public Future<flinkRestModel.ExecutionConfig> getJobConfig(String jobId) {
        return ((Future)sttp.client.package$.MODULE$.basicRequest().get(this.flinkUrl().path("jobs", jobId, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"config"}))).response(package$.MODULE$.asJson(flinkRestModel$JobConfig$.MODULE$.decodeJobConfig(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.execution$minusconfig(), this.ec);
    }

    public Future<SavepointResult> waitForSavepoint(String jobId, String savepointId, long timeoutLeft) {
        long start = System.currentTimeMillis();
        if (timeoutLeft <= 0L) {
            return Future$.MODULE$.failed((Throwable)new Exception(new StringBuilder(54).append("Failed to complete savepoint in time for ").append(new ExternalDeploymentId(jobId)).append(" and trigger ").append(savepointId).toString()));
        }
        return ((Future)sttp.client.package$.MODULE$.basicRequest().get(this.flinkUrl().path("jobs", jobId, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"savepoints", savepointId}))).response(package$.MODULE$.asJson(flinkRestModel$GetSavepointStatusResponse$.MODULE$.decodeGetSavepointStatusResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).flatMap((Function1 & Serializable & scala.Serializable)resp -> {
            Future future;
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Waiting for savepoint {} of {}, got response: {}", new Object[]{savepointId, new ExternalDeploymentId(jobId), resp});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (resp.isCompletedSuccessfully()) {
                BoxedUnit boxedUnit2;
                String location = (String)resp.operation().flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.location()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Savepoint {} for {} finished in {}", new Object[]{savepointId, new ExternalDeploymentId(jobId), location});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                future = Future$.MODULE$.successful((Object)new SavepointResult(location));
            } else if (resp.isFailed()) {
                future = Future$.MODULE$.failed((Throwable)new RuntimeException(new StringBuilder(30).append("Failed to complete savepoint: ").append(resp.operation()).toString()));
            } else {
                Thread.sleep(1000L);
                future = this.waitForSavepoint(jobId, savepointId, timeoutLeft - (System.currentTimeMillis() - start));
            }
            return future;
        }, this.ec);
    }

    public long waitForSavepoint$default$3() {
        return this.config.jobManagerTimeout().toMillis();
    }

    @Override
    public Future<BoxedUnit> cancel(String deploymentId) {
        return ((Future)sttp.client.package$.MODULE$.basicRequest().patch(this.flinkUrl().path("jobs", deploymentId, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> this.handleUnitResponse("cancel scenario", (Response<Either<String, String>>)response), this.ec).recoverWith(this.recoverWithMessage("cancel scenario"), this.ec);
    }

    @Override
    public Future<SavepointResult> makeSavepoint(String deploymentId, Option<String> savepointDir) {
        RequestT savepointRequest = sttp.client.package$.MODULE$.basicRequest().post(this.flinkUrl().path("jobs", deploymentId, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"savepoints"}))).body((Object)new flinkRestModel.SavepointTriggerRequest(savepointDir, false), package$.MODULE$.circeBodySerializer(flinkRestModel$SavepointTriggerRequest$.MODULE$.encodeSavepointTriggerRequest(), package$.MODULE$.circeBodySerializer$default$2()));
        return this.processSavepointRequest(deploymentId, (RequestT<Object, Either<String, String>, Nothing$>)savepointRequest, "make savepoint");
    }

    @Override
    public Future<SavepointResult> stop(String deploymentId, Option<String> savepointDir) {
        RequestT stopRequest = sttp.client.package$.MODULE$.basicRequest().post(this.flinkUrl().path("jobs", deploymentId, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stop"}))).body((Object)new flinkRestModel.StopRequest(savepointDir, false), package$.MODULE$.circeBodySerializer(flinkRestModel$StopRequest$.MODULE$.encodeStopRequest(), package$.MODULE$.circeBodySerializer$default$2()));
        return this.processSavepointRequest(deploymentId, (RequestT<Object, Either<String, String>, Nothing$>)stopRequest, "stop scenario");
    }

    private Future<SavepointResult> processSavepointRequest(String deploymentId, RequestT<Object, Either<String, String>, Nothing$> request, String action) {
        return ((Future)request.response(package$.MODULE$.asJson(flinkRestModel$SavepointTriggerResponse$.MODULE$.decodeSavepointTriggerResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).flatMap((Function1 & Serializable & scala.Serializable)response -> this.waitForSavepoint(deploymentId, response.request$minusid(), this.waitForSavepoint$default$3()), this.ec).recoverWith(this.recoverWithMessage(action), this.ec);
    }

    public DeeplyCheckingExceptionExtractor<TimeoutException> pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor() {
        return this.pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor;
    }

    @Override
    public Future<Option<ExternalDeploymentId>> runProgram(File jarFile, String mainClass, List<String> args, Option<String> savepointPath) {
        flinkRestModel.DeployProcessRequest program = new flinkRestModel.DeployProcessRequest(mainClass, savepointPath, FlinkArgsEncodeHack$.MODULE$.prepareProgramArgs(args).mkString(" "), flinkRestModel$DeployProcessRequest$.MODULE$.apply$default$4(), flinkRestModel$DeployProcessRequest$.MODULE$.apply$default$5());
        return this.uploadJarFileIfNotExists(jarFile).flatMap((Function1 & Serializable & scala.Serializable)flinkJarFile -> ((Future)sttp.client.package$.MODULE$.basicRequest().post(this.flinkUrl().path("jars", flinkJarFile.id(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"run"}))).body((Object)program, package$.MODULE$.circeBodySerializer(flinkRestModel$DeployProcessRequest$.MODULE$.encodeDeployProcessRequest(), package$.MODULE$.circeBodySerializer$default$2())).response(package$.MODULE$.asJson(flinkRestModel$RunResponse$.MODULE$.decodeRunResponse(), IsOption$.MODULE$.otherIsNotOption())).send($this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), $this.ec).map((Function1 & Serializable & scala.Serializable)ret -> new Some((Object)new ExternalDeploymentId(ret.jobid())), $this.ec).recover((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpFlinkClient $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Option option = this.$outer.pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor().unapply(A1);
                if (!option.isEmpty()) {
                    BoxedUnit boxedUnit;
                    TimeoutException e = (TimeoutException)option.get();
                    if (this.$outer.logger().underlying().isWarnEnabled()) {
                        this.$outer.logger().underlying().warn("TimeoutException occurred while waiting for deploy result. Recovering with Future.successful...", (Throwable)e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = None$.MODULE$;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                Option option = this.$outer.pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor().unapply(throwable);
                boolean bl = !option.isEmpty();
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, $this.ec).recoverWith(this.recoverWithMessage("deploy scenario"), $this.ec), this.ec);
    }

    public Future<flinkRestModel.ClusterOverview> getClusterOverview() {
        return ((Future)sttp.client.package$.MODULE$.basicRequest().get(this.flinkUrl().path("overview")).response(package$.MODULE$.asJson(flinkRestModel$ClusterOverview$.MODULE$.decodeClusterOverview(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec);
    }

    public Future<Configuration> getJobManagerConfig() {
        return ((Future)sttp.client.package$.MODULE$.basicRequest().get(this.flinkUrl().path("jobmanager", "config", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).response(package$.MODULE$.asJson(Decoder$.MODULE$.decodeList(flinkRestModel$KeyValueEntry$.MODULE$.decodeKeyValueEntry()), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).map((Function1 & Serializable & scala.Serializable)list -> this.configurationFromMap((Map<String, String>)((TraversableOnce)list.map((Function1 & Serializable & scala.Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.key()), (Object)e.value()), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())), this.ec);
    }

    /*
     * WARNING - void declaration
     */
    private Configuration configurationFromMap(Map<String, String> values) {
        void var2_2;
        Configuration configuration = new Configuration();
        values.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HttpFlinkClient.$anonfun$configurationFromMap$1(configuration, x0$1);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Future<BoxedUnit> handleUnitResponse(String action, Response<Either<String, String>> response) {
        Tuple2 tuple2 = new Tuple2((Object)new StatusCode(response.code()), response.body());
        if (tuple2 != null) {
            int code = ((StatusCode)tuple2._1()).code();
            Either either = (Either)tuple2._2();
            if (either instanceof Right && StatusCode$.MODULE$.isSuccess$extension(code)) {
                return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        int code = ((StatusCode)tuple2._1()).code();
        Either either = (Either)tuple2._2();
        if (!(either instanceof Left)) throw new MatchError((Object)tuple2);
        Left left = (Left)either;
        String error = (String)left.value();
        return this.pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$handleClientError(error, code, action);
    }

    public Future<Nothing$> pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$handleClientError(String body, int status, String action) {
        BoxedUnit boxedUnit;
        flinkRestModel.FlinkError decodedErrors = (flinkRestModel.FlinkError)CirceUtil$.MODULE$.decodeJson(body, flinkRestModel$FlinkError$.MODULE$.decodeFlinkError()).fold((Function1 & Serializable & scala.Serializable)error -> new flinkRestModel.FlinkError((List<String>)new .colon.colon((Object)new StringBuilder(18).append("Failed to decode: ").append(error).toString(), (List)Nil$.MODULE$)), (Function1 & Serializable & scala.Serializable)x -> (flinkRestModel.FlinkError)Predef$.MODULE$.identity(x));
        if (this.logger().underlying().isErrorEnabled()) {
            this.logger().underlying().error("Failed to {}, status code: {}, errors from Flink: {}", new Object[]{action, new StatusCode(status), decodedErrors.errors().mkString("\n")});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Future$.MODULE$.failed((Throwable)new FlinkClientError(new StringBuilder(60).append("Flink cluster failed to ").append(action).append(". Detailed error information in logs").toString()));
    }

    private <T> PartialFunction<Throwable, Future<T>> recoverWithMessage(String action) {
        return new scala.Serializable(this, action){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpFlinkClient $outer;
            private final String action$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Future<Nothing$> future;
                A1 A1 = x1;
                if (A1 instanceof HttpError) {
                    HttpError httpError = (HttpError)A1;
                    String body = httpError.body();
                    int status = httpError.statusCode();
                    future = this.$outer.pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$handleClientError(body, status, this.action$1);
                } else {
                    future = function1.apply(x1);
                }
                return (B1)future;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof HttpError;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.action$1 = action$1;
            }
        };
    }

    public static final /* synthetic */ boolean $anonfun$checkThatJarWithNameExists$3(String jarName$1, flinkRestModel.JarFile x$2) {
        String string = x$2.name();
        String string2 = jarName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findJobsByName$3(String jobName$1, flinkRestModel.JobOverview x$3) {
        String string = x$3.name();
        String string2 = jobName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$configurationFromMap$1(Configuration configuration$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        configuration$1.setString(k, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public HttpFlinkClient(FlinkConfig config, SttpBackend<Future, Nothing$, ?> backend, ExecutionContext ec) {
        this.config = config;
        this.backend = backend;
        this.ec = ec;
        LazyLogging.$init$((LazyLogging)this);
        this.flinkUrl = sttp.client.package$.MODULE$.UriContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).uri((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config.restUrl()}));
        this.pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor = DeeplyCheckingExceptionExtractor$.MODULE$.forClass(ClassTag$.MODULE$.apply(TimeoutException.class));
    }
}

