/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.management.rest;

import cats.data.NonEmptyList;
import cats.data.Validated;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.circe.Decoder$;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import org.apache.flink.configuration.Configuration;
import pl.touk.nussknacker.engine.api.deployment.DataFreshnessPolicy;
import pl.touk.nussknacker.engine.api.deployment.SavepointResult;
import pl.touk.nussknacker.engine.api.deployment.WithDataFreshnessStatus;
import pl.touk.nussknacker.engine.api.deployment.WithDataFreshnessStatus$;
import pl.touk.nussknacker.engine.deployment.ExternalDeploymentId;
import pl.touk.nussknacker.engine.management.FlinkArgsEncodeHack$;
import pl.touk.nussknacker.engine.management.FlinkConfig;
import pl.touk.nussknacker.engine.management.rest.FlinkClient;
import pl.touk.nussknacker.engine.management.rest.HttpFlinkClient$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$ClusterOverview$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$DeployProcessRequest$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$GetSavepointStatusResponse$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$JarsResponse$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$JobConfig$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$JobsResponse$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$KeyValueEntry$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$RunResponse$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$SavepointTriggerRequest$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$SavepointTriggerResponse$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$UploadJarResponse$;
import pl.touk.nussknacker.engine.sttp.HttpClientErrorHandler$;
import pl.touk.nussknacker.engine.sttp.SttpJson$;
import pl.touk.nussknacker.engine.util.exception.DeeplyCheckingExceptionExtractor;
import pl.touk.nussknacker.engine.util.exception.DeeplyCheckingExceptionExtractor$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import sttp.client3.IsOption$;
import sttp.client3.RequestT;
import sttp.client3.SttpBackend;
import sttp.client3.circe.package$;
import sttp.model.Part;
import sttp.model.Uri;

@ScalaSignature(bytes="\u0006\u0001\t\rh\u0001\u0002\u0010 \u00011B\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"Aq\n\u0001B\u0001B\u0003-\u0001\u000b\u0003\u0005`\u0001\t\u0005\t\u0015a\u0003a\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0011\u0015Y\u0007\u0001\"\u0001m\u0011\u001d\ti\u0002\u0001C\u0005\u0003?Aq!!\u0010\u0001\t\u0003\ty\u0004C\u0004\u0002F\u0001!\t%a\u0012\t\u000f\u0005U\u0003\u0001\"\u0003\u0002X!9\u0011Q\f\u0001\u0005\u0002\u0005}\u0003bBAN\u0001\u0011\u0005\u0011Q\u0014\u0005\b\u0003[\u0003A\u0011AAX\u0011%\t\u0019\u000eAI\u0001\n\u0003\t)\u000eC\u0004\u0002l\u0002!\t!!<\t\u000f\u0005M\b\u0001\"\u0001\u0002v\"9\u0011q \u0001\u0005\u0002\t\u0005\u0001b\u0002B\u0004\u0001\u0011%!\u0011\u0002\u0005\n\u0005k\u0001!\u0019!C\u0005\u0005oA\u0001B!\u0016\u0001A\u0003%!\u0011\b\u0005\b\u0005/\u0002A\u0011\u0001B-\u0011\u001d\u0011y\u0007\u0001C\u0001\u0005cBqAa\u001f\u0001\t\u0003\u0011i\bC\u0004\u0003\u001a\u0002!IAa'\b\u000f\t\u001dv\u0004#\u0001\u0003*\u001a1ad\bE\u0001\u0005WCaa\u0019\u000e\u0005\u0002\t5\u0006b\u0002BX5\u0011\u0005!\u0011\u0017\u0005\b\u0005wSB\u0011\u0001B_\u0005=AE\u000f\u001e9GY&t7n\u00117jK:$(B\u0001\u0011\"\u0003\u0011\u0011Xm\u001d;\u000b\u0005\t\u001a\u0013AC7b]\u0006<W-\\3oi*\u0011A%J\u0001\u0007K:<\u0017N\\3\u000b\u0005\u0019:\u0013a\u00038vgN\\g.Y2lKJT!\u0001K\u0015\u0002\tQ|Wo\u001b\u0006\u0002U\u0005\u0011\u0001\u000f\\\u0002\u0001'\u0011\u0001QfM\u001c\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\r\u0005s\u0017PU3g!\t!T'D\u0001 \u0013\t1tDA\u0006GY&t7n\u00117jK:$\bC\u0001\u001d@\u001b\u0005I$B\u0001\u001e<\u00031\u00198-\u00197bY><w-\u001b8h\u0015\taT(\u0001\u0005usB,7/\u00194f\u0015\u0005q\u0014aA2p[&\u0011\u0001)\u000f\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-\u0001\u0004d_:4\u0017n\u001a\t\u0003\u0007\u0012k\u0011!I\u0005\u0003\u000b\u0006\u00121B\u00127j].\u001cuN\u001c4jO\u0006Aa\r\\5oWV\u0013H\u000e\u0005\u0002I\u001b6\t\u0011J\u0003\u0002K\u0017\u0006)Qn\u001c3fY*\tA*\u0001\u0003tiR\u0004\u0018B\u0001(J\u0005\r)&/[\u0001\bE\u0006\u001c7.\u001a8e!\u0011\tFK\u0016/\u000e\u0003IS!aU&\u0002\u000f\rd\u0017.\u001a8ug%\u0011QK\u0015\u0002\f'R$\bOQ1dW\u0016tG\r\u0005\u0002X56\t\u0001L\u0003\u0002Z_\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005mC&A\u0002$viV\u0014X\r\u0005\u0002/;&\u0011al\f\u0002\u0004\u0003:L\u0018AA3d!\t9\u0016-\u0003\u0002c1\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0015L'\u000eF\u0002gO\"\u0004\"\u0001\u000e\u0001\t\u000b=+\u00019\u0001)\t\u000b}+\u00019\u00011\t\u000b\u0005+\u0001\u0019\u0001\"\t\u000b\u0019+\u0001\u0019A$\u00021U\u0004Hn\\1e\u0015\u0006\u0014h)\u001b7f\u0013\u001atu\u000e^#ySN$8\u000fF\u0002n\u0003\u0013\u00012a\u0016.o!\ry\u00171\u0001\b\u0003a~t!!\u001d@\u000f\u0005IlhBA:}\u001d\t!8P\u0004\u0002vu:\u0011a/_\u0007\u0002o*\u0011\u0001pK\u0001\u0007yI|w\u000e\u001e \n\u0003)J!\u0001K\u0015\n\u0005\u0019:\u0013B\u0001\u0013&\u0013\t\u00113%\u0003\u0002!C%\u0019\u0011\u0011A\u0010\u0002\u001d\u0019d\u0017N\\6SKN$Xj\u001c3fY&!\u0011QAA\u0004\u0005\u001dQ\u0015M\u001d$jY\u0016T1!!\u0001 \u0011\u001d\tYA\u0002a\u0001\u0003\u001b\tqA[1s\r&dW\r\u0005\u0003\u0002\u0010\u0005eQBAA\t\u0015\u0011\t\u0019\"!\u0006\u0002\u0005%|'BAA\f\u0003\u0011Q\u0017M^1\n\t\u0005m\u0011\u0011\u0003\u0002\u0005\r&dW-\u0001\u000edQ\u0016\u001c7\u000e\u00165bi*\u000b'oV5uQ:\u000bW.Z#ySN$8\u000f\u0006\u0003\u0002\"\u0005%\u0002\u0003B,[\u0003G\u0001BALA\u0013]&\u0019\u0011qE\u0018\u0003\r=\u0003H/[8o\u0011\u001d\tYc\u0002a\u0001\u0003[\tqA[1s\u001d\u0006lW\r\u0005\u0003\u00020\u0005]b\u0002BA\u0019\u0003g\u0001\"A^\u0018\n\u0007\u0005Ur&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003s\tYD\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003ky\u0013!C;qY>\fGMS1s)\u0011\t\t%a\u0011\u0011\t]S\u0016Q\u0006\u0005\b\u0003\u0017A\u0001\u0019AA\u0007\u0003E!W\r\\3uK*\u000b'/\u00134Fq&\u001cHo\u001d\u000b\u0005\u0003\u0013\n\t\u0006\u0005\u0003X5\u0006-\u0003c\u0001\u0018\u0002N%\u0019\u0011qJ\u0018\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003'J\u0001\u0019AA\u0017\u0003-Q\u0017M\u001d$jY\u0016t\u0015-\\3\u0002\u0013\u0011,G.\u001a;f\u0015\u0006\u0014H\u0003BA%\u00033Bq!a\u0017\u000b\u0001\u0004\ti#A\u0003kCJLE-\u0001\bgS:$'j\u001c2t\u0005ft\u0015-\\3\u0015\t\u0005\u0005\u0014q\u0013\u000b\u0005\u0003G\ni\t\u0005\u0003X5\u0006\u0015\u0004CBA4\u0003c\n)(\u0004\u0002\u0002j)!\u00111NA7\u0003)!W\r\u001d7ps6,g\u000e\u001e\u0006\u0004\u0003_\u001a\u0013aA1qS&!\u00111OA5\u0005]9\u0016\u000e\u001e5ECR\fgI]3tQ:,7o]*uCR,8\u000f\u0005\u0004\u0002x\u0005\u0005\u0015q\u0011\b\u0005\u0003s\niHD\u0002w\u0003wJ\u0011\u0001M\u0005\u0004\u0003\u007fz\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u0007\u000b)I\u0001\u0003MSN$(bAA@_A\u0019q.!#\n\t\u0005-\u0015q\u0001\u0002\f\u0015>\u0014wJ^3sm&,w\u000fC\u0004\u0002\u0010.\u0001\u001d!!%\u0002\u001f\u0019\u0014Xm\u001d5oKN\u001c\bk\u001c7jGf\u0004B!a\u001a\u0002\u0014&!\u0011QSA5\u0005M!\u0015\r^1Ge\u0016\u001c\bN\\3tgB{G.[2z\u0011\u001d\tIj\u0003a\u0001\u0003[\tqA[8c\u001d\u0006lW-\u0001\u0007hKRTuNY\"p]\u001aLw\r\u0006\u0003\u0002 \u0006%\u0006\u0003B,[\u0003C\u0003B!a)\u0002&:\u0011Ag`\u0005\u0005\u0003O\u000b9AA\bFq\u0016\u001cW\u000f^5p]\u000e{gNZ5h\u0011\u001d\tY\u000b\u0004a\u0001\u0003[\tQA[8c\u0013\u0012\f\u0001c^1ji\u001a{'oU1wKB|\u0017N\u001c;\u0015\u0011\u0005E\u0016\u0011XAc\u0003\u0013\u0004Ba\u0016.\u00024B!\u0011qMA[\u0013\u0011\t9,!\u001b\u0003\u001fM\u000bg/\u001a9pS:$(+Z:vYRDq!a+\u000e\u0001\u0004\tY\f\u0005\u0003\u0002>\u0006\u0005WBAA`\u0015\r\tYgI\u0005\u0005\u0003\u0007\fyL\u0001\u000bFqR,'O\\1m\t\u0016\u0004Hn\\=nK:$\u0018\n\u001a\u0005\b\u0003\u000fl\u0001\u0019AA\u0017\u0003-\u0019\u0018M^3q_&tG/\u00133\t\u0013\u0005-W\u0002%AA\u0002\u00055\u0017a\u0003;j[\u0016|W\u000f\u001e'fMR\u00042ALAh\u0013\r\t\tn\f\u0002\u0005\u0019>tw-\u0001\u000exC&$hi\u001c:TCZ,\u0007o\\5oi\u0012\"WMZ1vYR$3'\u0006\u0002\u0002X*\"\u0011QZAmW\t\tY\u000e\u0005\u0003\u0002^\u0006\u001dXBAAp\u0015\u0011\t\t/a9\u0002\u0013Ut7\r[3dW\u0016$'bAAs_\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005%\u0018q\u001c\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AB2b]\u000e,G\u000e\u0006\u0003\u0002J\u0005=\bbBAy\u001f\u0001\u0007\u00111X\u0001\rI\u0016\u0004Hn\\=nK:$\u0018\nZ\u0001\u000e[\u0006\\WmU1wKB|\u0017N\u001c;\u0015\r\u0005E\u0016q_A}\u0011\u001d\t\t\u0010\u0005a\u0001\u0003wCq!a?\u0011\u0001\u0004\ti0\u0001\u0007tCZ,\u0007o\\5oi\u0012K'\u000fE\u0003/\u0003K\ti#\u0001\u0003ti>\u0004HCBAY\u0005\u0007\u0011)\u0001C\u0004\u0002rF\u0001\r!a/\t\u000f\u0005m\u0018\u00031\u0001\u0002~\u00069\u0002O]8dKN\u001c8+\u0019<fa>Lg\u000e\u001e*fcV,7\u000f\u001e\u000b\t\u0003c\u0013YA!\u0004\u00032!9\u0011\u0011\u001f\nA\u0002\u0005m\u0006b\u0002B\b%\u0001\u0007!\u0011C\u0001\be\u0016\fX/Z:u!!\t&1\u0003B\f\u0005Wa\u0016b\u0001B\u000b%\nA!+Z9vKN$H\u000b\u0005\u0003\u0003\u001a\t\u0015b\u0002\u0002B\u000e\u0005GqAA!\b\u0003\"9\u0019aOa\b\n\u00031K!aU&\n\u0007\u0005}$+\u0003\u0003\u0003(\t%\"\u0001C%eK:$\u0018\u000e^=\u000b\u0007\u0005}$\u000b\u0005\u0005\u0002x\t5\u0012QFA\u0017\u0013\u0011\u0011y#!\"\u0003\r\u0015KG\u000f[3s\u0011\u001d\u0011\u0019D\u0005a\u0001\u0003[\ta!Y2uS>t\u0017\u0001\u0005;j[\u0016|W\u000f^#yiJ\f7\r^8s+\t\u0011I\u0004\u0005\u0004\u0003<\t\u0015#\u0011J\u0007\u0003\u0005{QAAa\u0010\u0003B\u0005IQ\r_2faRLwN\u001c\u0006\u0004\u0005\u0007\u001a\u0013\u0001B;uS2LAAa\u0012\u0003>\t\u0001C)Z3qYf\u001c\u0005.Z2lS:<W\t_2faRLwN\\#yiJ\f7\r^8s!\u0011\u0011YE!\u0015\u000e\u0005\t5#bA-\u0003P)!!1IA\u000b\u0013\u0011\u0011\u0019F!\u0014\u0003!QKW.Z8vi\u0016C8-\u001a9uS>t\u0017!\u0005;j[\u0016|W\u000f^#yiJ\f7\r^8sA\u0005Q!/\u001e8Qe><'/Y7\u0015\u0015\tm#q\fB1\u0005K\u0012Y\u0007\u0005\u0003X5\nu\u0003#\u0002\u0018\u0002&\u0005m\u0006bBA\u0006+\u0001\u0007\u0011Q\u0002\u0005\b\u0005G*\u0002\u0019AA\u0017\u0003%i\u0017-\u001b8DY\u0006\u001c8\u000fC\u0004\u0003hU\u0001\rA!\u001b\u0002\t\u0005\u0014xm\u001d\t\u0007\u0003o\n\t)!\f\t\u000f\t5T\u00031\u0001\u0002~\u0006i1/\u0019<fa>Lg\u000e\u001e)bi\"\f!cZ3u\u00072,8\u000f^3s\u001fZ,'O^5foV\u0011!1\u000f\t\u0005/j\u0013)\bE\u0002p\u0005oJAA!\u001f\u0002\b\ty1\t\\;ti\u0016\u0014xJ^3sm&,w/A\nhKRTuNY'b]\u0006<WM]\"p]\u001aLw-\u0006\u0002\u0003\u0000A!qK\u0017BA!\u0011\u0011\u0019I!&\u000e\u0005\t\u0015%\u0002\u0002BD\u0005\u0013\u000bQbY8oM&<WO]1uS>t'\u0002\u0002BF\u0005\u001b\u000bQA\u001a7j].TAAa$\u0003\u0012\u00061\u0011\r]1dQ\u0016T!Aa%\u0002\u0007=\u0014x-\u0003\u0003\u0003\u0018\n\u0015%!D\"p]\u001aLw-\u001e:bi&|g.\u0001\u000bd_:4\u0017nZ;sCRLwN\u001c$s_6l\u0015\r\u001d\u000b\u0005\u0005\u0003\u0013i\nC\u0004\u0003 b\u0001\rA!)\u0002\rY\fG.^3t!!\tyCa)\u0002.\u00055\u0012\u0002\u0002BS\u0003w\u00111!T1q\u0003=AE\u000f\u001e9GY&t7n\u00117jK:$\bC\u0001\u001b\u001b'\tQR\u0006\u0006\u0002\u0003*\u0006a1M]3bi\u0016,fn]1gKR!!1\u0017B])\u00151'Q\u0017B\\\u0011\u0015yE\u0004q\u0001Q\u0011\u0015yF\u0004q\u0001a\u0011\u0015\tE\u00041\u0001C\u0003\u0019\u0019'/Z1uKR!!q\u0018Bq)\u0019\u0011\tM!8\u0003`B9!1\u0019Bl\u0003[1g\u0002\u0002Bc\u0005'tAAa2\u0003N:\u0019aO!3\n\u0005\t-\u0017\u0001B2biNLAAa4\u0003R\u0006!A-\u0019;b\u0015\t\u0011Y-\u0003\u0003\u0002\u0000\tU'\u0002\u0002Bh\u0005#LAA!7\u0003\\\naa+\u00197jI\u0006$X\r\u001a(fY*!\u0011q\u0010Bk\u0011\u0015yU\u0004q\u0001Q\u0011\u0015yV\u0004q\u0001a\u0011\u0015\tU\u00041\u0001C\u0001")
public class HttpFlinkClient
implements FlinkClient,
LazyLogging {
    private final FlinkConfig config;
    private final Uri flinkUrl;
    private final SttpBackend<Future, Object> backend;
    private final ExecutionContext ec;
    private final DeeplyCheckingExceptionExtractor<TimeoutException> pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static Validated<NonEmptyList<String>, HttpFlinkClient> create(FlinkConfig flinkConfig, SttpBackend<Future, Object> sttpBackend, ExecutionContext executionContext) {
        return HttpFlinkClient$.MODULE$.create(flinkConfig, sttpBackend, executionContext);
    }

    public static HttpFlinkClient createUnsafe(FlinkConfig flinkConfig, SttpBackend<Future, Object> sttpBackend, ExecutionContext executionContext) {
        return HttpFlinkClient$.MODULE$.createUnsafe(flinkConfig, sttpBackend, executionContext);
    }

    private Logger logger$lzycompute() {
        HttpFlinkClient httpFlinkClient = this;
        synchronized (httpFlinkClient) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public Future<flinkRestModel.JarFile> uploadJarFileIfNotExists(File jarFile) {
        return this.checkThatJarWithNameExists(jarFile.getName()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                flinkRestModel.JarFile file = (flinkRestModel.JarFile)some.value();
                future = Future$.MODULE$.successful((Object)file);
            } else if (None$.MODULE$.equals(option)) {
                future = this.uploadJar(jarFile).map((Function1 & Serializable & scala.Serializable)id -> new flinkRestModel.JarFile((String)id, jarFile.getName()), $this.ec);
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, this.ec);
    }

    private Future<Option<flinkRestModel.JarFile>> checkThatJarWithNameExists(String jarName) {
        return ((Future)sttp.client3.package$.MODULE$.basicRequest().get(this.flinkUrl.addPath("jars", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).response(package$.MODULE$.asJson(flinkRestModel$JarsResponse$.MODULE$.decodeJarsResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).map((Function1 & Serializable & scala.Serializable)x$1 -> ((LinearSeqOptimized)x$1.files().toList().flatten((Function1)Predef$.MODULE$.$conforms())).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HttpFlinkClient.$anonfun$checkThatJarWithNameExists$3(jarName, x$2))), this.ec);
    }

    public Future<String> uploadJar(File jarFile) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Uploading new jar: {}", new Object[]{jarFile.getAbsolutePath()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return ((Future)sttp.client3.package$.MODULE$.basicRequest().post(this.flinkUrl.addPath("jars", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"upload"}))).multipartBody(sttp.client3.package$.MODULE$.multipartFile("jarfile", jarFile).contentType("application/x-java-archive"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Part[0])).response(package$.MODULE$.asJson(flinkRestModel$UploadJarResponse$.MODULE$.decodeUploadJarResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).map((Function1 & Serializable & scala.Serializable)file -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Uploaded jar to {}", new Object[]{file});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return new File(file.filename()).getName();
        }, this.ec).recoverWith(HttpClientErrorHandler$.MODULE$.recoverWithMessage("upload Nussnknacker jar to Flink", HttpClientErrorHandler$.MODULE$.recoverWithMessage$default$2()), this.ec);
    }

    @Override
    public Future<BoxedUnit> deleteJarIfExists(String jarFileName) {
        return this.checkThatJarWithNameExists(jarFileName).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                flinkRestModel.JarFile file = (flinkRestModel.JarFile)some.value();
                future = this.deleteJar(file.id()).recover((PartialFunction)new scala.Serializable(this, jarFileName){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HttpFlinkClient $outer;
                    private final String jarFileName$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        BoxedUnit boxedUnit;
                        A1 A1 = x1;
                        if (this.$outer.logger().underlying().isWarnEnabled()) {
                            this.$outer.logger().underlying().warn(new StringBuilder(22).append("Failed to delete jar: ").append(this.jarFileName$1).toString(), A1);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        return (B1)boxedUnit2;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        boolean bl = true;
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.jarFileName$1 = jarFileName$1;
                    }
                }, $this.ec);
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("{} does not exist, not removing", new Object[]{jarFileName});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, this.ec);
    }

    private Future<BoxedUnit> deleteJar(String jarId) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Delete jar id: {}", new Object[]{jarId});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Option option = HttpClientErrorHandler$.MODULE$.handleUnitResponse$default$2();
        return ((Future)sttp.client3.package$.MODULE$.basicRequest().delete(this.flinkUrl.addPath("jars", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{jarId}))).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> HttpClientErrorHandler$.MODULE$.handleUnitResponse("delete jar", option, response), this.ec).recoverWith(HttpClientErrorHandler$.MODULE$.recoverWithMessage("delete jar", HttpClientErrorHandler$.MODULE$.recoverWithMessage$default$2()), this.ec);
    }

    @Override
    public Future<WithDataFreshnessStatus<List<flinkRestModel.JobOverview>>> findJobsByName(String jobName, DataFreshnessPolicy freshnessPolicy) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Checking fetching scenario {} state", new Object[]{jobName});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return ((Future)sttp.client3.package$.MODULE$.basicRequest().readTimeout((Duration)this.config.scenarioStateRequestTimeout()).get(this.flinkUrl.addPath("jobs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"overview"}))).response(package$.MODULE$.asJson(flinkRestModel$JobsResponse$.MODULE$.decodeJobsResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).map((Function1 & Serializable & scala.Serializable)jobs -> ((List)((SeqLike)jobs.jobs().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)HttpFlinkClient.$anonfun$findJobsByName$3(jobName, x$3)))).sortBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.last$minusmodification()), (Ordering)Ordering.Long$.MODULE$)).reverse(), this.ec).map((Function1 & Serializable & scala.Serializable)value -> WithDataFreshnessStatus$.MODULE$.fresh(value), this.ec).recoverWith(HttpClientErrorHandler$.MODULE$.recoverWithMessage("retrieve Flink jobs", HttpClientErrorHandler$.MODULE$.recoverWithMessage$default$2()), this.ec);
    }

    @Override
    public Future<flinkRestModel.ExecutionConfig> getJobConfig(String jobId) {
        return ((Future)sttp.client3.package$.MODULE$.basicRequest().get(this.flinkUrl.addPath("jobs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{jobId, "config"}))).response(package$.MODULE$.asJson(flinkRestModel$JobConfig$.MODULE$.decodeJobConfig(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.execution$minusconfig(), this.ec);
    }

    public Future<SavepointResult> waitForSavepoint(String jobId, String savepointId, long timeoutLeft) {
        long start = System.currentTimeMillis();
        if (timeoutLeft <= 0L) {
            return Future$.MODULE$.failed((Throwable)new Exception(new StringBuilder(54).append("Failed to complete savepoint in time for ").append(new ExternalDeploymentId(jobId)).append(" and trigger ").append(savepointId).toString()));
        }
        return ((Future)sttp.client3.package$.MODULE$.basicRequest().get(this.flinkUrl.addPath("jobs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{jobId, "savepoints", savepointId}))).response(package$.MODULE$.asJson(flinkRestModel$GetSavepointStatusResponse$.MODULE$.decodeGetSavepointStatusResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).flatMap((Function1 & Serializable & scala.Serializable)resp -> {
            Future future;
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Waiting for savepoint {} of {}, got response: {}", new Object[]{savepointId, new ExternalDeploymentId(jobId), resp});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (resp.isCompletedSuccessfully()) {
                BoxedUnit boxedUnit2;
                String location = (String)resp.operation().flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.location()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Savepoint {} for {} finished in {}", new Object[]{savepointId, new ExternalDeploymentId(jobId), location});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                future = Future$.MODULE$.successful((Object)new SavepointResult(location));
            } else if (resp.isFailed()) {
                future = Future$.MODULE$.failed((Throwable)new RuntimeException(new StringBuilder(30).append("Failed to complete savepoint: ").append(resp.operation()).toString()));
            } else {
                Thread.sleep(1000L);
                future = this.waitForSavepoint(jobId, savepointId, timeoutLeft - (System.currentTimeMillis() - start));
            }
            return future;
        }, this.ec);
    }

    public long waitForSavepoint$default$3() {
        return this.config.jobManagerTimeout().toMillis();
    }

    @Override
    public Future<BoxedUnit> cancel(String deploymentId) {
        Option option = HttpClientErrorHandler$.MODULE$.handleUnitResponse$default$2();
        return ((Future)sttp.client3.package$.MODULE$.basicRequest().patch(this.flinkUrl.addPath("jobs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{deploymentId}))).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> HttpClientErrorHandler$.MODULE$.handleUnitResponse("cancel scenario", option, response), this.ec).recoverWith(HttpClientErrorHandler$.MODULE$.recoverWithMessage("cancel scenario", HttpClientErrorHandler$.MODULE$.recoverWithMessage$default$2()), this.ec);
    }

    @Override
    public Future<SavepointResult> makeSavepoint(String deploymentId, Option<String> savepointDir) {
        RequestT savepointRequest = sttp.client3.package$.MODULE$.basicRequest().post(this.flinkUrl.addPath("jobs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{deploymentId, "savepoints"}))).body((Object)new flinkRestModel.SavepointTriggerRequest(savepointDir, false), package$.MODULE$.circeBodySerializer(flinkRestModel$SavepointTriggerRequest$.MODULE$.encodeSavepointTriggerRequest(), package$.MODULE$.circeBodySerializer$default$2()));
        return this.processSavepointRequest(deploymentId, (RequestT<Object, Either<String, String>, Object>)savepointRequest, "make savepoint");
    }

    @Override
    public Future<SavepointResult> stop(String deploymentId, Option<String> savepointDir) {
        RequestT stopRequest = sttp.client3.package$.MODULE$.basicRequest().post(this.flinkUrl.addPath("jobs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{deploymentId, "savepoints"}))).body((Object)new flinkRestModel.SavepointTriggerRequest(savepointDir, true), package$.MODULE$.circeBodySerializer(flinkRestModel$SavepointTriggerRequest$.MODULE$.encodeSavepointTriggerRequest(), package$.MODULE$.circeBodySerializer$default$2()));
        return this.processSavepointRequest(deploymentId, (RequestT<Object, Either<String, String>, Object>)stopRequest, "stop scenario");
    }

    private Future<SavepointResult> processSavepointRequest(String deploymentId, RequestT<Object, Either<String, String>, Object> request, String action) {
        return ((Future)request.response(package$.MODULE$.asJson(flinkRestModel$SavepointTriggerResponse$.MODULE$.decodeSavepointTriggerResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).flatMap((Function1 & Serializable & scala.Serializable)response -> this.waitForSavepoint(deploymentId, response.request$minusid(), this.waitForSavepoint$default$3()), this.ec).recoverWith(HttpClientErrorHandler$.MODULE$.recoverWithMessage(action, HttpClientErrorHandler$.MODULE$.recoverWithMessage$default$2()), this.ec);
    }

    public DeeplyCheckingExceptionExtractor<TimeoutException> pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor() {
        return this.pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor;
    }

    @Override
    public Future<Option<ExternalDeploymentId>> runProgram(File jarFile, String mainClass, List<String> args, Option<String> savepointPath) {
        flinkRestModel.DeployProcessRequest program = new flinkRestModel.DeployProcessRequest(mainClass, savepointPath, FlinkArgsEncodeHack$.MODULE$.prepareProgramArgs(args).mkString(" "), flinkRestModel$DeployProcessRequest$.MODULE$.apply$default$4(), flinkRestModel$DeployProcessRequest$.MODULE$.apply$default$5());
        return this.uploadJarFileIfNotExists(jarFile).flatMap((Function1 & Serializable & scala.Serializable)flinkJarFile -> ((Future)sttp.client3.package$.MODULE$.basicRequest().post($this.flinkUrl.addPath("jars", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{flinkJarFile.id(), "run"}))).body((Object)program, package$.MODULE$.circeBodySerializer(flinkRestModel$DeployProcessRequest$.MODULE$.encodeDeployProcessRequest(), package$.MODULE$.circeBodySerializer$default$2())).response(package$.MODULE$.asJson(flinkRestModel$RunResponse$.MODULE$.codecForRunResponse(), IsOption$.MODULE$.otherIsNotOption())).send($this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), $this.ec).map((Function1 & Serializable & scala.Serializable)ret -> new Some((Object)new ExternalDeploymentId(ret.jobid())), $this.ec).recover((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpFlinkClient $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Option option = this.$outer.pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor().unapply(A1);
                if (!option.isEmpty()) {
                    BoxedUnit boxedUnit;
                    TimeoutException e = (TimeoutException)option.get();
                    if (this.$outer.logger().underlying().isWarnEnabled()) {
                        this.$outer.logger().underlying().warn("TimeoutException occurred while waiting for deploy result. Recovering with Future.successful...", (Throwable)e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = None$.MODULE$;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                Option option = this.$outer.pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor().unapply(throwable);
                boolean bl = !option.isEmpty();
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, $this.ec).recoverWith(HttpClientErrorHandler$.MODULE$.recoverWithMessage("deploy scenario", HttpClientErrorHandler$.MODULE$.recoverWithMessage$default$2()), $this.ec), this.ec);
    }

    @Override
    public Future<flinkRestModel.ClusterOverview> getClusterOverview() {
        return ((Future)sttp.client3.package$.MODULE$.basicRequest().get(this.flinkUrl.addPath("overview", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).response(package$.MODULE$.asJson(flinkRestModel$ClusterOverview$.MODULE$.decodeClusterOverview(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec);
    }

    @Override
    public Future<Configuration> getJobManagerConfig() {
        return ((Future)sttp.client3.package$.MODULE$.basicRequest().get(this.flinkUrl.addPath("jobmanager", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"config"}))).response(package$.MODULE$.asJson(Decoder$.MODULE$.decodeList(flinkRestModel$KeyValueEntry$.MODULE$.decodeKeyValueEntry()), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).map((Function1 & Serializable & scala.Serializable)list -> this.configurationFromMap((Map<String, String>)((TraversableOnce)list.map((Function1 & Serializable & scala.Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.key()), (Object)e.value()), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())), this.ec);
    }

    /*
     * WARNING - void declaration
     */
    private Configuration configurationFromMap(Map<String, String> values) {
        void var2_2;
        Configuration configuration = new Configuration();
        values.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HttpFlinkClient.$anonfun$configurationFromMap$1(configuration, x0$1);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public static final /* synthetic */ boolean $anonfun$checkThatJarWithNameExists$3(String jarName$1, flinkRestModel.JarFile x$2) {
        String string = x$2.name();
        String string2 = jarName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findJobsByName$3(String jobName$1, flinkRestModel.JobOverview x$3) {
        String string = x$3.name();
        String string2 = jobName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$configurationFromMap$1(Configuration configuration$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        configuration$1.setString(k, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public HttpFlinkClient(FlinkConfig config, Uri flinkUrl, SttpBackend<Future, Object> backend, ExecutionContext ec) {
        this.config = config;
        this.flinkUrl = flinkUrl;
        this.backend = backend;
        this.ec = ec;
        LazyLogging.$init$((LazyLogging)this);
        this.pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor = DeeplyCheckingExceptionExtractor$.MODULE$.forClass(ClassTag$.MODULE$.apply(TimeoutException.class));
    }
}

