/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.management;

import cats.Applicative;
import cats.Functor;
import cats.Monad;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.implicits$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import pl.touk.nussknacker.engine.api.StreamMetaData;
import pl.touk.nussknacker.engine.api.TypeSpecificData;
import pl.touk.nussknacker.engine.api.process.ProcessName;
import pl.touk.nussknacker.engine.canonicalgraph.CanonicalProcess;
import pl.touk.nussknacker.engine.deployment.ExternalDeploymentId;
import pl.touk.nussknacker.engine.management.FlinkSlotsChecker$NotEnoughSlotsException$;
import pl.touk.nussknacker.engine.management.rest.FlinkClient;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t]g\u0001\u0002 @\u0001)C\u0001b\u0017\u0001\u0003\u0002\u0003\u0006I\u0001\u0018\u0005\tE\u0002\u0011\t\u0011)A\u0006G\")\u0011\u000e\u0001C\u0001U\")\u0001\u000f\u0001C\u0001c\"9\u0011\u0011\u0006\u0001\u0005\n\u0005-\u0002b\u0002BV\u0001\u0011%!Q\u0016\u0005\b\u0005g\u0003A\u0011\u0002B[\u000f\u001d\t9f\u0010E\u0001\u000332aAP \t\u0002\u0005m\u0003BB5\n\t\u0003\tiF\u0002\u0004\u0002`%\u0001\u0015\u0011\r\u0005\u000b\u0003kZ!Q3A\u0005\u0002\u0005]\u0004BCA@\u0017\tE\t\u0015!\u0003\u0002z!Q\u0011\u0011Q\u0006\u0003\u0016\u0004%\t!a\u001e\t\u0015\u0005\r5B!E!\u0002\u0013\tI\b\u0003\u0006\u0002\u0006.\u0011)\u001a!C\u0001\u0003\u000fC!B!\u0005\f\u0005#\u0005\u000b\u0011BAE\u0011\u0019I7\u0002\"\u0001\u0003\u0014!I\u0011\u0011U\u0006\u0002\u0002\u0013\u0005!Q\u0004\u0005\n\u0003S[\u0011\u0013!C\u0001\u0003WC\u0011\"!1\f#\u0003%\t!a+\t\u0013\t\u00152\"%A\u0005\u0002\t\u001d\u0002\"CAb\u0017\u0005\u0005I\u0011IAc\u0011%\t9nCA\u0001\n\u0003\t9\bC\u0005\u0002Z.\t\t\u0011\"\u0001\u0003,!I\u0011q]\u0006\u0002\u0002\u0013\u0005\u0013\u0011\u001e\u0005\n\u0003o\\\u0011\u0011!C\u0001\u0005_A\u0011Ba\u0001\f\u0003\u0003%\tE!\u0002\t\u0013\t-1\"!A\u0005B\tMra\u0002B\u001c\u0013!\u0005!\u0011\b\u0004\b\u0003?J\u0001\u0012\u0001B\u001e\u0011\u0019Iw\u0004\"\u0001\u0003>!9!qH\u0010\u0005\u0002\t\u0005\u0003\"\u0003B ?\u0005\u0005I\u0011\u0011B.\u0011%\u0011\u0019gHA\u0001\n\u0003\u0013)\u0007C\u0005\u0003x}\t\t\u0011\"\u0003\u0003z\u00191\u0011QR\u0005A\u0003\u001fC!\"!%&\u0005+\u0007I\u0011AA<\u0011)\t\u0019*\nB\tB\u0003%\u0011\u0011\u0010\u0005\u000b\u0003++#Q3A\u0005\u0002\u0005]\u0004BCALK\tE\t\u0015!\u0003\u0002z!1\u0011.\nC\u0001\u00033Cq!a(&\t\u0003\t9\bC\u0005\u0002\"\u0016\n\t\u0011\"\u0001\u0002$\"I\u0011\u0011V\u0013\u0012\u0002\u0013\u0005\u00111\u0016\u0005\n\u0003\u0003,\u0013\u0013!C\u0001\u0003WC\u0011\"a1&\u0003\u0003%\t%!2\t\u0013\u0005]W%!A\u0005\u0002\u0005]\u0004\"CAmK\u0005\u0005I\u0011AAn\u0011%\t9/JA\u0001\n\u0003\nI\u000fC\u0005\u0002x\u0016\n\t\u0011\"\u0001\u0002z\"I!1A\u0013\u0002\u0002\u0013\u0005#Q\u0001\u0005\n\u0005\u000f)\u0013\u0011!C!\u0005\u0013A\u0011Ba\u0003&\u0003\u0003%\tE!\u0004\b\u0013\t\u0005\u0015\"!A\t\u0002\t\re!CAG\u0013\u0005\u0005\t\u0012\u0001BC\u0011\u0019I\u0007\b\"\u0001\u0003\u0014\"I!q\u0001\u001d\u0002\u0002\u0013\u0015#\u0011\u0002\u0005\n\u0005\u007fA\u0014\u0011!CA\u0005+C\u0011Ba\u00199\u0003\u0003%\tIa'\t\u0013\t]\u0004(!A\u0005\n\te$!\u0005$mS:\\7\u000b\\8ug\u000eCWmY6fe*\u0011\u0001)Q\u0001\u000b[\u0006t\u0017mZ3nK:$(B\u0001\"D\u0003\u0019)gnZ5oK*\u0011A)R\u0001\f]V\u001c8o\u001b8bG.,'O\u0003\u0002G\u000f\u0006!Ao\\;l\u0015\u0005A\u0015A\u00019m\u0007\u0001\u00192\u0001A&R!\tau*D\u0001N\u0015\u0005q\u0015!B:dC2\f\u0017B\u0001)N\u0005\u0019\te.\u001f*fMB\u0011!+W\u0007\u0002'*\u0011A+V\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003-^\u000b\u0001\u0002^=qKN\fg-\u001a\u0006\u00021\u0006\u00191m\\7\n\u0005i\u001b&a\u0003'bufdunZ4j]\u001e\faa\u00197jK:$\bCA/a\u001b\u0005q&BA0@\u0003\u0011\u0011Xm\u001d;\n\u0005\u0005t&a\u0003$mS:\\7\t\\5f]R\f!!Z2\u0011\u0005\u0011<W\"A3\u000b\u0005\u0019l\u0015AC2p]\u000e,(O]3oi&\u0011\u0001.\u001a\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\fa\u0001P5oSRtDCA6p)\tag\u000e\u0005\u0002n\u00015\tq\bC\u0003c\u0007\u0001\u000f1\rC\u0003\\\u0007\u0001\u0007A,\u0001\u0014dQ\u0016\u001c7NU3rk&\u0014X\rZ*m_R\u001cX\t_2fK\u0012\fe/Y5mC\ndWm\u00157piN$BA\u001d=\u0002\u0002A\u0019Am];\n\u0005Q,'A\u0002$viV\u0014X\r\u0005\u0002Mm&\u0011q/\u0014\u0002\u0005+:LG\u000fC\u0003z\t\u0001\u0007!0\u0001\tdC:|g.[2bYB\u0013xnY3tgB\u00111P`\u0007\u0002y*\u0011Q0Q\u0001\u000fG\u0006twN\\5dC2<'/\u00199i\u0013\tyHP\u0001\tDC:|g.[2bYB\u0013xnY3tg\"9\u00111\u0001\u0003A\u0002\u0005\u0015\u0011\u0001G2veJ,g\u000e\u001e7z\t\u0016\u0004Hn\\=fI*{'m]%egB1\u0011qAA\f\u0003;qA!!\u0003\u0002\u00149!\u00111BA\t\u001b\t\tiAC\u0002\u0002\u0010%\u000ba\u0001\u0010:p_Rt\u0014\"\u0001(\n\u0007\u0005UQ*A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00111\u0004\u0002\u0005\u0019&\u001cHOC\u0002\u0002\u00165\u0003B!a\b\u0002&5\u0011\u0011\u0011\u0005\u0006\u0004\u0003G\t\u0015A\u00033fa2|\u00170\\3oi&!\u0011qEA\u0011\u0005Q)\u0005\u0010^3s]\u0006dG)\u001a9m_flWM\u001c;JI\u0006)B-\u001a;fe6Lg.Z*m_R\u001c()\u00197b]\u000e,GCBA\u0017\u0005O\u0013I\u000b\u0005\u0005\u00020\u0005e\u0012QHA \u001b\t\t\tD\u0003\u0003\u00024\u0005U\u0012\u0001\u00023bi\u0006T!!a\u000e\u0002\t\r\fGo]\u0005\u0005\u0003w\t\tDA\u0004PaRLwN\u001c+\u0011\u0005\u0011\u001c\bcAA!K9\u0019\u00111\t\u0005\u000f\t\u0005\u0015\u0013Q\u000b\b\u0005\u0003\u000f\n\u0019F\u0004\u0003\u0002J\u0005Ec\u0002BA&\u0003\u001frA!a\u0003\u0002N%\t\u0001*\u0003\u0002G\u000f&\u0011A)R\u0005\u0003\u0005\u000eK!\u0001Q!\u0002#\u0019c\u0017N\\6TY>$8o\u00115fG.,'\u000f\u0005\u0002n\u0013M\u0011\u0011b\u0013\u000b\u0003\u00033\u0012qCT8u\u000b:|Wo\u001a5TY>$8/\u0012=dKB$\u0018n\u001c8\u0014\u000f-\t\u0019'!\u001b\u0002pA!\u0011qAA3\u0013\u0011\t9'a\u0007\u00031%cG.Z4bY\u0006\u0013x-^7f]R,\u0005pY3qi&|g\u000eE\u0002M\u0003WJ1!!\u001cN\u0005\u001d\u0001&o\u001c3vGR\u00042\u0001TA9\u0013\r\t\u0019(\u0014\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u000fCZ\f\u0017\u000e\\1cY\u0016\u001cFn\u001c;t+\t\tI\bE\u0002M\u0003wJ1!! N\u0005\rIe\u000e^\u0001\u0010CZ\f\u0017\u000e\\1cY\u0016\u001cFn\u001c;tA\u0005QAo\u001c;bYNcw\u000e^:\u0002\u0017Q|G/\u00197TY>$8\u000fI\u0001\rg2|Go\u001d\"bY\u0006t7-Z\u000b\u0003\u0003\u0013\u00032!a#&\u001b\u0005I!\u0001D*m_R\u001c()\u00197b]\u000e,7CB\u0013L\u0003S\ny'\u0001\u0005sK2,\u0017m]3e\u0003%\u0011X\r\\3bg\u0016$\u0007%A\u0005bY2|7-\u0019;fI\u0006Q\u0011\r\u001c7pG\u0006$X\r\u001a\u0011\u0015\r\u0005%\u00151TAO\u0011\u001d\t\tJ\u000ba\u0001\u0003sBq!!&+\u0001\u0004\tI(A\u0003wC2,X-\u0001\u0003d_BLHCBAE\u0003K\u000b9\u000bC\u0005\u0002\u00122\u0002\n\u00111\u0001\u0002z!I\u0011Q\u0013\u0017\u0011\u0002\u0003\u0007\u0011\u0011P\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tiK\u000b\u0003\u0002z\u0005=6FAAY!\u0011\t\u0019,!0\u000e\u0005\u0005U&\u0002BA\\\u0003s\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005mV*\u0001\u0006b]:|G/\u0019;j_:LA!a0\u00026\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a2\u0011\t\u0005%\u00171[\u0007\u0003\u0003\u0017TA!!4\u0002P\u0006!A.\u00198h\u0015\t\t\t.\u0001\u0003kCZ\f\u0017\u0002BAk\u0003\u0017\u0014aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003;\f\u0019\u000fE\u0002M\u0003?L1!!9N\u0005\r\te.\u001f\u0005\n\u0003K\f\u0014\u0011!a\u0001\u0003s\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAv!\u0019\ti/a=\u0002^6\u0011\u0011q\u001e\u0006\u0004\u0003cl\u0015AC2pY2,7\r^5p]&!\u0011Q_Ax\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005m(\u0011\u0001\t\u0004\u0019\u0006u\u0018bAA\u0000\u001b\n9!i\\8mK\u0006t\u0007\"CAsg\u0005\u0005\t\u0019AAo\u0003!A\u0017m\u001d5D_\u0012,GCAA=\u0003!!xn\u0015;sS:<GCAAd\u0003\u0019)\u0017/^1mgR!\u00111 B\b\u0011%\t)ONA\u0001\u0002\u0004\ti.A\u0007tY>$8OQ1mC:\u001cW\r\t\u000b\t\u0005+\u00119B!\u0007\u0003\u001cA\u0019\u00111R\u0006\t\u000f\u0005U$\u00031\u0001\u0002z!9\u0011\u0011\u0011\nA\u0002\u0005e\u0004bBAC%\u0001\u0007\u0011\u0011\u0012\u000b\t\u0005+\u0011yB!\t\u0003$!I\u0011QO\n\u0011\u0002\u0003\u0007\u0011\u0011\u0010\u0005\n\u0003\u0003\u001b\u0002\u0013!a\u0001\u0003sB\u0011\"!\"\u0014!\u0003\u0005\r!!#\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!\u0011\u0006\u0016\u0005\u0003\u0013\u000by\u000b\u0006\u0003\u0002^\n5\u0002\"CAs3\u0005\u0005\t\u0019AA=)\u0011\tYP!\r\t\u0013\u0005\u00158$!AA\u0002\u0005uG\u0003BA~\u0005kA\u0011\"!:\u001e\u0003\u0003\u0005\r!!8\u0002/9{G/\u00128pk\u001eD7\u000b\\8ug\u0016C8-\u001a9uS>t\u0007cAAF?M!qdSA8)\t\u0011I$A\u0003baBd\u0017\u0010\u0006\u0004\u0003\u0016\t\r#\u0011\f\u0005\b\u0005\u000b\n\u0003\u0019\u0001B$\u0003=\u0019G.^:uKJ|e/\u001a:wS\u0016<\b\u0003\u0002B%\u0005'rAAa\u0013\u0003P9!\u00111\tB'\u0013\tyv(C\u0002\u0003Ry\u000baB\u001a7j].\u0014Vm\u001d;N_\u0012,G.\u0003\u0003\u0003V\t]#aD\"mkN$XM](wKJ4\u0018.Z<\u000b\u0007\tEc\fC\u0004\u0002\u0006\u0006\u0002\r!!#\u0015\u0011\tU!Q\fB0\u0005CBq!!\u001e#\u0001\u0004\tI\bC\u0004\u0002\u0002\n\u0002\r!!\u001f\t\u000f\u0005\u0015%\u00051\u0001\u0002\n\u00069QO\\1qa2LH\u0003\u0002B4\u0005g\u0002R\u0001\u0014B5\u0005[J1Aa\u001bN\u0005\u0019y\u0005\u000f^5p]BIAJa\u001c\u0002z\u0005e\u0014\u0011R\u0005\u0004\u0005cj%A\u0002+va2,7\u0007C\u0005\u0003v\r\n\t\u00111\u0001\u0003\u0016\u0005\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005w\u0002B!!3\u0003~%!!qPAf\u0005\u0019y%M[3di\u0006a1\u000b\\8ug\n\u000bG.\u00198dKB\u0019\u00111\u0012\u001d\u0014\u000ba\u00129)a\u001c\u0011\u0015\t%%qRA=\u0003s\nI)\u0004\u0002\u0003\f*\u0019!QR'\u0002\u000fI,h\u000e^5nK&!!\u0011\u0013BF\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0005\u0007#b!!#\u0003\u0018\ne\u0005bBAIw\u0001\u0007\u0011\u0011\u0010\u0005\b\u0003+[\u0004\u0019AA=)\u0011\u0011iJ!*\u0011\u000b1\u0013IGa(\u0011\u000f1\u0013\t+!\u001f\u0002z%\u0019!1U'\u0003\rQ+\b\u000f\\33\u0011%\u0011)\bPA\u0001\u0002\u0004\tI\tC\u0003z\u000b\u0001\u0007!\u0010C\u0004\u0002\u0004\u0015\u0001\r!!\u0002\u0002KMdw\u000e^:UQ\u0006$x+\u001b7m\u0005\u0016\u0014V\r\\3bg\u0016$\u0017I\u001a;fe*{'mQ1oG\u0016dG\u0003\u0002BX\u0005c\u0003B\u0001Z:\u0002z!9\u00111\u0001\u0004A\u0002\u0005\u0015\u0011\u0001K:m_R\u001c\u0018\t\u001c7pG\u0006$X\r\u001a\"z!J|7-Z:t)\"\fGoV5m\u0005\u0016$U\r\u001d7ps\u0016$GC\u0002BX\u0005o\u00139\rC\u0004\u0003:\u001e\u0001\rAa/\u0002\rM$(/Z1n!\u0011\u0011iLa1\u000e\u0005\t}&b\u0001Ba\u0003\u0006\u0019\u0011\r]5\n\t\t\u0015'q\u0018\u0002\u000f'R\u0014X-Y7NKR\fG)\u0019;b\u0011\u001d\u0011Im\u0002a\u0001\u0005\u0017\f1\u0002\u001d:pG\u0016\u001c8OT1nKB!!Q\u001aBj\u001b\t\u0011yM\u0003\u0003\u0003R\n}\u0016a\u00029s_\u000e,7o]\u0005\u0005\u0005+\u0014yMA\u0006Qe>\u001cWm]:OC6,\u0007")
public class FlinkSlotsChecker
implements LazyLogging {
    private final FlinkClient client;
    private final ExecutionContext ec;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        FlinkSlotsChecker flinkSlotsChecker = this;
        synchronized (flinkSlotsChecker) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public Future<BoxedUnit> checkRequiredSlotsExceedAvailableSlots(CanonicalProcess canonicalProcess, List<ExternalDeploymentId> currentlyDeployedJobsIds) {
        OptionT collectedSlotsCheckInputs = this.determineSlotsBalance(canonicalProcess, currentlyDeployedJobsIds).flatMap((Function1 & Serializable & scala.Serializable)slotsBalance -> new OptionT((Object)$this.client.getClusterOverview().map((Function1 & Serializable & scala.Serializable)x$1 -> Option$.MODULE$.apply(x$1), $this.ec)).map((Function1 & Serializable & scala.Serializable)clusterOverview -> new Tuple2(slotsBalance, clusterOverview), (Functor)implicits$.MODULE$.catsStdInstancesForFuture($this.ec)), (Monad)implicits$.MODULE$.catsStdInstancesForFuture(this.ec));
        OptionT checkResult = new OptionT((Object)((Future)collectedSlotsCheckInputs.value()).recover((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkSlotsChecker $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Option option = NonFatal$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    BoxedUnit boxedUnit;
                    Throwable ex = (Throwable)option.get();
                    if (this.$outer.logger().underlying().isWarnEnabled()) {
                        this.$outer.logger().underlying().warn("Error during collecting inputs needed for available slots checking. Slots checking will be omitted", ex);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = None$.MODULE$;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                Option option = NonFatal$.MODULE$.unapply(throwable);
                boolean bl = !option.isEmpty();
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.ec)).map((Function1 & Serializable & scala.Serializable)collectedInputs -> {
            Tuple2 tuple2 = collectedInputs;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SlotsBalance slotsBalance = (SlotsBalance)tuple2._1();
            flinkRestModel.ClusterOverview clusterOverview = (flinkRestModel.ClusterOverview)tuple2._2();
            Tuple3 tuple3 = new Tuple3((Object)tuple2, (Object)slotsBalance, (Object)clusterOverview);
            Tuple3 tuple32 = tuple3;
            Tuple2 x$2 = (Tuple2)tuple32._1();
            SlotsBalance slotsBalance2 = (SlotsBalance)tuple32._2();
            flinkRestModel.ClusterOverview clusterOverview2 = (flinkRestModel.ClusterOverview)tuple32._3();
            return new Tuple2(collectedInputs, (Object)x$2);
        }, (Functor)implicits$.MODULE$.catsStdInstancesForFuture(this.ec)).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$4;
            if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
                throw new MatchError((Object)tuple22);
            }
            SlotsBalance slotsBalance = (SlotsBalance)tuple2._1();
            flinkRestModel.ClusterOverview clusterOverview = (flinkRestModel.ClusterOverview)tuple2._2();
            OptionT optionT = new OptionT((Object)(slotsBalance.value() > clusterOverview.slots$minusavailable() ? Future$.MODULE$.failed((Throwable)FlinkSlotsChecker$NotEnoughSlotsException$.MODULE$.apply(clusterOverview, slotsBalance)) : Future$.MODULE$.successful((Object)Option$.MODULE$.apply((Object)BoxedUnit.UNIT)))).map((Function1 & Serializable & scala.Serializable)_ -> {
                FlinkSlotsChecker.$anonfun$checkRequiredSlotsExceedAvailableSlots$6(_);
                return BoxedUnit.UNIT;
            }, (Functor)implicits$.MODULE$.catsStdInstancesForFuture($this.ec));
            return optionT;
        }, (Monad)implicits$.MODULE$.catsStdInstancesForFuture(this.ec));
        return ((Future)checkResult.value()).map((Function1 & Serializable & scala.Serializable)x$5 -> {
            FlinkSlotsChecker.$anonfun$checkRequiredSlotsExceedAvailableSlots$7(x$5);
            return BoxedUnit.UNIT;
        }, this.ec);
    }

    private OptionT<Future, SlotsBalance> determineSlotsBalance(CanonicalProcess canonicalProcess, List<ExternalDeploymentId> currentlyDeployedJobsIds) {
        OptionT optionT;
        TypeSpecificData typeSpecificData = canonicalProcess.metaData().typeSpecificData();
        if (typeSpecificData instanceof StreamMetaData) {
            StreamMetaData streamMetaData = (StreamMetaData)typeSpecificData;
            Future requiredSlotsFuture = this.slotsThatWillBeReleasedAfterJobCancel(currentlyDeployedJobsIds).flatMap((Function1 & Serializable & scala.Serializable)releasedSlots -> FlinkSlotsChecker.$anonfun$determineSlotsBalance$1(this, streamMetaData, canonicalProcess, BoxesRunTime.unboxToInt((Object)releasedSlots)), this.ec);
            optionT = new OptionT((Object)requiredSlotsFuture);
        } else {
            optionT = OptionT$.MODULE$.none((Applicative)implicits$.MODULE$.catsStdInstancesForFuture(this.ec));
        }
        return optionT;
    }

    private Future<Object> slotsThatWillBeReleasedAfterJobCancel(List<ExternalDeploymentId> currentlyDeployedJobsIds) {
        return Future$.MODULE$.sequence((TraversableOnce)currentlyDeployedJobsIds.map((Function1 & Serializable & scala.Serializable)deploymentId -> FlinkSlotsChecker.$anonfun$slotsThatWillBeReleasedAfterJobCancel$1(this, ((ExternalDeploymentId)deploymentId).value()), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom(), this.ec).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)FlinkSlotsChecker.$anonfun$slotsThatWillBeReleasedAfterJobCancel$3(x$7)), this.ec);
    }

    private Future<Object> slotsAllocatedByProcessThatWilBeDeployed(StreamMetaData stream, ProcessName processName) {
        return (Future)stream.parallelism().map((Function1 & Serializable & scala.Serializable)definedParallelism -> Future$.MODULE$.successful((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)definedParallelism)))).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.client.getJobManagerConfig().map((Function1 & Serializable & scala.Serializable)config -> BoxesRunTime.boxToInteger((int)FlinkSlotsChecker.$anonfun$slotsAllocatedByProcessThatWilBeDeployed$3(this, processName, config)), $this.ec));
    }

    public static final /* synthetic */ void $anonfun$checkRequiredSlotsExceedAvailableSlots$6(BoxedUnit _) {
    }

    public static final /* synthetic */ void $anonfun$checkRequiredSlotsExceedAvailableSlots$7(Option x$5) {
    }

    public static final /* synthetic */ Future $anonfun$determineSlotsBalance$1(FlinkSlotsChecker $this, StreamMetaData x2$1, CanonicalProcess canonicalProcess$1, int releasedSlots) {
        return $this.slotsAllocatedByProcessThatWilBeDeployed(x2$1, canonicalProcess$1.metaData().name()).map((Function1 & Serializable & scala.Serializable)allocatedSlots -> Option$.MODULE$.apply((Object)new SlotsBalance(releasedSlots, BoxesRunTime.unboxToInt((Object)allocatedSlots))), $this.ec);
    }

    public static final /* synthetic */ Future $anonfun$slotsThatWillBeReleasedAfterJobCancel$1(FlinkSlotsChecker $this, String deploymentId) {
        return $this.client.getJobConfig(deploymentId).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.job$minusparallelism()), $this.ec);
    }

    public static final /* synthetic */ int $anonfun$slotsThatWillBeReleasedAfterJobCancel$3(List x$7) {
        return BoxesRunTime.unboxToInt((Object)x$7.sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ int $anonfun$slotsAllocatedByProcessThatWilBeDeployed$3(FlinkSlotsChecker $this, ProcessName processName$1, Configuration config) {
        BoxedUnit boxedUnit;
        Integer defaultParallelism = (Integer)config.get(CoreOptions.DEFAULT_PARALLELISM);
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("Not specified parallelism for process: {}, will be used default configured on jobmanager: {}", new Object[]{processName$1, defaultParallelism});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Predef$.MODULE$.Integer2int(defaultParallelism);
    }

    public FlinkSlotsChecker(FlinkClient client, ExecutionContext ec) {
        this.client = client;
        this.ec = ec;
        LazyLogging.$init$((LazyLogging)this);
    }

    public static class NotEnoughSlotsException
    extends IllegalArgumentException
    implements Product,
    scala.Serializable {
        private final int availableSlots;
        private final int totalSlots;
        private final SlotsBalance slotsBalance;

        public int availableSlots() {
            return this.availableSlots;
        }

        public int totalSlots() {
            return this.totalSlots;
        }

        public SlotsBalance slotsBalance() {
            return this.slotsBalance;
        }

        public NotEnoughSlotsException copy(int availableSlots, int totalSlots, SlotsBalance slotsBalance) {
            return new NotEnoughSlotsException(availableSlots, totalSlots, slotsBalance);
        }

        public int copy$default$1() {
            return this.availableSlots();
        }

        public int copy$default$2() {
            return this.totalSlots();
        }

        public SlotsBalance copy$default$3() {
            return this.slotsBalance();
        }

        public String productPrefix() {
            return "NotEnoughSlotsException";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToInteger((int)this.availableSlots());
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this.totalSlots());
                    break;
                }
                case 2: {
                    object = this.slotsBalance();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof NotEnoughSlotsException;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.availableSlots());
            n = Statics.mix((int)n, (int)this.totalSlots());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.slotsBalance()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof NotEnoughSlotsException)) return false;
            boolean bl = true;
            if (!bl) return false;
            NotEnoughSlotsException notEnoughSlotsException = (NotEnoughSlotsException)x$1;
            if (this.availableSlots() != notEnoughSlotsException.availableSlots()) return false;
            if (this.totalSlots() != notEnoughSlotsException.totalSlots()) return false;
            SlotsBalance slotsBalance = this.slotsBalance();
            SlotsBalance slotsBalance2 = notEnoughSlotsException.slotsBalance();
            if (slotsBalance == null) {
                if (slotsBalance2 != null) {
                    return false;
                }
            } else if (!((Object)slotsBalance).equals(slotsBalance2)) return false;
            if (!notEnoughSlotsException.canEqual(this)) return false;
            return true;
        }

        public NotEnoughSlotsException(int availableSlots, int totalSlots, SlotsBalance slotsBalance) {
            this.availableSlots = availableSlots;
            this.totalSlots = totalSlots;
            this.slotsBalance = slotsBalance;
            super(new StringBuilder(72).append("Not enough free slots on Flink cluster. Available slots: ").append(availableSlots).append(", requested: ").append(Math.max(0, slotsBalance.value())).append(". ").append((Object)(slotsBalance.allocated() > 1 ? "Decrease scenario's parallelism or extend Flink cluster resources" : "Extend resources of Flink cluster resources")).toString());
            Product.$init$((Product)this);
        }
    }

    public static class SlotsBalance
    implements Product,
    scala.Serializable {
        private final int released;
        private final int allocated;

        public int released() {
            return this.released;
        }

        public int allocated() {
            return this.allocated;
        }

        public int value() {
            return this.allocated() - this.released();
        }

        public SlotsBalance copy(int released, int allocated) {
            return new SlotsBalance(released, allocated);
        }

        public int copy$default$1() {
            return this.released();
        }

        public int copy$default$2() {
            return this.allocated();
        }

        public String productPrefix() {
            return "SlotsBalance";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Integer n;
            int n2 = x$1;
            switch (n2) {
                case 0: {
                    n = BoxesRunTime.boxToInteger((int)this.released());
                    break;
                }
                case 1: {
                    n = BoxesRunTime.boxToInteger((int)this.allocated());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return n;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SlotsBalance;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.released());
            n = Statics.mix((int)n, (int)this.allocated());
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SlotsBalance)) return false;
            boolean bl = true;
            if (!bl) return false;
            SlotsBalance slotsBalance = (SlotsBalance)x$1;
            if (this.released() != slotsBalance.released()) return false;
            if (this.allocated() != slotsBalance.allocated()) return false;
            if (!slotsBalance.canEqual(this)) return false;
            return true;
        }

        public SlotsBalance(int released, int allocated) {
            this.released = released;
            this.allocated = allocated;
            Product.$init$((Product)this);
        }
    }
}

