/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.management.rest;

import cats.data.NonEmptyList;
import cats.data.Validated;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.circe.Decoder$;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import org.apache.flink.configuration.Configuration;
import pl.touk.nussknacker.engine.api.deployment.DataFreshnessPolicy;
import pl.touk.nussknacker.engine.api.deployment.SavepointResult;
import pl.touk.nussknacker.engine.api.deployment.WithDataFreshnessStatus;
import pl.touk.nussknacker.engine.api.deployment.WithDataFreshnessStatus$;
import pl.touk.nussknacker.engine.deployment.ExternalDeploymentId;
import pl.touk.nussknacker.engine.management.FlinkArgsEncodeHack$;
import pl.touk.nussknacker.engine.management.FlinkConfig;
import pl.touk.nussknacker.engine.management.rest.FlinkClient;
import pl.touk.nussknacker.engine.management.rest.HttpFlinkClient$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$ClusterOverview$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$DeployProcessRequest$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$GetSavepointStatusResponse$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$JarsResponse$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$JobConfig$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$JobDetails$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$JobsResponse$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$KeyValueEntry$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$RunResponse$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$SavepointTriggerRequest$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$SavepointTriggerResponse$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$UploadJarResponse$;
import pl.touk.nussknacker.engine.sttp.HttpClientErrorHandler$;
import pl.touk.nussknacker.engine.sttp.SttpJson$;
import pl.touk.nussknacker.engine.util.exception.DeeplyCheckingExceptionExtractor;
import pl.touk.nussknacker.engine.util.exception.DeeplyCheckingExceptionExtractor$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import sttp.client3.IsOption$;
import sttp.client3.RequestT;
import sttp.client3.SttpBackend;
import sttp.client3.circe.package$;
import sttp.model.Part;
import sttp.model.Uri;

@ScalaSignature(bytes="\u0006\u0001\tMh\u0001B\u0010!\u00015B\u0001B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\"A\u0001\u000b\u0001B\u0001B\u0003-\u0011\u000b\u0003\u0005a\u0001\t\u0005\t\u0015a\u0003b\u0011\u0015!\u0007\u0001\"\u0001f\u0011\u0015a\u0007\u0001\"\u0001n\u0011\u001d\ty\u0002\u0001C\u0005\u0003CAq!a\u0010\u0001\t\u0003\t\t\u0005C\u0004\u0002H\u0001!\t%!\u0013\t\u000f\u0005]\u0003\u0001\"\u0003\u0002Z!9\u0011q\f\u0001\u0005B\u0005\u0005\u0004bBAM\u0001\u0011\u0005\u00131\u0014\u0005\b\u0003W\u0003A\u0011IAW\u0011\u001d\tY\f\u0001C\u0001\u0003{C\u0011\"!9\u0001#\u0003%\t!a9\t\u000f\u0005e\b\u0001\"\u0011\u0002|\"9!\u0011\u0001\u0001\u0005B\t\r\u0001b\u0002B\u0007\u0001\u0011\u0005#q\u0002\u0005\b\u0005+\u0001A\u0011\u0002B\f\u0011%\u0011\u0019\u0005\u0001b\u0001\n\u0013\u0011)\u0005\u0003\u0005\u0003d\u0001\u0001\u000b\u0011\u0002B$\u0011\u001d\u0011)\u0007\u0001C!\u0005OBqAa \u0001\t\u0003\u0012\t\tC\u0004\u0003\f\u0002!\tE!$\t\u000f\t%\u0006\u0001\"\u0003\u0003,\u001e9!q\u0017\u0011\t\u0002\tefAB\u0010!\u0011\u0003\u0011Y\f\u0003\u0004e7\u0011\u0005!Q\u0018\u0005\b\u0005\u007f[B\u0011\u0001Ba\u0011\u001d\u0011Ym\u0007C\u0001\u0005\u001b\u0014q\u0002\u0013;ua\u001ac\u0017N\\6DY&,g\u000e\u001e\u0006\u0003C\t\nAA]3ti*\u00111\u0005J\u0001\u000b[\u0006t\u0017mZ3nK:$(BA\u0013'\u0003\u0019)gnZ5oK*\u0011q\u0005K\u0001\f]V\u001c8o\u001b8bG.,'O\u0003\u0002*U\u0005!Ao\\;l\u0015\u0005Y\u0013A\u00019m\u0007\u0001\u0019B\u0001\u0001\u00185qA\u0011qFM\u0007\u0002a)\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\t1\u0011I\\=SK\u001a\u0004\"!\u000e\u001c\u000e\u0003\u0001J!a\u000e\u0011\u0003\u0017\u0019c\u0017N\\6DY&,g\u000e\u001e\t\u0003s\u0001k\u0011A\u000f\u0006\u0003wq\nAb]2bY\u0006dwnZ4j]\u001eT!!\u0010 \u0002\u0011QL\b/Z:bM\u0016T\u0011aP\u0001\u0004G>l\u0017BA!;\u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0002\r\r|gNZ5h!\t!U)D\u0001#\u0013\t1%EA\u0006GY&t7nQ8oM&<\u0017\u0001\u00034mS:\\WK\u001d7\u0011\u0005%sU\"\u0001&\u000b\u0005-c\u0015!B7pI\u0016d'\"A'\u0002\tM$H\u000f]\u0005\u0003\u001f*\u00131!\u0016:j\u0003\u001d\u0011\u0017mY6f]\u0012\u0004BAU+X;6\t1K\u0003\u0002U\u0019\u000691\r\\5f]R\u001c\u0014B\u0001,T\u0005-\u0019F\u000f\u001e9CC\u000e\\WM\u001c3\u0011\u0005a[V\"A-\u000b\u0005i\u0003\u0014AC2p]\u000e,(O]3oi&\u0011A,\u0017\u0002\u0007\rV$XO]3\u0011\u0005=r\u0016BA01\u0005\r\te._\u0001\u0003K\u000e\u0004\"\u0001\u00172\n\u0005\rL&\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\u0019aM[6\u0015\u0007\u001dD\u0017\u000e\u0005\u00026\u0001!)\u0001+\u0002a\u0002#\")\u0001-\u0002a\u0002C\")!)\u0002a\u0001\u0007\")q)\u0002a\u0001\u0011\u0006AR\u000f\u001d7pC\u0012T\u0015M\u001d$jY\u0016LeMT8u\u000bbL7\u000f^:\u0015\u00079\fY\u0001E\u0002Y7>\u00042\u0001]A\u0003\u001d\r\t\u0018\u0011\u0001\b\u0003e~t!a\u001d@\u000f\u0005QlhBA;}\u001d\t18P\u0004\u0002xu6\t\u0001P\u0003\u0002zY\u00051AH]8pizJ\u0011aK\u0005\u0003S)J!a\n\u0015\n\u0005\u00152\u0013BA\u0012%\u0013\t\t#%C\u0002\u0002\u0004\u0001\naB\u001a7j].\u0014Vm\u001d;N_\u0012,G.\u0003\u0003\u0002\b\u0005%!a\u0002&be\u001aKG.\u001a\u0006\u0004\u0003\u0007\u0001\u0003bBA\u0007\r\u0001\u0007\u0011qB\u0001\bU\u0006\u0014h)\u001b7f!\u0011\t\t\"a\u0007\u000e\u0005\u0005M!\u0002BA\u000b\u0003/\t!![8\u000b\u0005\u0005e\u0011\u0001\u00026bm\u0006LA!!\b\u0002\u0014\t!a)\u001b7f\u0003i\u0019\u0007.Z2l)\"\fGOS1s/&$\bNT1nK\u0016C\u0018n\u001d;t)\u0011\t\u0019#a\u000b\u0011\ta[\u0016Q\u0005\t\u0005_\u0005\u001dr.C\u0002\u0002*A\u0012aa\u00149uS>t\u0007bBA\u0017\u000f\u0001\u0007\u0011qF\u0001\bU\u0006\u0014h*Y7f!\u0011\t\t$!\u000f\u000f\t\u0005M\u0012Q\u0007\t\u0003oBJ1!a\u000e1\u0003\u0019\u0001&/\u001a3fM&!\u00111HA\u001f\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u0007\u0019\u0002\u0013U\u0004Hn\\1e\u0015\u0006\u0014H\u0003BA\"\u0003\u000b\u0002B\u0001W.\u00020!9\u0011Q\u0002\u0005A\u0002\u0005=\u0011!\u00053fY\u0016$XMS1s\u0013\u001a,\u00050[:ugR!\u00111JA*!\u0011A6,!\u0014\u0011\u0007=\ny%C\u0002\u0002RA\u0012A!\u00168ji\"9\u0011QK\u0005A\u0002\u0005=\u0012a\u00036be\u001aKG.\u001a(b[\u0016\f\u0011\u0002Z3mKR,'*\u0019:\u0015\t\u0005-\u00131\f\u0005\b\u0003;R\u0001\u0019AA\u0018\u0003\u0015Q\u0017M]%e\u0003A9W\r\u001e&pEN|e/\u001a:wS\u0016<8\u000f\u0006\u0002\u0002dQ!\u0011QMAH!\u0011A6,a\u001a\u0011\r\u0005%\u00141OA<\u001b\t\tYG\u0003\u0003\u0002n\u0005=\u0014A\u00033fa2|\u00170\\3oi*\u0019\u0011\u0011\u000f\u0013\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002v\u0005-$aF,ji\"$\u0015\r^1Ge\u0016\u001c\bN\\3tgN#\u0018\r^;t!\u0019\tI(a!\u0002\n:!\u00111PA@\u001d\r9\u0018QP\u0005\u0002c%\u0019\u0011\u0011\u0011\u0019\u0002\u000fA\f7m[1hK&!\u0011QQAD\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005\u0005\u0005\u0007E\u0002q\u0003\u0017KA!!$\u0002\n\tY!j\u001c2Pm\u0016\u0014h/[3x\u0011\u001d\t\tj\u0003a\u0002\u0003'\u000bqB\u001a:fg\"tWm]:Q_2L7-\u001f\t\u0005\u0003S\n)*\u0003\u0003\u0002\u0018\u0006-$a\u0005#bi\u00064%/Z:i]\u0016\u001c8\u000fU8mS\u000eL\u0018!D4fi*{'\rR3uC&d7\u000f\u0006\u0003\u0002\u001e\u0006\u001d\u0006\u0003\u0002-\\\u0003?\u0003RaLA\u0014\u0003C\u00032\u0001]AR\u0013\u0011\t)+!\u0003\u0003\u0015){'\rR3uC&d7\u000fC\u0004\u0002*2\u0001\r!a\f\u0002\u000b)|'-\u00133\u0002\u0019\u001d,GOS8c\u0007>tg-[4\u0015\t\u0005=\u0016\u0011\u0018\t\u00051n\u000b\t\f\u0005\u0003\u00024\u0006UfbA\u001b\u0002\u0002%!\u0011qWA\u0005\u0005=)\u00050Z2vi&|gnQ8oM&<\u0007bBAU\u001b\u0001\u0007\u0011qF\u0001\u0011o\u0006LGOR8s'\u00064X\r]8j]R$\u0002\"a0\u0002H\u0006M\u0017q\u001b\t\u00051n\u000b\t\r\u0005\u0003\u0002j\u0005\r\u0017\u0002BAc\u0003W\u0012qbU1wKB|\u0017N\u001c;SKN,H\u000e\u001e\u0005\b\u0003Ss\u0001\u0019AAe!\u0011\tY-a4\u000e\u0005\u00055'bAA7I%!\u0011\u0011[Ag\u0005Q)\u0005\u0010^3s]\u0006dG)\u001a9m_flWM\u001c;JI\"9\u0011Q\u001b\bA\u0002\u0005=\u0012aC:bm\u0016\u0004x.\u001b8u\u0013\u0012D\u0011\"!7\u000f!\u0003\u0005\r!a7\u0002\u0017QLW.Z8vi2+g\r\u001e\t\u0004_\u0005u\u0017bAApa\t!Aj\u001c8h\u0003i9\u0018-\u001b;G_J\u001c\u0016M^3q_&tG\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t)O\u000b\u0003\u0002\\\u0006\u001d8FAAu!\u0011\tY/!>\u000e\u0005\u00055(\u0002BAx\u0003c\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005M\b'\u0001\u0006b]:|G/\u0019;j_:LA!a>\u0002n\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\r\r\fgnY3m)\u0011\tY%!@\t\u000f\u0005}\b\u00031\u0001\u0002J\u0006aA-\u001a9m_flWM\u001c;JI\u0006iQ.Y6f'\u00064X\r]8j]R$b!a0\u0003\u0006\t\u001d\u0001bBA\u0000#\u0001\u0007\u0011\u0011\u001a\u0005\b\u0005\u0013\t\u0002\u0019\u0001B\u0006\u00031\u0019\u0018M^3q_&tG\u000fR5s!\u0015y\u0013qEA\u0018\u0003\u0011\u0019Ho\u001c9\u0015\r\u0005}&\u0011\u0003B\n\u0011\u001d\tyP\u0005a\u0001\u0003\u0013DqA!\u0003\u0013\u0001\u0004\u0011Y!A\fqe>\u001cWm]:TCZ,\u0007o\\5oiJ+\u0017/^3tiRA\u0011q\u0018B\r\u00057\u0011y\u0004C\u0004\u0002\u0000N\u0001\r!!3\t\u000f\tu1\u00031\u0001\u0003 \u00059!/Z9vKN$\b\u0003\u0003*\u0003\"\t\u0015\"\u0011H/\n\u0007\t\r2K\u0001\u0005SKF,Xm\u001d;U!\u0011\u00119Ca\r\u000f\t\t%\"\u0011\u0007\b\u0005\u0005W\u0011yCD\u0002x\u0005[I\u0011!T\u0005\u0003)2K1!!!T\u0013\u0011\u0011)Da\u000e\u0003\u0011%#WM\u001c;jifT1!!!T!!\tIHa\u000f\u00020\u0005=\u0012\u0002\u0002B\u001f\u0003\u000f\u0013a!R5uQ\u0016\u0014\bb\u0002B!'\u0001\u0007\u0011qF\u0001\u0007C\u000e$\u0018n\u001c8\u0002!QLW.Z8vi\u0016CHO]1di>\u0014XC\u0001B$!\u0019\u0011IEa\u0015\u0003X5\u0011!1\n\u0006\u0005\u0005\u001b\u0012y%A\u0005fq\u000e,\u0007\u000f^5p]*\u0019!\u0011\u000b\u0013\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005+\u0012YE\u0001\u0011EK\u0016\u0004H._\"iK\u000e\\\u0017N\\4Fq\u000e,\u0007\u000f^5p]\u0016CHO]1di>\u0014\b\u0003\u0002B-\u0005?j!Aa\u0017\u000b\u0007i\u0013iF\u0003\u0003\u0003R\u0005]\u0011\u0002\u0002B1\u00057\u0012\u0001\u0003V5nK>,H/\u0012=dKB$\u0018n\u001c8\u0002#QLW.Z8vi\u0016CHO]1di>\u0014\b%\u0001\u0006sk:\u0004&o\\4sC6$BB!\u001b\u0003n\t=$1\u000fB=\u0005{\u0002B\u0001W.\u0003lA)q&a\n\u0002J\"9\u0011Q\u0002\fA\u0002\u0005=\u0001b\u0002B9-\u0001\u0007\u0011qF\u0001\n[\u0006Lgn\u00117bgNDqA!\u001e\u0017\u0001\u0004\u00119(\u0001\u0003be\u001e\u001c\bCBA=\u0003\u0007\u000by\u0003C\u0004\u0003|Y\u0001\rAa\u0003\u0002\u001bM\fg/\u001a9pS:$\b+\u0019;i\u0011\u001d\tIK\u0006a\u0001\u0005\u0017\t!cZ3u\u00072,8\u000f^3s\u001fZ,'O^5foV\u0011!1\u0011\t\u00051n\u0013)\tE\u0002q\u0005\u000fKAA!#\u0002\n\ty1\t\\;ti\u0016\u0014xJ^3sm&,w/A\nhKRTuNY'b]\u0006<WM]\"p]\u001aLw-\u0006\u0002\u0003\u0010B!\u0001l\u0017BI!\u0011\u0011\u0019J!*\u000e\u0005\tU%\u0002\u0002BL\u00053\u000bQbY8oM&<WO]1uS>t'\u0002\u0002BN\u0005;\u000bQA\u001a7j].TAAa(\u0003\"\u00061\u0011\r]1dQ\u0016T!Aa)\u0002\u0007=\u0014x-\u0003\u0003\u0003(\nU%!D\"p]\u001aLw-\u001e:bi&|g.\u0001\u000bd_:4\u0017nZ;sCRLwN\u001c$s_6l\u0015\r\u001d\u000b\u0005\u0005#\u0013i\u000bC\u0004\u00030f\u0001\rA!-\u0002\rY\fG.^3t!!\t\tDa-\u00020\u0005=\u0012\u0002\u0002B[\u0003{\u00111!T1q\u0003=AE\u000f\u001e9GY&t7n\u00117jK:$\bCA\u001b\u001c'\tYb\u0006\u0006\u0002\u0003:\u0006a1M]3bi\u0016,fn]1gKR!!1\u0019Be)\u00159'Q\u0019Bd\u0011\u0015\u0001V\u0004q\u0001R\u0011\u0015\u0001W\u0004q\u0001b\u0011\u0015\u0011U\u00041\u0001D\u0003\u0019\u0019'/Z1uKR!!q\u001aBy)\u0019\u0011\tN!<\u0003pB9!1\u001bBt\u0003_9g\u0002\u0002Bk\u0005GtAAa6\u0003^:\u0019qO!7\n\u0005\tm\u0017\u0001B2biNLAAa8\u0003b\u0006!A-\u0019;b\u0015\t\u0011Y.\u0003\u0003\u0002\u0002\n\u0015(\u0002\u0002Bp\u0005CLAA!;\u0003l\naa+\u00197jI\u0006$X\r\u001a(fY*!\u0011\u0011\u0011Bs\u0011\u0015\u0001f\u0004q\u0001R\u0011\u0015\u0001g\u0004q\u0001b\u0011\u0015\u0011e\u00041\u0001D\u0001")
public class HttpFlinkClient
implements FlinkClient,
LazyLogging {
    private final FlinkConfig config;
    private final Uri flinkUrl;
    private final SttpBackend<Future, Object> backend;
    private final ExecutionContext ec;
    private final DeeplyCheckingExceptionExtractor<TimeoutException> pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static Validated<NonEmptyList<String>, HttpFlinkClient> create(FlinkConfig flinkConfig, SttpBackend<Future, Object> sttpBackend, ExecutionContext executionContext) {
        return HttpFlinkClient$.MODULE$.create(flinkConfig, sttpBackend, executionContext);
    }

    public static HttpFlinkClient createUnsafe(FlinkConfig flinkConfig, SttpBackend<Future, Object> sttpBackend, ExecutionContext executionContext) {
        return HttpFlinkClient$.MODULE$.createUnsafe(flinkConfig, sttpBackend, executionContext);
    }

    private Logger logger$lzycompute() {
        HttpFlinkClient httpFlinkClient = this;
        synchronized (httpFlinkClient) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public Future<flinkRestModel.JarFile> uploadJarFileIfNotExists(File jarFile) {
        return this.checkThatJarWithNameExists(jarFile.getName()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                flinkRestModel.JarFile file = (flinkRestModel.JarFile)some.value();
                future = Future$.MODULE$.successful((Object)file);
            } else if (None$.MODULE$.equals(option)) {
                future = this.uploadJar(jarFile).map((Function1 & Serializable & scala.Serializable)id -> new flinkRestModel.JarFile((String)id, jarFile.getName()), $this.ec);
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, this.ec);
    }

    private Future<Option<flinkRestModel.JarFile>> checkThatJarWithNameExists(String jarName) {
        return ((Future)sttp.client3.package$.MODULE$.basicRequest().get(this.flinkUrl.addPath("jars", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).response(package$.MODULE$.asJson(flinkRestModel$JarsResponse$.MODULE$.decodeJarsResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).map((Function1 & Serializable & scala.Serializable)x$1 -> ((LinearSeqOptimized)x$1.files().toList().flatten((Function1)Predef$.MODULE$.$conforms())).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HttpFlinkClient.$anonfun$checkThatJarWithNameExists$3(jarName, x$2))), this.ec);
    }

    public Future<String> uploadJar(File jarFile) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Uploading new jar: {}", new Object[]{jarFile.getAbsolutePath()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return ((Future)sttp.client3.package$.MODULE$.basicRequest().post(this.flinkUrl.addPath("jars", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"upload"}))).multipartBody(sttp.client3.package$.MODULE$.multipartFile("jarfile", jarFile).contentType("application/x-java-archive"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Part[0])).response(package$.MODULE$.asJson(flinkRestModel$UploadJarResponse$.MODULE$.decodeUploadJarResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).map((Function1 & Serializable & scala.Serializable)file -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Uploaded jar to {}", new Object[]{file});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return new File(file.filename()).getName();
        }, this.ec).recoverWith(HttpClientErrorHandler$.MODULE$.recoverWithMessage("upload Nussnknacker jar to Flink", HttpClientErrorHandler$.MODULE$.recoverWithMessage$default$2()), this.ec);
    }

    @Override
    public Future<BoxedUnit> deleteJarIfExists(String jarFileName) {
        return this.checkThatJarWithNameExists(jarFileName).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                flinkRestModel.JarFile file = (flinkRestModel.JarFile)some.value();
                future = this.deleteJar(file.id()).recover((PartialFunction)new scala.Serializable(this, jarFileName){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HttpFlinkClient $outer;
                    private final String jarFileName$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        BoxedUnit boxedUnit;
                        A1 A1 = x1;
                        if (this.$outer.logger().underlying().isWarnEnabled()) {
                            this.$outer.logger().underlying().warn(new StringBuilder(22).append("Failed to delete jar: ").append(this.jarFileName$1).toString(), A1);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        return (B1)boxedUnit2;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        boolean bl = true;
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.jarFileName$1 = jarFileName$1;
                    }
                }, $this.ec);
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("{} does not exist, not removing", new Object[]{jarFileName});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, this.ec);
    }

    private Future<BoxedUnit> deleteJar(String jarId) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Delete jar id: {}", new Object[]{jarId});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Option option = HttpClientErrorHandler$.MODULE$.handleUnitResponse$default$2();
        return ((Future)sttp.client3.package$.MODULE$.basicRequest().delete(this.flinkUrl.addPath("jars", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{jarId}))).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> HttpClientErrorHandler$.MODULE$.handleUnitResponse("delete jar", option, response), this.ec).recoverWith(HttpClientErrorHandler$.MODULE$.recoverWithMessage("delete jar", HttpClientErrorHandler$.MODULE$.recoverWithMessage$default$2()), this.ec);
    }

    @Override
    public Future<WithDataFreshnessStatus<List<flinkRestModel.JobOverview>>> getJobsOverviews(DataFreshnessPolicy freshnessPolicy) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Fetching jobs overview");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return ((Future)sttp.client3.package$.MODULE$.basicRequest().readTimeout((Duration)this.config.scenarioStateRequestTimeout()).get(this.flinkUrl.addPath("jobs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"overview"}))).response(package$.MODULE$.asJson(flinkRestModel$JobsResponse$.MODULE$.decodeJobsResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).map((Function1 & Serializable & scala.Serializable)jobs -> ((List)jobs.jobs().sortBy((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.last$minusmodification()), (Ordering)Ordering.Long$.MODULE$)).reverse(), this.ec).map((Function1 & Serializable & scala.Serializable)jobs -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace(new StringBuilder(14).append("Fetched jobs: ").append(jobs).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return jobs;
        }, this.ec).map((Function1 & Serializable & scala.Serializable)value -> WithDataFreshnessStatus$.MODULE$.fresh(value), this.ec).recoverWith(HttpClientErrorHandler$.MODULE$.recoverWithMessage("retrieve Flink jobs", HttpClientErrorHandler$.MODULE$.recoverWithMessage$default$2()), this.ec);
    }

    @Override
    public Future<Option<flinkRestModel.JobDetails>> getJobDetails(String jobId) {
        return ((Future)sttp.client3.package$.MODULE$.basicRequest().get(this.flinkUrl.addPath("jobs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{jobId}))).response(SttpJson$.MODULE$.asOptionalJson(flinkRestModel$JobDetails$.MODULE$.decodeJobDetails())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).recoverWith(HttpClientErrorHandler$.MODULE$.recoverWithMessage("retrieve Flink job details", HttpClientErrorHandler$.MODULE$.recoverWithMessage$default$2()), this.ec);
    }

    @Override
    public Future<flinkRestModel.ExecutionConfig> getJobConfig(String jobId) {
        return ((Future)sttp.client3.package$.MODULE$.basicRequest().get(this.flinkUrl.addPath("jobs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{jobId, "config"}))).response(package$.MODULE$.asJson(flinkRestModel$JobConfig$.MODULE$.decodeJobConfig(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.execution$minusconfig(), this.ec);
    }

    public Future<SavepointResult> waitForSavepoint(String jobId, String savepointId, long timeoutLeft) {
        long start = System.currentTimeMillis();
        if (timeoutLeft <= 0L) {
            return Future$.MODULE$.failed((Throwable)new Exception(new StringBuilder(54).append("Failed to complete savepoint in time for ").append(new ExternalDeploymentId(jobId)).append(" and trigger ").append(savepointId).toString()));
        }
        return ((Future)sttp.client3.package$.MODULE$.basicRequest().get(this.flinkUrl.addPath("jobs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{jobId, "savepoints", savepointId}))).response(package$.MODULE$.asJson(flinkRestModel$GetSavepointStatusResponse$.MODULE$.decodeGetSavepointStatusResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).flatMap((Function1 & Serializable & scala.Serializable)resp -> {
            Future future;
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Waiting for savepoint {} of {}, got response: {}", new Object[]{savepointId, new ExternalDeploymentId(jobId), resp});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (resp.isCompletedSuccessfully()) {
                BoxedUnit boxedUnit2;
                String location = (String)resp.operation().flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.location()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Savepoint {} for {} finished in {}", new Object[]{savepointId, new ExternalDeploymentId(jobId), location});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                future = Future$.MODULE$.successful((Object)new SavepointResult(location));
            } else if (resp.isFailed()) {
                future = Future$.MODULE$.failed((Throwable)new RuntimeException(new StringBuilder(30).append("Failed to complete savepoint: ").append(resp.operation()).toString()));
            } else {
                Thread.sleep(1000L);
                future = this.waitForSavepoint(jobId, savepointId, timeoutLeft - (System.currentTimeMillis() - start));
            }
            return future;
        }, this.ec);
    }

    public long waitForSavepoint$default$3() {
        return this.config.jobManagerTimeout().toMillis();
    }

    @Override
    public Future<BoxedUnit> cancel(String deploymentId) {
        Option option = HttpClientErrorHandler$.MODULE$.handleUnitResponse$default$2();
        return ((Future)sttp.client3.package$.MODULE$.basicRequest().patch(this.flinkUrl.addPath("jobs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{deploymentId}))).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> HttpClientErrorHandler$.MODULE$.handleUnitResponse("cancel scenario", option, response), this.ec).recoverWith(HttpClientErrorHandler$.MODULE$.recoverWithMessage("cancel scenario", HttpClientErrorHandler$.MODULE$.recoverWithMessage$default$2()), this.ec);
    }

    @Override
    public Future<SavepointResult> makeSavepoint(String deploymentId, Option<String> savepointDir) {
        RequestT savepointRequest = sttp.client3.package$.MODULE$.basicRequest().post(this.flinkUrl.addPath("jobs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{deploymentId, "savepoints"}))).body((Object)new flinkRestModel.SavepointTriggerRequest(savepointDir, false), package$.MODULE$.circeBodySerializer(flinkRestModel$SavepointTriggerRequest$.MODULE$.encodeSavepointTriggerRequest(), package$.MODULE$.circeBodySerializer$default$2()));
        return this.processSavepointRequest(deploymentId, (RequestT<Object, Either<String, String>, Object>)savepointRequest, "make savepoint");
    }

    @Override
    public Future<SavepointResult> stop(String deploymentId, Option<String> savepointDir) {
        RequestT stopRequest = sttp.client3.package$.MODULE$.basicRequest().post(this.flinkUrl.addPath("jobs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{deploymentId, "savepoints"}))).body((Object)new flinkRestModel.SavepointTriggerRequest(savepointDir, true), package$.MODULE$.circeBodySerializer(flinkRestModel$SavepointTriggerRequest$.MODULE$.encodeSavepointTriggerRequest(), package$.MODULE$.circeBodySerializer$default$2()));
        return this.processSavepointRequest(deploymentId, (RequestT<Object, Either<String, String>, Object>)stopRequest, "stop scenario");
    }

    private Future<SavepointResult> processSavepointRequest(String deploymentId, RequestT<Object, Either<String, String>, Object> request, String action) {
        return ((Future)request.response(package$.MODULE$.asJson(flinkRestModel$SavepointTriggerResponse$.MODULE$.decodeSavepointTriggerResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).flatMap((Function1 & Serializable & scala.Serializable)response -> this.waitForSavepoint(deploymentId, response.request$minusid(), this.waitForSavepoint$default$3()), this.ec).recoverWith(HttpClientErrorHandler$.MODULE$.recoverWithMessage(action, HttpClientErrorHandler$.MODULE$.recoverWithMessage$default$2()), this.ec);
    }

    public DeeplyCheckingExceptionExtractor<TimeoutException> pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor() {
        return this.pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor;
    }

    @Override
    public Future<Option<ExternalDeploymentId>> runProgram(File jarFile, String mainClass, List<String> args, Option<String> savepointPath, Option<String> jobId) {
        String x$1 = mainClass;
        Option<String> x$2 = savepointPath;
        String x$3 = FlinkArgsEncodeHack$.MODULE$.prepareProgramArgs(args).mkString(" ");
        Option<String> x$4 = jobId;
        int x$5 = flinkRestModel$DeployProcessRequest$.MODULE$.apply$default$4();
        boolean x$6 = flinkRestModel$DeployProcessRequest$.MODULE$.apply$default$5();
        flinkRestModel.DeployProcessRequest program = new flinkRestModel.DeployProcessRequest(x$1, x$2, x$3, x$5, x$6, x$4);
        return this.uploadJarFileIfNotExists(jarFile).flatMap((Function1 & Serializable & scala.Serializable)flinkJarFile -> ((Future)sttp.client3.package$.MODULE$.basicRequest().post($this.flinkUrl.addPath("jars", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{flinkJarFile.id(), "run"}))).body((Object)program, package$.MODULE$.circeBodySerializer(flinkRestModel$DeployProcessRequest$.MODULE$.encodeDeployProcessRequest(), package$.MODULE$.circeBodySerializer$default$2())).response(package$.MODULE$.asJson(flinkRestModel$RunResponse$.MODULE$.codecForRunResponse(), IsOption$.MODULE$.otherIsNotOption())).send($this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), $this.ec).map((Function1 & Serializable & scala.Serializable)ret -> new Some((Object)new ExternalDeploymentId(ret.jobid())), $this.ec).recover((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpFlinkClient $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Option option = this.$outer.pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor().unapply(A1);
                if (!option.isEmpty()) {
                    BoxedUnit boxedUnit;
                    TimeoutException e = (TimeoutException)option.get();
                    if (this.$outer.logger().underlying().isWarnEnabled()) {
                        this.$outer.logger().underlying().warn("TimeoutException occurred while waiting for deploy result. Recovering with Future.successful...", (Throwable)e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = None$.MODULE$;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                Option option = this.$outer.pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor().unapply(throwable);
                boolean bl = !option.isEmpty();
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, $this.ec).recoverWith(HttpClientErrorHandler$.MODULE$.recoverWithMessage("deploy scenario", HttpClientErrorHandler$.MODULE$.recoverWithMessage$default$2()), $this.ec), this.ec);
    }

    @Override
    public Future<flinkRestModel.ClusterOverview> getClusterOverview() {
        return ((Future)sttp.client3.package$.MODULE$.basicRequest().get(this.flinkUrl.addPath("overview", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).response(package$.MODULE$.asJson(flinkRestModel$ClusterOverview$.MODULE$.decodeClusterOverview(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec);
    }

    @Override
    public Future<Configuration> getJobManagerConfig() {
        return ((Future)sttp.client3.package$.MODULE$.basicRequest().get(this.flinkUrl.addPath("jobmanager", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"config"}))).response(package$.MODULE$.asJson(Decoder$.MODULE$.decodeList(flinkRestModel$KeyValueEntry$.MODULE$.decodeKeyValueEntry()), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).map((Function1 & Serializable & scala.Serializable)list -> this.configurationFromMap((Map<String, String>)((TraversableOnce)list.map((Function1 & Serializable & scala.Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.key()), (Object)e.value()), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())), this.ec);
    }

    /*
     * WARNING - void declaration
     */
    private Configuration configurationFromMap(Map<String, String> values) {
        void var2_2;
        Configuration configuration = new Configuration();
        values.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HttpFlinkClient.$anonfun$configurationFromMap$1(configuration, x0$1);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public static final /* synthetic */ boolean $anonfun$checkThatJarWithNameExists$3(String jarName$1, flinkRestModel.JarFile x$2) {
        String string = x$2.name();
        String string2 = jarName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$configurationFromMap$1(Configuration configuration$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        configuration$1.setString(k, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public HttpFlinkClient(FlinkConfig config, Uri flinkUrl, SttpBackend<Future, Object> backend, ExecutionContext ec) {
        this.config = config;
        this.flinkUrl = flinkUrl;
        this.backend = backend;
        this.ec = ec;
        LazyLogging.$init$((LazyLogging)this);
        this.pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor = DeeplyCheckingExceptionExtractor$.MODULE$.forClass(ClassTag$.MODULE$.apply(TimeoutException.class));
    }
}

