/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.management.rest;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.circe.Decoder$;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import org.apache.flink.configuration.Configuration;
import pl.touk.nussknacker.engine.api.deployment.SavepointResult;
import pl.touk.nussknacker.engine.deployment.ExternalDeploymentId;
import pl.touk.nussknacker.engine.management.FlinkArgsEncodeHack$;
import pl.touk.nussknacker.engine.management.FlinkConfig;
import pl.touk.nussknacker.engine.management.rest.FlinkClient;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$ClusterOverview$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$DeployProcessRequest$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$GetSavepointStatusResponse$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$JarsResponse$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$JobConfig$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$JobsResponse$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$KeyValueEntry$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$RunResponse$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$SavepointTriggerRequest$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$SavepointTriggerResponse$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$StopRequest$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$UploadJarResponse$;
import pl.touk.nussknacker.engine.sttp.SttpJson$;
import pl.touk.nussknacker.engine.util.exception.DeeplyCheckingExceptionExtractor;
import pl.touk.nussknacker.engine.util.exception.DeeplyCheckingExceptionExtractor$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import sttp.client.HttpClientErrorHandler$;
import sttp.client.IsOption$;
import sttp.client.RequestT;
import sttp.client.SttpBackend;
import sttp.client.circe.package$;
import sttp.model.Part;
import sttp.model.Uri;

@ScalaSignature(bytes="\u0006\u0001\tUe\u0001\u0002\u000e\u001c\u0001!B\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0006\u0007\"A!\r\u0001B\u0001B\u0003-1\rC\u0003g\u0001\u0011\u0005q\rC\u0004n\u0001\t\u0007I\u0011\u00028\t\rU\u0004\u0001\u0015!\u0003p\u0011\u00151\b\u0001\"\u0001x\u0011\u001d\ti\u0003\u0001C\u0005\u0003_Aq!!\u0014\u0001\t\u0003\ty\u0005C\u0004\u0002V\u0001!\t%a\u0016\t\u000f\u0005\u0015\u0004\u0001\"\u0003\u0002h!9\u0011Q\u000e\u0001\u0005\u0002\u0005=\u0004bBAG\u0001\u0011\u0005\u0011q\u0012\u0005\b\u0003?\u0003A\u0011AAQ\u0011%\ty\rAI\u0001\n\u0003\t\t\u000eC\u0004\u0002h\u0002!\t!!;\t\u000f\u0005=\b\u0001\"\u0001\u0002r\"9\u00111 \u0001\u0005\u0002\u0005u\bb\u0002B\u0002\u0001\u0011%!Q\u0001\u0005\n\u0005G\u0001!\u0019!C\u0005\u0005KA\u0001Ba\u0011\u0001A\u0003%!q\u0005\u0005\b\u0005\u000b\u0002A\u0011\u0001B$\u0011\u001d\u0011i\u0006\u0001C\u0001\u0005?BqA!\u001b\u0001\t\u0003\u0011Y\u0007C\u0004\u0003\b\u0002!IA!#\u0003\u001f!#H\u000f\u001d$mS:\\7\t\\5f]RT!\u0001H\u000f\u0002\tI,7\u000f\u001e\u0006\u0003=}\t!\"\\1oC\u001e,W.\u001a8u\u0015\t\u0001\u0013%\u0001\u0004f]\u001eLg.\u001a\u0006\u0003E\r\n1B\\;tg.t\u0017mY6fe*\u0011A%J\u0001\u0005i>,8NC\u0001'\u0003\t\u0001Hn\u0001\u0001\u0014\t\u0001Isf\r\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005A\nT\"A\u000e\n\u0005IZ\"a\u0003$mS:\\7\t\\5f]R\u0004\"\u0001N\u001e\u000e\u0003UR!AN\u001c\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005aJ\u0014\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003i\n1aY8n\u0013\taTGA\u0006MCjLHj\\4hS:<\u0017AB2p]\u001aLw\r\u0005\u0002@\u00016\tQ$\u0003\u0002B;\tYa\t\\5oW\u000e{gNZ5h\u0003\u001d\u0011\u0017mY6f]\u0012\u0004R\u0001R%L#Rk\u0011!\u0012\u0006\u0003\r\u001e\u000baa\u00197jK:$(\"\u0001%\u0002\tM$H\u000f]\u0005\u0003\u0015\u0016\u00131b\u0015;ua\n\u000b7m[3oIB\u0011AjT\u0007\u0002\u001b*\u0011ajK\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001)N\u0005\u00191U\u000f^;sKB\u0011!FU\u0005\u0003'.\u0012qAT8uQ&tw\r\u0005\u0002V?:\u0011a+\u0018\b\u0003/rs!\u0001W.\u000e\u0003eS!AW\u0014\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0015B\u0001$H\u0013\tqV)A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0001\f'\u0001\u0003(pi\"Lgn\u001a+\u000b\u0005y+\u0015AA3d!\taE-\u0003\u0002f\u001b\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005!dGcA5kWB\u0011\u0001\u0007\u0001\u0005\u0006\u0005\u0012\u0001\u001da\u0011\u0005\u0006E\u0012\u0001\u001da\u0019\u0005\u0006{\u0011\u0001\rAP\u0001\tM2Lgn[+sYV\tq\u000e\u0005\u0002qg6\t\u0011O\u0003\u0002s\u000f\u0006)Qn\u001c3fY&\u0011A/\u001d\u0002\u0004+JL\u0017!\u00034mS:\\WK\u001d7!\u0003a)\b\u000f\\8bI*\u000b'OR5mK&3gj\u001c;Fq&\u001cHo\u001d\u000b\u0004q\u0006e\u0001c\u0001'PsB\u0019!0a\u0005\u000f\u0007m\fyAD\u0002}\u0003\u001bq1!`A\u0006\u001d\rq\u0018\u0011\u0002\b\u0004\u007f\u0006\u001da\u0002BA\u0001\u0003\u000bq1\u0001WA\u0002\u0013\u00051\u0013B\u0001\u0013&\u0013\t\u00113%\u0003\u0002!C%\u0011adH\u0005\u00039uI1!!\u0005\u001c\u000391G.\u001b8l%\u0016\u001cH/T8eK2LA!!\u0006\u0002\u0018\t9!*\u0019:GS2,'bAA\t7!9\u00111D\u0004A\u0002\u0005u\u0011a\u00026be\u001aKG.\u001a\t\u0005\u0003?\tI#\u0004\u0002\u0002\")!\u00111EA\u0013\u0003\tIwN\u0003\u0002\u0002(\u0005!!.\u0019<b\u0013\u0011\tY#!\t\u0003\t\u0019KG.Z\u0001\u001bG\",7m\u001b+iCRT\u0015M],ji\"t\u0015-\\3Fq&\u001cHo\u001d\u000b\u0005\u0003c\tI\u0004\u0005\u0003M\u001f\u0006M\u0002\u0003\u0002\u0016\u00026eL1!a\u000e,\u0005\u0019y\u0005\u000f^5p]\"9\u00111\b\u0005A\u0002\u0005u\u0012a\u00026be:\u000bW.\u001a\t\u0005\u0003\u007f\t9E\u0004\u0003\u0002B\u0005\r\u0003C\u0001-,\u0013\r\t)eK\u0001\u0007!J,G-\u001a4\n\t\u0005%\u00131\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u00153&A\u0005va2|\u0017\r\u001a&beR!\u0011\u0011KA*!\u0011au*!\u0010\t\u000f\u0005m\u0011\u00021\u0001\u0002\u001e\u0005\tB-\u001a7fi\u0016T\u0015M]%g\u000bbL7\u000f^:\u0015\t\u0005e\u0013\u0011\r\t\u0005\u0019>\u000bY\u0006E\u0002+\u0003;J1!a\u0018,\u0005\u0011)f.\u001b;\t\u000f\u0005\r$\u00021\u0001\u0002>\u0005Y!.\u0019:GS2,g*Y7f\u0003%!W\r\\3uK*\u000b'\u000f\u0006\u0003\u0002Z\u0005%\u0004bBA6\u0017\u0001\u0007\u0011QH\u0001\u0006U\u0006\u0014\u0018\nZ\u0001\u000fM&tGMS8cg\nKh*Y7f)\u0011\t\t(!#\u0011\t1{\u00151\u000f\t\u0007\u0003k\ni(a!\u000f\t\u0005]\u00141\u0010\b\u00041\u0006e\u0014\"\u0001\u0017\n\u0005y[\u0013\u0002BA@\u0003\u0003\u0013A\u0001T5ti*\u0011al\u000b\t\u0004u\u0006\u0015\u0015\u0002BAD\u0003/\u00111BS8c\u001fZ,'O^5fo\"9\u00111\u0012\u0007A\u0002\u0005u\u0012a\u00026pE:\u000bW.Z\u0001\rO\u0016$(j\u001c2D_:4\u0017n\u001a\u000b\u0005\u0003#\u000bY\n\u0005\u0003M\u001f\u0006M\u0005\u0003BAK\u0003/s1\u0001MA\b\u0013\u0011\tI*a\u0006\u0003\u001f\u0015CXmY;uS>t7i\u001c8gS\u001eDq!!(\u000e\u0001\u0004\ti$A\u0003k_\nLE-\u0001\txC&$hi\u001c:TCZ,\u0007o\\5oiRA\u00111UA[\u0003\u0003\f)\r\u0005\u0003M\u001f\u0006\u0015\u0006\u0003BAT\u0003ck!!!+\u000b\t\u0005-\u0016QV\u0001\u000bI\u0016\u0004Hn\\=nK:$(bAAX?\u0005\u0019\u0011\r]5\n\t\u0005M\u0016\u0011\u0016\u0002\u0010'\u00064X\r]8j]R\u0014Vm];mi\"9\u0011Q\u0014\bA\u0002\u0005]\u0006\u0003BA]\u0003{k!!a/\u000b\u0007\u0005-v$\u0003\u0003\u0002@\u0006m&\u0001F#yi\u0016\u0014h.\u00197EKBdw._7f]RLE\rC\u0004\u0002D:\u0001\r!!\u0010\u0002\u0017M\fg/\u001a9pS:$\u0018\n\u001a\u0005\n\u0003\u000ft\u0001\u0013!a\u0001\u0003\u0013\f1\u0002^5nK>,H\u000fT3giB\u0019!&a3\n\u0007\u000557F\u0001\u0003M_:<\u0017AG<bSR4uN]*bm\u0016\u0004x.\u001b8uI\u0011,g-Y;mi\u0012\u001aTCAAjU\u0011\tI-!6,\u0005\u0005]\u0007\u0003BAm\u0003Gl!!a7\u000b\t\u0005u\u0017q\\\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!9,\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003K\fYNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\faaY1oG\u0016dG\u0003BA-\u0003WDq!!<\u0011\u0001\u0004\t9,\u0001\u0007eKBdw._7f]RLE-A\u0007nC.,7+\u0019<fa>Lg\u000e\u001e\u000b\u0007\u0003G\u000b\u00190!>\t\u000f\u00055\u0018\u00031\u0001\u00028\"9\u0011q_\tA\u0002\u0005e\u0018\u0001D:bm\u0016\u0004x.\u001b8u\t&\u0014\b#\u0002\u0016\u00026\u0005u\u0012\u0001B:u_B$b!a)\u0002\u0000\n\u0005\u0001bBAw%\u0001\u0007\u0011q\u0017\u0005\b\u0003o\u0014\u0002\u0019AA}\u0003]\u0001(o\\2fgN\u001c\u0016M^3q_&tGOU3rk\u0016\u001cH\u000f\u0006\u0005\u0002$\n\u001d!\u0011\u0002B\u0010\u0011\u001d\tio\u0005a\u0001\u0003oCqAa\u0003\u0014\u0001\u0004\u0011i!A\u0004sKF,Xm\u001d;\u0011\u0011\u0011\u0013yAa\u0005\u0003\u001aEK1A!\u0005F\u0005!\u0011V-];fgR$\u0006cA+\u0003\u0016%\u0019!qC1\u0003\u0011%#WM\u001c;jif\u0004\u0002\"!\u001e\u0003\u001c\u0005u\u0012QH\u0005\u0005\u0005;\t\tI\u0001\u0004FSRDWM\u001d\u0005\b\u0005C\u0019\u0002\u0019AA\u001f\u0003\u0019\t7\r^5p]\u0006\u0001B/[7f_V$X\t\u001f;sC\u000e$xN]\u000b\u0003\u0005O\u0001bA!\u000b\u00034\t]RB\u0001B\u0016\u0015\u0011\u0011iCa\f\u0002\u0013\u0015D8-\u001a9uS>t'b\u0001B\u0019?\u0005!Q\u000f^5m\u0013\u0011\u0011)Da\u000b\u0003A\u0011+W\r\u001d7z\u0007\",7m[5oO\u0016C8-\u001a9uS>tW\t\u001f;sC\u000e$xN\u001d\t\u0005\u0005s\u0011y$\u0004\u0002\u0003<)\u0019aJ!\u0010\u000b\t\tE\u0012QE\u0005\u0005\u0005\u0003\u0012YD\u0001\tUS6,w.\u001e;Fq\u000e,\u0007\u000f^5p]\u0006\tB/[7f_V$X\t\u001f;sC\u000e$xN\u001d\u0011\u0002\u0015I,h\u000e\u0015:pOJ\fW\u000e\u0006\u0006\u0003J\t5#q\nB*\u00053\u0002B\u0001T(\u0003LA)!&!\u000e\u00028\"9\u00111\u0004\fA\u0002\u0005u\u0001b\u0002B)-\u0001\u0007\u0011QH\u0001\n[\u0006Lgn\u00117bgNDqA!\u0016\u0017\u0001\u0004\u00119&\u0001\u0003be\u001e\u001c\bCBA;\u0003{\ni\u0004C\u0004\u0003\\Y\u0001\r!!?\u0002\u001bM\fg/\u001a9pS:$\b+\u0019;i\u0003I9W\r^\"mkN$XM](wKJ4\u0018.Z<\u0016\u0005\t\u0005\u0004\u0003\u0002'P\u0005G\u00022A\u001fB3\u0013\u0011\u00119'a\u0006\u0003\u001f\rcWo\u001d;fe>3XM\u001d<jK^\f1cZ3u\u0015>\u0014W*\u00198bO\u0016\u00148i\u001c8gS\u001e,\"A!\u001c\u0011\t1{%q\u000e\t\u0005\u0005c\u0012\u0019)\u0004\u0002\u0003t)!!Q\u000fB<\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]*!!\u0011\u0010B>\u0003\u00151G.\u001b8l\u0015\u0011\u0011iHa \u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\u0011\t)A\u0002pe\u001eLAA!\"\u0003t\ti1i\u001c8gS\u001e,(/\u0019;j_:\fAcY8oM&<WO]1uS>tgI]8n\u001b\u0006\u0004H\u0003\u0002B8\u0005\u0017CqA!$\u001a\u0001\u0004\u0011y)\u0001\u0004wC2,Xm\u001d\t\t\u0003\u007f\u0011\t*!\u0010\u0002>%!!1SA&\u0005\ri\u0015\r\u001d")
public class HttpFlinkClient
implements FlinkClient,
LazyLogging {
    private final FlinkConfig config;
    private final SttpBackend<Future, Nothing$, Nothing$> backend;
    private final ExecutionContext ec;
    private final Uri flinkUrl;
    private final DeeplyCheckingExceptionExtractor<TimeoutException> pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        HttpFlinkClient httpFlinkClient = this;
        synchronized (httpFlinkClient) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private Uri flinkUrl() {
        return this.flinkUrl;
    }

    public Future<flinkRestModel.JarFile> uploadJarFileIfNotExists(File jarFile) {
        return this.checkThatJarWithNameExists(jarFile.getName()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                flinkRestModel.JarFile file = (flinkRestModel.JarFile)some.value();
                future = Future$.MODULE$.successful((Object)file);
            } else if (None$.MODULE$.equals(option)) {
                future = this.uploadJar(jarFile).map((Function1 & Serializable & scala.Serializable)id -> new flinkRestModel.JarFile((String)id, jarFile.getName()), $this.ec);
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, this.ec);
    }

    private Future<Option<flinkRestModel.JarFile>> checkThatJarWithNameExists(String jarName) {
        return ((Future)sttp.client.package$.MODULE$.basicRequest().get(this.flinkUrl().path("jars")).response(package$.MODULE$.asJson(flinkRestModel$JarsResponse$.MODULE$.decodeJarsResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).map((Function1 & Serializable & scala.Serializable)x$1 -> ((LinearSeqOptimized)x$1.files().toList().flatten((Function1)Predef$.MODULE$.$conforms())).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HttpFlinkClient.$anonfun$checkThatJarWithNameExists$3(jarName, x$2))), this.ec);
    }

    public Future<String> uploadJar(File jarFile) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Uploading new jar: {}", new Object[]{jarFile.getAbsolutePath()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return ((Future)sttp.client.package$.MODULE$.basicRequest().post(this.flinkUrl().path("jars", "upload", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).multipartBody(sttp.client.package$.MODULE$.multipartFile("jarfile", jarFile).contentType("application/x-java-archive"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Part[0])).response(package$.MODULE$.asJson(flinkRestModel$UploadJarResponse$.MODULE$.decodeUploadJarResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).map((Function1 & Serializable & scala.Serializable)file -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Uploaded jar to {}", new Object[]{file});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return new File(file.filename()).getName();
        }, this.ec).recoverWith(HttpClientErrorHandler$.MODULE$.recoverWithMessage("upload Nussnknacker jar to Flink", HttpClientErrorHandler$.MODULE$.recoverWithMessage$default$2()), this.ec);
    }

    @Override
    public Future<BoxedUnit> deleteJarIfExists(String jarFileName) {
        return this.checkThatJarWithNameExists(jarFileName).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                flinkRestModel.JarFile file = (flinkRestModel.JarFile)some.value();
                future = this.deleteJar(file.id()).recover((PartialFunction)new scala.Serializable(this, jarFileName){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HttpFlinkClient $outer;
                    private final String jarFileName$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        BoxedUnit boxedUnit;
                        A1 A1 = x1;
                        if (this.$outer.logger().underlying().isWarnEnabled()) {
                            this.$outer.logger().underlying().warn(new StringBuilder(22).append("Failed to delete jar: ").append(this.jarFileName$1).toString(), A1);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        return (B1)boxedUnit2;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        boolean bl = true;
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.jarFileName$1 = jarFileName$1;
                    }
                }, $this.ec);
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("{} does not exist, not removing", new Object[]{jarFileName});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, this.ec);
    }

    private Future<BoxedUnit> deleteJar(String jarId) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Delete jar id: {}", new Object[]{jarId});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Option option = HttpClientErrorHandler$.MODULE$.handleUnitResponse$default$2();
        return ((Future)sttp.client.package$.MODULE$.basicRequest().delete(this.flinkUrl().path("jars", jarId, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> HttpClientErrorHandler$.MODULE$.handleUnitResponse("delete jar", option, response), this.ec).recoverWith(HttpClientErrorHandler$.MODULE$.recoverWithMessage("delete jar", HttpClientErrorHandler$.MODULE$.recoverWithMessage$default$2()), this.ec);
    }

    @Override
    public Future<List<flinkRestModel.JobOverview>> findJobsByName(String jobName) {
        return ((Future)sttp.client.package$.MODULE$.basicRequest().get(this.flinkUrl().path("jobs", "overview", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).response(package$.MODULE$.asJson(flinkRestModel$JobsResponse$.MODULE$.decodeJobsResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).map((Function1 & Serializable & scala.Serializable)jobs -> ((List)((SeqLike)jobs.jobs().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)HttpFlinkClient.$anonfun$findJobsByName$3(jobName, x$3)))).sortBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.last$minusmodification()), (Ordering)Ordering.Long$.MODULE$)).reverse(), this.ec).recoverWith(HttpClientErrorHandler$.MODULE$.recoverWithMessage("retrieve Flink jobs", HttpClientErrorHandler$.MODULE$.recoverWithMessage$default$2()), this.ec);
    }

    @Override
    public Future<flinkRestModel.ExecutionConfig> getJobConfig(String jobId) {
        return ((Future)sttp.client.package$.MODULE$.basicRequest().get(this.flinkUrl().path("jobs", jobId, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"config"}))).response(package$.MODULE$.asJson(flinkRestModel$JobConfig$.MODULE$.decodeJobConfig(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.execution$minusconfig(), this.ec);
    }

    public Future<SavepointResult> waitForSavepoint(String jobId, String savepointId, long timeoutLeft) {
        long start = System.currentTimeMillis();
        if (timeoutLeft <= 0L) {
            return Future$.MODULE$.failed((Throwable)new Exception(new StringBuilder(54).append("Failed to complete savepoint in time for ").append(new ExternalDeploymentId(jobId)).append(" and trigger ").append(savepointId).toString()));
        }
        return ((Future)sttp.client.package$.MODULE$.basicRequest().get(this.flinkUrl().path("jobs", jobId, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"savepoints", savepointId}))).response(package$.MODULE$.asJson(flinkRestModel$GetSavepointStatusResponse$.MODULE$.decodeGetSavepointStatusResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).flatMap((Function1 & Serializable & scala.Serializable)resp -> {
            Future future;
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Waiting for savepoint {} of {}, got response: {}", new Object[]{savepointId, new ExternalDeploymentId(jobId), resp});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (resp.isCompletedSuccessfully()) {
                BoxedUnit boxedUnit2;
                String location = (String)resp.operation().flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.location()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Savepoint {} for {} finished in {}", new Object[]{savepointId, new ExternalDeploymentId(jobId), location});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                future = Future$.MODULE$.successful((Object)new SavepointResult(location));
            } else if (resp.isFailed()) {
                future = Future$.MODULE$.failed((Throwable)new RuntimeException(new StringBuilder(30).append("Failed to complete savepoint: ").append(resp.operation()).toString()));
            } else {
                Thread.sleep(1000L);
                future = this.waitForSavepoint(jobId, savepointId, timeoutLeft - (System.currentTimeMillis() - start));
            }
            return future;
        }, this.ec);
    }

    public long waitForSavepoint$default$3() {
        return this.config.jobManagerTimeout().toMillis();
    }

    @Override
    public Future<BoxedUnit> cancel(String deploymentId) {
        Option option = HttpClientErrorHandler$.MODULE$.handleUnitResponse$default$2();
        return ((Future)sttp.client.package$.MODULE$.basicRequest().patch(this.flinkUrl().path("jobs", deploymentId, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> HttpClientErrorHandler$.MODULE$.handleUnitResponse("cancel scenario", option, response), this.ec).recoverWith(HttpClientErrorHandler$.MODULE$.recoverWithMessage("cancel scenario", HttpClientErrorHandler$.MODULE$.recoverWithMessage$default$2()), this.ec);
    }

    @Override
    public Future<SavepointResult> makeSavepoint(String deploymentId, Option<String> savepointDir) {
        RequestT savepointRequest = sttp.client.package$.MODULE$.basicRequest().post(this.flinkUrl().path("jobs", deploymentId, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"savepoints"}))).body((Object)new flinkRestModel.SavepointTriggerRequest(savepointDir, false), package$.MODULE$.circeBodySerializer(flinkRestModel$SavepointTriggerRequest$.MODULE$.encodeSavepointTriggerRequest(), package$.MODULE$.circeBodySerializer$default$2()));
        return this.processSavepointRequest(deploymentId, (RequestT<Object, Either<String, String>, Nothing$>)savepointRequest, "make savepoint");
    }

    @Override
    public Future<SavepointResult> stop(String deploymentId, Option<String> savepointDir) {
        RequestT stopRequest = sttp.client.package$.MODULE$.basicRequest().post(this.flinkUrl().path("jobs", deploymentId, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stop"}))).body((Object)new flinkRestModel.StopRequest(savepointDir, false), package$.MODULE$.circeBodySerializer(flinkRestModel$StopRequest$.MODULE$.encodeStopRequest(), package$.MODULE$.circeBodySerializer$default$2()));
        return this.processSavepointRequest(deploymentId, (RequestT<Object, Either<String, String>, Nothing$>)stopRequest, "stop scenario");
    }

    private Future<SavepointResult> processSavepointRequest(String deploymentId, RequestT<Object, Either<String, String>, Nothing$> request, String action) {
        return ((Future)request.response(package$.MODULE$.asJson(flinkRestModel$SavepointTriggerResponse$.MODULE$.decodeSavepointTriggerResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).flatMap((Function1 & Serializable & scala.Serializable)response -> this.waitForSavepoint(deploymentId, response.request$minusid(), this.waitForSavepoint$default$3()), this.ec).recoverWith(HttpClientErrorHandler$.MODULE$.recoverWithMessage(action, HttpClientErrorHandler$.MODULE$.recoverWithMessage$default$2()), this.ec);
    }

    public DeeplyCheckingExceptionExtractor<TimeoutException> pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor() {
        return this.pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor;
    }

    @Override
    public Future<Option<ExternalDeploymentId>> runProgram(File jarFile, String mainClass, List<String> args, Option<String> savepointPath) {
        flinkRestModel.DeployProcessRequest program = new flinkRestModel.DeployProcessRequest(mainClass, savepointPath, FlinkArgsEncodeHack$.MODULE$.prepareProgramArgs(args).mkString(" "), flinkRestModel$DeployProcessRequest$.MODULE$.apply$default$4(), flinkRestModel$DeployProcessRequest$.MODULE$.apply$default$5());
        return this.uploadJarFileIfNotExists(jarFile).flatMap((Function1 & Serializable & scala.Serializable)flinkJarFile -> ((Future)sttp.client.package$.MODULE$.basicRequest().post(this.flinkUrl().path("jars", flinkJarFile.id(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"run"}))).body((Object)program, package$.MODULE$.circeBodySerializer(flinkRestModel$DeployProcessRequest$.MODULE$.encodeDeployProcessRequest(), package$.MODULE$.circeBodySerializer$default$2())).response(package$.MODULE$.asJson(flinkRestModel$RunResponse$.MODULE$.codecForRunResponse(), IsOption$.MODULE$.otherIsNotOption())).send($this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), $this.ec).map((Function1 & Serializable & scala.Serializable)ret -> new Some((Object)new ExternalDeploymentId(ret.jobid())), $this.ec).recover((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpFlinkClient $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Option option = this.$outer.pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor().unapply(A1);
                if (!option.isEmpty()) {
                    BoxedUnit boxedUnit;
                    TimeoutException e = (TimeoutException)option.get();
                    if (this.$outer.logger().underlying().isWarnEnabled()) {
                        this.$outer.logger().underlying().warn("TimeoutException occurred while waiting for deploy result. Recovering with Future.successful...", (Throwable)e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = None$.MODULE$;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                Option option = this.$outer.pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor().unapply(throwable);
                boolean bl = !option.isEmpty();
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, $this.ec).recoverWith(HttpClientErrorHandler$.MODULE$.recoverWithMessage("deploy scenario", HttpClientErrorHandler$.MODULE$.recoverWithMessage$default$2()), $this.ec), this.ec);
    }

    public Future<flinkRestModel.ClusterOverview> getClusterOverview() {
        return ((Future)sttp.client.package$.MODULE$.basicRequest().get(this.flinkUrl().path("overview")).response(package$.MODULE$.asJson(flinkRestModel$ClusterOverview$.MODULE$.decodeClusterOverview(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec);
    }

    public Future<Configuration> getJobManagerConfig() {
        return ((Future)sttp.client.package$.MODULE$.basicRequest().get(this.flinkUrl().path("jobmanager", "config", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).response(package$.MODULE$.asJson(Decoder$.MODULE$.decodeList(flinkRestModel$KeyValueEntry$.MODULE$.decodeKeyValueEntry()), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).map((Function1 & Serializable & scala.Serializable)list -> this.configurationFromMap((Map<String, String>)((TraversableOnce)list.map((Function1 & Serializable & scala.Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.key()), (Object)e.value()), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())), this.ec);
    }

    /*
     * WARNING - void declaration
     */
    private Configuration configurationFromMap(Map<String, String> values) {
        void var2_2;
        Configuration configuration = new Configuration();
        values.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HttpFlinkClient.$anonfun$configurationFromMap$1(configuration, x0$1);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public static final /* synthetic */ boolean $anonfun$checkThatJarWithNameExists$3(String jarName$1, flinkRestModel.JarFile x$2) {
        String string = x$2.name();
        String string2 = jarName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findJobsByName$3(String jobName$1, flinkRestModel.JobOverview x$3) {
        String string = x$3.name();
        String string2 = jobName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$configurationFromMap$1(Configuration configuration$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        configuration$1.setString(k, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public HttpFlinkClient(FlinkConfig config, SttpBackend<Future, Nothing$, ?> backend, ExecutionContext ec) {
        this.config = config;
        this.backend = backend;
        this.ec = ec;
        LazyLogging.$init$((LazyLogging)this);
        this.flinkUrl = sttp.client.package$.MODULE$.UriContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).uri((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config.restUrl()}));
        this.pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor = DeeplyCheckingExceptionExtractor$.MODULE$.forClass(ClassTag$.MODULE$.apply(TimeoutException.class));
    }
}

