/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.management.rest;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.circe.Decoder$;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import org.apache.flink.configuration.Configuration;
import pl.touk.nussknacker.engine.api.deployment.SavepointResult;
import pl.touk.nussknacker.engine.deployment.ExternalDeploymentId;
import pl.touk.nussknacker.engine.management.FlinkArgsEncodeHack$;
import pl.touk.nussknacker.engine.management.FlinkConfig;
import pl.touk.nussknacker.engine.management.rest.FlinkClient;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$ClusterOverview$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$DeployProcessRequest$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$GetSavepointStatusResponse$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$JarsResponse$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$JobConfig$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$JobsResponse$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$KeyValueEntry$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$RunResponse$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$SavepointTriggerRequest$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$SavepointTriggerResponse$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$StopRequest$;
import pl.touk.nussknacker.engine.management.rest.flinkRestModel$UploadJarResponse$;
import pl.touk.nussknacker.engine.sttp.HttpClientErrorHandler$;
import pl.touk.nussknacker.engine.sttp.SttpJson$;
import pl.touk.nussknacker.engine.util.exception.DeeplyCheckingExceptionExtractor;
import pl.touk.nussknacker.engine.util.exception.DeeplyCheckingExceptionExtractor$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import sttp.client3.IsOption$;
import sttp.client3.RequestT;
import sttp.client3.SttpBackend;
import sttp.client3.circe.package$;
import sttp.model.Part;
import sttp.model.Uri;

@ScalaSignature(bytes="\u0006\u0001\t=e\u0001\u0002\u000e\u001c\u0001!B\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0006\u0007\"AA\u000b\u0001B\u0001B\u0003-Q\u000bC\u0003Y\u0001\u0011\u0005\u0011\fC\u0004`\u0001\t\u0007I\u0011\u00021\t\r\u001d\u0004\u0001\u0015!\u0003b\u0011\u0015A\u0007\u0001\"\u0001j\u0011\u001d\t9\u0002\u0001C\u0005\u00033Aq!a\u000e\u0001\t\u0003\tI\u0004C\u0004\u0002@\u0001!\t%!\u0011\t\u000f\u0005=\u0003\u0001\"\u0003\u0002R!9\u0011q\u000b\u0001\u0005\u0002\u0005e\u0003bBA=\u0001\u0011\u0005\u00111\u0010\u0005\b\u0003\u0017\u0003A\u0011AAG\u0011%\tY\fAI\u0001\n\u0003\ti\fC\u0004\u0002T\u0002!\t!!6\t\u000f\u0005m\u0007\u0001\"\u0001\u0002^\"9\u0011q\u001d\u0001\u0005\u0002\u0005%\bbBAx\u0001\u0011%\u0011\u0011\u001f\u0005\n\u0005;\u0001!\u0019!C\u0005\u0005?A\u0001B!\u0010\u0001A\u0003%!\u0011\u0005\u0005\b\u0005\u007f\u0001A\u0011\u0001B!\u0011\u001d\u00119\u0006\u0001C\u0001\u00053BqAa\u0019\u0001\t\u0003\u0011)\u0007C\u0004\u0003\u0002\u0002!IAa!\u0003\u001f!#H\u000f\u001d$mS:\\7\t\\5f]RT!\u0001H\u000f\u0002\tI,7\u000f\u001e\u0006\u0003=}\t!\"\\1oC\u001e,W.\u001a8u\u0015\t\u0001\u0013%\u0001\u0004f]\u001eLg.\u001a\u0006\u0003E\r\n1B\\;tg.t\u0017mY6fe*\u0011A%J\u0001\u0005i>,8NC\u0001'\u0003\t\u0001Hn\u0001\u0001\u0014\t\u0001Isf\r\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005A\nT\"A\u000e\n\u0005IZ\"a\u0003$mS:\\7\t\\5f]R\u0004\"\u0001N\u001e\u000e\u0003UR!AN\u001c\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005aJ\u0014\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003i\n1aY8n\u0013\taTGA\u0006MCjLHj\\4hS:<\u0017AB2p]\u001aLw\r\u0005\u0002@\u00016\tQ$\u0003\u0002B;\tYa\t\\5oW\u000e{gNZ5h\u0003\u001d\u0011\u0017mY6f]\u0012\u0004B\u0001R%L#6\tQI\u0003\u0002G\u000f\u000691\r\\5f]R\u001c$\"\u0001%\u0002\tM$H\u000f]\u0005\u0003\u0015\u0016\u00131b\u0015;ua\n\u000b7m[3oIB\u0011AjT\u0007\u0002\u001b*\u0011ajK\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001)N\u0005\u00191U\u000f^;sKB\u0011!FU\u0005\u0003'.\u00121!\u00118z\u0003\t)7\r\u0005\u0002M-&\u0011q+\u0014\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\fa\u0001P5oSRtDC\u0001._)\rYF,\u0018\t\u0003a\u0001AQA\u0011\u0003A\u0004\rCQ\u0001\u0016\u0003A\u0004UCQ!\u0010\u0003A\u0002y\n\u0001B\u001a7j].,&\u000f\\\u000b\u0002CB\u0011!-Z\u0007\u0002G*\u0011AmR\u0001\u0006[>$W\r\\\u0005\u0003M\u000e\u00141!\u0016:j\u0003%1G.\u001b8l+Jd\u0007%\u0001\rva2|\u0017\r\u001a&be\u001aKG.Z%g\u001d>$X\t_5tiN$2A[A\u0002!\rauj\u001b\t\u0003Yzt!!\u001c?\u000f\u00059\\hBA8{\u001d\t\u0001\u0018P\u0004\u0002rq:\u0011!o\u001e\b\u0003gZl\u0011\u0001\u001e\u0006\u0003k\u001e\na\u0001\u0010:p_Rt\u0014\"\u0001\u0014\n\u0005\u0011*\u0013B\u0001\u0012$\u0013\t\u0001\u0013%\u0003\u0002\u001f?%\u0011A$H\u0005\u0003{n\taB\u001a7j].\u0014Vm\u001d;N_\u0012,G.C\u0002\u0000\u0003\u0003\u0011qAS1s\r&dWM\u0003\u0002~7!9\u0011QA\u0004A\u0002\u0005\u001d\u0011a\u00026be\u001aKG.\u001a\t\u0005\u0003\u0013\t\u0019\"\u0004\u0002\u0002\f)!\u0011QBA\b\u0003\tIwN\u0003\u0002\u0002\u0012\u0005!!.\u0019<b\u0013\u0011\t)\"a\u0003\u0003\t\u0019KG.Z\u0001\u001bG\",7m\u001b+iCRT\u0015M],ji\"t\u0015-\\3Fq&\u001cHo\u001d\u000b\u0005\u00037\t\u0019\u0003\u0005\u0003M\u001f\u0006u\u0001\u0003\u0002\u0016\u0002 -L1!!\t,\u0005\u0019y\u0005\u000f^5p]\"9\u0011Q\u0005\u0005A\u0002\u0005\u001d\u0012a\u00026be:\u000bW.\u001a\t\u0005\u0003S\t\tD\u0004\u0003\u0002,\u00055\u0002CA:,\u0013\r\tycK\u0001\u0007!J,G-\u001a4\n\t\u0005M\u0012Q\u0007\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005=2&A\u0005va2|\u0017\r\u001a&beR!\u00111HA\u001f!\u0011au*a\n\t\u000f\u0005\u0015\u0011\u00021\u0001\u0002\b\u0005\tB-\u001a7fi\u0016T\u0015M]%g\u000bbL7\u000f^:\u0015\t\u0005\r\u00131\n\t\u0005\u0019>\u000b)\u0005E\u0002+\u0003\u000fJ1!!\u0013,\u0005\u0011)f.\u001b;\t\u000f\u00055#\u00021\u0001\u0002(\u0005Y!.\u0019:GS2,g*Y7f\u0003%!W\r\\3uK*\u000b'\u000f\u0006\u0003\u0002D\u0005M\u0003bBA+\u0017\u0001\u0007\u0011qE\u0001\u0006U\u0006\u0014\u0018\nZ\u0001\u000fM&tGMS8cg\nKh*Y7f)\u0011\tY&!\u001e\u0011\t1{\u0015Q\f\t\u0007\u0003?\nI'a\u001c\u000f\t\u0005\u0005\u0014Q\r\b\u0004g\u0006\r\u0014\"\u0001\u0017\n\u0007\u0005\u001d4&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005-\u0014Q\u000e\u0002\u0005\u0019&\u001cHOC\u0002\u0002h-\u00022\u0001\\A9\u0013\u0011\t\u0019(!\u0001\u0003\u0017){'m\u0014<feZLWm\u001e\u0005\b\u0003ob\u0001\u0019AA\u0014\u0003\u001dQwN\u0019(b[\u0016\fAbZ3u\u0015>\u00147i\u001c8gS\u001e$B!! \u0002\bB!AjTA@!\u0011\t\t)a!\u000f\u0005Ab\u0018\u0002BAC\u0003\u0003\u0011q\"\u0012=fGV$\u0018n\u001c8D_:4\u0017n\u001a\u0005\b\u0003\u0013k\u0001\u0019AA\u0014\u0003\u0015QwNY%e\u0003A9\u0018-\u001b;G_J\u001c\u0016M^3q_&tG\u000f\u0006\u0005\u0002\u0010\u0006\u0005\u0016QVAY!\u0011au*!%\u0011\t\u0005M\u0015QT\u0007\u0003\u0003+SA!a&\u0002\u001a\u0006QA-\u001a9m_flWM\u001c;\u000b\u0007\u0005mu$A\u0002ba&LA!a(\u0002\u0016\ny1+\u0019<fa>Lg\u000e\u001e*fgVdG\u000fC\u0004\u0002\n:\u0001\r!a)\u0011\t\u0005\u0015\u0016\u0011V\u0007\u0003\u0003OS1!a& \u0013\u0011\tY+a*\u0003)\u0015CH/\u001a:oC2$U\r\u001d7ps6,g\u000e^%e\u0011\u001d\tyK\u0004a\u0001\u0003O\t1b]1wKB|\u0017N\u001c;JI\"I\u00111\u0017\b\u0011\u0002\u0003\u0007\u0011QW\u0001\fi&lWm\\;u\u0019\u00164G\u000fE\u0002+\u0003oK1!!/,\u0005\u0011auN\\4\u00025]\f\u0017\u000e\u001e$peN\u000bg/\u001a9pS:$H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005}&\u0006BA[\u0003\u0003\\#!a1\u0011\t\u0005\u0015\u0017qZ\u0007\u0003\u0003\u000fTA!!3\u0002L\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u001b\\\u0013AC1o]>$\u0018\r^5p]&!\u0011\u0011[Ad\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0007G\u0006t7-\u001a7\u0015\t\u0005\r\u0013q\u001b\u0005\b\u00033\u0004\u0002\u0019AAR\u00031!W\r\u001d7ps6,g\u000e^%e\u00035i\u0017m[3TCZ,\u0007o\\5oiR1\u0011qRAp\u0003CDq!!7\u0012\u0001\u0004\t\u0019\u000bC\u0004\u0002dF\u0001\r!!:\u0002\u0019M\fg/\u001a9pS:$H)\u001b:\u0011\u000b)\ny\"a\n\u0002\tM$x\u000e\u001d\u000b\u0007\u0003\u001f\u000bY/!<\t\u000f\u0005e'\u00031\u0001\u0002$\"9\u00111\u001d\nA\u0002\u0005\u0015\u0018a\u00069s_\u000e,7o]*bm\u0016\u0004x.\u001b8u%\u0016\fX/Z:u)!\ty)a=\u0002v\ne\u0001bBAm'\u0001\u0007\u00111\u0015\u0005\b\u0003o\u001c\u0002\u0019AA}\u0003\u001d\u0011X-];fgR\u0004\u0002\u0002RA~\u0003\u007f\u0014\u0019\"U\u0005\u0004\u0003{,%\u0001\u0003*fcV,7\u000f\u001e+\u0011\t\t\u0005!Q\u0002\b\u0005\u0005\u0007\u0011YA\u0004\u0003\u0003\u0006\t%abA:\u0003\b%\t\u0001*\u0003\u0002G\u000f&\u0019\u0011qM#\n\t\t=!\u0011\u0003\u0002\t\u0013\u0012,g\u000e^5us*\u0019\u0011qM#\u0011\u0011\u0005}#QCA\u0014\u0003OIAAa\u0006\u0002n\t1Q)\u001b;iKJDqAa\u0007\u0014\u0001\u0004\t9#\u0001\u0004bGRLwN\\\u0001\u0011i&lWm\\;u\u000bb$(/Y2u_J,\"A!\t\u0011\r\t\r\"Q\u0006B\u0019\u001b\t\u0011)C\u0003\u0003\u0003(\t%\u0012!C3yG\u0016\u0004H/[8o\u0015\r\u0011YcH\u0001\u0005kRLG.\u0003\u0003\u00030\t\u0015\"\u0001\t#fKBd\u0017p\u00115fG.LgnZ#yG\u0016\u0004H/[8o\u000bb$(/Y2u_J\u0004BAa\r\u0003:5\u0011!Q\u0007\u0006\u0004\u001d\n]\"\u0002\u0002B\u0016\u0003\u001fIAAa\u000f\u00036\t\u0001B+[7f_V$X\t_2faRLwN\\\u0001\u0012i&lWm\\;u\u000bb$(/Y2u_J\u0004\u0013A\u0003:v]B\u0013xn\u001a:b[RQ!1\tB$\u0005\u0013\u0012iEa\u0015\u0011\t1{%Q\t\t\u0006U\u0005}\u00111\u0015\u0005\b\u0003\u000b1\u0002\u0019AA\u0004\u0011\u001d\u0011YE\u0006a\u0001\u0003O\t\u0011\"\\1j]\u000ec\u0017m]:\t\u000f\t=c\u00031\u0001\u0003R\u0005!\u0011M]4t!\u0019\ty&!\u001b\u0002(!9!Q\u000b\fA\u0002\u0005\u0015\u0018!D:bm\u0016\u0004x.\u001b8u!\u0006$\b.\u0001\nhKR\u001cE.^:uKJ|e/\u001a:wS\u0016<XC\u0001B.!\u0011auJ!\u0018\u0011\u00071\u0014y&\u0003\u0003\u0003b\u0005\u0005!aD\"mkN$XM](wKJ4\u0018.Z<\u0002'\u001d,GOS8c\u001b\u0006t\u0017mZ3s\u0007>tg-[4\u0016\u0005\t\u001d\u0004\u0003\u0002'P\u0005S\u0002BAa\u001b\u0003~5\u0011!Q\u000e\u0006\u0005\u0005_\u0012\t(A\u0007d_:4\u0017nZ;sCRLwN\u001c\u0006\u0005\u0005g\u0012)(A\u0003gY&t7N\u0003\u0003\u0003x\te\u0014AB1qC\u000eDWM\u0003\u0002\u0003|\u0005\u0019qN]4\n\t\t}$Q\u000e\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002)\r|gNZ5hkJ\fG/[8o\rJ|W.T1q)\u0011\u0011IG!\"\t\u000f\t\u001d\u0015\u00041\u0001\u0003\n\u00061a/\u00197vKN\u0004\u0002\"!\u000b\u0003\f\u0006\u001d\u0012qE\u0005\u0005\u0005\u001b\u000b)DA\u0002NCB\u0004")
public class HttpFlinkClient
implements FlinkClient,
LazyLogging {
    private final FlinkConfig config;
    private final SttpBackend<Future, Object> backend;
    private final ExecutionContext ec;
    private final Uri flinkUrl;
    private final DeeplyCheckingExceptionExtractor<TimeoutException> pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        HttpFlinkClient httpFlinkClient = this;
        synchronized (httpFlinkClient) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private Uri flinkUrl() {
        return this.flinkUrl;
    }

    public Future<flinkRestModel.JarFile> uploadJarFileIfNotExists(File jarFile) {
        return this.checkThatJarWithNameExists(jarFile.getName()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                flinkRestModel.JarFile file = (flinkRestModel.JarFile)some.value();
                future = Future$.MODULE$.successful((Object)file);
            } else if (None$.MODULE$.equals(option)) {
                future = this.uploadJar(jarFile).map((Function1 & Serializable & scala.Serializable)id -> new flinkRestModel.JarFile((String)id, jarFile.getName()), $this.ec);
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, this.ec);
    }

    private Future<Option<flinkRestModel.JarFile>> checkThatJarWithNameExists(String jarName) {
        return ((Future)sttp.client3.package$.MODULE$.basicRequest().get(this.flinkUrl().addPath("jars", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).response(package$.MODULE$.asJson(flinkRestModel$JarsResponse$.MODULE$.decodeJarsResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).map((Function1 & Serializable & scala.Serializable)x$1 -> ((LinearSeqOptimized)x$1.files().toList().flatten((Function1)Predef$.MODULE$.$conforms())).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HttpFlinkClient.$anonfun$checkThatJarWithNameExists$3(jarName, x$2))), this.ec);
    }

    public Future<String> uploadJar(File jarFile) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Uploading new jar: {}", new Object[]{jarFile.getAbsolutePath()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return ((Future)sttp.client3.package$.MODULE$.basicRequest().post(this.flinkUrl().addPath("jars", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"upload"}))).multipartBody(sttp.client3.package$.MODULE$.multipartFile("jarfile", jarFile).contentType("application/x-java-archive"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Part[0])).response(package$.MODULE$.asJson(flinkRestModel$UploadJarResponse$.MODULE$.decodeUploadJarResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).map((Function1 & Serializable & scala.Serializable)file -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Uploaded jar to {}", new Object[]{file});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return new File(file.filename()).getName();
        }, this.ec).recoverWith(HttpClientErrorHandler$.MODULE$.recoverWithMessage("upload Nussnknacker jar to Flink", HttpClientErrorHandler$.MODULE$.recoverWithMessage$default$2()), this.ec);
    }

    @Override
    public Future<BoxedUnit> deleteJarIfExists(String jarFileName) {
        return this.checkThatJarWithNameExists(jarFileName).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                flinkRestModel.JarFile file = (flinkRestModel.JarFile)some.value();
                future = this.deleteJar(file.id()).recover((PartialFunction)new scala.Serializable(this, jarFileName){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HttpFlinkClient $outer;
                    private final String jarFileName$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        BoxedUnit boxedUnit;
                        A1 A1 = x1;
                        if (this.$outer.logger().underlying().isWarnEnabled()) {
                            this.$outer.logger().underlying().warn(new StringBuilder(22).append("Failed to delete jar: ").append(this.jarFileName$1).toString(), A1);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        return (B1)boxedUnit2;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        boolean bl = true;
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.jarFileName$1 = jarFileName$1;
                    }
                }, $this.ec);
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("{} does not exist, not removing", new Object[]{jarFileName});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, this.ec);
    }

    private Future<BoxedUnit> deleteJar(String jarId) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Delete jar id: {}", new Object[]{jarId});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Option option = HttpClientErrorHandler$.MODULE$.handleUnitResponse$default$2();
        return ((Future)sttp.client3.package$.MODULE$.basicRequest().delete(this.flinkUrl().addPath("jars", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{jarId}))).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> HttpClientErrorHandler$.MODULE$.handleUnitResponse("delete jar", option, response), this.ec).recoverWith(HttpClientErrorHandler$.MODULE$.recoverWithMessage("delete jar", HttpClientErrorHandler$.MODULE$.recoverWithMessage$default$2()), this.ec);
    }

    @Override
    public Future<List<flinkRestModel.JobOverview>> findJobsByName(String jobName) {
        return ((Future)sttp.client3.package$.MODULE$.basicRequest().get(this.flinkUrl().addPath("jobs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"overview"}))).response(package$.MODULE$.asJson(flinkRestModel$JobsResponse$.MODULE$.decodeJobsResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).map((Function1 & Serializable & scala.Serializable)jobs -> ((List)((SeqLike)jobs.jobs().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)HttpFlinkClient.$anonfun$findJobsByName$3(jobName, x$3)))).sortBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.last$minusmodification()), (Ordering)Ordering.Long$.MODULE$)).reverse(), this.ec).recoverWith(HttpClientErrorHandler$.MODULE$.recoverWithMessage("retrieve Flink jobs", HttpClientErrorHandler$.MODULE$.recoverWithMessage$default$2()), this.ec);
    }

    @Override
    public Future<flinkRestModel.ExecutionConfig> getJobConfig(String jobId) {
        return ((Future)sttp.client3.package$.MODULE$.basicRequest().get(this.flinkUrl().addPath("jobs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{jobId, "config"}))).response(package$.MODULE$.asJson(flinkRestModel$JobConfig$.MODULE$.decodeJobConfig(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.execution$minusconfig(), this.ec);
    }

    public Future<SavepointResult> waitForSavepoint(String jobId, String savepointId, long timeoutLeft) {
        long start = System.currentTimeMillis();
        if (timeoutLeft <= 0L) {
            return Future$.MODULE$.failed((Throwable)new Exception(new StringBuilder(54).append("Failed to complete savepoint in time for ").append(new ExternalDeploymentId(jobId)).append(" and trigger ").append(savepointId).toString()));
        }
        return ((Future)sttp.client3.package$.MODULE$.basicRequest().get(this.flinkUrl().addPath("jobs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{jobId, "savepoints", savepointId}))).response(package$.MODULE$.asJson(flinkRestModel$GetSavepointStatusResponse$.MODULE$.decodeGetSavepointStatusResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).flatMap((Function1 & Serializable & scala.Serializable)resp -> {
            Future future;
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Waiting for savepoint {} of {}, got response: {}", new Object[]{savepointId, new ExternalDeploymentId(jobId), resp});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (resp.isCompletedSuccessfully()) {
                BoxedUnit boxedUnit2;
                String location = (String)resp.operation().flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.location()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Savepoint {} for {} finished in {}", new Object[]{savepointId, new ExternalDeploymentId(jobId), location});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                future = Future$.MODULE$.successful((Object)new SavepointResult(location));
            } else if (resp.isFailed()) {
                future = Future$.MODULE$.failed((Throwable)new RuntimeException(new StringBuilder(30).append("Failed to complete savepoint: ").append(resp.operation()).toString()));
            } else {
                Thread.sleep(1000L);
                future = this.waitForSavepoint(jobId, savepointId, timeoutLeft - (System.currentTimeMillis() - start));
            }
            return future;
        }, this.ec);
    }

    public long waitForSavepoint$default$3() {
        return this.config.jobManagerTimeout().toMillis();
    }

    @Override
    public Future<BoxedUnit> cancel(String deploymentId) {
        Option option = HttpClientErrorHandler$.MODULE$.handleUnitResponse$default$2();
        return ((Future)sttp.client3.package$.MODULE$.basicRequest().patch(this.flinkUrl().addPath("jobs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{deploymentId}))).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> HttpClientErrorHandler$.MODULE$.handleUnitResponse("cancel scenario", option, response), this.ec).recoverWith(HttpClientErrorHandler$.MODULE$.recoverWithMessage("cancel scenario", HttpClientErrorHandler$.MODULE$.recoverWithMessage$default$2()), this.ec);
    }

    @Override
    public Future<SavepointResult> makeSavepoint(String deploymentId, Option<String> savepointDir) {
        RequestT savepointRequest = sttp.client3.package$.MODULE$.basicRequest().post(this.flinkUrl().addPath("jobs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{deploymentId, "savepoints"}))).body((Object)new flinkRestModel.SavepointTriggerRequest(savepointDir, false), package$.MODULE$.circeBodySerializer(flinkRestModel$SavepointTriggerRequest$.MODULE$.encodeSavepointTriggerRequest(), package$.MODULE$.circeBodySerializer$default$2()));
        return this.processSavepointRequest(deploymentId, (RequestT<Object, Either<String, String>, Object>)savepointRequest, "make savepoint");
    }

    @Override
    public Future<SavepointResult> stop(String deploymentId, Option<String> savepointDir) {
        RequestT stopRequest = sttp.client3.package$.MODULE$.basicRequest().post(this.flinkUrl().addPath("jobs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{deploymentId, "stop"}))).body((Object)new flinkRestModel.StopRequest(savepointDir, false), package$.MODULE$.circeBodySerializer(flinkRestModel$StopRequest$.MODULE$.encodeStopRequest(), package$.MODULE$.circeBodySerializer$default$2()));
        return this.processSavepointRequest(deploymentId, (RequestT<Object, Either<String, String>, Object>)stopRequest, "stop scenario");
    }

    private Future<SavepointResult> processSavepointRequest(String deploymentId, RequestT<Object, Either<String, String>, Object> request, String action) {
        return ((Future)request.response(package$.MODULE$.asJson(flinkRestModel$SavepointTriggerResponse$.MODULE$.decodeSavepointTriggerResponse(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).flatMap((Function1 & Serializable & scala.Serializable)response -> this.waitForSavepoint(deploymentId, response.request$minusid(), this.waitForSavepoint$default$3()), this.ec).recoverWith(HttpClientErrorHandler$.MODULE$.recoverWithMessage(action, HttpClientErrorHandler$.MODULE$.recoverWithMessage$default$2()), this.ec);
    }

    public DeeplyCheckingExceptionExtractor<TimeoutException> pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor() {
        return this.pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor;
    }

    @Override
    public Future<Option<ExternalDeploymentId>> runProgram(File jarFile, String mainClass, List<String> args, Option<String> savepointPath) {
        flinkRestModel.DeployProcessRequest program = new flinkRestModel.DeployProcessRequest(mainClass, savepointPath, FlinkArgsEncodeHack$.MODULE$.prepareProgramArgs(args).mkString(" "), flinkRestModel$DeployProcessRequest$.MODULE$.apply$default$4(), flinkRestModel$DeployProcessRequest$.MODULE$.apply$default$5());
        return this.uploadJarFileIfNotExists(jarFile).flatMap((Function1 & Serializable & scala.Serializable)flinkJarFile -> ((Future)sttp.client3.package$.MODULE$.basicRequest().post(this.flinkUrl().addPath("jars", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{flinkJarFile.id(), "run"}))).body((Object)program, package$.MODULE$.circeBodySerializer(flinkRestModel$DeployProcessRequest$.MODULE$.encodeDeployProcessRequest(), package$.MODULE$.circeBodySerializer$default$2())).response(package$.MODULE$.asJson(flinkRestModel$RunResponse$.MODULE$.codecForRunResponse(), IsOption$.MODULE$.otherIsNotOption())).send($this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), $this.ec).map((Function1 & Serializable & scala.Serializable)ret -> new Some((Object)new ExternalDeploymentId(ret.jobid())), $this.ec).recover((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpFlinkClient $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Option option = this.$outer.pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor().unapply(A1);
                if (!option.isEmpty()) {
                    BoxedUnit boxedUnit;
                    TimeoutException e = (TimeoutException)option.get();
                    if (this.$outer.logger().underlying().isWarnEnabled()) {
                        this.$outer.logger().underlying().warn("TimeoutException occurred while waiting for deploy result. Recovering with Future.successful...", (Throwable)e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = None$.MODULE$;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                Option option = this.$outer.pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor().unapply(throwable);
                boolean bl = !option.isEmpty();
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, $this.ec).recoverWith(HttpClientErrorHandler$.MODULE$.recoverWithMessage("deploy scenario", HttpClientErrorHandler$.MODULE$.recoverWithMessage$default$2()), $this.ec), this.ec);
    }

    public Future<flinkRestModel.ClusterOverview> getClusterOverview() {
        return ((Future)sttp.client3.package$.MODULE$.basicRequest().get(this.flinkUrl().addPath("overview", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).response(package$.MODULE$.asJson(flinkRestModel$ClusterOverview$.MODULE$.decodeClusterOverview(), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec);
    }

    public Future<Configuration> getJobManagerConfig() {
        return ((Future)sttp.client3.package$.MODULE$.basicRequest().get(this.flinkUrl().addPath("jobmanager", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"config"}))).response(package$.MODULE$.asJson(Decoder$.MODULE$.decodeList(flinkRestModel$KeyValueEntry$.MODULE$.decodeKeyValueEntry()), IsOption$.MODULE$.otherIsNotOption())).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)response -> SttpJson$.MODULE$.failureToFuture(response), this.ec).map((Function1 & Serializable & scala.Serializable)list -> this.configurationFromMap((Map<String, String>)((TraversableOnce)list.map((Function1 & Serializable & scala.Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.key()), (Object)e.value()), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())), this.ec);
    }

    /*
     * WARNING - void declaration
     */
    private Configuration configurationFromMap(Map<String, String> values) {
        void var2_2;
        Configuration configuration = new Configuration();
        values.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HttpFlinkClient.$anonfun$configurationFromMap$1(configuration, x0$1);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public static final /* synthetic */ boolean $anonfun$checkThatJarWithNameExists$3(String jarName$1, flinkRestModel.JarFile x$2) {
        String string = x$2.name();
        String string2 = jarName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findJobsByName$3(String jobName$1, flinkRestModel.JobOverview x$3) {
        String string = x$3.name();
        String string2 = jobName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$configurationFromMap$1(Configuration configuration$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        configuration$1.setString(k, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public HttpFlinkClient(FlinkConfig config, SttpBackend<Future, Object> backend, ExecutionContext ec) {
        this.config = config;
        this.backend = backend;
        this.ec = ec;
        LazyLogging.$init$((LazyLogging)this);
        this.flinkUrl = sttp.client3.package$.MODULE$.UriContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).uri((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config.restUrl()}));
        this.pl$touk$nussknacker$engine$management$rest$HttpFlinkClient$$timeoutExtractor = DeeplyCheckingExceptionExtractor$.MODULE$.forClass(ClassTag$.MODULE$.apply(TimeoutException.class));
    }
}

