/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.definition.parameter;

import java.io.Serializable;
import java.util.Optional;
import pl.touk.nussknacker.engine.api.AdditionalVariable;
import pl.touk.nussknacker.engine.api.AdditionalVariables;
import pl.touk.nussknacker.engine.api.BranchParamName;
import pl.touk.nussknacker.engine.api.LazyParameter;
import pl.touk.nussknacker.engine.api.ParamName;
import pl.touk.nussknacker.engine.api.component.ParameterConfig;
import pl.touk.nussknacker.engine.api.component.SingleComponentConfig;
import pl.touk.nussknacker.engine.api.definition.AdditionalVariableProvidedInRuntime;
import pl.touk.nussknacker.engine.api.definition.AdditionalVariableWithFixedValue;
import pl.touk.nussknacker.engine.api.definition.Parameter;
import pl.touk.nussknacker.engine.api.definition.ParameterEditor;
import pl.touk.nussknacker.engine.api.definition.ParameterValidator;
import pl.touk.nussknacker.engine.api.typed.typing;
import pl.touk.nussknacker.engine.definition.parameter.OptionalDeterminer$;
import pl.touk.nussknacker.engine.definition.parameter.ParameterData;
import pl.touk.nussknacker.engine.definition.parameter.ParameterData$;
import pl.touk.nussknacker.engine.definition.parameter.defaults.DefaultValueDeterminerChain$;
import pl.touk.nussknacker.engine.definition.parameter.defaults.DefaultValueDeterminerParameters;
import pl.touk.nussknacker.engine.definition.parameter.editor.EditorExtractor$;
import pl.touk.nussknacker.engine.definition.parameter.validator.ValidatorExtractorParameters;
import pl.touk.nussknacker.engine.definition.parameter.validator.ValidatorsExtractor$;
import pl.touk.nussknacker.engine.graph.expression.Expression;
import pl.touk.nussknacker.engine.types.EspTypeUtils$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;

public final class ParameterExtractor$ {
    public static final ParameterExtractor$ MODULE$ = new ParameterExtractor$();

    public Parameter extractParameter(java.lang.reflect.Parameter p, SingleComponentConfig componentConfig) {
        Option nodeParamNames = Option$.MODULE$.apply((Object)p.getAnnotation(ParamName.class)).map((Function1 & Serializable)x$1 -> x$1.value());
        Option branchParamName = Option$.MODULE$.apply((Object)p.getAnnotation(BranchParamName.class)).map((Function1 & Serializable)x$2 -> x$2.value());
        String name = (String)nodeParamNames.orElse((Function0 & Serializable)() -> branchParamName).getOrElse((Function0 & Serializable)() -> MODULE$.throwIllegalArgument(p, false, "missing @ParamName or @BranchParamName annotation"));
        ParameterConfig parameterConfig = componentConfig.paramConfig(name);
        typing.TypingResult rawParamType = EspTypeUtils$.MODULE$.extractParameterType(p);
        typing.TypingResult paramWithUnwrappedBranch = branchParamName.isDefined() ? this.extractBranchParamType(rawParamType, p) : rawParamType;
        Tuple2<typing.TypingResult, Object> tuple2 = this.determineIfLazyParameter(paramWithUnwrappedBranch);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        typing.TypingResult paramTypeWithUnwrappedLazy = (typing.TypingResult)tuple2._1();
        boolean isLazyParameter = tuple2._2$mcZ$sp();
        Tuple2 tuple22 = new Tuple2((Object)paramTypeWithUnwrappedLazy, (Object)BoxesRunTime.boxToBoolean((boolean)isLazyParameter));
        typing.TypingResult paramTypeWithUnwrappedLazy2 = (typing.TypingResult)tuple22._1();
        boolean isLazyParameter2 = tuple22._2$mcZ$sp();
        Tuple3<typing.TypingResult, Object, Object> tuple3 = this.determineOptionalParameter(paramTypeWithUnwrappedLazy2);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        typing.TypingResult paramType = (typing.TypingResult)tuple3._1();
        boolean isScalaOptionParameter = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
        boolean isJavaOptionalParameter = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)paramType, (Object)BoxesRunTime.boxToBoolean((boolean)isScalaOptionParameter), (Object)BoxesRunTime.boxToBoolean((boolean)isJavaOptionalParameter));
        typing.TypingResult paramType2 = (typing.TypingResult)tuple32._1();
        boolean isScalaOptionParameter2 = BoxesRunTime.unboxToBoolean((Object)tuple32._2());
        boolean isJavaOptionalParameter2 = BoxesRunTime.unboxToBoolean((Object)tuple32._3());
        ParameterData parameterData = ParameterData$.MODULE$.apply(p, paramType2);
        boolean isOptional = OptionalDeterminer$.MODULE$.isOptional(parameterData, isScalaOptionParameter2, isJavaOptionalParameter2);
        Option<ParameterEditor> editor = EditorExtractor$.MODULE$.extract(parameterData, parameterConfig);
        List<ParameterValidator> validators = ValidatorsExtractor$.MODULE$.extract(new ValidatorExtractorParameters(parameterData, isOptional, parameterConfig, editor));
        Option<Expression> defaultValue = DefaultValueDeterminerChain$.MODULE$.determineParameterDefaultValue(new DefaultValueDeterminerParameters(parameterData, isOptional, parameterConfig, editor));
        return new Parameter(name, paramType2, editor, validators, defaultValue, this.additionalVariables(p, isLazyParameter2), Predef$.MODULE$.Set().empty(), branchParamName.isDefined(), isLazyParameter2, isScalaOptionParameter2, isJavaOptionalParameter2);
    }

    private typing.TypingResult extractBranchParamType(typing.TypingResult typ, java.lang.reflect.Parameter p) {
        typing.TypingResult typingResult = typ;
        if (typingResult instanceof typing.TypedClass) {
            typing.TypedClass typedClass = (typing.TypedClass)typingResult;
            Class cl = typedClass.klass();
            List list = typedClass.params();
            if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                typing.TypingResult typingResult2 = (typing.TypingResult)colon2.head();
                List list2 = colon2.next$access$1();
                if (typingResult2 instanceof typing.TypedClass) {
                    typing.TypedClass typedClass2 = (typing.TypedClass)typingResult2;
                    Class keyClass = typedClass2.klass();
                    if (list2 instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list2;
                        typing.TypingResult valueType = (typing.TypingResult)colon3.head();
                        List list3 = colon3.next$access$1();
                        if (Nil$.MODULE$.equals(list3) && Map.class.isAssignableFrom(cl) && String.class.isAssignableFrom(keyClass)) {
                            return valueType;
                        }
                    }
                }
            }
        }
        throw this.throwIllegalArgument(p, true, "invalid type: should be Map[String, T]");
    }

    private Nothing$ throwIllegalArgument(java.lang.reflect.Parameter p, boolean isBranch, String message) {
        String method = p.getDeclaringExecutable().getName();
        String declaring = p.getDeclaringExecutable().getDeclaringClass().getName();
        String parameterType = isBranch ? "Branch parameter" : "Parameter";
        throw new IllegalArgumentException(parameterType + " " + p + " of method: " + method + " in class: " + declaring + " has " + message);
    }

    private Tuple2<typing.TypingResult, Object> determineIfLazyParameter(typing.TypingResult typ) {
        typing.TypingResult typingResult = typ;
        if (typingResult instanceof typing.TypedClass) {
            typing.TypedClass typedClass = (typing.TypedClass)typingResult;
            Class cl = typedClass.klass();
            List genericParams = typedClass.params();
            if (LazyParameter.class.isAssignableFrom(cl)) {
                return new Tuple2(genericParams.head(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
        }
        return new Tuple2((Object)typ, (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    private Tuple3<typing.TypingResult, Object, Object> determineOptionalParameter(typing.TypingResult typ) {
        boolean bl = false;
        typing.TypedClass typedClass = null;
        typing.TypingResult typingResult = typ;
        if (typingResult instanceof typing.TypedClass) {
            bl = true;
            typedClass = (typing.TypedClass)typingResult;
            Class cl = typedClass.klass();
            List genericParams = typedClass.params();
            if (Option.class.isAssignableFrom(cl)) {
                return new Tuple3(genericParams.head(), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
        }
        if (bl) {
            Class cl = typedClass.klass();
            List genericParams = typedClass.params();
            if (Optional.class.isAssignableFrom(cl)) {
                return new Tuple3(genericParams.head(), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
        }
        return new Tuple3((Object)typ, (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    private Map<String, pl.touk.nussknacker.engine.api.definition.AdditionalVariable> additionalVariables(java.lang.reflect.Parameter p, boolean isLazyParameter) {
        return (Map)Option$.MODULE$.apply((Object)p.getAnnotation(AdditionalVariables.class)).map((Function1 & Serializable)x$5 -> Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])x$5.value()), (Function1 & Serializable)additionalVariable -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)additionalVariable.name()), (Object)MODULE$.createAdditionalVariable((AdditionalVariable)additionalVariable, isLazyParameter)), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty());
    }

    private pl.touk.nussknacker.engine.api.definition.AdditionalVariable createAdditionalVariable(AdditionalVariable additionalVariable, boolean isLazyParameter) {
        Class valueClass = additionalVariable.clazz();
        typing.TypingResult type = typing.Typed$.MODULE$.apply(valueClass);
        if (isLazyParameter) {
            return new AdditionalVariableProvidedInRuntime(type);
        }
        return new AdditionalVariableWithFixedValue(this.initClassForAdditionalVariable(valueClass), type);
    }

    private Object initClassForAdditionalVariable(Class<?> clazz) {
        Object obj;
        try {
            obj = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new IllegalArgumentException("Failed to create instance of " + clazz.getName() + ", it has to have no-arg constructor to be injected as AdditionalVariable", e);
            }
            throw throwable;
        }
        return obj;
    }

    private ParameterExtractor$() {
    }
}

