/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.definition.parameter.editor;

import java.io.Serializable;
import pl.touk.nussknacker.engine.api.component.ParameterConfig;
import pl.touk.nussknacker.engine.api.definition.BoolParameterEditor$;
import pl.touk.nussknacker.engine.api.definition.CronParameterEditor$;
import pl.touk.nussknacker.engine.api.definition.DateParameterEditor$;
import pl.touk.nussknacker.engine.api.definition.DateTimeParameterEditor$;
import pl.touk.nussknacker.engine.api.definition.DualParameterEditor;
import pl.touk.nussknacker.engine.api.definition.DurationParameterEditor;
import pl.touk.nussknacker.engine.api.definition.FixedExpressionValue;
import pl.touk.nussknacker.engine.api.definition.FixedValuesParameterEditor;
import pl.touk.nussknacker.engine.api.definition.JsonParameterEditor$;
import pl.touk.nussknacker.engine.api.definition.ParameterEditor;
import pl.touk.nussknacker.engine.api.definition.PeriodParameterEditor;
import pl.touk.nussknacker.engine.api.definition.RawParameterEditor$;
import pl.touk.nussknacker.engine.api.definition.SimpleParameterEditor;
import pl.touk.nussknacker.engine.api.definition.SpelTemplateParameterEditor$;
import pl.touk.nussknacker.engine.api.definition.SqlParameterEditor$;
import pl.touk.nussknacker.engine.api.definition.StringParameterEditor$;
import pl.touk.nussknacker.engine.api.definition.TextareaParameterEditor$;
import pl.touk.nussknacker.engine.api.definition.TimeParameterEditor$;
import pl.touk.nussknacker.engine.api.editor.DualEditor;
import pl.touk.nussknacker.engine.api.editor.DualEditorMode;
import pl.touk.nussknacker.engine.api.editor.RawEditor;
import pl.touk.nussknacker.engine.api.editor.SimpleEditor;
import pl.touk.nussknacker.engine.api.editor.SimpleEditorType;
import pl.touk.nussknacker.engine.definition.parameter.ParameterData;
import pl.touk.nussknacker.engine.definition.parameter.editor.ParameterTypeEditorDeterminer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;

public final class EditorExtractor$ {
    public static final EditorExtractor$ MODULE$ = new EditorExtractor$();

    public Option<ParameterEditor> extract(ParameterData param, ParameterConfig parameterConfig) {
        return parameterConfig.editor().orElse((Function0 & Serializable)() -> MODULE$.extractFromAnnotations(param)).orElse((Function0 & Serializable)() -> new ParameterTypeEditorDeterminer(param.typing()).determine());
    }

    private Option<ParameterEditor> extractFromAnnotations(ParameterData param) {
        Option rawEditorAnnotation;
        Option simpleEditorAnnotation;
        Option dualEditorAnnotation = param.getAnnotation(ClassTag$.MODULE$.apply(DualEditor.class));
        Tuple3 tuple3 = new Tuple3(dualEditorAnnotation, simpleEditorAnnotation = param.getAnnotation(ClassTag$.MODULE$.apply(SimpleEditor.class)), rawEditorAnnotation = param.getAnnotation(ClassTag$.MODULE$.apply(RawEditor.class)));
        if (tuple3 != null) {
            Some some;
            DualEditor dualEditorAnnotation2;
            Option option = (Option)tuple3._1();
            Option option2 = (Option)tuple3._2();
            Option option3 = (Option)tuple3._3();
            if (option instanceof Some && (dualEditorAnnotation2 = (DualEditor)(some = (Some)option).value()) != null) {
                DualEditor dualEditor = dualEditorAnnotation2;
                if (None$.MODULE$.equals(option2) && None$.MODULE$.equals(option3)) {
                    DualEditorMode defaultMode = dualEditor.defaultMode();
                    SimpleEditor simpleEditor = dualEditor.simpleEditor();
                    return new Some((Object)new DualParameterEditor(this.simpleParameterEditor(simpleEditor), defaultMode));
                }
            }
        }
        if (tuple3 != null) {
            Some some;
            SimpleEditor simpleEditorAnnotation2;
            Option option = (Option)tuple3._1();
            Option option4 = (Option)tuple3._2();
            Option option5 = (Option)tuple3._3();
            if (None$.MODULE$.equals(option) && option4 instanceof Some && (simpleEditorAnnotation2 = (SimpleEditor)(some = (Some)option4).value()) != null) {
                SimpleEditor simpleEditor = simpleEditorAnnotation2;
                if (None$.MODULE$.equals(option5)) {
                    return new Some((Object)this.simpleParameterEditor(simpleEditor));
                }
            }
        }
        if (tuple3 != null) {
            Some some;
            Option option = (Option)tuple3._1();
            Option option6 = (Option)tuple3._2();
            Option option7 = (Option)tuple3._3();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option6) && option7 instanceof Some && (some = (Some)option7).value() != null) {
                return new Some((Object)RawParameterEditor$.MODULE$);
            }
        }
        return None$.MODULE$;
    }

    private SimpleParameterEditor simpleParameterEditor(SimpleEditor simpleEditor) {
        SimpleEditorType simpleEditorType = simpleEditor.type();
        if (SimpleEditorType.BOOL_EDITOR.equals(simpleEditorType)) {
            return BoolParameterEditor$.MODULE$;
        }
        if (SimpleEditorType.STRING_EDITOR.equals(simpleEditorType)) {
            return StringParameterEditor$.MODULE$;
        }
        if (SimpleEditorType.FIXED_VALUES_EDITOR.equals(simpleEditorType)) {
            return new FixedValuesParameterEditor(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])simpleEditor.possibleValues()), (Function1 & Serializable)value -> new FixedExpressionValue(value.expression(), value.label()), ClassTag$.MODULE$.apply(FixedExpressionValue.class))).toList());
        }
        if (SimpleEditorType.DATE_EDITOR.equals(simpleEditorType)) {
            return DateParameterEditor$.MODULE$;
        }
        if (SimpleEditorType.TIME_EDITOR.equals(simpleEditorType)) {
            return TimeParameterEditor$.MODULE$;
        }
        if (SimpleEditorType.DATE_TIME_EDITOR.equals(simpleEditorType)) {
            return DateTimeParameterEditor$.MODULE$;
        }
        if (SimpleEditorType.DURATION_EDITOR.equals(simpleEditorType)) {
            return new DurationParameterEditor(Predef$.MODULE$.wrapRefArray((Object[])simpleEditor.timeRangeComponents()).toList());
        }
        if (SimpleEditorType.PERIOD_EDITOR.equals(simpleEditorType)) {
            return new PeriodParameterEditor(Predef$.MODULE$.wrapRefArray((Object[])simpleEditor.timeRangeComponents()).toList());
        }
        if (SimpleEditorType.CRON_EDITOR.equals(simpleEditorType)) {
            return CronParameterEditor$.MODULE$;
        }
        if (SimpleEditorType.TEXTAREA_EDITOR.equals(simpleEditorType)) {
            return TextareaParameterEditor$.MODULE$;
        }
        if (SimpleEditorType.JSON_EDITOR.equals(simpleEditorType)) {
            return JsonParameterEditor$.MODULE$;
        }
        if (SimpleEditorType.SQL_EDITOR.equals(simpleEditorType)) {
            return SqlParameterEditor$.MODULE$;
        }
        if (SimpleEditorType.SPEL_TEMPLATE_EDITOR.equals(simpleEditorType)) {
            return SpelTemplateParameterEditor$.MODULE$;
        }
        throw new MatchError((Object)simpleEditorType);
    }

    private EditorExtractor$() {
    }
}

