/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.spel.internal;

import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.util.Currency;
import java.util.Locale;
import java.util.UUID;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.util.StringUtils;
import pl.touk.nussknacker.engine.api.spel.SpelConversionsProvider;
import pl.touk.nussknacker.engine.spel.internal.NumberToNumberConverterFactory;
import pl.touk.nussknacker.engine.spel.internal.ObjectToArrayConverter;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005i:QAB\u0004\t\u0002Q1QAF\u0004\t\u0002]AQaJ\u0001\u0005\u0002e2AAF\u0004\u00013!)qe\u0001C\u0001Q!)\u0011f\u0001C!U\u0005qB)\u001a4bk2$8\u000b]3m\u0007>tg/\u001a:tS>t7\u000f\u0015:pm&$WM\u001d\u0006\u0003\u0011%\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u0015-\tAa\u001d9fY*\u0011A\"D\u0001\u0007K:<\u0017N\\3\u000b\u00059y\u0011a\u00038vgN\\g.Y2lKJT!\u0001E\t\u0002\tQ|Wo\u001b\u0006\u0002%\u0005\u0011\u0001\u000f\\\u0002\u0001!\t)\u0012!D\u0001\b\u0005y!UMZ1vYR\u001c\u0006/\u001a7D_:4XM]:j_:\u001c\bK]8wS\u0012,'o\u0005\u0002\u00021A\u0011QcA\n\u0004\u0007i\u0001\u0003CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g\r\u0005\u0002\"K5\t!E\u0003\u0002\u000bG)\u0011AeC\u0001\u0004CBL\u0017B\u0001\u0014#\u0005]\u0019\u0006/\u001a7D_:4XM]:j_:\u001c\bK]8wS\u0012,'/\u0001\u0004=S:LGO\u0010\u000b\u00021\u0005!r-\u001a;D_:4XM]:j_:\u001cVM\u001d<jG\u0016,\u0012a\u000b\t\u0003Y]j\u0011!\f\u0006\u0003]=\nqa];qa>\u0014HO\u0003\u00021c\u000591m\u001c8wKJ$(B\u0001\u001a4\u0003\u0011\u0019wN]3\u000b\u0005Q*\u0014aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003Y\n1a\u001c:h\u0013\tATF\u0001\rHK:,'/[2D_:4XM]:j_:\u001cVM\u001d<jG\u0016$\u0012\u0001\u0006")
public class DefaultSpelConversionsProvider
implements SpelConversionsProvider {
    public GenericConversionService getConversionService() {
        GenericConversionService service2 = new GenericConversionService();
        service2.addConverterFactory((ConverterFactory)new NumberToNumberConverterFactory());
        service2.addConverter(String.class, ZoneId.class, source2 -> ZoneId.of(source2));
        service2.addConverter(String.class, ZoneOffset.class, source2 -> ZoneOffset.of(source2));
        service2.addConverter(String.class, Locale.class, source2 -> StringUtils.parseLocale((String)source2));
        service2.addConverter(String.class, Charset.class, source2 -> Charset.forName(source2));
        service2.addConverter(String.class, Currency.class, source2 -> Currency.getInstance(source2));
        service2.addConverter(String.class, UUID.class, source2 -> {
            if (StringUtils.hasLength((String)source2)) {
                return UUID.fromString(source2.trim());
            }
            return null;
        });
        service2.addConverter(String.class, LocalTime.class, source2 -> LocalTime.parse(source2));
        service2.addConverter(String.class, LocalDate.class, source2 -> LocalDate.parse(source2));
        service2.addConverter(String.class, LocalDateTime.class, source2 -> LocalDateTime.parse(source2));
        service2.addConverter(String.class, ChronoLocalDate.class, source2 -> LocalDate.parse(source2));
        service2.addConverter(String.class, ChronoLocalDateTime.class, source2 -> LocalDateTime.parse(source2));
        service2.addConverter((GenericConverter)new ObjectToArrayConverter((ConversionService)service2));
        service2.addConverter(Number.class, String.class, source2 -> source2.toString());
        return service2;
    }
}

