/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.types;

import cats.data.IndexedStateT;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import cats.implicits$;
import cats.kernel.Semigroup;
import cats.kernel.Semigroup$;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import pl.touk.nussknacker.engine.api.Documentation;
import pl.touk.nussknacker.engine.api.ParamName;
import pl.touk.nussknacker.engine.api.generics.GenericFunctionTypingError;
import pl.touk.nussknacker.engine.api.generics.GenericType;
import pl.touk.nussknacker.engine.api.generics.MethodTypeInfo;
import pl.touk.nussknacker.engine.api.generics.MethodTypeInfo$;
import pl.touk.nussknacker.engine.api.generics.Parameter;
import pl.touk.nussknacker.engine.api.generics.TypingFunction;
import pl.touk.nussknacker.engine.api.process.ClassExtractionSettings;
import pl.touk.nussknacker.engine.api.process.PropertyFromGetterExtractionStrategy;
import pl.touk.nussknacker.engine.api.process.VisibleMembersPredicate;
import pl.touk.nussknacker.engine.api.typed.typing;
import pl.touk.nussknacker.engine.definition.TypeInfos;
import pl.touk.nussknacker.engine.types.MethodTypeInfoSubclassChecker$;
import pl.touk.nussknacker.engine.types.ParameterListError;
import pl.touk.nussknacker.engine.util.Implicits$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class EspTypeUtils$ {
    public static final EspTypeUtils$ MODULE$ = new EspTypeUtils$();

    public TypeInfos.ClazzDefinition clazzDefinition(Class<?> clazz, ClassExtractionSettings settings) {
        return new TypeInfos.ClazzDefinition(typing.Typed$.MODULE$.typedClass(clazz), this.extractPublicMethodsAndFields(clazz, false, settings), this.extractPublicMethodsAndFields(clazz, true, settings));
    }

    private Map<String, List<TypeInfos.MethodInfo>> extractPublicMethodsAndFields(Class<?> clazz, boolean staticMethodsAndFields, ClassExtractionSettings settings) {
        VisibleMembersPredicate membersPredicate = settings.visibleMembersPredicate(clazz);
        Map<String, List<TypeInfos.MethodInfo>> methods = this.extractPublicMethods(clazz, membersPredicate, staticMethodsAndFields, settings);
        Map fields = Implicits$.MODULE$.RichScalaMap(this.extractPublicFields(clazz, membersPredicate, staticMethodsAndFields, settings)).mapValuesNow((Function1 & Serializable)x$1 -> new .colon.colon(x$1, (List)Nil$.MODULE$));
        return this.filterHiddenParameterAndReturnType((Map<String, List<TypeInfos.MethodInfo>>)((Map)methods.$plus$plus((IterableOnce)fields)), settings);
    }

    private Map<String, List<TypeInfos.MethodInfo>> extractPublicMethods(Class<?> clazz, VisibleMembersPredicate membersPredicate, boolean staticMethodsAndFields, ClassExtractionSettings settings) {
        List additionalMethods = clazz.isInterface() ? Predef$.MODULE$.wrapRefArray((Object[])Object.class.getMethods()).toList() : (clazz.isPrimitive() ? Predef$.MODULE$.wrapRefArray((Object[])ClassUtils.primitiveToWrapper(clazz).getMethods()).toList() : package$.MODULE$.List().empty());
        List publicMethods = (List)Predef$.MODULE$.wrapRefArray((Object[])clazz.getMethods()).toList().$plus$plus((IterableOnce)additionalMethods);
        List methods = staticMethodsAndFields ? publicMethods.filter((Function1 & Serializable)member -> BoxesRunTime.boxToBoolean((boolean)membersPredicate.shouldBeVisible(member))).filter((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)EspTypeUtils$.$anonfun$extractPublicMethods$2(m))) : publicMethods.filter((Function1 & Serializable)member -> BoxesRunTime.boxToBoolean((boolean)membersPredicate.shouldBeVisible(member))).filter((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)EspTypeUtils$.$anonfun$extractPublicMethods$4(m)));
        List filteredMethods = methods.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)EspTypeUtils$.$anonfun$extractPublicMethods$5(x$2)));
        List methodNameAndInfoList = filteredMethods.flatMap((Function1 & Serializable)x$3 -> MODULE$.extractMethod((Method)x$3, settings));
        List staticMethodInfos = methodNameAndInfoList.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)EspTypeUtils$.$anonfun$extractPublicMethods$7(x$4)));
        List functionalMethodInfos = methodNameAndInfoList.filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)EspTypeUtils$.$anonfun$extractPublicMethods$8(x$5)));
        Map groupedFunctionalMethodInfos = Implicits$.MODULE$.RichScalaMap(functionalMethodInfos.groupBy((Function1 & Serializable)x$6 -> (String)x$6._1())).mapValuesNow((Function1 & Serializable)x$7 -> x$7.map((Function1 & Serializable)x$8 -> (TypeInfos.MethodInfo)x$8._2())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return (Map)implicits$.MODULE$.catsSyntaxSemigroup(this.deduplicateMethodsWithGenericReturnType((List<Tuple2<String, TypeInfos.StaticMethodInfo>>)staticMethodInfos), (Semigroup)Semigroup$.MODULE$.catsKernelMonoidForMap((Semigroup)Semigroup$.MODULE$.catsKernelMonoidForList())).combine((Object)groupedFunctionalMethodInfos);
    }

    private Map<String, List<TypeInfos.MethodInfo>> filterHiddenParameterAndReturnType(Map<String, List<TypeInfos.MethodInfo>> infos, ClassExtractionSettings settings) {
        return (Map)Implicits$.MODULE$.RichScalaMap(infos).mapValuesNow((Function1 & Serializable)methodList -> methodList.filter((Function1 & Serializable)methodInfo -> BoxesRunTime.boxToBoolean((boolean)EspTypeUtils$.filterOneMethod$1(methodInfo, settings)))).filter((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)EspTypeUtils$.$anonfun$filterHiddenParameterAndReturnType$11(x$14)));
    }

    private Map<String, List<TypeInfos.StaticMethodInfo>> deduplicateMethodsWithGenericReturnType(List<Tuple2<String, TypeInfos.StaticMethodInfo>> methodNameAndInfoList) {
        Map groupedByNameAndParameters = methodNameAndInfoList.groupBy((Function1 & Serializable)mi -> new Tuple3(mi._1(), (Object)((TypeInfos.StaticMethodInfo)mi._2()).signature().noVarArgs(), (Object)((TypeInfos.StaticMethodInfo)mi._2()).signature().varArg()));
        return Implicits$.MODULE$.RichScalaMap(Implicits$.MODULE$.RichTupleList(groupedByNameAndParameters.toList().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                List methodsForParams = (List)tuple2._2();
                return (Tuple2)methodsForParams.find((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)EspTypeUtils$.$anonfun$deduplicateMethodsWithGenericReturnType$3(methodsForParams, x0$2))).getOrElse((Function0 & Serializable)() -> (Tuple2)methodsForParams.minBy((Function1 & Serializable)x$15 -> ((TypeInfos.StaticMethodInfo)x$15._2()).signature().result().display(), (Ordering)Ordering.String$.MODULE$));
            }
            throw new MatchError((Object)tuple2);
        })).toGroupedMap()).mapValuesNow((Function1 & Serializable)x$16 -> (List)x$16.sortBy((Function1 & Serializable)x$17 -> x$17.toString(), (Ordering)Ordering.String$.MODULE$));
    }

    private List<String> collectMethodNames(Method method, ClassExtractionSettings settings) {
        boolean isGetter;
        boolean bl = isGetter = method.getName().matches("^(get|is).+") && method.getParameterCount() == 0;
        if (isGetter) {
            String propertyMethod = StringUtils.uncapitalize((String)method.getName().replaceAll("^get|^is", ""));
            PropertyFromGetterExtractionStrategy propertyFromGetterExtractionStrategy = settings.propertyExtractionStrategy();
            if (PropertyFromGetterExtractionStrategy.AddPropertyNextToGetter$.MODULE$.equals(propertyFromGetterExtractionStrategy)) {
                return new .colon.colon((Object)method.getName(), (List)new .colon.colon((Object)propertyMethod, (List)Nil$.MODULE$));
            }
            if (PropertyFromGetterExtractionStrategy.ReplaceGetterWithProperty$.MODULE$.equals(propertyFromGetterExtractionStrategy)) {
                return new .colon.colon((Object)propertyMethod, (List)Nil$.MODULE$);
            }
            if (PropertyFromGetterExtractionStrategy.DoNothing$.MODULE$.equals(propertyFromGetterExtractionStrategy)) {
                return new .colon.colon((Object)method.getName(), (List)Nil$.MODULE$);
            }
            throw new MatchError((Object)propertyFromGetterExtractionStrategy);
        }
        return new .colon.colon((Object)method.getName(), (List)Nil$.MODULE$);
    }

    private List<Tuple2<String, TypeInfos.MethodInfo>> extractMethod(Method method, ClassExtractionSettings settings) {
        Option<GenericType> option = this.extractAnnotation(method, GenericType.class);
        if (None$.MODULE$.equals(option)) {
            return this.extractRegularMethod(method, settings);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            GenericType annotation = (GenericType)some.value();
            return this.extractGenericMethod(method, annotation, settings);
        }
        throw new MatchError(option);
    }

    private TypingFunction getTypeFunctionInstanceFromAnnotation(Method method, GenericType genericType) {
        TypingFunction typingFunction;
        Class typeFunctionClass = genericType.typingFunction();
        try {
            Constructor typeFunctionConstructor = typeFunctionClass.getDeclaredConstructor(new Class[0]);
            typingFunction = (TypingFunction)typeFunctionConstructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("TypingFunction for " + method.getName() + " cannot be abstract class.", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("TypingFunction's constructor for " + method.getName() + " failed.", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not find parameterless constructor for method " + method.getName() + " or its TypingFunction was declared inside non-static class.", e);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not extract information about generic method " + method.getName() + ".", e);
        }
        return typingFunction;
    }

    private List<Tuple2<String, TypeInfos.MethodInfo>> extractGenericMethod(Method method, GenericType genericType, ClassExtractionSettings settings) {
        TypingFunction typeFunctionInstance = this.getTypeFunctionInstanceFromAnnotation(method, genericType);
        NonEmptyList<MethodTypeInfo> methodTypeInfo = this.extractGenericParameters(typeFunctionInstance, method);
        return this.collectMethodNames(method, settings).map((Function1 & Serializable)methodName -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(methodName), (Object)new TypeInfos.FunctionalMethodInfo((Function1<List<typing.TypingResult>, Validated<NonEmptyList<GenericFunctionTypingError>, typing.TypingResult>>)(Function1 & Serializable)x -> typeFunctionInstance.computeResultType(x), methodTypeInfo, (String)methodName, MODULE$.extractNussknackerDocs(method))));
    }

    private List<Tuple2<String, TypeInfos.StaticMethodInfo>> extractRegularMethod(Method method, ClassExtractionSettings settings) {
        return this.collectMethodNames(method, settings).map((Function1 & Serializable)methodName -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(methodName), (Object)new TypeInfos.StaticMethodInfo(MODULE$.extractMethodTypeInfo(method), (String)methodName, MODULE$.extractNussknackerDocs(method))));
    }

    private Map<String, TypeInfos.StaticMethodInfo> extractPublicFields(Class<?> clazz, VisibleMembersPredicate membersPredicate, boolean staticMethodsAndFields, ClassExtractionSettings settings) {
        Field[] interestingFields = (Field[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])clazz.getFields()), (Function1 & Serializable)member -> BoxesRunTime.boxToBoolean((boolean)membersPredicate.shouldBeVisible(member)));
        Field[] fields = staticMethodsAndFields ? (Field[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])interestingFields), (Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)EspTypeUtils$.$anonfun$extractPublicFields$2(m))) : (Field[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])interestingFields), (Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)EspTypeUtils$.$anonfun$extractPublicFields$3(m)));
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)field -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.getName()), (Object)new TypeInfos.StaticMethodInfo(new MethodTypeInfo((List)Nil$.MODULE$, (Option)None$.MODULE$, MODULE$.extractFieldReturnType((Field)field)), field.getName(), MODULE$.extractNussknackerDocs((AccessibleObject)field))), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Option<String> extractNussknackerDocs(AccessibleObject accessibleObject) {
        return this.extractAnnotation(accessibleObject, Documentation.class).map((Function1 & Serializable)x$18 -> x$18.description());
    }

    private NonEmptyList<MethodTypeInfo> extractGenericParameters(TypingFunction typingFunction, Method method) {
        MethodTypeInfo autoExtractedParameters = this.extractMethodTypeInfo(method);
        List definedParametersOption = typingFunction.signatures().toList().flatMap((Function1 & Serializable)x$19 -> x$19.toList());
        definedParametersOption.map((Function1 & Serializable)x$20 -> MethodTypeInfoSubclassChecker$.MODULE$.check((MethodTypeInfo)x$20, autoExtractedParameters)).collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Validated<NonEmptyList<ParameterListError>, BoxedUnit>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Validated.Invalid) {
                    Validated.Invalid invalid = (Validated.Invalid)A1;
                    NonEmptyList e = (NonEmptyList)invalid.e();
                    return (B1)e;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Validated<NonEmptyList<ParameterListError>, BoxedUnit> x1) {
                Validated<NonEmptyList<ParameterListError>, BoxedUnit> validated = x1;
                return validated instanceof Validated.Invalid;
            }
        }).foreach((Function1 & Serializable)x -> {
            String errorString = x.map((Function1 & Serializable)x$21 -> x$21.message()).toList().mkString("; ");
            throw new IllegalArgumentException("Generic function " + method.getName() + " has declared parameters that are incompatible with methods signature: " + errorString);
        });
        return (NonEmptyList)NonEmptyList$.MODULE$.fromList(definedParametersOption).getOrElse((Function0 & Serializable)() -> NonEmptyList$.MODULE$.one((Object)autoExtractedParameters));
    }

    private MethodTypeInfo extractMethodTypeInfo(Method method) {
        return MethodTypeInfo$.MODULE$.fromList(Predef$.MODULE$.wrapRefArray((Object[])method.getParameters()).toList().map((Function1 & Serializable)param -> {
            Option<ParamName> annotationOption = MODULE$.extractAnnotation((AnnotatedElement)param, (Class)ParamName.class);
            String name = (String)annotationOption.map((Function1 & Serializable)x$22 -> x$22.value()).getOrElse((Function0 & Serializable)() -> param.getName());
            typing.TypingResult paramType = MODULE$.extractParameterType((java.lang.reflect.Parameter)param);
            return new Tuple4(param, annotationOption, (Object)name, (Object)paramType);
        }).map((Function1 & Serializable)x$23 -> {
            Tuple4 tuple4 = x$23;
            if (tuple4 != null) {
                String name = (String)tuple4._3();
                typing.TypingResult paramType = (typing.TypingResult)tuple4._4();
                return new Parameter(name, paramType);
            }
            throw new MatchError((Object)tuple4);
        }), method.isVarArgs(), this.extractMethodReturnType(method));
    }

    public typing.TypingResult extractParameterType(java.lang.reflect.Parameter javaParam) {
        return (typing.TypingResult)this.extractClass(javaParam.getParameterizedType()).getOrElse((Function0 & Serializable)() -> typing.Typed$.MODULE$.apply(javaParam.getType()));
    }

    private typing.TypingResult extractFieldReturnType(Field field) {
        return (typing.TypingResult)this.extractGenericReturnType(field.getGenericType()).orElse((Function0 & Serializable)() -> MODULE$.extractClass(field.getGenericType())).getOrElse((Function0 & Serializable)() -> typing.Typed$.MODULE$.apply(field.getType()));
    }

    public typing.TypingResult extractMethodReturnType(Method method) {
        return (typing.TypingResult)this.extractGenericReturnType(method.getGenericReturnType()).orElse((Function0 & Serializable)() -> MODULE$.extractClass(method.getGenericReturnType())).getOrElse((Function0 & Serializable)() -> typing.Typed$.MODULE$.apply(method.getReturnType()));
    }

    private Option<typing.TypingResult> extractGenericReturnType(Type typ) {
        ParameterizedType parameterizedType;
        Type type = typ;
        if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType() instanceof Class) {
            return this.extractGenericMonadReturnType(parameterizedType, (Class)parameterizedType.getRawType());
        }
        return None$.MODULE$;
    }

    private Option<typing.TypingResult> extractGenericMonadReturnType(ParameterizedType genericReturnType, Class<?> genericReturnRawType) {
        if (IndexedStateT.class.isAssignableFrom(genericReturnRawType)) {
            Type returnType = genericReturnType.getActualTypeArguments()[3];
            return this.extractClass(returnType);
        }
        if (Option.class.isAssignableFrom(genericReturnRawType)) {
            Type optionGenericType = genericReturnType.getActualTypeArguments()[0];
            return this.extractClass(optionGenericType);
        }
        if (Optional.class.isAssignableFrom(genericReturnRawType)) {
            Type optionalGenericType = genericReturnType.getActualTypeArguments()[0];
            return this.extractClass(optionalGenericType);
        }
        return None$.MODULE$;
    }

    private Option<typing.TypingResult> extractClass(Type typ) {
        ParameterizedType parameterizedType;
        Type type = typ;
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return new Some((Object)typing.Typed$.MODULE$.apply(clazz));
        }
        if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType() instanceof Class) {
            return new Some((Object)this.extractGenericParams(parameterizedType, (Class)parameterizedType.getRawType()));
        }
        return None$.MODULE$;
    }

    private typing.TypingResult extractGenericParams(ParameterizedType paramsType, Class<?> paramsRawType) {
        return typing.Typed$.MODULE$.genericTypeClass(paramsRawType, Predef$.MODULE$.wrapRefArray((Object[])paramsType.getActualTypeArguments()).toList().map((Function1 & Serializable)p -> (typing.TypingResult)MODULE$.extractClass((Type)p).getOrElse((Function0 & Serializable)() -> typing.Unknown$.MODULE$)));
    }

    private Option<Method> extractScalaVersionOfVarArgMethod(Method method) {
        Option option;
        Class<?> obj = method.getDeclaringClass();
        String name = method.getName();
        List args = Predef$.MODULE$.wrapRefArray((Object[])method.getParameterTypes()).toList();
        List list = args;
        if (list != null && !(option = package$.MODULE$.$colon$plus().unapply((SeqOps)list)).isEmpty()) {
            List noVarArgs = (List)((Tuple2)option.get())._1();
            Class varArg = (Class)((Tuple2)option.get())._2();
            if (method.isVarArgs() && varArg.isArray()) {
                Some some;
                try {
                    some = new Some((Object)obj.getMethod(name, (Class[])((IterableOnceOps)noVarArgs.$colon$plus(Seq.class)).toArray(ClassTag$.MODULE$.apply(Class.class))));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    some = None$.MODULE$;
                }
                return some;
            }
        }
        return None$.MODULE$;
    }

    private Option<Method> extractJavaVersionOfVarArgMethod(Method method) {
        return ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])method.getDeclaringClass().getMethods()), (Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)EspTypeUtils$.$anonfun$extractJavaVersionOfVarArgMethod$1(method, m)));
    }

    private <T extends Annotation> Option<T> extractAnnotation(AnnotatedElement obj, Class<T> annotationType) {
        return Option$.MODULE$.apply(obj.getAnnotation(annotationType)).orElse((Function0 & Serializable)() -> {
            AnnotatedElement annotatedElement = obj;
            if (annotatedElement instanceof Method) {
                Method method = (Method)annotatedElement;
                return MODULE$.extractScalaVersionOfVarArgMethod(method).flatMap((Function1 & Serializable)x$24 -> MODULE$.extractAnnotation((AnnotatedElement)x$24, annotationType));
            }
            return None$.MODULE$;
        });
    }

    public <T> T companionObject(Class<T> klazz) {
        return (T)klazz.getField("MODULE$").get(null);
    }

    public static final /* synthetic */ boolean $anonfun$extractPublicMethods$2(Method m) {
        return Modifier.isStatic(m.getModifiers());
    }

    public static final /* synthetic */ boolean $anonfun$extractPublicMethods$4(Method m) {
        return !Modifier.isStatic(m.getModifiers());
    }

    public static final /* synthetic */ boolean $anonfun$extractPublicMethods$5(Method x$2) {
        return MODULE$.extractJavaVersionOfVarArgMethod(x$2).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$extractPublicMethods$7(Tuple2 x$4) {
        return x$4._2() instanceof TypeInfos.StaticMethodInfo;
    }

    public static final /* synthetic */ boolean $anonfun$extractPublicMethods$8(Tuple2 x$5) {
        return x$5._2() instanceof TypeInfos.FunctionalMethodInfo;
    }

    private static final boolean typeResultVisible$1(typing.TypingResult t2, ClassExtractionSettings settings$2) {
        typing.TypingResult typingResult = t2;
        if (typingResult instanceof typing.SingleTypingResult) {
            typing.SingleTypingResult singleTypingResult = (typing.SingleTypingResult)typingResult;
            return !settings$2.isHidden(singleTypingResult.objType().klass()) && singleTypingResult.objType().params().forall((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)EspTypeUtils$.typeResultVisible$1(t, settings$2)));
        }
        if (typingResult instanceof typing.TypedUnion) {
            typing.TypedUnion typedUnion = (typing.TypedUnion)typingResult;
            Set ts = typedUnion.possibleTypes();
            return ts.forall((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)EspTypeUtils$.typeResultVisible$1(t, settings$2)));
        }
        if (typing.TypedNull$.MODULE$.equals(typingResult)) {
            return true;
        }
        if (typing.Unknown$.MODULE$.equals(typingResult)) {
            return true;
        }
        throw new MatchError((Object)typingResult);
    }

    private static final boolean filterOneMethod$1(TypeInfos.MethodInfo methodInfo, ClassExtractionSettings settings$2) {
        List noVarArgTypes = methodInfo.signatures().toList().flatMap((Function1 & Serializable)x$9 -> x$9.noVarArgs()).map((Function1 & Serializable)x$10 -> x$10.refClazz());
        List varArgTypes = methodInfo.signatures().toList().flatMap((Function1 & Serializable)x$11 -> x$11.varArg().toList()).map((Function1 & Serializable)x$12 -> x$12.refClazz());
        List resultTypes = methodInfo.signatures().toList().map((Function1 & Serializable)x$13 -> x$13.result());
        List list = noVarArgTypes;
        List list2 = varArgTypes;
        return resultTypes.$colon$colon$colon(list2).$colon$colon$colon(list).forall((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)EspTypeUtils$.typeResultVisible$1(t, settings$2)));
    }

    public static final /* synthetic */ boolean $anonfun$filterHiddenParameterAndReturnType$11(Tuple2 x$14) {
        return ((IterableOnceOps)x$14._2()).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$deduplicateMethodsWithGenericReturnType$4(TypeInfos.StaticMethodInfo methodInfo$1, Tuple2 mi) {
        return methodInfo$1.signature().result().canBeSubclassOf(((TypeInfos.StaticMethodInfo)mi._2()).signature().result());
    }

    public static final /* synthetic */ boolean $anonfun$deduplicateMethodsWithGenericReturnType$3(List methodsForParams$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            TypeInfos.StaticMethodInfo methodInfo = (TypeInfos.StaticMethodInfo)tuple2._2();
            return methodsForParams$1.forall((Function1 & Serializable)mi -> BoxesRunTime.boxToBoolean((boolean)EspTypeUtils$.$anonfun$deduplicateMethodsWithGenericReturnType$4(methodInfo, mi)));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$extractPublicFields$2(Field m) {
        return Modifier.isStatic(m.getModifiers());
    }

    public static final /* synthetic */ boolean $anonfun$extractPublicFields$3(Field m) {
        return !Modifier.isStatic(m.getModifiers());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$extractJavaVersionOfVarArgMethod$1(Method method$5, Method m) {
        if (!m.isVarArgs()) return false;
        List list = Predef$.MODULE$.wrapRefArray((Object[])m.getParameterTypes()).toList();
        if (list == null) return false;
        Option option = package$.MODULE$.$colon$plus().unapply((SeqOps)list);
        if (option.isEmpty()) return false;
        List noVarArgs = (List)((Tuple2)option.get())._1();
        Class varArgArr = (Class)((Tuple2)option.get())._2();
        if (!varArgArr.isArray()) return false;
        List list2 = Predef$.MODULE$.wrapRefArray((Object[])method$5.getParameterTypes()).toList();
        Object object = noVarArgs.$colon$plus(Seq.class);
        if (list2 != null) {
            if (!list2.equals(object)) return false;
            return true;
        }
        if (object == null) return true;
        return false;
    }

    private EspTypeUtils$() {
    }
}

