/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.types;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;
import pl.touk.nussknacker.engine.api.process.ClassExtractionSettings;
import pl.touk.nussknacker.engine.api.typed.typing;
import pl.touk.nussknacker.engine.definition.TypeInfos;
import pl.touk.nussknacker.engine.types.EspTypeUtils$;
import pl.touk.nussknacker.engine.types.TypesInformationExtractor;
import pl.touk.nussknacker.engine.util.logging.ExecutionTimeMeasuring;
import pl.touk.nussknacker.engine.variables.MetaVariables;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Set;
import scala.package$;
import scala.runtime.ScalaRunTime$;

public final class TypesInformationExtractor$
implements LazyLogging,
ExecutionTimeMeasuring {
    public static final TypesInformationExtractor$ MODULE$ = new TypesInformationExtractor$();
    private static final List<Class<?>> primitiveTypes;
    private static final scala.collection.immutable.Set<typing.TypingResult> mandatoryClasses;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        ExecutionTimeMeasuring.$init$((ExecutionTimeMeasuring)MODULE$);
        primitiveTypes = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{Boolean.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Byte.TYPE, Short.TYPE, Character.TYPE}));
        mandatoryClasses = (scala.collection.immutable.Set)((IterableOps)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{java.util.List.class, Map.class, BigDecimal.class, Number.class, String.class, MetaVariables.class}))).$plus$plus((IterableOnce)MODULE$.primitiveTypes().map((Function1 & Serializable)x$1 -> ClassUtils.primitiveToWrapper((Class)x$1)))).map((Function1 & Serializable)x$1 -> typing.Typed$.MODULE$.apply(x$1));
    }

    public <R> R measure(Function0<String> additionalMessage, Function0<R> block) {
        return (R)ExecutionTimeMeasuring.measure$((ExecutionTimeMeasuring)this, additionalMessage, block);
    }

    private Logger logger$lzycompute() {
        TypesInformationExtractor$ typesInformationExtractor$ = this;
        synchronized (typesInformationExtractor$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    private List<Class<?>> primitiveTypes() {
        return primitiveTypes;
    }

    private scala.collection.immutable.Set<typing.TypingResult> mandatoryClasses() {
        return mandatoryClasses;
    }

    public scala.collection.immutable.Set<TypeInfos.ClazzDefinition> clazzAndItsChildrenDefinition(Iterable<typing.TypingResult> clazzes, ClassExtractionSettings settings) {
        HashSet collectedSoFar = HashSet$.MODULE$.empty();
        return ((IterableOnceOps)((IterableOps)((IterableOps)clazzes.flatMap((Function1 & Serializable)typingResult -> MODULE$.typesFromTypingResult((typing.TypingResult)typingResult))).$plus$plus(this.mandatoryClasses())).flatMap((Function1 & Serializable)cl -> MODULE$.clazzAndItsChildrenDefinitionIfNotCollectedSoFar((typing.TypingResult)cl, (Set<typing.TypingResult>)collectedSoFar, new TypesInformationExtractor.DiscoveryPath((List<TypesInformationExtractor.DiscoverySegment>)new .colon.colon((Object)new TypesInformationExtractor.Clazz((typing.TypingResult)cl), (List)Nil$.MODULE$)), settings))).toSet();
    }

    private scala.collection.immutable.Set<typing.TypingResult> typesFromTypingResult(typing.TypingResult typingResult2) {
        typing.TypingResult typingResult3 = typingResult2;
        if (typingResult3 instanceof typing.TypedClass) {
            typing.TypedClass typedClass = (typing.TypedClass)typingResult3;
            return this.typesFromTypedClass(typedClass);
        }
        if (typingResult3 instanceof typing.TypedUnion) {
            typing.TypedUnion typedUnion = (typing.TypedUnion)typingResult3;
            scala.collection.immutable.Set set = typedUnion.possibleTypes();
            return (scala.collection.immutable.Set)set.flatMap((Function1 & Serializable)typingResult -> MODULE$.typesFromTypingResult((typing.TypingResult)typingResult));
        }
        if (typingResult3 instanceof typing.TypedObjectTypingResult) {
            typing.TypedObjectTypingResult typedObjectTypingResult = (typing.TypedObjectTypingResult)typingResult3;
            ListMap fields = typedObjectTypingResult.fields();
            typing.TypedClass clazz = typedObjectTypingResult.objType();
            return (scala.collection.immutable.Set)this.typesFromTypedClass(clazz).$plus$plus((IterableOnce)fields.values().flatMap((Function1 & Serializable)typingResult -> MODULE$.typesFromTypingResult((typing.TypingResult)typingResult)));
        }
        if (typingResult3 instanceof typing.TypedDict) {
            typing.TypedDict typedDict = (typing.TypedDict)typingResult3;
            return this.typesFromTypedClass(typedDict.objType());
        }
        if (typingResult3 instanceof typing.TypedObjectWithData) {
            typing.TypedObjectWithData typedObjectWithData = (typing.TypedObjectWithData)typingResult3;
            return this.typesFromTypedClass(typedObjectWithData.underlying().objType());
        }
        if (typing.TypedNull$.MODULE$.equals(typingResult3)) {
            return Predef$.MODULE$.Set().empty();
        }
        if (typing.Unknown$.MODULE$.equals(typingResult3)) {
            return Predef$.MODULE$.Set().empty();
        }
        throw new MatchError((Object)typingResult3);
    }

    private scala.collection.immutable.Set<typing.TypingResult> typesFromTypedClass(typing.TypedClass typedClass) {
        return (scala.collection.immutable.Set)typedClass.params().flatMap((Function1 & Serializable)typingResult -> MODULE$.typesFromTypingResult((typing.TypingResult)typingResult)).toSet().$plus((Object)typing.Typed$.MODULE$.apply(typedClass.klass()));
    }

    private scala.collection.immutable.Set<TypeInfos.ClazzDefinition> clazzAndItsChildrenDefinitionIfNotCollectedSoFar(typing.TypingResult typingResult, Set<typing.TypingResult> collectedSoFar, TypesInformationExtractor.DiscoveryPath path, ClassExtractionSettings settings) {
        if (collectedSoFar.contains((Object)typingResult)) {
            return Predef$.MODULE$.Set().empty();
        }
        collectedSoFar.$plus$eq((Object)typingResult);
        return this.clazzAndItsChildrenDefinition(typingResult, collectedSoFar, path, settings);
    }

    private scala.collection.immutable.Set<TypeInfos.ClazzDefinition> clazzAndItsChildrenDefinition(typing.TypingResult typingResult, Set<typing.TypingResult> collectedSoFar, TypesInformationExtractor.DiscoveryPath path, ClassExtractionSettings settings) {
        typing.TypingResult typingResult2 = typingResult;
        if (typingResult2 instanceof typing.TypedClass) {
            scala.collection.immutable.Set set;
            typing.TypedClass typedClass = (typing.TypedClass)typingResult2;
            if (settings.isHidden(typedClass.klass())) {
                set = Predef$.MODULE$.Set().empty();
            } else {
                TypeInfos.ClazzDefinition classDefinition = this.clazzDefinitionWithLogging(typedClass.klass(), path, settings);
                set = (scala.collection.immutable.Set)this.definitionsFromMethods(classDefinition, collectedSoFar, path, settings).$plus((Object)classDefinition);
            }
            scala.collection.immutable.Set definitionsForClass = set;
            return (scala.collection.immutable.Set)definitionsForClass.$plus$plus(this.definitionsFromGenericParameters(typedClass, collectedSoFar, path, settings));
        }
        return Predef$.MODULE$.Set().empty();
    }

    private scala.collection.immutable.Set<TypeInfos.ClazzDefinition> definitionsFromGenericParameters(typing.TypedClass typedClass, Set<typing.TypingResult> collectedSoFar, TypesInformationExtractor.DiscoveryPath path, ClassExtractionSettings settings) {
        return ((List)typedClass.params().zipWithIndex()).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                typing.TypingResult k = (typing.TypingResult)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                if (k instanceof typing.TypedClass) {
                    typing.TypedClass typedClass = (typing.TypedClass)k;
                    return MODULE$.clazzAndItsChildrenDefinitionIfNotCollectedSoFar((typing.TypingResult)typedClass, collectedSoFar, path.pushSegment(new TypesInformationExtractor.GenericParameter((typing.TypingResult)typedClass, idx)), settings);
                }
            }
            return Predef$.MODULE$.Set().empty();
        }).toSet();
    }

    private scala.collection.immutable.Set<TypeInfos.ClazzDefinition> definitionsFromMethods(TypeInfos.ClazzDefinition classDefinition, Set<typing.TypingResult> collectedSoFar, TypesInformationExtractor.DiscoveryPath path, ClassExtractionSettings settings) {
        return (scala.collection.immutable.Set)TypesInformationExtractor$.extractFromMethods$1(classDefinition.methods(), collectedSoFar, path, settings).$plus$plus((IterableOnce)TypesInformationExtractor$.extractFromMethods$1(classDefinition.staticMethods(), collectedSoFar, path, settings));
    }

    private TypeInfos.ClazzDefinition clazzDefinitionWithLogging(Class<?> clazz, TypesInformationExtractor.DiscoveryPath path, ClassExtractionSettings settings) {
        return (TypeInfos.ClazzDefinition)this.measure((Function0<String>)(Function0 & Serializable)() -> this.message$1(path, clazz), (Function0 & Serializable)() -> EspTypeUtils$.MODULE$.clazzDefinition(clazz, settings));
    }

    private static final scala.collection.immutable.Set extractFromMethods$1(scala.collection.immutable.Map methods, Set collectedSoFar$3, TypesInformationExtractor.DiscoveryPath path$2, ClassExtractionSettings settings$3) {
        return ((IterableOnceOps)((IterableOps)((IterableOps)methods.values().flatten(Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable)x$2 -> x$2.signatures().toList().map((Function1 & Serializable)x$3 -> x$3.result()))).flatMap((Function1 & Serializable)kl -> MODULE$.clazzAndItsChildrenDefinitionIfNotCollectedSoFar((typing.TypingResult)kl, (Set<typing.TypingResult>)collectedSoFar$3, path$2.pushSegment(new TypesInformationExtractor.MethodReturnType((typing.TypingResult)kl)), settings$3))).toSet();
    }

    private final String message$1(TypesInformationExtractor.DiscoveryPath path$3, Class clazz$1) {
        if (this.logger().underlying().isTraceEnabled()) {
            return path$3.print();
        }
        return clazz$1.getName();
    }

    private TypesInformationExtractor$() {
    }
}

