/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.kafka.exception;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.NewTopic;
import pl.touk.nussknacker.engine.kafka.KafkaConfig;
import pl.touk.nussknacker.engine.kafka.KafkaUtils$;
import pl.touk.nussknacker.engine.kafka.exception.KafkaExceptionConsumerConfig;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.SetLike;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u00013Aa\u0002\u0005\u0001+!Aa\u0005\u0001B\u0001B\u0003%q\u0005\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0011\u0015\u0001\u0004\u0001\"\u00012\u0011\u001d)\u0004A1A\u0005\nYBaA\u000f\u0001!\u0002\u00139\u0004\"B\u001e\u0001\t\u0003a$AG&bM.\fWI\u001d:peR{\u0007/[2J]&$\u0018.\u00197ju\u0016\u0014(BA\u0005\u000b\u0003%)\u0007pY3qi&|gN\u0003\u0002\f\u0019\u0005)1.\u00194lC*\u0011QBD\u0001\u0007K:<\u0017N\\3\u000b\u0005=\u0001\u0012a\u00038vgN\\g.Y2lKJT!!\u0005\n\u0002\tQ|Wo\u001b\u0006\u0002'\u0005\u0011\u0001\u000f\\\u0002\u0001'\r\u0001a\u0003\b\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005u!S\"\u0001\u0010\u000b\u0005}\u0001\u0013\u0001D:dC2\fGn\\4hS:<'BA\u0011#\u0003!!\u0018\u0010]3tC\u001a,'\"A\u0012\u0002\u0007\r|W.\u0003\u0002&=\tYA*\u0019>z\u0019><w-\u001b8h\u0003-Y\u0017MZ6b\u0007>tg-[4\u0011\u0005!JS\"\u0001\u0006\n\u0005)R!aC&bM.\f7i\u001c8gS\u001e\fa#\u001a=dKB$\u0018n\u001c8IC:$G.\u001a:D_:4\u0017n\u001a\t\u0003[9j\u0011\u0001C\u0005\u0003_!\u0011AdS1gW\u0006,\u0005pY3qi&|gnQ8ogVlWM]\"p]\u001aLw-\u0001\u0004=S:LGO\u0010\u000b\u0004eM\"\u0004CA\u0017\u0001\u0011\u001513\u00011\u0001(\u0011\u0015Y3\u00011\u0001-\u00039!\u0018.\\3pkR\u001cVmY8oIN,\u0012a\u000e\t\u0003/aJ!!\u000f\r\u0003\u0007%sG/A\buS6,w.\u001e;TK\u000e|g\u000eZ:!\u0003\u0011Ig.\u001b;\u0015\u0003u\u0002\"a\u0006 \n\u0005}B\"\u0001B+oSR\u0004")
public class KafkaErrorTopicInitializer
implements LazyLogging {
    private final KafkaConfig kafkaConfig;
    private final KafkaExceptionConsumerConfig exceptionHandlerConfig;
    private final int timeoutSeconds;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        KafkaErrorTopicInitializer kafkaErrorTopicInitializer = this;
        synchronized (kafkaErrorTopicInitializer) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private int timeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void init() {
        String errorTopic = this.exceptionHandlerConfig.topic();
        KafkaUtils$.MODULE$.usingAdminClient(this.kafkaConfig, (Function1 & Serializable & scala.Serializable)admin -> {
            Object object;
            Set topicNames = (Set)admin.listTopics(new ListTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(this.timeoutSeconds() * 1000))).names().get((long)this.timeoutSeconds(), TimeUnit.SECONDS);
            boolean topicExists = ((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(topicNames).asScala()).contains((Object)errorTopic);
            if (topicExists) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Topic exists, skipping");
                    object = BoxedUnit.UNIT;
                } else {
                    object = BoxedUnit.UNIT;
                }
            } else {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Creating error topic: {} with default configs, please check if the values are correct", new Object[]{errorTopic});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                NewTopic errorTopicConfig = new NewTopic(errorTopic, Optional.empty(), Optional.empty());
                try {
                    object = admin.createTopics(Arrays.asList((Object[])new NewTopic[]{errorTopicConfig})).all().get((long)this.timeoutSeconds(), TimeUnit.SECONDS);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        throw new IllegalStateException(new StringBuilder(50).append("Failed to create ").append(errorTopic).append(" (").append(e.getMessage()).append("), cannot run scenario properly").toString(), e);
                    }
                    throw throwable;
                }
            }
            return object;
        });
    }

    public KafkaErrorTopicInitializer(KafkaConfig kafkaConfig, KafkaExceptionConsumerConfig exceptionHandlerConfig) {
        this.kafkaConfig = kafkaConfig;
        this.exceptionHandlerConfig = exceptionHandlerConfig;
        LazyLogging.$init$((LazyLogging)this);
        this.timeoutSeconds = 5;
    }
}

