/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.kafka.validator;

import cats.data.Validated;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.ConfigResource;
import pl.touk.nussknacker.engine.kafka.KafkaConfig;
import pl.touk.nussknacker.engine.kafka.KafkaUtils$;
import pl.touk.nussknacker.engine.kafka.validator.CachedTopicsExistenceValidatorConfig;
import pl.touk.nussknacker.engine.kafka.validator.CachedTopicsExistenceValidatorConfig$;
import pl.touk.nussknacker.engine.kafka.validator.TopicExistenceValidationException;
import pl.touk.nussknacker.engine.kafka.validator.TopicsExistenceValidator;
import pl.touk.nussknacker.engine.util.cache.SingleValueCache;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenSeq;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u0005\u000b\u0001]A\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\u0006c\u0001!\tA\r\u0005\u0006k\u0001!IA\u000e\u0005\u0006u\u0001!\ta\u000f\u0005\u0006;\u0002!IA\u0018\u0005\u0006E\u0002!Ia\u0019\u0005\u000b\u0003\u0007\u0001\u0001R1A\u0005\n\u0005\u0015\u0001BCA\u0010\u0001!\u0015\r\u0011\"\u0003\u0002\"\tq2)Y2iK\u0012$v\u000e]5dg\u0016C\u0018n\u001d;f]\u000e,g+\u00197jI\u0006$xN\u001d\u0006\u0003\u00171\t\u0011B^1mS\u0012\fGo\u001c:\u000b\u00055q\u0011!B6bM.\f'BA\b\u0011\u0003\u0019)gnZ5oK*\u0011\u0011CE\u0001\f]V\u001c8o\u001b8bG.,'O\u0003\u0002\u0014)\u0005!Ao\\;l\u0015\u0005)\u0012A\u00019m\u0007\u0001\u0019B\u0001\u0001\r\u001fEA\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t1\u0011I\\=SK\u001a\u0004\"a\b\u0011\u000e\u0003)I!!\t\u0006\u00031Q{\u0007/[2t\u000bbL7\u000f^3oG\u00164\u0016\r\\5eCR|'\u000f\u0005\u0002$U5\tAE\u0003\u0002&M\u0005a1oY1mC2|wmZ5oO*\u0011q\u0005K\u0001\tif\u0004Xm]1gK*\t\u0011&A\u0002d_6L!a\u000b\u0013\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\fW\u000647.Y\"p]\u001aLw\r\u0005\u0002/_5\tA\"\u0003\u00021\u0019\tY1*\u00194lC\u000e{gNZ5h\u0003\u0019a\u0014N\\5u}Q\u00111\u0007\u000e\t\u0003?\u0001AQ\u0001\f\u0002A\u00025\naaY8oM&<W#A\u001c\u0011\u0005}A\u0014BA\u001d\u000b\u0005\u0011\u001a\u0015m\u00195fIR{\u0007/[2t\u000bbL7\u000f^3oG\u00164\u0016\r\\5eCR|'oQ8oM&<\u0017A\u0004<bY&$\u0017\r^3U_BL7m\u001d\u000b\u0003ym\u0003B!\u0010\"E\u000f6\taH\u0003\u0002@\u0001\u0006!A-\u0019;b\u0015\u0005\t\u0015\u0001B2biNL!a\u0011 \u0003\u0013Y\u000bG.\u001b3bi\u0016$\u0007CA\u0010F\u0013\t1%BA\u0011U_BL7-\u0012=jgR,gnY3WC2LG-\u0019;j_:,\u0005pY3qi&|g\u000eE\u0002I!Ns!!\u0013(\u000f\u0005)kU\"A&\u000b\u000513\u0012A\u0002\u001fs_>$h(C\u0001\u001c\u0013\ty%$A\u0004qC\u000e\\\u0017mZ3\n\u0005E\u0013&\u0001\u0002'jgRT!a\u0014\u000e\u0011\u0005QCfBA+W!\tQ%$\u0003\u0002X5\u00051\u0001K]3eK\u001aL!!\u0017.\u0003\rM#(/\u001b8h\u0015\t9&\u0004C\u0003]\t\u0001\u0007q)\u0001\u0004u_BL7m]\u0001\u0014SN\fU\u000f^8De\u0016\fG/Z#oC\ndW\r\u001a\u000b\u0002?B\u0011\u0011\u0004Y\u0005\u0003Cj\u0011qAQ8pY\u0016\fg.\u0001\tvg&tw-\u00113nS:\u001cE.[3oiV\u0011A\r_\u000b\u0002KB!\u0011D\u001a5w\u0013\t9'DA\u0005Gk:\u001cG/[8ocA!\u0011DZ5w!\tQG/D\u0001l\u0015\taW.A\u0003bI6LgN\u0003\u0002o_\u000691\r\\5f]R\u001c(BA\u0007q\u0015\t\t(/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002g\u0006\u0019qN]4\n\u0005U\\'!B!e[&t\u0007CA<y\u0019\u0001!Q!\u001f\u0004C\u0002i\u0014\u0011\u0001V\t\u0003wz\u0004\"!\u0007?\n\u0005uT\"a\u0002(pi\"Lgn\u001a\t\u00033}L1!!\u0001\u001b\u0005\r\te._\u0001\u0017CV$xn\u0011:fCR,7+\u001a;uS:<7)Y2iKV\u0011\u0011q\u0001\t\u0006\u0003\u0013\t\u0019bX\u0007\u0003\u0003\u0017QA!!\u0004\u0002\u0010\u0005)1-Y2iK*\u0019\u0011\u0011\u0003\b\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003+\tYA\u0001\tTS:<G.\u001a,bYV,7)Y2iK\"\u001aq!!\u0007\u0011\u0007e\tY\"C\u0002\u0002\u001ei\u0011\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u001dQ|\u0007/[2MSN$8)Y2iKV\u0011\u00111\u0005\t\u0006\u0003\u0013\t\u0019b\u0012\u0015\u0004\u0011\u0005e\u0001")
public class CachedTopicsExistenceValidator
implements TopicsExistenceValidator,
LazyLogging {
    private transient SingleValueCache<Object> autoCreateSettingCache;
    private transient SingleValueCache<List<String>> topicListCache;
    private final KafkaConfig kafkaConfig;
    private transient Logger logger;
    private volatile transient byte bitmap$trans$0;

    @Override
    public final Validated<TopicExistenceValidationException, String> validateTopic(String topic) {
        return TopicsExistenceValidator.validateTopic$(this, topic);
    }

    private Logger logger$lzycompute() {
        CachedTopicsExistenceValidator cachedTopicsExistenceValidator = this;
        synchronized (cachedTopicsExistenceValidator) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.logger$lzycompute() : this.logger;
    }

    private CachedTopicsExistenceValidatorConfig config() {
        return this.kafkaConfig.topicsExistenceValidationConfig().validatorConfig();
    }

    private SingleValueCache<Object> autoCreateSettingCache$lzycompute() {
        CachedTopicsExistenceValidator cachedTopicsExistenceValidator = this;
        synchronized (cachedTopicsExistenceValidator) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.autoCreateSettingCache = new SingleValueCache((Option)None$.MODULE$, (Option)new Some((Object)this.config().autoCreateFlagFetchCacheTtl()));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.autoCreateSettingCache;
    }

    private SingleValueCache<Object> autoCreateSettingCache() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.autoCreateSettingCache$lzycompute() : this.autoCreateSettingCache;
    }

    private SingleValueCache<List<String>> topicListCache$lzycompute() {
        CachedTopicsExistenceValidator cachedTopicsExistenceValidator = this;
        synchronized (cachedTopicsExistenceValidator) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.topicListCache = new SingleValueCache((Option)None$.MODULE$, (Option)new Some((Object)this.config().topicsFetchCacheTtl()));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.topicListCache;
    }

    private SingleValueCache<List<String>> topicListCache() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.topicListCache$lzycompute() : this.topicListCache;
    }

    @Override
    public Validated<TopicExistenceValidationException, List<String>> validateTopics(List<String> topics) {
        return !this.kafkaConfig.topicsExistenceValidationConfig().enabled() || this.isAutoCreateEnabled() ? new Validated.Valid(topics) : (Validated)this.topicListCache().get().flatMap((Function1 & Serializable & scala.Serializable)existingTopics -> ((SeqLike)topics.diff((GenSeq)existingTopics)).isEmpty() ? new Some((Object)new Validated.Valid((Object)topics)) : None$.MODULE$).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            List existingTopics = (List)this.usingAdminClient().apply((Function1 & Serializable & scala.Serializable)x$2 -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter((Set)x$2.listTopics(new ListTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer((int)this.config().adminClientTimeout().toMillis()))).names().get()).asScala()).toList());
            this.topicListCache().put((Object)existingTopics);
            List notExistingTopics = (List)topics.diff((GenSeq)existingTopics);
            return notExistingTopics.isEmpty() ? new Validated.Valid((Object)topics) : new Validated.Invalid((Object)new TopicExistenceValidationException((List<String>)notExistingTopics));
        });
    }

    private boolean isAutoCreateEnabled() {
        return BoxesRunTime.unboxToBoolean((Object)this.autoCreateSettingCache().getOrCreate((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            int timeout = (int)this.config().adminClientTimeout().toMillis();
            String randomKafkaNodeId = (String)this.usingAdminClient().apply((Function1 & Serializable & scala.Serializable)x$3 -> ((Object)BoxesRunTime.boxToInteger((int)((Node)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)x$3.describeCluster(new DescribeClusterOptions().timeoutMs(Predef$.MODULE$.int2Integer(timeout))).nodes().get()).asScala()).head()).id())).toString());
            return BoxesRunTime.unboxToBoolean((Object)this.usingAdminClient().apply((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)CachedTopicsExistenceValidator.$anonfun$isAutoCreateEnabled$3(this, randomKafkaNodeId, x$4))));
        }));
    }

    private <T> Function1<Function1<Admin, T>, T> usingAdminClient() {
        return (Function1 & Serializable & scala.Serializable)adminClientOperation -> KafkaUtils$.MODULE$.usingAdminClient($this.kafkaConfig, adminClientOperation);
    }

    public static final /* synthetic */ boolean $anonfun$isAutoCreateEnabled$3(CachedTopicsExistenceValidator $this, String randomKafkaNodeId$1, Admin x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(((Config)((IterableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(x$4.describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigResource(ConfigResource.Type.BROKER, randomKafkaNodeId$1), (List)Nil$.MODULE$)).asJava(), new DescribeConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer((int)$this.config().adminClientTimeout().toMillis()))).values().values()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> (Config)x$5.get(), Iterable$.MODULE$.canBuildFrom())).head()).get(CachedTopicsExistenceValidatorConfig$.MODULE$.AutoCreateTopicPropertyName()).value())).toBoolean();
    }

    public CachedTopicsExistenceValidator(KafkaConfig kafkaConfig) {
        this.kafkaConfig = kafkaConfig;
        TopicsExistenceValidator.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
    }
}

