/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.baseengine.metrics.dropwizard.influxdb;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.dropwizard.metrics5.influxdb.InfluxDbSender;
import pl.touk.nussknacker.engine.baseengine.metrics.dropwizard.influxdb.InfluxSenderConfig;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import sttp.client.Response;
import sttp.client.SttpBackend;
import sttp.client.TryHttpURLConnectionBackend$;
import sttp.model.StatusCode$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb\u0001B\u0007\u000f\u0001}A\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\u0006\u0003\u0002!\tA\u0011\u0005\b\u000b\u0002\u0011\r\u0011b\u0003G\u0011\u0019I\u0007\u0001)A\u0005\u000f\"9!\u000e\u0001b\u0001\n\u0013Y\u0007B\u0002?\u0001A\u0003%A\u000eC\u0003~\u0001\u0011\u0005c\u0010C\u0004\u0002\u0006\u0001!\t%a\u0002\t\r\u0005M\u0001\u0001\"\u0011\u007f\u0011\u0019\t)\u0002\u0001C!}\"9\u0011q\u0003\u0001\u0005B\u0005e\u0001BBA\u0011\u0001\u0011\u0005cP\u0001\nJ]\u001adW\u000f\u001f#c\u0011R$\boU3oI\u0016\u0014(BA\b\u0011\u0003!IgN\u001a7vq\u0012\u0014'BA\t\u0013\u0003)!'o\u001c9xSj\f'\u000f\u001a\u0006\u0003'Q\tq!\\3ue&\u001c7O\u0003\u0002\u0016-\u0005Q!-Y:fK:<\u0017N\\3\u000b\u0005]A\u0012AB3oO&tWM\u0003\u0002\u001a5\u0005Ya.^:tW:\f7m[3s\u0015\tYB$\u0001\u0003u_V\\'\"A\u000f\u0002\u0005Ad7\u0001A\n\u0005\u0001\u0001B#\u0007\u0005\u0002\"M5\t!E\u0003\u0002$I\u0005!A.\u00198h\u0015\u0005)\u0013\u0001\u00026bm\u0006L!a\n\u0012\u0003\r=\u0013'.Z2u!\tI\u0003'D\u0001+\u0015\ty1F\u0003\u0002-[\u0005AQ.\u001a;sS\u000e\u001cXG\u0003\u0002\u0012])\tq&\u0001\u0002j_&\u0011\u0011G\u000b\u0002\u000f\u0013:4G.\u001e=EEN+g\u000eZ3s!\t\u0019$(D\u00015\u0015\t)d'\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u00028q\u0005AA/\u001f9fg\u00064WMC\u0001:\u0003\r\u0019w.\\\u0005\u0003wQ\u00121\u0002T1{s2{wmZ5oO\u0006!1m\u001c8g!\tqt(D\u0001\u000f\u0013\t\u0001eB\u0001\nJ]\u001adW\u000f_*f]\u0012,'oQ8oM&<\u0017A\u0002\u001fj]&$h\b\u0006\u0002D\tB\u0011a\b\u0001\u0005\u0006y\t\u0001\r!P\u0001\bE\u0006\u001c7.\u001a8e+\u00059\u0005#\u0002%N\u001f^[V\"A%\u000b\u0005)[\u0015AB2mS\u0016tGOC\u0001M\u0003\u0011\u0019H\u000f\u001e9\n\u00059K%aC*uiB\u0014\u0015mY6f]\u0012\u0004\"\u0001U+\u000e\u0003ES!AU*\u0002\tU$\u0018\u000e\u001c\u0006\u0002)\u0006)1oY1mC&\u0011a+\u0015\u0002\u0004)JL\bC\u0001-Z\u001b\u0005\u0019\u0016B\u0001.T\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001\u00184\u000f\u0005u#gB\u00010d\u001d\ty&-D\u0001a\u0015\t\tg$\u0001\u0004=e>|GOP\u0005\u0002\u0019&\u0011!jS\u0005\u0003K&\u000bq\u0001]1dW\u0006<W-\u0003\u0002hQ\nAaj\u001c;iS:<GK\u0003\u0002f\u0013\u0006A!-Y2lK:$\u0007%\u0001\u0004ck\u001a4WM]\u000b\u0002YB\u0019QN\u001d;\u000e\u00039T!a\u001c9\u0002\u000f5,H/\u00192mK*\u0011\u0011oU\u0001\u000bG>dG.Z2uS>t\u0017BA:o\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0005ULhB\u0001<x!\ty6+\u0003\u0002y'\u00061\u0001K]3eK\u001aL!A_>\u0003\rM#(/\u001b8h\u0015\tA8+A\u0004ck\u001a4WM\u001d\u0011\u0002\u000f\r|gN\\3diR\tq\u0010E\u0002Y\u0003\u0003I1!a\u0001T\u0005\u0011)f.\u001b;\u0002\tM,g\u000e\u001a\u000b\u0004\u007f\u0006%\u0001bBA\u0006\u0011\u0001\u0007\u0011QB\u0001\f[\u0016\f7/\u001e:f[\u0016tG\u000fE\u0002\"\u0003\u001fI1!!\u0005#\u00055\u0019FO]5oO\n+\u0018\u000e\u001c3fe\u0006)a\r\\;tQ\u0006QA-[:d_:tWm\u0019;\u0002\u0017%\u001c8i\u001c8oK\u000e$X\r\u001a\u000b\u0003\u00037\u00012\u0001WA\u000f\u0013\r\tyb\u0015\u0002\b\u0005>|G.Z1o\u0003\u0015\u0019Gn\\:f\u0001")
public class InfluxDbHttpSender
implements InfluxDbSender,
LazyLogging {
    private final InfluxSenderConfig conf;
    private final SttpBackend<Try, Nothing$, Nothing$> backend;
    private final ArrayBuffer<String> buffer;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        InfluxDbHttpSender influxDbHttpSender = this;
        synchronized (influxDbHttpSender) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private SttpBackend<Try, Nothing$, Nothing$> backend() {
        return this.backend;
    }

    private ArrayBuffer<String> buffer() {
        return this.buffer;
    }

    public void connect() {
    }

    public void send(StringBuilder measurement) {
        this.buffer().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{measurement.toString()}));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void flush() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        String data = this.buffer().mkString();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Sending {} metrics for conf {}", new Object[]{BoxesRunTime.boxToInteger((int)this.buffer().size()), this.conf});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        this.buffer().clear();
        Try answer = (Try)this.conf.req().body(data).send(this.backend(), Predef.$eq$colon$eq$.MODULE$.tpEquals());
        boolean bl = false;
        Success success = null;
        Try try_ = answer;
        if (try_ instanceof Success) {
            bl = true;
            success = (Success)try_;
            Response res = (Response)success.value();
            if (StatusCode$.MODULE$.isSuccess$extension(res.code())) {
                BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl) {
            BoxedUnit boxedUnit4;
            Response res = (Response)success.value();
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Failed to send data to influx: {}, {}", new Object[]{BoxesRunTime.boxToInteger((int)res.code()), res.body()});
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit5 = boxedUnit4;
            return;
        }
        if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
        Failure failure = (Failure)try_;
        Throwable ex = failure.exception();
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn(new StringBuilder(31).append("Failed to send data to influx: ").append(ex.getMessage()).toString(), ex);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit6 = boxedUnit;
    }

    public void disconnect() {
    }

    public boolean isConnected() {
        return true;
    }

    public void close() {
    }

    public InfluxDbHttpSender(InfluxSenderConfig conf) {
        BoxedUnit boxedUnit;
        this.conf = conf;
        LazyLogging.$init$((LazyLogging)this);
        this.backend = TryHttpURLConnectionBackend$.MODULE$.apply(TryHttpURLConnectionBackend$.MODULE$.apply$default$1(), TryHttpURLConnectionBackend$.MODULE$.apply$default$2(), TryHttpURLConnectionBackend$.MODULE$.apply$default$3(), TryHttpURLConnectionBackend$.MODULE$.apply$default$4(), TryHttpURLConnectionBackend$.MODULE$.apply$default$5());
        this.buffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("InfluxSender created with url: {}", new Object[]{conf.req().uri()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }
}

