/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.lite.metrics.dropwizard.influxdb;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.dropwizard.metrics5.influxdb.InfluxDbSender;
import pl.touk.nussknacker.engine.lite.metrics.dropwizard.influxdb.InfluxSenderConfig;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import sttp.client3.Response;
import sttp.client3.SttpBackend;
import sttp.client3.TryHttpURLConnectionBackend$;
import sttp.model.StatusCode$;

@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001B\u0007\u000f\u0001}A\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\u0006\u0003\u0002!\tA\u0011\u0005\b\u000b\u0002\u0011\r\u0011b\u0003G\u0011\u0019Y\u0006\u0001)A\u0005\u000f\"9A\f\u0001b\u0001\n\u0013i\u0006BB9\u0001A\u0003%a\fC\u0003s\u0001\u0011\u00053\u000fC\u0003x\u0001\u0011\u0005\u0003\u0010C\u0003\u007f\u0001\u0011\u00053\u000fC\u0003\u0000\u0001\u0011\u00053\u000fC\u0004\u0002\u0002\u0001!\t%a\u0001\t\r\u0005-\u0001\u0001\"\u0011t\u0005IIeN\u001a7vq\u0012\u0013\u0007\n\u001e;q'\u0016tG-\u001a:\u000b\u0005=\u0001\u0012\u0001C5oM2,\b\u0010\u001a2\u000b\u0005E\u0011\u0012A\u00033s_B<\u0018N_1sI*\u00111\u0003F\u0001\b[\u0016$(/[2t\u0015\t)b#\u0001\u0003mSR,'BA\f\u0019\u0003\u0019)gnZ5oK*\u0011\u0011DG\u0001\f]V\u001c8o\u001b8bG.,'O\u0003\u0002\u001c9\u0005!Ao\\;l\u0015\u0005i\u0012A\u00019m\u0007\u0001\u0019B\u0001\u0001\u0011)eA\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0005Y\u0006twMC\u0001&\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0012#AB(cU\u0016\u001cG\u000f\u0005\u0002*a5\t!F\u0003\u0002\u0010W)\u0011A&L\u0001\t[\u0016$(/[2tk)\u0011\u0011C\f\u0006\u0002_\u0005\u0011\u0011n\\\u0005\u0003c)\u0012a\"\u00138gYVDHIY*f]\u0012,'\u000f\u0005\u00024u5\tAG\u0003\u00026m\u0005a1oY1mC2|wmZ5oO*\u0011q\u0007O\u0001\tif\u0004Xm]1gK*\t\u0011(A\u0002d_6L!a\u000f\u001b\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\u0005G>tg\r\u0005\u0002?\u007f5\ta\"\u0003\u0002A\u001d\t\u0011\u0012J\u001c4mkb\u001cVM\u001c3fe\u000e{gNZ5h\u0003\u0019a\u0014N\\5u}Q\u00111\t\u0012\t\u0003}\u0001AQ\u0001\u0010\u0002A\u0002u\nqAY1dW\u0016tG-F\u0001H!\u0011AUjT,\u000e\u0003%S!AS&\u0002\u000f\rd\u0017.\u001a8ug)\tA*\u0001\u0003tiR\u0004\u0018B\u0001(J\u0005-\u0019F\u000f\u001e9CC\u000e\\WM\u001c3\u0011\u0005A+V\"A)\u000b\u0005I\u001b\u0016\u0001B;uS2T\u0011\u0001V\u0001\u0006g\u000e\fG.Y\u0005\u0003-F\u00131\u0001\u0016:z!\tA\u0016,D\u0001T\u0013\tQ6KA\u0002B]f\f\u0001BY1dW\u0016tG\rI\u0001\u0007EV4g-\u001a:\u0016\u0003y\u00032a\u00183g\u001b\u0005\u0001'BA1c\u0003\u001diW\u000f^1cY\u0016T!aY*\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002fA\nY\u0011I\u001d:bs\n+hMZ3s!\t9gN\u0004\u0002iYB\u0011\u0011nU\u0007\u0002U*\u00111NH\u0001\u0007yI|w\u000e\u001e \n\u00055\u001c\u0016A\u0002)sK\u0012,g-\u0003\u0002pa\n11\u000b\u001e:j]\u001eT!!\\*\u0002\u000f\t,hMZ3sA\u000591m\u001c8oK\u000e$H#\u0001;\u0011\u0005a+\u0018B\u0001<T\u0005\u0011)f.\u001b;\u0002\tM,g\u000e\u001a\u000b\u0003ifDQA\u001f\u0005A\u0002m\f1\"\\3bgV\u0014X-\\3oiB\u0011\u0011\u0005`\u0005\u0003{\n\u0012Qb\u0015;sS:<')^5mI\u0016\u0014\u0018!\u00024mkND\u0017A\u00033jg\u000e|gN\\3di\u0006Y\u0011n]\"p]:,7\r^3e)\t\t)\u0001E\u0002Y\u0003\u000fI1!!\u0003T\u0005\u001d\u0011un\u001c7fC:\fQa\u00197pg\u0016\u0004")
public class InfluxDbHttpSender
implements InfluxDbSender,
LazyLogging {
    private final InfluxSenderConfig conf;
    private final SttpBackend<Try, Object> backend;
    private final ArrayBuffer<String> buffer;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        InfluxDbHttpSender influxDbHttpSender = this;
        synchronized (influxDbHttpSender) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private SttpBackend<Try, Object> backend() {
        return this.backend;
    }

    private ArrayBuffer<String> buffer() {
        return this.buffer;
    }

    public void connect() {
    }

    public void send(StringBuilder measurement) {
        block0: {
            String stringValue = measurement.toString();
            if (stringValue.contains(((Object)BoxesRunTime.boxToDouble((double)Double.NaN)).toString())) break block0;
            this.buffer().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{stringValue}));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void flush() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.buffer().isEmpty()) {
            BoxedUnit boxedUnit3;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("No metrics to send, skipping");
                boxedUnit3 = BoxedUnit.UNIT;
                return;
            }
            boxedUnit3 = BoxedUnit.UNIT;
            return;
        }
        String data = this.buffer().mkString();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Sending {} metrics for conf {}", new Object[]{BoxesRunTime.boxToInteger((int)this.buffer().size()), this.conf});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        this.buffer().clear();
        Try answer = (Try)this.conf.req().body(data).send(this.backend(), Predef.$eq$colon$eq$.MODULE$.tpEquals(), Predef$.MODULE$.$conforms());
        boolean bl = false;
        Success success = null;
        Try try_ = answer;
        if (try_ instanceof Success) {
            bl = true;
            success = (Success)try_;
            Response res = (Response)success.value();
            if (StatusCode$.MODULE$.isSuccess$extension(res.code())) {
                BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl) {
            BoxedUnit boxedUnit5;
            Response res = (Response)success.value();
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Failed to send data to influx: {}, {}", new Object[]{BoxesRunTime.boxToInteger((int)res.code()), res.body()});
                boxedUnit5 = BoxedUnit.UNIT;
            } else {
                boxedUnit5 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit6 = boxedUnit5;
            return;
        }
        if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
        Failure failure = (Failure)try_;
        Throwable ex = failure.exception();
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn(new StringBuilder(31).append("Failed to send data to influx: ").append(ex.getMessage()).toString(), ex);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit7 = boxedUnit;
    }

    public void disconnect() {
    }

    public boolean isConnected() {
        return true;
    }

    public void close() {
    }

    public InfluxDbHttpSender(InfluxSenderConfig conf) {
        BoxedUnit boxedUnit;
        this.conf = conf;
        LazyLogging.$init$((LazyLogging)this);
        this.backend = TryHttpURLConnectionBackend$.MODULE$.apply(TryHttpURLConnectionBackend$.MODULE$.apply$default$1(), TryHttpURLConnectionBackend$.MODULE$.apply$default$2(), TryHttpURLConnectionBackend$.MODULE$.apply$default$3(), TryHttpURLConnectionBackend$.MODULE$.apply$default$4(), TryHttpURLConnectionBackend$.MODULE$.apply$default$5());
        this.buffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("InfluxSender created with url: {}", new Object[]{conf.req().uri()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }
}

