/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.lite.metrics.dropwizard;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.dropwizard.metrics5.Histogram;
import io.dropwizard.metrics5.Metric;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.Reservoir;
import io.dropwizard.metrics5.SlidingTimeWindowReservoir;
import java.util.concurrent.TimeUnit;
import pl.touk.nussknacker.engine.api.process.ProcessName;
import pl.touk.nussknacker.engine.util.metrics.BaseMetricsProviderForScenario;
import pl.touk.nussknacker.engine.util.metrics.Counter;
import pl.touk.nussknacker.engine.util.metrics.Gauge;
import pl.touk.nussknacker.engine.util.metrics.MetricIdentifier;
import pl.touk.nussknacker.engine.util.metrics.MetricsProviderForScenario;
import pl.touk.nussknacker.engine.util.metrics.RateMeter;
import pl.touk.nussknacker.engine.util.metrics.common.naming$;
import pl.touk.nussknacker.engine.util.service.EspTimer;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001\u0002\u0007\u000e\u0001qA\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\")q\n\u0001C\u0001!\")Q\u000b\u0001C!-\")q\f\u0001C!A\"9!\u000eAI\u0001\n\u0003Y\u0007\"\u0002<\u0001\t\u00139\bbBA\u000e\u0001\u0011\u0005\u0013Q\u0004\u0005\b\u0003\u007f\u0001A\u0011IA!\u0011\u001d\t)\u0005\u0001C\u0005\u0003\u000fBq!!\u0015\u0001\t\u0003\n\u0019F\u0001\u0013Ee>\u0004x/\u001b>be\u0012lU\r\u001e:jGN\u0004&o\u001c<jI\u0016\u0014hi\u001c:TG\u0016t\u0017M]5p\u0015\tqq\"\u0001\u0006ee>\u0004x/\u001b>be\u0012T!\u0001E\t\u0002\u000f5,GO]5dg*\u0011!cE\u0001\u0005Y&$XM\u0003\u0002\u0015+\u00051QM\\4j]\u0016T!AF\f\u0002\u00179,8o]6oC\u000e\\WM\u001d\u0006\u00031e\tA\u0001^8vW*\t!$\u0001\u0002qY\u000e\u00011#\u0002\u0001\u001eG)\u0012\u0004C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"AB!osJ+g\r\u0005\u0002%Q5\tQE\u0003\u0002\u0011M)\u0011qeE\u0001\u0005kRLG.\u0003\u0002*K\tq\")Y:f\u001b\u0016$(/[2t!J|g/\u001b3fe\u001a{'oU2f]\u0006\u0014\u0018n\u001c\t\u0003WAj\u0011\u0001\f\u0006\u0003[9\nA\u0001\\1oO*\tq&\u0001\u0003kCZ\f\u0017BA\u0019-\u00055\tU\u000f^8DY>\u001cX-\u00192mKB\u00111GO\u0007\u0002i)\u0011QGN\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003oa\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002s\u0005\u00191m\\7\n\u0005m\"$a\u0003'bufdunZ4j]\u001e\fAb]2f]\u0006\u0014\u0018n\u001c(b[\u0016\u0004\"AP\"\u000e\u0003}R!\u0001Q!\u0002\u000fA\u0014xnY3tg*\u0011!iE\u0001\u0004CBL\u0017B\u0001#@\u0005-\u0001&o\\2fgNt\u0015-\\3\u0002\u001d5,GO]5d%\u0016<\u0017n\u001d;ssB\u0011q)T\u0007\u0002\u0011*\u0011\u0011JS\u0001\t[\u0016$(/[2tk)\u0011ab\u0013\u0006\u0002\u0019\u0006\u0011\u0011n\\\u0005\u0003\u001d\"\u0013a\"T3ue&\u001c'+Z4jgR\u0014\u00180\u0001\u0004=S:LGO\u0010\u000b\u0004#N#\u0006C\u0001*\u0001\u001b\u0005i\u0001\"\u0002\u001f\u0004\u0001\u0004i\u0004\"B#\u0004\u0001\u00041\u0015aB2pk:$XM\u001d\u000b\u0003/j\u0003\"\u0001\n-\n\u0005e+#aB\"pk:$XM\u001d\u0005\u00067\u0012\u0001\r\u0001X\u0001\u0011[\u0016$(/[2JI\u0016tG/\u001b4jKJ\u0004\"\u0001J/\n\u0005y+#\u0001E'fiJL7-\u00133f]RLg-[3s\u0003%A\u0017n\u001d;pOJ\fW\u000eF\u0002bI\u0016\u0004\"\u0001\n2\n\u0005\r,#!\u0003%jgR|wM]1n\u0011\u0015YV\u00011\u0001]\u0011\u001d1W\u0001%AA\u0002\u001d\f1$\u001b8ti\u0006tG\u000fV5nKJ<\u0016N\u001c3po&s7+Z2p]\u0012\u001c\bC\u0001\u0010i\u0013\tIwD\u0001\u0003M_:<\u0017a\u00055jgR|wM]1nI\u0011,g-Y;mi\u0012\u0012T#\u00017+\u0005\u001dl7&\u00018\u0011\u0005=$X\"\u00019\u000b\u0005E\u0014\u0018!C;oG\",7m[3e\u0015\t\u0019x$\u0001\u0006b]:|G/\u0019;j_:L!!\u001e9\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0005sK\u001eL7\u000f^3s+\tA8\u0010F\u0004z\u0003\u0013\ti!!\u0005\u0011\u0005i\\H\u0002\u0001\u0003\u0006y\u001e\u0011\r! \u0002\u0002)F\u0019a0a\u0001\u0011\u0005yy\u0018bAA\u0001?\t9aj\u001c;iS:<\u0007cA$\u0002\u0006%\u0019\u0011q\u0001%\u0003\r5+GO]5d\u0011\u0019\tYa\u0002a\u00019\u0006\u0011\u0011\u000e\u001a\u0005\u0007\u0003\u001f9\u0001\u0019A=\u0002\r5,GO]5d\u0011\u001d\t\u0019b\u0002a\u0001\u0003+\tqB]3vg\u0016Le-\u0012=jgRLgn\u001a\t\u0004=\u0005]\u0011bAA\r?\t9!i\\8mK\u0006t\u0017!\u0004:fO&\u001cH/\u001a:HCV<W-\u0006\u0003\u0002 \u0005UBCBA\u0011\u0003O\tI\u0003E\u0002\u001f\u0003GI1!!\n \u0005\u0011)f.\u001b;\t\u000bmC\u0001\u0019\u0001/\t\u000f\u0005-\u0002\u00021\u0001\u0002.\u0005)q-Y;hKB)A%a\f\u00024%\u0019\u0011\u0011G\u0013\u0003\u000b\u001d\u000bWoZ3\u0011\u0007i\f)\u0004\u0002\u0004}\u0011\t\u0007\u0011qG\t\u0004}\u0006e\u0002c\u0001\u0010\u0002<%\u0019\u0011QH\u0010\u0003\u0007\u0005s\u00170\u0001\u0004sK6|g/\u001a\u000b\u0005\u0003C\t\u0019\u0005C\u0003\\\u0013\u0001\u0007A,A\tqe\u0016\u0004\u0018M]3NKR\u0014\u0018n\u0019(b[\u0016$B!!\u0013\u0002PA\u0019q)a\u0013\n\u0007\u00055\u0003J\u0001\u0006NKR\u0014\u0018n\u0019(b[\u0016Da!a\u0003\u000b\u0001\u0004a\u0016!B2m_N,GCAA\u0011\u0001")
public class DropwizardMetricsProviderForScenario
implements BaseMetricsProviderForScenario,
AutoCloseable,
LazyLogging {
    private final ProcessName scenarioName;
    private final MetricRegistry metricRegistry;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public EspTimer espTimer(MetricIdentifier identifier, long instantTimerWindowInSeconds) {
        return BaseMetricsProviderForScenario.espTimer$((BaseMetricsProviderForScenario)this, (MetricIdentifier)identifier, (long)instantTimerWindowInSeconds);
    }

    public RateMeter instantRateMeterWithCount(MetricIdentifier identifier) {
        return BaseMetricsProviderForScenario.instantRateMeterWithCount$((BaseMetricsProviderForScenario)this, (MetricIdentifier)identifier);
    }

    public int defaultInstantTimerWindowInSeconds() {
        return MetricsProviderForScenario.defaultInstantTimerWindowInSeconds$((MetricsProviderForScenario)this);
    }

    public long espTimer$default$2() {
        return MetricsProviderForScenario.espTimer$default$2$((MetricsProviderForScenario)this);
    }

    private Logger logger$lzycompute() {
        DropwizardMetricsProviderForScenario dropwizardMetricsProviderForScenario = this;
        synchronized (dropwizardMetricsProviderForScenario) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public Counter counter(MetricIdentifier metricIdentifier) {
        io.dropwizard.metrics5.Counter counter = this.register(metricIdentifier, new io.dropwizard.metrics5.Counter(), true);
        return x$1 -> counter.inc(x$1);
    }

    public pl.touk.nussknacker.engine.util.metrics.Histogram histogram(MetricIdentifier metricIdentifier, long instantTimerWindowInSeconds) {
        SlidingTimeWindowReservoir reservoir = new SlidingTimeWindowReservoir(instantTimerWindowInSeconds, TimeUnit.SECONDS);
        Histogram histogram = this.register(metricIdentifier, new Histogram((Reservoir)reservoir), true);
        return x$1 -> histogram.update(x$1);
    }

    public long histogram$default$2() {
        return 10L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T extends Metric> T register(MetricIdentifier id, T metric, boolean reuseIfExisting) {
        Metric metric2;
        MetricName metricName = this.prepareMetricName(id);
        try {
            metric2 = this.metricRegistry.register(metricName, metric);
            return (T)metric2;
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof IllegalArgumentException)) throw throwable;
            IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable2;
            if (!reuseIfExisting) throw throwable;
            String string = illegalArgumentException.getMessage();
            String string2 = new StringBuilder(30).append("A metric named ").append(metricName).append(" already exists").toString();
            if (string != null ? !string.equals(string2) : string2 != null) throw throwable;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Reusing existing metric for {}", new Object[]{metricName});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Metric metric3 = (Metric)this.metricRegistry.getMetrics().get(metricName);
            metric2 = metric3;
        }
        return (T)metric2;
    }

    public <T> void registerGauge(MetricIdentifier metricIdentifier, Gauge<T> gauge) {
        this.register(metricIdentifier, () -> gauge.getValue(), false);
    }

    public void remove(MetricIdentifier metricIdentifier) {
        this.metricRegistry.remove(this.prepareMetricName(metricIdentifier));
    }

    private MetricName prepareMetricName(MetricIdentifier id) {
        return MetricRegistry.name((String)((String)id.name().head()), (String[])((String[])id.name().tail().toArray(ClassTag$.MODULE$.apply(String.class)))).tagged((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)id.tags()).asJava()).tagged(new String[]{naming$.MODULE$.scenarioIdTag(), this.scenarioName.value()});
    }

    @Override
    public void close() {
        this.metricRegistry.removeMatching((name, x$1) -> {
            Object v = name.getTags().get(naming$.MODULE$.scenarioIdTag());
            String string = $this.scenarioName.value();
            return !(v != null ? !v.equals(string) : string != null);
        });
    }

    public DropwizardMetricsProviderForScenario(ProcessName scenarioName, MetricRegistry metricRegistry) {
        this.scenarioName = scenarioName;
        this.metricRegistry = metricRegistry;
        MetricsProviderForScenario.$init$((MetricsProviderForScenario)this);
        BaseMetricsProviderForScenario.$init$((BaseMetricsProviderForScenario)this);
        LazyLogging.$init$((LazyLogging)this);
    }
}

