/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.lite.metrics.dropwizard.influxdb;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.dropwizard.metrics5.influxdb.InfluxDbSender;
import pl.touk.nussknacker.engine.lite.metrics.dropwizard.influxdb.InfluxSenderConfig;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import sttp.client.Response;
import sttp.client.SttpBackend;
import sttp.client.TryHttpURLConnectionBackend$;
import sttp.model.StatusCode$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb\u0001B\u0007\u000f\u0001}A\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\u0006\u0003\u0002!\tA\u0011\u0005\b\u000b\u0002\u0011\r\u0011b\u0003G\u0011\u0019I\u0007\u0001)A\u0005\u000f\"9!\u000e\u0001b\u0001\n\u0013Y\u0007B\u0002?\u0001A\u0003%A\u000eC\u0003~\u0001\u0011\u0005c\u0010C\u0004\u0002\u0006\u0001!\t%a\u0002\t\r\u0005M\u0001\u0001\"\u0011\u007f\u0011\u0019\t)\u0002\u0001C!}\"9\u0011q\u0003\u0001\u0005B\u0005e\u0001BBA\u0011\u0001\u0011\u0005cP\u0001\nJ]\u001adW\u000f\u001f#c\u0011R$\boU3oI\u0016\u0014(BA\b\u0011\u0003!IgN\u001a7vq\u0012\u0014'BA\t\u0013\u0003)!'o\u001c9xSj\f'\u000f\u001a\u0006\u0003'Q\tq!\\3ue&\u001c7O\u0003\u0002\u0016-\u0005!A.\u001b;f\u0015\t9\u0002$\u0001\u0004f]\u001eLg.\u001a\u0006\u00033i\t1B\\;tg.t\u0017mY6fe*\u00111\u0004H\u0001\u0005i>,8NC\u0001\u001e\u0003\t\u0001Hn\u0001\u0001\u0014\t\u0001\u0001\u0003F\r\t\u0003C\u0019j\u0011A\t\u0006\u0003G\u0011\nA\u0001\\1oO*\tQ%\u0001\u0003kCZ\f\u0017BA\u0014#\u0005\u0019y%M[3diB\u0011\u0011\u0006M\u0007\u0002U)\u0011qb\u000b\u0006\u0003Y5\n\u0001\"\\3ue&\u001c7/\u000e\u0006\u0003#9R\u0011aL\u0001\u0003S>L!!\r\u0016\u0003\u001d%sg\r\\;y\t\n\u001cVM\u001c3feB\u00111GO\u0007\u0002i)\u0011QGN\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003oa\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002s\u0005\u00191m\\7\n\u0005m\"$a\u0003'bufdunZ4j]\u001e\fAaY8oMB\u0011ahP\u0007\u0002\u001d%\u0011\u0001I\u0004\u0002\u0013\u0013:4G.\u001e=TK:$WM]\"p]\u001aLw-\u0001\u0004=S:LGO\u0010\u000b\u0003\u0007\u0012\u0003\"A\u0010\u0001\t\u000bq\u0012\u0001\u0019A\u001f\u0002\u000f\t\f7m[3oIV\tq\tE\u0003I\u001b>;6,D\u0001J\u0015\tQ5*\u0001\u0004dY&,g\u000e\u001e\u0006\u0002\u0019\u0006!1\u000f\u001e;q\u0013\tq\u0015JA\u0006TiR\u0004()Y2lK:$\u0007C\u0001)V\u001b\u0005\t&B\u0001*T\u0003\u0011)H/\u001b7\u000b\u0003Q\u000bQa]2bY\u0006L!AV)\u0003\u0007Q\u0013\u0018\u0010\u0005\u0002Y36\t1+\u0003\u0002['\n9aj\u001c;iS:<\u0007C\u0001/g\u001d\tiFM\u0004\u0002_G:\u0011qLY\u0007\u0002A*\u0011\u0011MH\u0001\u0007yI|w\u000e\u001e \n\u00031K!AS&\n\u0005\u0015L\u0015a\u00029bG.\fw-Z\u0005\u0003O\"\u0014\u0001BT8uQ&tw\r\u0016\u0006\u0003K&\u000b\u0001BY1dW\u0016tG\rI\u0001\u0007EV4g-\u001a:\u0016\u00031\u00042!\u001c:u\u001b\u0005q'BA8q\u0003\u001diW\u000f^1cY\u0016T!!]*\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002t]\nY\u0011I\u001d:bs\n+hMZ3s!\t)\u0018P\u0004\u0002woB\u0011qlU\u0005\u0003qN\u000ba\u0001\u0015:fI\u00164\u0017B\u0001>|\u0005\u0019\u0019FO]5oO*\u0011\u0001pU\u0001\bEV4g-\u001a:!\u0003\u001d\u0019wN\u001c8fGR$\u0012a \t\u00041\u0006\u0005\u0011bAA\u0002'\n!QK\\5u\u0003\u0011\u0019XM\u001c3\u0015\u0007}\fI\u0001C\u0004\u0002\f!\u0001\r!!\u0004\u0002\u00175,\u0017m];sK6,g\u000e\u001e\t\u0004C\u0005=\u0011bAA\tE\ti1\u000b\u001e:j]\u001e\u0014U/\u001b7eKJ\fQA\u001a7vg\"\f!\u0002Z5tG>tg.Z2u\u0003-I7oQ8o]\u0016\u001cG/\u001a3\u0015\u0005\u0005m\u0001c\u0001-\u0002\u001e%\u0019\u0011qD*\u0003\u000f\t{w\u000e\\3b]\u0006)1\r\\8tK\u0002")
public class InfluxDbHttpSender
implements InfluxDbSender,
LazyLogging {
    private final InfluxSenderConfig conf;
    private final SttpBackend<Try, Nothing$, Nothing$> backend;
    private final ArrayBuffer<String> buffer;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        InfluxDbHttpSender influxDbHttpSender = this;
        synchronized (influxDbHttpSender) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private SttpBackend<Try, Nothing$, Nothing$> backend() {
        return this.backend;
    }

    private ArrayBuffer<String> buffer() {
        return this.buffer;
    }

    public void connect() {
    }

    public void send(StringBuilder measurement) {
        block0: {
            String stringValue = measurement.toString();
            if (stringValue.contains(((Object)BoxesRunTime.boxToDouble((double)Double.NaN)).toString())) break block0;
            this.buffer().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{stringValue}));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void flush() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.buffer().isEmpty()) {
            BoxedUnit boxedUnit3;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("No metrics to send, skipping");
                boxedUnit3 = BoxedUnit.UNIT;
                return;
            }
            boxedUnit3 = BoxedUnit.UNIT;
            return;
        }
        String data = this.buffer().mkString();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Sending {} metrics for conf {}", new Object[]{BoxesRunTime.boxToInteger((int)this.buffer().size()), this.conf});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        this.buffer().clear();
        Try answer = (Try)this.conf.req().body(data).send(this.backend(), Predef.$eq$colon$eq$.MODULE$.tpEquals());
        boolean bl = false;
        Success success = null;
        Try try_ = answer;
        if (try_ instanceof Success) {
            bl = true;
            success = (Success)try_;
            Response res = (Response)success.value();
            if (StatusCode$.MODULE$.isSuccess$extension(res.code())) {
                BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl) {
            BoxedUnit boxedUnit5;
            Response res = (Response)success.value();
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Failed to send data to influx: {}, {}", new Object[]{BoxesRunTime.boxToInteger((int)res.code()), res.body()});
                boxedUnit5 = BoxedUnit.UNIT;
            } else {
                boxedUnit5 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit6 = boxedUnit5;
            return;
        }
        if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
        Failure failure = (Failure)try_;
        Throwable ex = failure.exception();
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn(new StringBuilder(31).append("Failed to send data to influx: ").append(ex.getMessage()).toString(), ex);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit7 = boxedUnit;
    }

    public void disconnect() {
    }

    public boolean isConnected() {
        return true;
    }

    public void close() {
    }

    public InfluxDbHttpSender(InfluxSenderConfig conf) {
        BoxedUnit boxedUnit;
        this.conf = conf;
        LazyLogging.$init$((LazyLogging)this);
        this.backend = TryHttpURLConnectionBackend$.MODULE$.apply(TryHttpURLConnectionBackend$.MODULE$.apply$default$1(), TryHttpURLConnectionBackend$.MODULE$.apply$default$2(), TryHttpURLConnectionBackend$.MODULE$.apply$default$3(), TryHttpURLConnectionBackend$.MODULE$.apply$default$4(), TryHttpURLConnectionBackend$.MODULE$.apply$default$5());
        this.buffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("InfluxSender created with url: {}", new Object[]{conf.req().uri()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }
}

