/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.diff;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonNumEquals;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.diff.Diff;
import com.github.fge.jsonpatch.diff.DiffOperation;
import com.google.common.base.Equivalence;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

final class DiffFactorizer {
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquals.getInstance();

    private DiffFactorizer() {
    }

    public static void factorizeDiffs(List<Diff> diffs) {
        DiffFactorizer.findPairs(diffs);
        DiffFactorizer.factorizePairs(diffs);
        ArrayList<Diff> addDiffs = Lists.newArrayList();
        for (Diff diff2 : diffs) {
            if (diff2.operation != DiffOperation.ADD || diff2.value.size() == 0) continue;
            Diff addDiff = null;
            for (Diff testAddDiff : addDiffs) {
                if (!EQUIVALENCE.equivalent(diff2.value, testAddDiff.value)) continue;
                addDiff = testAddDiff;
                break;
            }
            if (addDiff == null) {
                if (diff2.arrayPath != null && diff2.secondArrayIndex == -1) continue;
                addDiffs.add(diff2);
                continue;
            }
            diff2.operation = DiffOperation.COPY;
            diff2.fromPath = addDiff.arrayPath != null ? addDiff.getSecondArrayPath() : addDiff.path;
        }
    }

    private static void findPairs(List<Diff> diffs) {
        int diffsSize = diffs.size();
        block0: for (int addIndex = 0; addIndex < diffsSize; ++addIndex) {
            Diff addition = diffs.get(addIndex);
            if (addition.operation != DiffOperation.ADD) continue;
            for (int removeIndex = 0; removeIndex < diffsSize; ++removeIndex) {
                Diff removal = diffs.get(removeIndex);
                if (removal.operation != DiffOperation.REMOVE || !EQUIVALENCE.equivalent(removal.value, addition.value)) continue;
                addition.pairedDiff = removal;
                addition.firstOfPair = addIndex < removeIndex;
                removal.pairedDiff = addition;
                removal.firstOfPair = removeIndex < addIndex;
                continue block0;
            }
        }
    }

    private static void factorizePairs(List<Diff> diffs) {
        ArrayList<Diff> seenBefore = Lists.newArrayList();
        ArrayList<Diff> seenAfter = Lists.newArrayList();
        Iterator<Diff> iterator = diffs.iterator();
        block4: while (iterator.hasNext()) {
            Diff diff2 = iterator.next();
            if (diff2.pairedDiff != null) {
                switch (diff2.operation) {
                    case REMOVE: {
                        if (diff2.arrayPath != null && diff2.firstOfPair) {
                            seenBefore.add(diff2);
                        }
                        iterator.remove();
                        continue block4;
                    }
                    case ADD: {
                        DiffFactorizer.transformAddition(seenBefore, seenAfter, diff2);
                    }
                }
            }
            if (diff2.arrayPath == null) continue;
            diff2.secondArrayIndex = DiffFactorizer.adjustSecondArrayIndex(seenBefore, diff2.arrayPath, diff2.secondArrayIndex);
        }
    }

    private static void transformAddition(List<Diff> seenBefore, List<Diff> seenAfter, Diff diff2) {
        Diff removal = diff2.pairedDiff;
        diff2.operation = DiffOperation.MOVE;
        diff2.pairedDiff = null;
        if (removal.arrayPath == null) {
            diff2.fromPath = removal.path;
            return;
        }
        if (diff2.firstOfPair) {
            int removeIndex = removal.firstArrayIndex;
            removeIndex = DiffFactorizer.adjustFirstArrayIndex(seenAfter, removal.arrayPath, removeIndex);
            if (removal.arrayPath.equals(diff2.arrayPath)) {
                int moveSecondArrayIndex = DiffFactorizer.adjustSecondArrayIndex(seenBefore, diff2.arrayPath, diff2.secondArrayIndex);
                int moveFirstArrayIndex = DiffFactorizer.adjustFirstArrayIndex(seenAfter, diff2.arrayPath, diff2.firstArrayIndex);
                removeIndex += moveSecondArrayIndex - moveFirstArrayIndex;
            }
            diff2.fromPath = removal.arrayPath.append(removeIndex);
            seenAfter.add(removal);
        } else {
            seenBefore.remove(removal);
            int removeIndex = removal.secondArrayIndex;
            removeIndex = DiffFactorizer.adjustSecondArrayIndex(seenBefore, removal.arrayPath, removeIndex);
            diff2.fromPath = removal.arrayPath.append(removeIndex);
        }
    }

    private static int adjustFirstArrayIndex(List<Diff> seenAfter, JsonPointer arrayPath, int arrayIndex) {
        int arrayRemoves = 0;
        for (Diff removal : seenAfter) {
            if (!arrayPath.equals(removal.arrayPath) || arrayIndex <= removal.firstArrayIndex) continue;
            ++arrayRemoves;
        }
        return arrayIndex - arrayRemoves;
    }

    private static int adjustSecondArrayIndex(List<Diff> seenAfter, JsonPointer arrayPath, int arrayIndex) {
        if (arrayIndex == -1) {
            return arrayIndex;
        }
        int arrayRemoves = 0;
        for (Diff removal : seenAfter) {
            if (!arrayPath.equals(removal.arrayPath) || arrayIndex < removal.secondArrayIndex) continue;
            ++arrayRemoves;
        }
        return arrayIndex + arrayRemoves;
    }
}

