/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.mergepatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.mergepatch.JsonMergePatch;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;

final class ObjectMergePatch
extends JsonMergePatch {
    private final Map<String, JsonNode> fields;
    private final Set<String> removals;

    ObjectMergePatch(JsonNode content) {
        super(content);
        this.fields = JacksonUtils.asMap(content);
        this.removals = Sets.newHashSet();
        for (Map.Entry<String, JsonNode> entry : this.fields.entrySet()) {
            if (!entry.getValue().isNull()) continue;
            this.removals.add(entry.getKey());
        }
        this.fields.keySet().removeAll(this.removals);
    }

    @Override
    public JsonNode apply(JsonNode input) throws JsonPatchException {
        if (!input.isObject()) {
            return ObjectMergePatch.mapToNode(this.fields);
        }
        Map<String, JsonNode> map2 = JacksonUtils.asMap(input);
        map2.keySet().removeAll(this.removals);
        for (Map.Entry<String, JsonNode> entry : map2.entrySet()) {
            String memberName = entry.getKey();
            JsonNode patchNode = this.fields.get(memberName);
            if (patchNode == null) continue;
            if (!patchNode.isContainerNode()) {
                entry.setValue(patchNode);
                continue;
            }
            JsonMergePatch patch = JsonMergePatch.fromJson(patchNode);
            entry.setValue(patch.apply(entry.getValue()));
        }
        for (String key : Sets.difference(this.fields.keySet(), map2.keySet())) {
            map2.put(key, ObjectMergePatch.clearNulls(this.fields.get(key)));
        }
        return ObjectMergePatch.mapToNode(map2);
    }

    private static JsonNode mapToNode(Map<String, JsonNode> map2) {
        ObjectNode ret = FACTORY.objectNode();
        return ret.putAll(map2);
    }
}

