/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.keyword.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.core.processing.RawProcessor;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.core.util.Dictionary;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;

public final class SyntaxProcessor
extends RawProcessor<SchemaTree, SchemaTree> {
    private final MessageBundle bundle;
    private final Map<String, SyntaxChecker> checkers;

    public SyntaxProcessor(MessageBundle bundle, Dictionary<SyntaxChecker> dict) {
        super("schema", "schema");
        this.bundle = bundle;
        this.checkers = dict.entries();
    }

    @Override
    public SchemaTree rawProcess(ProcessingReport report, SchemaTree input) throws ProcessingException {
        this.validate(report, input);
        return input;
    }

    private void validate(ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode node = tree.getNode();
        NodeType type = NodeType.getNodeType(node);
        if (type != NodeType.OBJECT) {
            report.error(this.newMsg(tree, "core.notASchema").putArgument("found", type));
            return;
        }
        TreeMap<String, SyntaxChecker> map2 = Maps.newTreeMap();
        map2.putAll(this.checkers);
        HashSet<String> fields = Sets.newHashSet(node.fieldNames());
        map2.keySet().retainAll(fields);
        fields.removeAll(map2.keySet());
        if (!fields.isEmpty()) {
            report.warn(this.newMsg(tree, "core.unknownKeywords").putArgument("ignored", Ordering.natural().sortedCopy(fields)));
        }
        ArrayList<JsonPointer> pointers = Lists.newArrayList();
        for (SyntaxChecker checker : map2.values()) {
            checker.checkSyntax(pointers, this.bundle, report, tree);
        }
        for (JsonPointer pointer : pointers) {
            this.validate(report, tree.append(pointer));
        }
    }

    private ProcessingMessage newMsg(SchemaTree tree, String key) {
        return new ProcessingMessage().put("schema", tree).put("domain", "syntax").setMessage(this.bundle.getMessage(key));
    }

    public String toString() {
        return "syntax checker";
    }
}

