/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.load.uri;

import com.github.fge.Thawed;
import com.github.fge.jsonschema.core.load.uri.PathRedirectRegistry;
import com.github.fge.jsonschema.core.load.uri.SchemaRedirectRegistry;
import com.github.fge.jsonschema.core.load.uri.URITranslatorConfiguration;
import com.github.fge.jsonschema.core.messages.JsonSchemaCoreMessageBundle;
import com.github.fge.jsonschema.core.util.URIUtils;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import java.net.URI;

public final class URITranslatorConfigurationBuilder
implements Thawed<URITranslatorConfiguration> {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaCoreMessageBundle.class);
    private static final URI EMPTY = URI.create("");
    URI namespace = EMPTY;
    final PathRedirectRegistry pathRedirects = new PathRedirectRegistry();
    final SchemaRedirectRegistry schemaRedirects = new SchemaRedirectRegistry();

    URITranslatorConfigurationBuilder() {
    }

    URITranslatorConfigurationBuilder(URITranslatorConfiguration cfg) {
        this.namespace = cfg.namespace;
        this.pathRedirects.putAll(cfg.pathRedirects);
        this.schemaRedirects.putAll(cfg.schemaRedirects);
    }

    public URITranslatorConfigurationBuilder setNamespace(URI uri) {
        BUNDLE.checkNotNull(uri, "uriChecks.nullInput");
        URI normalized = URIUtils.normalizeURI(uri);
        URIUtils.checkPathURI(normalized);
        this.namespace = normalized;
        return this;
    }

    public URITranslatorConfigurationBuilder setNamespace(String uri) {
        BUNDLE.checkNotNull(uri, "uriChecks.nullInput");
        return this.setNamespace(URI.create(uri));
    }

    public URITranslatorConfigurationBuilder addSchemaRedirect(URI from2, URI to) {
        this.schemaRedirects.put(from2, to);
        return this;
    }

    public URITranslatorConfigurationBuilder addSchemaRedirect(String from2, String to) {
        BUNDLE.checkNotNull(from2, "uriChecks.nullInput");
        BUNDLE.checkNotNull(to, "uriChecks.nullInput");
        return this.addSchemaRedirect(URI.create(from2), URI.create(to));
    }

    public URITranslatorConfigurationBuilder addPathRedirect(URI from2, URI to) {
        this.pathRedirects.put(from2, to);
        return this;
    }

    public URITranslatorConfigurationBuilder addPathRedirect(String from2, String to) {
        BUNDLE.checkNotNull(from2, "uriChecks.nullInput");
        BUNDLE.checkNotNull(to, "uriChecks.nullInput");
        return this.addPathRedirect(URI.create(from2), URI.create(to));
    }

    @Override
    public URITranslatorConfiguration freeze() {
        return new URITranslatorConfiguration(this);
    }
}

