/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.ref;

import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jackson.jsonpointer.JsonPointerException;
import com.github.fge.jsonschema.core.exceptions.JsonReferenceException;
import com.github.fge.jsonschema.core.messages.JsonSchemaCoreMessageBundle;
import com.github.fge.jsonschema.core.ref.EmptyJsonRef;
import com.github.fge.jsonschema.core.ref.HierarchicalJsonRef;
import com.github.fge.jsonschema.core.ref.JarJsonRef;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.util.URIUtils;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.google.common.base.Optional;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class JsonRef {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaCoreMessageBundle.class);
    private static final URI EMPTY_URI = URI.create("");
    protected static final URI HASHONLY_URI = URI.create("#");
    protected final boolean legal;
    protected final URI uri;
    protected final URI locator;
    protected final JsonPointer pointer;
    private final String asString;
    private final int hashCode;

    protected JsonRef(URI uri) {
        JsonPointer ptr;
        String scheme = uri.getScheme();
        String ssp = uri.getSchemeSpecificPart();
        String fragment2 = Optional.fromNullable(uri.getFragment()).or("");
        boolean isLegal = true;
        try {
            ptr = fragment2.isEmpty() ? JsonPointer.empty() : new JsonPointer(fragment2);
        }
        catch (JsonPointerException ignored) {
            ptr = null;
            isLegal = false;
        }
        this.legal = isLegal;
        this.pointer = ptr;
        try {
            this.uri = new URI(scheme, ssp, fragment2);
            this.locator = new URI(scheme, ssp, "");
            this.asString = this.uri.toString();
            this.hashCode = this.asString.hashCode();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("WTF??", e);
        }
    }

    public static JsonRef fromURI(URI uri) {
        BUNDLE.checkNotNull(uri, "jsonRef.nullURI");
        URI normalized = URIUtils.normalizeURI(uri);
        if (HASHONLY_URI.equals(normalized) || EMPTY_URI.equals(normalized)) {
            return EmptyJsonRef.getInstance();
        }
        return "jar".equals(normalized.getScheme()) ? new JarJsonRef(normalized) : new HierarchicalJsonRef(normalized);
    }

    public static JsonRef fromString(String s) throws JsonReferenceException {
        BUNDLE.checkNotNull(s, "jsonRef.nullInput");
        try {
            return JsonRef.fromURI(new URI(s));
        }
        catch (URISyntaxException e) {
            throw new JsonReferenceException(new ProcessingMessage().setMessage(BUNDLE.getMessage("jsonRef.invalidURI")).putArgument("input", s), (Throwable)e);
        }
    }

    public static JsonRef emptyRef() {
        return EmptyJsonRef.getInstance();
    }

    public final URI toURI() {
        return this.uri;
    }

    public abstract boolean isAbsolute();

    public abstract JsonRef resolve(JsonRef var1);

    public final URI getLocator() {
        return this.locator;
    }

    public final boolean isLegal() {
        return this.legal;
    }

    public final JsonPointer getPointer() {
        return this.pointer;
    }

    public final boolean contains(JsonRef other) {
        return this.locator.equals(other.locator);
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsonRef)) {
            return false;
        }
        JsonRef that = (JsonRef)obj;
        return this.asString.equals(that.asString);
    }

    public final String toString() {
        return this.asString;
    }
}

