/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.BiMap;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Serialization;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.j2objc.annotations.RetainedWith;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible
public final class HashBiMap<K, V>
extends AbstractMap<K, V>
implements BiMap<K, V>,
Serializable {
    private static final int ABSENT = -1;
    private static final int ENDPOINT = -2;
    transient K[] keys;
    transient V[] values;
    transient int size;
    transient int modCount;
    private transient int[] hashTableKToV;
    private transient int[] hashTableVToK;
    private transient int[] nextInBucketKToV;
    private transient int[] nextInBucketVToK;
    @NullableDecl
    private transient int firstInInsertionOrder;
    @NullableDecl
    private transient int lastInInsertionOrder;
    private transient int[] prevInInsertionOrder;
    private transient int[] nextInInsertionOrder;
    private transient Set<K> keySet;
    private transient Set<V> valueSet;
    private transient Set<Map.Entry<K, V>> entrySet;
    @MonotonicNonNullDecl
    @RetainedWith
    private transient BiMap<V, K> inverse;

    public static <K, V> HashBiMap<K, V> create() {
        return HashBiMap.create(16);
    }

    public static <K, V> HashBiMap<K, V> create(int expectedSize) {
        return new HashBiMap<K, V>(expectedSize);
    }

    public static <K, V> HashBiMap<K, V> create(Map<? extends K, ? extends V> map2) {
        HashBiMap<K, V> bimap = HashBiMap.create(map2.size());
        bimap.putAll(map2);
        return bimap;
    }

    private HashBiMap(int expectedSize) {
        this.init(expectedSize);
    }

    void init(int expectedSize) {
        CollectPreconditions.checkNonnegative(expectedSize, "expectedSize");
        int tableSize = Hashing.closedTableSize(expectedSize, 1.0);
        this.size = 0;
        this.keys = new Object[expectedSize];
        this.values = new Object[expectedSize];
        this.hashTableKToV = HashBiMap.createFilledWithAbsent(tableSize);
        this.hashTableVToK = HashBiMap.createFilledWithAbsent(tableSize);
        this.nextInBucketKToV = HashBiMap.createFilledWithAbsent(expectedSize);
        this.nextInBucketVToK = HashBiMap.createFilledWithAbsent(expectedSize);
        this.firstInInsertionOrder = -2;
        this.lastInInsertionOrder = -2;
        this.prevInInsertionOrder = HashBiMap.createFilledWithAbsent(expectedSize);
        this.nextInInsertionOrder = HashBiMap.createFilledWithAbsent(expectedSize);
    }

    private static int[] createFilledWithAbsent(int size) {
        int[] array = new int[size];
        Arrays.fill(array, -1);
        return array;
    }

    private static int[] expandAndFillWithAbsent(int[] array, int newSize) {
        int oldSize = array.length;
        int[] result2 = Arrays.copyOf(array, newSize);
        Arrays.fill(result2, oldSize, newSize, -1);
        return result2;
    }

    @Override
    public int size() {
        return this.size;
    }

    private void ensureCapacity(int minCapacity) {
        if (this.nextInBucketKToV.length < minCapacity) {
            int oldCapacity = this.nextInBucketKToV.length;
            int newCapacity = ImmutableCollection.Builder.expandedCapacity(oldCapacity, minCapacity);
            this.keys = Arrays.copyOf(this.keys, newCapacity);
            this.values = Arrays.copyOf(this.values, newCapacity);
            this.nextInBucketKToV = HashBiMap.expandAndFillWithAbsent(this.nextInBucketKToV, newCapacity);
            this.nextInBucketVToK = HashBiMap.expandAndFillWithAbsent(this.nextInBucketVToK, newCapacity);
            this.prevInInsertionOrder = HashBiMap.expandAndFillWithAbsent(this.prevInInsertionOrder, newCapacity);
            this.nextInInsertionOrder = HashBiMap.expandAndFillWithAbsent(this.nextInInsertionOrder, newCapacity);
        }
        if (this.hashTableKToV.length < minCapacity) {
            int newTableSize = Hashing.closedTableSize(minCapacity, 1.0);
            this.hashTableKToV = HashBiMap.createFilledWithAbsent(newTableSize);
            this.hashTableVToK = HashBiMap.createFilledWithAbsent(newTableSize);
            int entryToRehash = 0;
            while (entryToRehash < this.size) {
                int keyHash = Hashing.smearedHash(this.keys[entryToRehash]);
                int keyBucket = this.bucket(keyHash);
                this.nextInBucketKToV[entryToRehash] = this.hashTableKToV[keyBucket];
                this.hashTableKToV[keyBucket] = entryToRehash;
                int valueHash = Hashing.smearedHash(this.values[entryToRehash]);
                int valueBucket = this.bucket(valueHash);
                this.nextInBucketVToK[entryToRehash] = this.hashTableVToK[valueBucket];
                this.hashTableVToK[valueBucket] = entryToRehash++;
            }
        }
    }

    private int bucket(int hash2) {
        return hash2 & this.hashTableKToV.length - 1;
    }

    int findEntryByKey(@NullableDecl Object key) {
        return this.findEntryByKey(key, Hashing.smearedHash(key));
    }

    int findEntryByKey(@NullableDecl Object key, int keyHash) {
        return this.findEntry(key, keyHash, this.hashTableKToV, this.nextInBucketKToV, this.keys);
    }

    int findEntryByValue(@NullableDecl Object value) {
        return this.findEntryByValue(value, Hashing.smearedHash(value));
    }

    int findEntryByValue(@NullableDecl Object value, int valueHash) {
        return this.findEntry(value, valueHash, this.hashTableVToK, this.nextInBucketVToK, this.values);
    }

    int findEntry(@NullableDecl Object o, int oHash, int[] hashTable, int[] nextInBucket, Object[] array) {
        int entry = hashTable[this.bucket(oHash)];
        while (entry != -1) {
            if (Objects.equal(array[entry], o)) {
                return entry;
            }
            entry = nextInBucket[entry];
        }
        return -1;
    }

    @Override
    public boolean containsKey(@NullableDecl Object key) {
        return this.findEntryByKey(key) != -1;
    }

    @Override
    public boolean containsValue(@NullableDecl Object value) {
        return this.findEntryByValue(value) != -1;
    }

    @Override
    @NullableDecl
    public V get(@NullableDecl Object key) {
        int entry = this.findEntryByKey(key);
        return entry == -1 ? null : (V)this.values[entry];
    }

    @NullableDecl
    K getInverse(@NullableDecl Object value) {
        int entry = this.findEntryByValue(value);
        return entry == -1 ? null : (K)this.keys[entry];
    }

    @Override
    @CanIgnoreReturnValue
    public V put(@NullableDecl K key, @NullableDecl V value) {
        return this.put(key, value, false);
    }

    @NullableDecl
    V put(@NullableDecl K key, @NullableDecl V value, boolean force) {
        int keyHash = Hashing.smearedHash(key);
        int entryForKey = this.findEntryByKey(key, keyHash);
        if (entryForKey != -1) {
            V oldValue = this.values[entryForKey];
            if (Objects.equal(oldValue, value)) {
                return value;
            }
            this.replaceValueInEntry(entryForKey, value, force);
            return oldValue;
        }
        int valueHash = Hashing.smearedHash(value);
        int valueEntry = this.findEntryByValue(value, valueHash);
        if (force) {
            if (valueEntry != -1) {
                this.removeEntryValueHashKnown(valueEntry, valueHash);
            }
        } else {
            Preconditions.checkArgument(valueEntry == -1, "Value already present: %s", value);
        }
        this.ensureCapacity(this.size + 1);
        this.keys[this.size] = key;
        this.values[this.size] = value;
        this.insertIntoTableKToV(this.size, keyHash);
        this.insertIntoTableVToK(this.size, valueHash);
        this.setSucceeds(this.lastInInsertionOrder, this.size);
        this.setSucceeds(this.size, -2);
        ++this.size;
        ++this.modCount;
        return null;
    }

    @Override
    @NullableDecl
    @CanIgnoreReturnValue
    public V forcePut(@NullableDecl K key, @NullableDecl V value) {
        return this.put(key, value, true);
    }

    @NullableDecl
    K putInverse(@NullableDecl V value, @NullableDecl K key, boolean force) {
        int valueHash = Hashing.smearedHash(value);
        int entryForValue = this.findEntryByValue(value, valueHash);
        if (entryForValue != -1) {
            K oldKey = this.keys[entryForValue];
            if (Objects.equal(oldKey, key)) {
                return key;
            }
            this.replaceKeyInEntry(entryForValue, key, force);
            return oldKey;
        }
        int predecessor = this.lastInInsertionOrder;
        int keyHash = Hashing.smearedHash(key);
        int keyEntry = this.findEntryByKey(key, keyHash);
        if (force) {
            if (keyEntry != -1) {
                predecessor = this.prevInInsertionOrder[keyEntry];
                this.removeEntryKeyHashKnown(keyEntry, keyHash);
            }
        } else {
            Preconditions.checkArgument(keyEntry == -1, "Key already present: %s", key);
        }
        this.ensureCapacity(this.size + 1);
        this.keys[this.size] = key;
        this.values[this.size] = value;
        this.insertIntoTableKToV(this.size, keyHash);
        this.insertIntoTableVToK(this.size, valueHash);
        int successor = predecessor == -2 ? this.firstInInsertionOrder : this.nextInInsertionOrder[predecessor];
        this.setSucceeds(predecessor, this.size);
        this.setSucceeds(this.size, successor);
        ++this.size;
        ++this.modCount;
        return null;
    }

    private void setSucceeds(int prev, int next) {
        if (prev == -2) {
            this.firstInInsertionOrder = next;
        } else {
            this.nextInInsertionOrder[prev] = next;
        }
        if (next == -2) {
            this.lastInInsertionOrder = prev;
        } else {
            this.prevInInsertionOrder[next] = prev;
        }
    }

    private void insertIntoTableKToV(int entry, int keyHash) {
        Preconditions.checkArgument(entry != -1);
        int keyBucket = this.bucket(keyHash);
        this.nextInBucketKToV[entry] = this.hashTableKToV[keyBucket];
        this.hashTableKToV[keyBucket] = entry;
    }

    private void insertIntoTableVToK(int entry, int valueHash) {
        Preconditions.checkArgument(entry != -1);
        int valueBucket = this.bucket(valueHash);
        this.nextInBucketVToK[entry] = this.hashTableVToK[valueBucket];
        this.hashTableVToK[valueBucket] = entry;
    }

    private void deleteFromTableKToV(int entry, int keyHash) {
        Preconditions.checkArgument(entry != -1);
        int keyBucket = this.bucket(keyHash);
        if (this.hashTableKToV[keyBucket] == entry) {
            this.hashTableKToV[keyBucket] = this.nextInBucketKToV[entry];
            this.nextInBucketKToV[entry] = -1;
            return;
        }
        int prevInBucket = this.hashTableKToV[keyBucket];
        int entryInBucket = this.nextInBucketKToV[prevInBucket];
        while (entryInBucket != -1) {
            if (entryInBucket == entry) {
                this.nextInBucketKToV[prevInBucket] = this.nextInBucketKToV[entry];
                this.nextInBucketKToV[entry] = -1;
                return;
            }
            prevInBucket = entryInBucket;
            entryInBucket = this.nextInBucketKToV[entryInBucket];
        }
        throw new AssertionError((Object)("Expected to find entry with key " + this.keys[entry]));
    }

    private void deleteFromTableVToK(int entry, int valueHash) {
        Preconditions.checkArgument(entry != -1);
        int valueBucket = this.bucket(valueHash);
        if (this.hashTableVToK[valueBucket] == entry) {
            this.hashTableVToK[valueBucket] = this.nextInBucketVToK[entry];
            this.nextInBucketVToK[entry] = -1;
            return;
        }
        int prevInBucket = this.hashTableVToK[valueBucket];
        int entryInBucket = this.nextInBucketVToK[prevInBucket];
        while (entryInBucket != -1) {
            if (entryInBucket == entry) {
                this.nextInBucketVToK[prevInBucket] = this.nextInBucketVToK[entry];
                this.nextInBucketVToK[entry] = -1;
                return;
            }
            prevInBucket = entryInBucket;
            entryInBucket = this.nextInBucketVToK[entryInBucket];
        }
        throw new AssertionError((Object)("Expected to find entry with value " + this.values[entry]));
    }

    private void replaceValueInEntry(int entry, @NullableDecl V newValue, boolean force) {
        Preconditions.checkArgument(entry != -1);
        int newValueHash = Hashing.smearedHash(newValue);
        int newValueIndex = this.findEntryByValue(newValue, newValueHash);
        if (newValueIndex != -1) {
            if (force) {
                this.removeEntryValueHashKnown(newValueIndex, newValueHash);
                if (entry == this.size) {
                    entry = newValueIndex;
                }
            } else {
                throw new IllegalArgumentException("Value already present in map: " + newValue);
            }
        }
        this.deleteFromTableVToK(entry, Hashing.smearedHash(this.values[entry]));
        this.values[entry] = newValue;
        this.insertIntoTableVToK(entry, newValueHash);
    }

    private void replaceKeyInEntry(int entry, @NullableDecl K newKey, boolean force) {
        Preconditions.checkArgument(entry != -1);
        int newKeyHash = Hashing.smearedHash(newKey);
        int newKeyIndex = this.findEntryByKey(newKey, newKeyHash);
        int newPredecessor = this.lastInInsertionOrder;
        int newSuccessor = -2;
        if (newKeyIndex != -1) {
            if (force) {
                newPredecessor = this.prevInInsertionOrder[newKeyIndex];
                newSuccessor = this.nextInInsertionOrder[newKeyIndex];
                this.removeEntryKeyHashKnown(newKeyIndex, newKeyHash);
                if (entry == this.size) {
                    entry = newKeyIndex;
                }
            } else {
                throw new IllegalArgumentException("Key already present in map: " + newKey);
            }
        }
        if (newPredecessor == entry) {
            newPredecessor = this.prevInInsertionOrder[entry];
        } else if (newPredecessor == this.size) {
            newPredecessor = newKeyIndex;
        }
        if (newSuccessor == entry) {
            newSuccessor = this.nextInInsertionOrder[entry];
        } else if (newSuccessor == this.size) {
            newSuccessor = newKeyIndex;
        }
        int oldPredecessor = this.prevInInsertionOrder[entry];
        int oldSuccessor = this.nextInInsertionOrder[entry];
        this.setSucceeds(oldPredecessor, oldSuccessor);
        this.deleteFromTableKToV(entry, Hashing.smearedHash(this.keys[entry]));
        this.keys[entry] = newKey;
        this.insertIntoTableKToV(entry, Hashing.smearedHash(newKey));
        this.setSucceeds(newPredecessor, entry);
        this.setSucceeds(entry, newSuccessor);
    }

    @Override
    @NullableDecl
    @CanIgnoreReturnValue
    public V remove(@NullableDecl Object key) {
        int keyHash = Hashing.smearedHash(key);
        int entry = this.findEntryByKey(key, keyHash);
        if (entry == -1) {
            return null;
        }
        V value = this.values[entry];
        this.removeEntryKeyHashKnown(entry, keyHash);
        return value;
    }

    @NullableDecl
    K removeInverse(@NullableDecl Object value) {
        int valueHash = Hashing.smearedHash(value);
        int entry = this.findEntryByValue(value, valueHash);
        if (entry == -1) {
            return null;
        }
        K key = this.keys[entry];
        this.removeEntryValueHashKnown(entry, valueHash);
        return key;
    }

    void removeEntry(int entry) {
        this.removeEntryKeyHashKnown(entry, Hashing.smearedHash(this.keys[entry]));
    }

    private void removeEntry(int entry, int keyHash, int valueHash) {
        Preconditions.checkArgument(entry != -1);
        this.deleteFromTableKToV(entry, keyHash);
        this.deleteFromTableVToK(entry, valueHash);
        int oldPredecessor = this.prevInInsertionOrder[entry];
        int oldSuccessor = this.nextInInsertionOrder[entry];
        this.setSucceeds(oldPredecessor, oldSuccessor);
        this.moveEntryToIndex(this.size - 1, entry);
        this.keys[this.size - 1] = null;
        this.values[this.size - 1] = null;
        --this.size;
        ++this.modCount;
    }

    void removeEntryKeyHashKnown(int entry, int keyHash) {
        this.removeEntry(entry, keyHash, Hashing.smearedHash(this.values[entry]));
    }

    void removeEntryValueHashKnown(int entry, int valueHash) {
        this.removeEntry(entry, Hashing.smearedHash(this.keys[entry]), valueHash);
    }

    private void moveEntryToIndex(int src, int dest) {
        if (src == dest) {
            return;
        }
        int predecessor = this.prevInInsertionOrder[src];
        int successor = this.nextInInsertionOrder[src];
        this.setSucceeds(predecessor, dest);
        this.setSucceeds(dest, successor);
        K key = this.keys[src];
        V value = this.values[src];
        this.keys[dest] = key;
        this.values[dest] = value;
        int keyHash = Hashing.smearedHash(key);
        int keyBucket = this.bucket(keyHash);
        if (this.hashTableKToV[keyBucket] == src) {
            this.hashTableKToV[keyBucket] = dest;
        } else {
            int prevInBucket = this.hashTableKToV[keyBucket];
            int entryInBucket = this.nextInBucketKToV[prevInBucket];
            while (true) {
                if (entryInBucket == src) {
                    this.nextInBucketKToV[prevInBucket] = dest;
                    break;
                }
                prevInBucket = entryInBucket;
                entryInBucket = this.nextInBucketKToV[entryInBucket];
            }
        }
        this.nextInBucketKToV[dest] = this.nextInBucketKToV[src];
        this.nextInBucketKToV[src] = -1;
        int valueHash = Hashing.smearedHash(value);
        int valueBucket = this.bucket(valueHash);
        if (this.hashTableVToK[valueBucket] == src) {
            this.hashTableVToK[valueBucket] = dest;
        } else {
            int prevInBucket = this.hashTableVToK[valueBucket];
            int entryInBucket = this.nextInBucketVToK[prevInBucket];
            while (true) {
                if (entryInBucket == src) {
                    this.nextInBucketVToK[prevInBucket] = dest;
                    break;
                }
                prevInBucket = entryInBucket;
                entryInBucket = this.nextInBucketVToK[entryInBucket];
            }
        }
        this.nextInBucketVToK[dest] = this.nextInBucketVToK[src];
        this.nextInBucketVToK[src] = -1;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, 0, this.size, null);
        Arrays.fill(this.values, 0, this.size, null);
        Arrays.fill(this.hashTableKToV, -1);
        Arrays.fill(this.hashTableVToK, -1);
        Arrays.fill(this.nextInBucketKToV, 0, this.size, -1);
        Arrays.fill(this.nextInBucketVToK, 0, this.size, -1);
        Arrays.fill(this.prevInInsertionOrder, 0, this.size, -1);
        Arrays.fill(this.nextInInsertionOrder, 0, this.size, -1);
        this.size = 0;
        this.firstInInsertionOrder = -2;
        this.lastInInsertionOrder = -2;
        ++this.modCount;
    }

    @Override
    public Set<K> keySet() {
        KeySet result2 = this.keySet;
        return result2 == null ? (this.keySet = new KeySet()) : result2;
    }

    @Override
    public Set<V> values() {
        ValueSet result2 = this.valueSet;
        return result2 == null ? (this.valueSet = new ValueSet()) : result2;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet result2 = this.entrySet;
        return result2 == null ? (this.entrySet = new EntrySet()) : result2;
    }

    @Override
    public BiMap<V, K> inverse() {
        BiMap<K, V> result2 = this.inverse;
        return result2 == null ? (this.inverse = new Inverse(this)) : result2;
    }

    @GwtIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        Serialization.writeMap(this, stream);
    }

    @GwtIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = Serialization.readCount(stream);
        this.init(16);
        Serialization.populateMap(this, stream, size);
    }

    static final class EntryForValue<K, V>
    extends AbstractMapEntry<V, K> {
        final HashBiMap<K, V> biMap;
        final V value;
        int index;

        EntryForValue(HashBiMap<K, V> biMap, int index) {
            this.biMap = biMap;
            this.value = biMap.values[index];
            this.index = index;
        }

        private void updateIndex() {
            if (this.index == -1 || this.index > this.biMap.size || !Objects.equal(this.value, this.biMap.values[this.index])) {
                this.index = this.biMap.findEntryByValue(this.value);
            }
        }

        @Override
        public V getKey() {
            return this.value;
        }

        @Override
        public K getValue() {
            this.updateIndex();
            return this.index == -1 ? null : (K)this.biMap.keys[this.index];
        }

        @Override
        public K setValue(K key) {
            this.updateIndex();
            if (this.index == -1) {
                return this.biMap.putInverse(this.value, key, false);
            }
            Object oldKey = this.biMap.keys[this.index];
            if (Objects.equal(oldKey, key)) {
                return key;
            }
            ((HashBiMap)this.biMap).replaceKeyInEntry(this.index, key, false);
            return oldKey;
        }
    }

    static class InverseEntrySet<K, V>
    extends View<K, V, Map.Entry<V, K>> {
        InverseEntrySet(HashBiMap<K, V> biMap) {
            super(biMap);
        }

        @Override
        public boolean contains(@NullableDecl Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                Object v = e.getKey();
                Object k = e.getValue();
                int eIndex = this.biMap.findEntryByValue(v);
                return eIndex != -1 && Objects.equal(this.biMap.keys[eIndex], k);
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                Object v = e.getKey();
                Object k = e.getValue();
                int vHash = Hashing.smearedHash(v);
                int eIndex = this.biMap.findEntryByValue(v, vHash);
                if (eIndex != -1 && Objects.equal(this.biMap.keys[eIndex], k)) {
                    this.biMap.removeEntryValueHashKnown(eIndex, vHash);
                    return true;
                }
            }
            return false;
        }

        @Override
        Map.Entry<V, K> forEntry(int entry) {
            return new EntryForValue(this.biMap, entry);
        }
    }

    static class Inverse<K, V>
    extends AbstractMap<V, K>
    implements BiMap<V, K>,
    Serializable {
        private final HashBiMap<K, V> forward;
        private transient Set<Map.Entry<V, K>> inverseEntrySet;

        Inverse(HashBiMap<K, V> forward) {
            this.forward = forward;
        }

        @Override
        public int size() {
            return this.forward.size;
        }

        @Override
        public boolean containsKey(@NullableDecl Object key) {
            return this.forward.containsValue(key);
        }

        @Override
        @NullableDecl
        public K get(@NullableDecl Object key) {
            return this.forward.getInverse(key);
        }

        @Override
        public boolean containsValue(@NullableDecl Object value) {
            return this.forward.containsKey(value);
        }

        @Override
        @NullableDecl
        @CanIgnoreReturnValue
        public K put(@NullableDecl V value, @NullableDecl K key) {
            return this.forward.putInverse(value, key, false);
        }

        @Override
        @NullableDecl
        @CanIgnoreReturnValue
        public K forcePut(@NullableDecl V value, @NullableDecl K key) {
            return this.forward.putInverse(value, key, true);
        }

        @Override
        public BiMap<K, V> inverse() {
            return this.forward;
        }

        @Override
        @NullableDecl
        @CanIgnoreReturnValue
        public K remove(@NullableDecl Object value) {
            return this.forward.removeInverse(value);
        }

        @Override
        public void clear() {
            this.forward.clear();
        }

        @Override
        public Set<V> keySet() {
            return this.forward.values();
        }

        @Override
        public Set<K> values() {
            return this.forward.keySet();
        }

        @Override
        public Set<Map.Entry<V, K>> entrySet() {
            Set<Map.Entry<V, K>> result2 = this.inverseEntrySet;
            return result2 == null ? (this.inverseEntrySet = new InverseEntrySet<K, V>(this.forward)) : result2;
        }

        @GwtIncompatible(value="serialization")
        private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
            in.defaultReadObject();
            ((HashBiMap)this.forward).inverse = this;
        }
    }

    final class EntryForKey
    extends AbstractMapEntry<K, V> {
        @NullableDecl
        final K key;
        int index;

        EntryForKey(int index) {
            this.key = HashBiMap.this.keys[index];
            this.index = index;
        }

        void updateIndex() {
            if (this.index == -1 || this.index > HashBiMap.this.size || !Objects.equal(HashBiMap.this.keys[this.index], this.key)) {
                this.index = HashBiMap.this.findEntryByKey(this.key);
            }
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        @NullableDecl
        public V getValue() {
            this.updateIndex();
            return this.index == -1 ? null : (Object)HashBiMap.this.values[this.index];
        }

        @Override
        public V setValue(V value) {
            this.updateIndex();
            if (this.index == -1) {
                return HashBiMap.this.put(this.key, value);
            }
            Object oldValue = HashBiMap.this.values[this.index];
            if (Objects.equal(oldValue, value)) {
                return value;
            }
            HashBiMap.this.replaceValueInEntry(this.index, value, false);
            return oldValue;
        }
    }

    final class EntrySet
    extends View<K, V, Map.Entry<K, V>> {
        EntrySet() {
            super(HashBiMap.this);
        }

        @Override
        public boolean contains(@NullableDecl Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                Object k = e.getKey();
                Object v = e.getValue();
                int eIndex = HashBiMap.this.findEntryByKey(k);
                return eIndex != -1 && Objects.equal(v, HashBiMap.this.values[eIndex]);
            }
            return false;
        }

        @Override
        @CanIgnoreReturnValue
        public boolean remove(@NullableDecl Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                Object k = e.getKey();
                Object v = e.getValue();
                int kHash = Hashing.smearedHash(k);
                int eIndex = HashBiMap.this.findEntryByKey(k, kHash);
                if (eIndex != -1 && Objects.equal(v, HashBiMap.this.values[eIndex])) {
                    HashBiMap.this.removeEntryKeyHashKnown(eIndex, kHash);
                    return true;
                }
            }
            return false;
        }

        @Override
        Map.Entry<K, V> forEntry(int entry) {
            return new EntryForKey(entry);
        }
    }

    final class ValueSet
    extends View<K, V, V> {
        ValueSet() {
            super(HashBiMap.this);
        }

        @Override
        V forEntry(int entry) {
            return HashBiMap.this.values[entry];
        }

        @Override
        public boolean contains(@NullableDecl Object o) {
            return HashBiMap.this.containsValue(o);
        }

        @Override
        public boolean remove(@NullableDecl Object o) {
            int oHash = Hashing.smearedHash(o);
            int entry = HashBiMap.this.findEntryByValue(o, oHash);
            if (entry != -1) {
                HashBiMap.this.removeEntryValueHashKnown(entry, oHash);
                return true;
            }
            return false;
        }
    }

    final class KeySet
    extends View<K, V, K> {
        KeySet() {
            super(HashBiMap.this);
        }

        @Override
        K forEntry(int entry) {
            return HashBiMap.this.keys[entry];
        }

        @Override
        public boolean contains(@NullableDecl Object o) {
            return HashBiMap.this.containsKey(o);
        }

        @Override
        public boolean remove(@NullableDecl Object o) {
            int oHash = Hashing.smearedHash(o);
            int entry = HashBiMap.this.findEntryByKey(o, oHash);
            if (entry != -1) {
                HashBiMap.this.removeEntryKeyHashKnown(entry, oHash);
                return true;
            }
            return false;
        }
    }

    static abstract class View<K, V, T>
    extends AbstractSet<T> {
        final HashBiMap<K, V> biMap;

        View(HashBiMap<K, V> biMap) {
            this.biMap = biMap;
        }

        abstract T forEntry(int var1);

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private int index;
                private int indexToRemove;
                private int expectedModCount;
                private int remaining;
                {
                    this.index = View.this.biMap.firstInInsertionOrder;
                    this.indexToRemove = -1;
                    this.expectedModCount = View.this.biMap.modCount;
                    this.remaining = View.this.biMap.size;
                }

                private void checkForComodification() {
                    if (View.this.biMap.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                }

                @Override
                public boolean hasNext() {
                    this.checkForComodification();
                    return this.index != -2 && this.remaining > 0;
                }

                @Override
                public T next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Object result2 = View.this.forEntry(this.index);
                    this.indexToRemove = this.index;
                    this.index = View.this.biMap.nextInInsertionOrder[this.index];
                    --this.remaining;
                    return result2;
                }

                @Override
                public void remove() {
                    this.checkForComodification();
                    CollectPreconditions.checkRemove(this.indexToRemove != -1);
                    View.this.biMap.removeEntry(this.indexToRemove);
                    if (this.index == View.this.biMap.size) {
                        this.index = this.indexToRemove;
                    }
                    this.indexToRemove = -1;
                    this.expectedModCount = View.this.biMap.modCount;
                }
            };
        }

        @Override
        public int size() {
            return this.biMap.size;
        }

        @Override
        public void clear() {
            this.biMap.clear();
        }
    }
}

