/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.cookie;

import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.CookieDecoder;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public final class ServerCookieDecoder
extends CookieDecoder {
    private static final String RFC2965_VERSION = "$Version";
    private static final String RFC2965_PATH = "$Path";
    private static final String RFC2965_DOMAIN = "$Domain";
    private static final String RFC2965_PORT = "$Port";
    public static final ServerCookieDecoder STRICT = new ServerCookieDecoder(true);
    public static final ServerCookieDecoder LAX = new ServerCookieDecoder(false);

    private ServerCookieDecoder(boolean strict) {
        super(strict);
    }

    public List<Cookie> decodeAll(String header2) {
        ArrayList cookies2 = new ArrayList();
        this.decode(cookies2, header2);
        return Collections.unmodifiableList(cookies2);
    }

    public Set<Cookie> decode(String header2) {
        TreeSet<Cookie> cookies2 = new TreeSet<Cookie>();
        this.decode(cookies2, header2);
        return cookies2;
    }

    private void decode(Collection<? super Cookie> cookies2, String header2) {
        int headerLen = ObjectUtil.checkNotNull(header2, "header").length();
        if (headerLen == 0) {
            return;
        }
        int i = 0;
        boolean rfc2965Style = false;
        if (header2.regionMatches(true, 0, RFC2965_VERSION, 0, RFC2965_VERSION.length())) {
            i = header2.indexOf(59) + 1;
            rfc2965Style = true;
        }
        while (i != headerLen) {
            DefaultCookie cookie2;
            int valueBegin;
            int valueEnd;
            int nameEnd;
            int nameBegin;
            block9: {
                char c = header2.charAt(i);
                if (c == '\t' || c == '\n' || c == '\u000b' || c == '\f' || c == '\r' || c == ' ' || c == ',' || c == ';') {
                    ++i;
                    continue;
                }
                nameBegin = i;
                do {
                    char curChar;
                    if ((curChar = header2.charAt(i)) == ';') {
                        nameEnd = i;
                        valueEnd = -1;
                        valueBegin = -1;
                    } else {
                        if (curChar != '=') continue;
                        nameEnd = i++;
                        if (i == headerLen) {
                            valueEnd = 0;
                            valueBegin = 0;
                        } else {
                            valueBegin = i;
                            int semiPos = header2.indexOf(59, i);
                            i = semiPos > 0 ? semiPos : headerLen;
                            valueEnd = i;
                        }
                    }
                    break block9;
                } while (++i != headerLen);
                nameEnd = headerLen;
                valueEnd = -1;
                valueBegin = -1;
            }
            if (rfc2965Style && (header2.regionMatches(nameBegin, RFC2965_PATH, 0, RFC2965_PATH.length()) || header2.regionMatches(nameBegin, RFC2965_DOMAIN, 0, RFC2965_DOMAIN.length()) || header2.regionMatches(nameBegin, RFC2965_PORT, 0, RFC2965_PORT.length())) || (cookie2 = this.initCookie(header2, nameBegin, nameEnd, valueBegin, valueEnd)) == null) continue;
            cookies2.add(cookie2);
        }
    }
}

