/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.util;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.Extension;
import io.swagger.annotations.ExtensionProperty;
import io.swagger.util.Json;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class BaseReaderUtils {
    private BaseReaderUtils() {
    }

    public static Map<String, Object> parseExtensions(Extension[] extensions) {
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        for (Extension extension2 : extensions) {
            String name = extension2.name();
            String key = name.length() > 0 ? StringUtils.prependIfMissing(name, (CharSequence)"x-", new CharSequence[0]) : name;
            for (ExtensionProperty property : extension2.properties()) {
                String propertyName = property.name();
                String propertyValue = property.value();
                JsonNode processedValue = null;
                boolean propertyAsJson = property.parseValue();
                if (!StringUtils.isNotBlank(propertyName) || !StringUtils.isNotBlank(propertyValue)) continue;
                if (key.isEmpty()) {
                    if (propertyAsJson) {
                        try {
                            processedValue = Json.mapper().readTree(propertyValue);
                            map2.put(StringUtils.prependIfMissing(propertyName, (CharSequence)"x-", new CharSequence[0]), processedValue);
                        }
                        catch (Exception e) {
                            map2.put(StringUtils.prependIfMissing(propertyName, (CharSequence)"x-", new CharSequence[0]), propertyValue);
                        }
                        continue;
                    }
                    map2.put(StringUtils.prependIfMissing(propertyName, (CharSequence)"x-", new CharSequence[0]), propertyValue);
                    continue;
                }
                Object value = map2.get(key);
                if (value == null || !(value instanceof Map)) {
                    value = new HashMap();
                    map2.put(key, value);
                }
                Map mapValue = (Map)value;
                if (propertyAsJson) {
                    try {
                        processedValue = Json.mapper().readTree(propertyValue);
                        mapValue.put(propertyName, processedValue);
                    }
                    catch (Exception e) {
                        mapValue.put(propertyName, propertyValue);
                    }
                    continue;
                }
                mapValue.put(propertyName, propertyValue);
            }
        }
        return map2;
    }
}

