/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.models.RefFormat;
import io.swagger.v3.parser.models.RefType;
import io.swagger.v3.parser.util.DeserializationUtils;
import io.swagger.v3.parser.util.OpenAPIDeserializer;
import io.swagger.v3.parser.util.PathUtils;
import io.swagger.v3.parser.util.RefUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ResolverCache {
    private static final Pattern SCHEMAS_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "schemas/(?<name>.+)");
    private static final Pattern RESPONSES_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "responses/(?<name>.+)");
    private static final Pattern PARAMETERS_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "parameters/(?<name>.+)");
    private static final Pattern REQUEST_BODIES_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "requestBodies/(?<name>.+)");
    private static final Pattern EXAMPLES_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "examples/(?<name>.+)");
    private static final Pattern LINKS_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "links/(?<name>.+)");
    private static final Pattern CALLBACKS_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "callbacks/(?<name>.+)");
    private static final Pattern HEADERS_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "headers/(?<name>.+)");
    private static final Pattern SECURITY_SCHEMES = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "securitySchemes/(?<name>.+)");
    private static final Pattern PATHS_PATTERN = Pattern.compile("^" + RefType.PATH.getInternalPrefix() + "(?<name>.+)");
    private final OpenAPI openApi;
    private final List<AuthorizationValue> auths;
    private final Path parentDirectory;
    private final String rootPath;
    private Map<String, Object> resolutionCache = new HashMap<String, Object>();
    private Map<String, String> externalFileCache = new HashMap<String, String>();
    private Set<String> referencedModelKeys = new HashSet<String>();
    private Map<String, String> renameCache = new HashMap<String, String>();

    public ResolverCache(OpenAPI openApi, List<AuthorizationValue> auths, String parentFileLocation) {
        this.openApi = openApi;
        this.auths = auths;
        this.rootPath = parentFileLocation;
        if (parentFileLocation != null) {
            this.parentDirectory = parentFileLocation.startsWith("http") ? null : PathUtils.getParentDirectoryOfFile(parentFileLocation);
        } else {
            File file = new File(".");
            this.parentDirectory = file.toPath();
        }
    }

    public <T> T loadRef(String ref, RefFormat refFormat, Class<T> expectedType) {
        Object result2;
        String[] jsonPathElements;
        if (refFormat == RefFormat.INTERNAL) {
            Object loadedRef = this.loadInternalRef(ref);
            try {
                return expectedType.cast(loadedRef);
            }
            catch (Exception e) {
                return null;
            }
        }
        String[] refParts = ref.split("#/");
        if (refParts.length > 2) {
            throw new RuntimeException("Invalid ref format: " + ref);
        }
        String file = refParts[0];
        String definitionPath = refParts.length == 2 ? refParts[1] : null;
        Object previouslyResolvedEntity = this.resolutionCache.get(ref);
        if (previouslyResolvedEntity != null) {
            return expectedType.cast(previouslyResolvedEntity);
        }
        String contents = this.externalFileCache.get(file);
        if (contents == null) {
            if (this.parentDirectory != null) {
                contents = RefUtils.readExternalRef(file, refFormat, this.auths, this.parentDirectory);
            } else if (this.rootPath != null && this.rootPath.startsWith("http")) {
                contents = RefUtils.readExternalUrlRef(file, refFormat, this.auths, this.rootPath);
            } else if (this.rootPath != null) {
                contents = RefUtils.readExternalClasspathRef(file, refFormat, this.auths, this.rootPath);
            }
            this.externalFileCache.put(file, contents);
        }
        if (definitionPath == null) {
            T result3 = DeserializationUtils.deserialize(contents, file, expectedType);
            this.resolutionCache.put(ref, result3);
            return result3;
        }
        JsonNode tree = DeserializationUtils.deserializeIntoTree(contents, file);
        for (String jsonPathElement : jsonPathElements = definitionPath.split("/")) {
            if ((tree = tree.get(this.unescapePointer(jsonPathElement))) != null) continue;
            throw new RuntimeException("Could not find " + definitionPath + " in contents of " + file);
        }
        if (expectedType.equals(Schema.class)) {
            OpenAPIDeserializer deserializer = new OpenAPIDeserializer();
            result2 = deserializer.getSchema((ObjectNode)tree, definitionPath.replace("/", "."), null);
        } else {
            result2 = DeserializationUtils.deserialize(tree, file, expectedType);
        }
        this.updateLocalRefs(file, result2);
        this.resolutionCache.put(ref, result2);
        return result2;
    }

    protected <T> void updateLocalRefs(String file, T result2) {
        Parameter parameter;
        if (result2 instanceof Parameter && (parameter = (Parameter)result2).getSchema() != null) {
            this.updateLocalRefs(file, parameter.getSchema());
        }
        if (result2 instanceof Schema && ((Schema)result2).get$ref() != null) {
            Schema prop = (Schema)result2;
            this.updateLocalRefs(file, prop);
        } else if (result2 instanceof Schema) {
            Schema model = (Schema)result2;
            this.updateLocalRefs(file, model);
        }
    }

    protected <T> void updateLocalRefs(String file, Schema schema) {
        if (schema.get$ref() != null) {
            String updatedLocation = this.merge(file, schema.get$ref());
            schema.set$ref(updatedLocation);
        } else if (schema.getProperties() != null) {
            Map<String, Schema> properties = schema.getProperties();
            for (Schema property : properties.values()) {
                this.updateLocalRefs(file, property);
            }
        }
    }

    protected String merge(String host, String ref) {
        if (StringUtils.isBlank(host)) {
            return ref;
        }
        if (ref.startsWith("http:") || ref.startsWith("https:")) {
            return ref;
        }
        if (!(host.startsWith("http:") || host.startsWith("https:") || ref.startsWith("#/components"))) {
            return ref;
        }
        if (ref.startsWith(".")) {
            return ref;
        }
        if (host.endsWith("/") && ref.startsWith("/")) {
            return host + ref.substring(1);
        }
        return host + ref;
    }

    private Object loadInternalRef(String ref) {
        Object result2 = null;
        if (ref.startsWith("#/paths")) {
            result2 = this.getFromMap(ref, this.openApi.getPaths(), PATHS_PATTERN);
        } else if (this.openApi.getComponents() != null) {
            if (ref.startsWith("#/components/schemas")) {
                result2 = this.getFromMap(ref, this.openApi.getComponents().getSchemas(), SCHEMAS_PATTERN);
            } else if (ref.startsWith("#/components/requestBodies")) {
                result2 = this.getFromMap(ref, this.openApi.getComponents().getRequestBodies(), REQUEST_BODIES_PATTERN);
            } else if (ref.startsWith("#/components/examples")) {
                result2 = this.getFromMap(ref, this.openApi.getComponents().getExamples(), EXAMPLES_PATTERN);
            } else if (ref.startsWith("#/components/responses")) {
                result2 = this.getFromMap(ref, this.openApi.getComponents().getResponses(), RESPONSES_PATTERN);
            } else if (ref.startsWith("#/components/parameters")) {
                result2 = this.getFromMap(ref, this.openApi.getComponents().getParameters(), PARAMETERS_PATTERN);
            } else if (ref.startsWith("#/components/links")) {
                result2 = this.getFromMap(ref, this.openApi.getComponents().getLinks(), LINKS_PATTERN);
            } else if (ref.startsWith("#/components/headers")) {
                result2 = this.getFromMap(ref, this.openApi.getComponents().getHeaders(), HEADERS_PATTERN);
            } else if (ref.startsWith("#/components/callbacks")) {
                result2 = this.getFromMap(ref, this.openApi.getComponents().getCallbacks(), CALLBACKS_PATTERN);
            } else if (ref.startsWith("#/components/securitySchemes")) {
                result2 = this.getFromMap(ref, this.openApi.getComponents().getSecuritySchemes(), SECURITY_SCHEMES);
            }
        }
        return result2;
    }

    private String unescapePointer(String jsonPathElement) {
        try {
            jsonPathElement = URLDecoder.decode(jsonPathElement, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        jsonPathElement = jsonPathElement.replaceAll("~1", "/");
        return jsonPathElement.replaceAll("~0", "~");
    }

    private Object getFromMap(String ref, Map map2, Pattern pattern) {
        Matcher parameterMatcher = pattern.matcher(ref);
        if (parameterMatcher.matches()) {
            String paramName = this.unescapePointer(parameterMatcher.group("name"));
            if (map2 != null) {
                return map2.get(paramName);
            }
        }
        return null;
    }

    public boolean hasReferencedKey(String modelKey) {
        if (this.referencedModelKeys == null) {
            return false;
        }
        return this.referencedModelKeys.contains(modelKey);
    }

    public void addReferencedKey(String modelKey) {
        this.referencedModelKeys.add(modelKey);
    }

    public String getRenamedRef(String originalRef) {
        return this.renameCache.get(originalRef);
    }

    public void putRenamedRef(String originalRef, String newRef) {
        this.renameCache.put(originalRef, newRef);
    }

    public Map<String, Object> getResolutionCache() {
        return Collections.unmodifiableMap(this.resolutionCache);
    }

    public Map<String, String> getExternalFileCache() {
        return Collections.unmodifiableMap(this.externalFileCache);
    }

    public Map<String, String> getRenameCache() {
        return Collections.unmodifiableMap(this.renameCache);
    }
}

